<?php

class Prontuario_AtendimentoController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		Zend_Layout::getMvcInstance()->setLayout("prontuario");
		$this->view->title = "Atendimento";
		//$this->_helper->layout->setLayout("simples");
	}

	public function indexAction() {
            
		$ate_codigo = $this->_getParam("ate_codigo", FALSE);
		$tbAte = new Application_Model_AtendimentoSocial();
		$this->view->dados = $tbAte->getAtendimentoAtual($_SESSION[prontuario][age]->age_codigo);
		$this->render("unico");
	}
	
	public function atendimentoInternacaoAction() {
		$obs = $this->_getParam("obs", FALSE);
		$tbAte = new Application_Model_Atendimento();	
		$this->view->dados = $tbAte->buscar();
		
		
		
		$this->view->obs = $obs;

		$this->render($tbAte->textareaUnico() ? "unico" : "multiplo");
	}
	public function salvarAction() {
            $arr = $this->_request->getPost();
            //echo "<pre>".print_r($arr)."</pre>";
            //die();
            $tbAts = new Application_Model_AtendimentoSocial();
            unset($arr["submit"]); 
            unset($arr["names"]);
            unset($arr["no_ocupacao"]); 
            foreach($arr as $ind => $val){
                if($val == "" || $val == NULL){
                    unset($arr[$ind]);
                }
            }
            
            try{
                $tbAts->salvar($arr);
                $this->view->dialog = array("Confirmação", "Dados salvos com sucesso!", 300, 140);
                //$this->render("unico");
            }catch (Zend_Validate_Exception $exc){
                throw new Zend_Validate_Exception($exc->getMessage());
            }
            //return parent::salvar($data);
            $this->_redirect("/prontuario/atendimento");
	}	
	public function salvarInternacaoAction() {
		if ($this->_request->isPost()) {
			$obs = $this->_getParam("obs", FALSE);
		
			$dados = array(
				"ate_codigo" => $this->_request->getPost("ate_codigo", NULL),
				"ate_hora" => $this->_request->getPost("ate_hora", NULL),
				"ate_reclamacao" => $this->_request->getPost("ate_reclamacao", NULL),				
				"cd10_codigo" => $this->_request->getPost("cd10_codigo", NULL),
				"ate_atendido" => $this->_request->getPost("ate_atendido", "S")
			);		
			$tbAte = new Application_Model_Atendimento();
			$io_codigo = $this->_getParam("io_codigo", FALSE);
			$ate_codigo = $tbAte->salvar($dados,$obs,$io_codigo);
				
			if(!$this->_request->getPost("ate_codigo")){				
				$dadosInternacao = array(
					"ate_codigo" => $ate_codigo,
					"io_codigo" => 	$io_codigo	
				);				
				$tbAti = new Application_Model_AtendimentoInternacao();				
				$atin_codigo = $tbAti->salvar($dadosInternacao);
			}
			$this->view->dados = $tbAte->buscarInternacao($ate_codigo);

			$this->view->dialog = array("Confirmação", "Atendimento salvo com sucesso!", 300, 140);
			$this->view->obs = $obs;

			$this->_redirect("/leito/atendimento/index/cod/$io_codigo/ate_codigo/$ate_codigo");
		
		} else {
			$this->_redirect("/prontuario/atendimento");
		}
	}

	public function historicoAction() {
		$tbAte = new Application_Model_Atendimento();
		
		// filtrar 
		$this->view->term = $this->_getParam("term", FALSE);
		$this->view->itens = $tbAte->getHistorico($this->view->term);
	}

	/**
	 * Esta é a página com as abas do atendimento (exames, atendimento, medicamento...)
	 */
	public function verAction() {
		$ate_codigo = $this->_getParam("id", FALSE);
		$age_codigo = $this->_getParam("age", FALSE);
               // die($age_codigo. "zz".$ate_codigo);
		$tbAte = new Application_Model_Atendimento();

		if ($age_codigo) {
                     if($ate_codigo){
                        $this->view->ate = $tbAte->buscar($ate_codigo);
                        $this->view->ate_codigo = $ate_codigo;
                    }else{
                        $ate = $tbAte->temAtendimento($age_codigo);
                        if ($ate){                               
                            $ate_codigo = $ate->ate_codigo;
                            $this->view->ate = $tbAte->buscar($ate_codigo);
                            $this->view->ate_codigo = $ate_codigo;
                        }else{
                            $tbPre = new Application_Model_PreConsulta();
                            $this->view->ate = $tbPre->buscar($age_codigo);
                        }
                    }
		}else {
                    
                    return $this->_redirect("/prontuario");
                }
            }

	/**
	 * Esta é a página com os dados preenchidos na guia atendimento
	 */
	public function detalhesAction() {
		$ate_codigo = $this->_getParam("id", FALSE);
		if (!$ate_codigo)
			return $this->_redirect("/prontuario");

		$tbAte = new Application_Model_Atendimento();
		$this->view->dados = $tbAte->getDetalhes($ate_codigo);
		$this->render($tbAte->textareaUnico() ? "detalhes-unico" : "detalhes-multiplo");
	}

	/**
	 * Busca os dados do atendimento e retorna em json
	 * Usado no modulo agenda para preencher a tela com os dados do atendimento
	 */
	public function jsonAction() {
		$ate_codigo = $this->_getParam("ate", FALSE);
		if (!$ate_codigo)
			return $this->_redirect("/prontuario/atendimento");

		$tbAte = new Application_Model_Atendimento();
		$age = $tbAte->getDadosCabecalho($ate_codigo);

		if (!$age) {
			$this->view->dados = array("success" => FALSE, "mensagem" => "Código inválido");
			return $this->render("dados", NULL, TRUE);
		}

		$age = $age->toArray();

		$tbReq = new Application_Model_RequisicaoExame();
		$exames = $tbReq->getItens(FALSE, $ate_codigo)->toArray();

		// monta resultados
		$this->view->dados = array_merge(
				array("success" => TRUE), $age, array("exames" => $exames)
		);
		return $this->render("dados", NULL, TRUE);
	}
	public function verificaseestaematendimentoAction(){
                
		$tbUsr = new Application_Model_Usuarios;
                $age_codigo = $this->_getParam("age_codigo", FALSE);
                $tbAge = new Application_Model_Agendamento();
		
                if($tbUsr->isMedico()){                    
			$tbAte = new Application_Model_Atendimento();
			
			if ($age_codigo) {
				$ate = $tbAte->estaEmAtendimento($age_codigo);
                               
				if ($ate){
                                    $med_codigo= $ate->med_codigo;
                                }
			}
			
                        $tbUsr = new Application_Model_Usuarios();
                        $usr = $tbUsr->getUsrAtual();

                        $tbAge->alteraMedico($age_codigo, $usr->usr_codigo,"E");
                        die(TRUE);
		}else{
                    $tbAge->alteraSituacao("E",$age_codigo);
                    die(true);
		}
		
	}

}

