<?php

class Prontuario_AtestadoController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		Zend_Layout::getMvcInstance()->setLayout("prontuario");
		$this->view->title = "Atestado";
	}

	public function indexAction() {
		$tbAte = new Application_Model_Atendimento();
		$tbAtest = new Application_Model_Atestado();
		
		// tem atestado?
		$this->view->dados = $tbAtest->buscar();
		$this->view->imprimir = $this->_getParam("imprimir",0);	
		
		$cd10_codigo = $tbAte->temAtendimentoMedico()->cd10_codigo;
		
		if(!$cd10_codigo){
			$this->view->erro = "É preciso informar um CID para emitir um atestado. <a href=\"".$this->view->url(array("controller"=>"atendimento"))."\">Ir para Atendimento</a>.";
			$this->view->imprimir = 0;
		} else {
			$tbCid = new Application_Model_Cid();
			$this->view->cid = $tbCid->find($cd10_codigo)->current();
		}
	}

	public function salvarAction() {
		if ($this->_request->isPost()) {
			
			$padraoMotivos = array(
				"consulta_medica" => 'S',
				"acompanhando_filho" => 'N',
				"retorno_trabalho" => 'N',
				"repouso_hs" => 'N',
				"repouso_hoje" => 'N',
				"repouso_dia" => 'N'
			);
			$motivos = $this->_request->getPost("motivo",$padraoMotivos);
			$dados = array(
				"acompanhando" => $this->_request->getPost("acompanhando", NULL),
				"retornoaotrabalho" => $this->_request->getPost("retornoaotrabalho", NULL),
				"repousohs_ini" => $this->_request->getPost("repousohs_ini", NULL),
				"repousohs_final" => $this->_request->getPost("repousohs_final", NULL),
				"repousodias" => $this->_request->getPost("repousodias", 0),
				"obs" => $this->_request->getPost("obs", NULL)
			);			
			$dados = array_merge($padraoMotivos,$dados,$motivos);

			try {
				Zend_Registry::get("logger")->log($motivos, Zend_Log::INFO);
				Zend_Registry::get("logger")->log($padraoMotivos, Zend_Log::INFO);
				Zend_Registry::get("logger")->log($dados, Zend_Log::INFO);
				$tbAtest = new Application_Model_Atestado();
				$tbAtest->salvar($dados);
				$this->_redirect("/prontuario/atestado/index/imprimir/1");
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object) $dados;
				$this->render("index");
			}
		} else {
			$this->_redirect("/prontuario/atestado");
		}
	}

	public function imprimirAction(){
		Zend_Layout::getMvcInstance()->setLayout("print");
		$tbUsr = new Application_Model_Usuarios();
		$this->view->title = "Imprimir Atestado Médico";
		
		$this->view->atest_codigo = $this->_getParam("atest",false);
		
		$tbAtest = new Application_Model_Atestado();
		$this->view->dados = $tbAtest->imprimir($this->view->atest_codigo);
		$this->view->isMedico = $tbUsr->isMedico();
	}
}
