<?php

class Prontuario_EncaminhamentoController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		//Zend_Layout::getMvcInstance()->setLayout("prontuario");
		$this->view->title = "Encaminhamento";
	}
	
	public function indexAction(){
		$this->_helper->layout->setLayout("prontuario");
		
		// no atendimento, é possivel carregar o historico por ajax.
		// Nesse caso, não deve enviar o layout junto
		$this->view->obs = $this->_getParam("obs", FALSE);		
		$this->view->io_codigo = $this->_getParam("io_codigo", FALSE);
		$this->view->ate_codigo = $this->_getParam("ate_codigo", FALSE);
		$this->view->usu_codigo = $this->_getParam("usu_codigo", FALSE);		
		if($this->view->obs){
			$this->_helper->layout->disableLayout();
			//$this->render("itens");
		}	
		$tbEsp = new Application_Model_Especialidade();
		$this->view->especialidade = $tbEsp->selectTag();
	}
	
	public function itensAction(){	
		$tbEnc = new Application_Model_Encaminhamento();
		$this->view->itens = $tbEnc->getItens();	
		$this->view->obs = $this->_getParam("obs",FALSE);
	}
	/**
	 * Mostra os encaminhamentos da internação atual
	 */
	public function itensInternacaoAction(){
		$io_codigo = $this->_getParam("io_codigo",FALSE);
		$ate_codigo = $this->_getParam("ate_codigo",FALSE);
		$usu_codigo = $this->_getParam("usu_codigo",FALSE);
		$imprimi = $this->_getParam("imprimi",FALSE);
                
		//die($io_codigo."-".$ate_codigo."-".$usu_codigo."-".$imprimi);
                $tbEnc = new Application_Model_Encaminhamento();
		$this->view->itens = $tbEnc->getItensInternacao($io_codigo);	
		$this->view->obs = $this->_getParam("obs",FALSE);
                $this->view->io_codigo = $io_codigo;
		$this->view->usu_codigo = $usu_codigo;
		$this->view->ate_codigo = $ate_codigo;
		$this->view->imprimi = $imprimi;
		$this->render("itens");
	}
	
	public function historicoAction(){		
		$ate_codigo = $this->_getParam("id", FALSE);
		if(!$ate_codigo)
			return $this->_redirect ("/prontuario");
				
		$tbEnc = new Application_Model_Encaminhamento();
		$this->view->itens = $tbEnc->getHistorico($ate_codigo);
	}	

	public function salvarAction() {
		//echo "<pre>".print_r($_POST,1);exit;
		if ($this->_request->isPost()) {

			$obs = $this->_request->getPost("obs",FALSE);			
			$ate_codigo = $this->_request->getPost("ate_codigo",FALSE);
			$io_codigo = $this->_request->getPost("io_codigo",FALSE);	
			
			
			$dados = array(
				"ate_codigo" => $this->_request->getPost("ate_codigo", 0),
				"enc_codigo" => $this->_request->getPost("enc_codigo", 0),
				"esp_codigo" => $this->_request->getPost("esp_codigo", NULL),
				"enc_descricao" => $this->_request->getPost("enc_descricao", NULL),
				"enc_internacao" => $this->_request->getPost("enc_internacao", NULL),
				"enc_urgencia" => $this->_request->getPost("enc_urgencia", NULL)
			);

			try {
				$tbEnc = new Application_Model_Encaminhamento();
				$tbEnc->salvar($dados,$obs);
				$this->view->dialog = array("Confirmação","Encaminhamento registrado com sucesso!",300,140);
				$tbEsp = new Application_Model_Especialidade();
				$this->view->especialidade = $tbEsp->selectTag();
				if($obs == "S"){
						$this->_redirect("leito/atendimento/index/cod/$io_codigo/ate_codigo/$ate_codigo");
				}else{
						$this->_helper->layout->setLayout("prontuario");
						$this->render("index");
				}
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object) $dados;
				$this->render("index");
			}
		} else {
			$this->_redirect("/prontuario/encaminhamento");
		}
	}

	public function excluirAction(){
		$id = (int) $this->_getParam("id",0);
                $ate_codigo = $this->_getParam("ate_codigo",FALSE);
		$io_codigo = $this->_getParam("cod",FALSE);
                //die($io_codigo."-".$ate_codigo);
		if(!$id)
			return $this->_redirect ("/prontuario/encaminhamento");
		
		$tbEnc = new Application_Model_Encaminhamento();
		$tbEnc->excluir($id);
		//die($io_codigo);
		
                if($io_codigo){
                   return $this->_redirect ("/leito/atendimento/index/cod/$io_codigo/ate_codigo/$ate_codigo");
                }else{
                   return $this->_redirect ("/prontuario/encaminhamento");
                }
	}
	
	public function imprimirAction(){
		Zend_Layout::getMvcInstance()->setLayout("print");
		$tbUsr = new Application_Model_Usuarios();
		$this->view->title = "Imprimir Encaminhamento Médico";
		
                $io_codigo = $this->_getParam("cod",FALSE);
                $usu_codigo = $this->_getParam("usu_codigo",FALSE);
                
                //die($usu_codigo."0".$io_codigo);
		$id = (int) $this->_getParam("id",0);
		if(!$id)
			return $this->_redirect ("/prontuario/encaminhamento");
		
		$tbEnc = new Application_Model_Encaminhamento();
		$this->view->dados = $tbEnc->imprimir($id,$io_codigo,$usu_codigo);		
		$this->view->tipo = $tipo;
		$this->view->isMedico = $tbUsr->isMedico();
	}

}

