<?php

class Prontuario_FichaController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		Zend_Layout::getMvcInstance()->setLayout("simples");
	}

	/**
	 * Deve carregar todo o histórico do paciente
	 */
	public function indexAction() {
		$this->view->headLink()->appendStylesheet($this->view->baseUrl("/public/css/relatorio/usuario/prontuario.css"),"all");
		$this->view->headLink()->appendStylesheet($this->view->baseUrl("/public/css/relatorio.css"),"all");
		$this->view->usu_codigo = $this->_getParam("usu", FALSE);
		if(!$this->view->usu_codigo)
			return $this->_redirect ("/prontuario");		
		
		$tbUsu = new Application_Model_Usuario();
		$opcoes = array("alertas","pre-consulta","atendimentos","procedimentos","medicamentos",
						"pre-consulta" => array(
							"incluirSemObservacao" => TRUE
						));
		
		
		// já existe atendimento?
		$tbAte = new Application_Model_Atendimento();	
		$this->view->dadosAte = $tbAte->buscar();
		
		// procedimentos disponiveis para este CBO		
		$tbProc = new Application_Model_Procedimento();
		$this->view->procedimentos = $tbProc->selectTag();	
		
		// receita médica
		$tbIRec = new Application_Model_ReceitaItens();
		$this->view->medicamentos = $tbIRec->getItens("posto");
		
		$this->view->dados = $tbUsu->relProntuario($this->view->usu_codigo, FALSE, FALSE, $opcoes);
	}
	
	public function index2Action(){
		$this->view->headLink()->appendStylesheet($this->view->baseUrl("/public/css/relatorio/usuario/prontuario.css"),"all");
		$this->view->headLink()->appendStylesheet($this->view->baseUrl("/public/css/relatorio.css"),"all");
		
		$this->view->usu_codigo = $this->_getParam("usu", FALSE);
		
		$tbUsu = new Application_Model_Usuario();
		$this->view->dados = $tbUsu->relProntuarioFicha($this->view->usu_codigo);
		//echo "<pre>" . print_r($this->view->dados, 1) . "</pre>";
		//exit;
	}

	/**
	 * Imprime o atendimento feito pelo médico
	 * Deve ser carimbado e assinado pelo médico,
	 * e depois guardado junto a ficha (física) do paciente
	 */
	public function atendimentoAction(){
		$ate_codigo = $this->_getParam("ate", FALSE);
		if(!$ate_codigo)
			return $this->_redirect ("/prontuario");
		
		$this->view->headLink()->appendStylesheet($this->view->baseUrl("/public/css/relatorio/usuario/prontuario.css"),"all");
		$this->view->headLink()->appendStylesheet($this->view->baseUrl("/public/css/relatorio.css"),"all");
		$tbUsu = new Application_Model_Usuario();
		$tbAts = new Application_Model_AtendimentoSocial();
		$this->view->dados = $tbAts->getDadosAtendimentoGeral($ate_codigo); 
        }
	
	public function internacaoAction(){
            $this->view->title = "Ficha de Internação";
            // Chamando o Model de Internação
            $tbInt = new Application_Model_Internacao();
            $ate_codigo = $this->_getParam("id", FALSE);
            // Criando array de dados pra impressão da ficha
            $dados = $this->view->ficha = $tbInt->getFichaInternacao($ate_codigo)->toArray();
            // Se tiver observação interna, busca a grade
            if($dados["io_codigo"]) { 
                $dados_grade = $this->view->dados_grade = $tbInt->getGradeMedicacaoFicha($dados["io_codigo"])->toArray(); 
            }
            // Chamando o Layout padrão de relatórios, que está na pasta layout/default/scripts  
            Zend_Layout::getMvcInstance()->setLayout("relatorio");
            // Chamando a ficha para exibição dos dados
            $this->render("internacao");
	}
	
}

