<?php

class Prontuario_IndexController extends Zend_Controller_Action {

    private $_p;

    public function init() {
        Zend_Layout::getMvcInstance()->setLayout("prontuario");
        $this->_p = new Zend_Session_Namespace("prontuario");
    }

    public function indexAction() {
        $this->view->title = "Prontuário Eletrônico";
//        echo $_SESSION["prontuario"]["age"]->age_atendido;
//            die();
        // ha paciente em atendimento?
       
        if (false !== ($age = Application_Model_Agendamento::usuEmAberto())) {
            $this->view->age = $age;

            // filtrar atendimentos?
            $this->view->term = $this->_request->getPost("term", FALSE);
        }
        else // vai para "agenda do dia"
            return $this->_redirect("/prontuario/agenda-do-dia");
    }

    public function menuAction() {
        $tbAts = new Application_Model_AtendimentoSocial();
        $ageCodigo = Application_Model_Agendamento::usuEmAberto()->age_codigo;
        if ($ageCodigo)
            $dadosAte = $tbAts->getAtendimentoAtual($ageCodigo);
            $this->view->temAtendimento = $dadosAte;
    }

    public function iniciarAction() {
        $age_codigo = $this->_getParam("cod", FALSE);
        $tbAge = new Application_Model_Agendamento();
        if ($age_codigo && !$tbAge->usuEmAberto())
            $tbAge->iniciar($age_codigo);
        $tbUsr = new Application_Model_Usuarios();
        $usr_codigo = $tbUsr->getUsrAtual();
        
        $tbCha = new Application_Model_Chamada();
        $dataCha = array("age_codigo" => $age_codigo,
            "usr_codigo" => $usr_codigo->usr_codigo,
            "cha_status" => "C"
        );
        
        $idCha = $tbCha->salvar($dataCha,$age_codigo);
        return $this->_redirect("/prontuario");
    }

    public function cancelarAction() {
        //die("01");
        Application_Model_Agendamento::cancelarAgendaAtual();
        $tbUsr = new Application_Model_Usuarios();
        $tbAge = new Application_Model_Agendamento();
        $age_codigo = $this->_getParam("age", FALSE);
        $tbAte = new Application_Model_Atendimento();
        $ate = $tbAte->estaEmAtendimento($age_codigo);
        //die("02");
        if ($ate->age_atendido == "E") {
            $tbAge->alteraSituacao("S", $age_codigo);
        }
        $this->_redirect("/prontuario/agenda-do-dia");
    }

    public function destroiSessionAction() {
        $s = new Zend_Session_Namespace("logon");
        $s->unsetAll();
        $s = new Zend_Session_Namespace("prontuario");
        $s->unsetAll();
        return $this->_redirect("/prontuario/agenda-do-dia");
    }

}

