<?php

class Prontuario_ReceitaMedicaController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		//Zend_Layout::getMvcInstance()->setLayout("prontuario");
		$this->view->title = "Medicamento";
	}

	public function indexAction() {
		$usu_codigo = $this->_getParam("usu_codigo",false);
		$tbUsu = new Application_Model_Usuario();
		
		$this->_helper->layout->setLayout("prontuario");
		//die($this->_getParam("obs", FALSE));
		// no atendimento, é possivel carregar o historico por ajax.
		// Nesse caso, não deve enviar o layout junto
		$this->view->obs = $this->_getParam("obs", FALSE);		
		$this->view->io_codigo = $this->_getParam("io_codigo", FALSE);
		$this->view->ate_codigo = $this->_getParam("ate_codigo", FALSE);
		$this->view->usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$this->view->imprimi = $this->_getParam("imprimi", FALSE);

		if($this->view->obs){
			$this->_helper->layout->disableLayout();
			//echo "<pre>".print_r($tbUsu->getDados($usu_codigo)->usu_nome,1);exit;
			$this->view->usu_nome = $tbUsu->getDados($usu_codigo)->usu_nome;
		}else{
			$age = Application_Model_Agendamento::usuEmAberto();
		//	echo "<pre>".print_r("asdas".$age,1);exit;
			$this->view->usu_nome = $age->age_paciente;
		}
		
	}
	
	public function formAction(){
		$tbRec = new Application_Model_Receita();
		$this->view->tipo = $this->_getParam("tipo","posto");
		$this->view->dados = $tbRec->temReceita($this->view->tipo);
	}
	
	public function itensAction(){		
		$tipo = $this->_getParam("tipo","posto");
		$obs = $this->_getParam("obs",FALSE);
		
		
		//die("ahahah");
		$tbIRec = new Application_Model_ReceitaItens();
		$this->view->itens = $tbIRec->getItens($tipo);
		$this->view->obs = $obs;
	}
	
	public function itensInternacaoAction(){				
		$obs = $this->_getParam("obs",FALSE);			
		$io_codigo = $this->_getParam("io_codigo",FALSE);
		$ate_codigo = $this->_getParam("ate_codigo",FALSE);
		$usu_codigo = $this->_getParam("usu_codigo",FALSE);
		$imprimi = $this->_getParam("imprimi",FALSE);
//die("ate".$imprimi);
		
                $tbIRec = new Application_Model_ReceitaItens();
		$this->view->itens = $tbIRec->getItensInternacao($io_codigo);
		$this->view->obs = $obs;
		$this->view->io_codigo = $io_codigo;
		$this->view->usu_codigo = $usu_codigo;
		$this->view->ate_codigo = $ate_codigo;
		$this->view->imprimi = $imprimi;
		$this->render("itens");
	}
	
	
	public function historicoAction(){		
		$ate_codigo = $this->_getParam("id", FALSE);
		if(!$ate_codigo)
			return $this->_redirect ("/prontuario");
		
		$tipo = $this->_getParam("tipo","posto");
				
		$tbIRec = new Application_Model_ReceitaItens();
		$this->view->itens = $tbIRec->getHistorico($ate_codigo,$tipo);
		$this->view->tipo = $tipo;
	}	
	
	public function salvarAction() {
		//echo "<pre>".print_r($_POST,1);exit;
		if ($this->_request->isPost()) {
			$io_codigo = $this->_request->getPost("io_codigo",FALSE);
			$usu_codigo = $this->_request->getPost("usu_codigo",FALSE);
			$obs = $this->_request->getPost("obs",FALSE);
			$ate_codigo = $this->_request->getPost("ate_codigo",FALSE);
			$dados = array(
				"ate_codigo" => $ate_codigo,
				"rec_tipo" => $this->_request->getPost("rec_tipo", NULL),
				"rec_validade" => $this->_request->getPost("rec_validade", NULL)
			);
			
			$dadosItens = array(
				
				"pro_codigo" => $this->_request->getPost("pro_codigo", NULL),
				"irec_quantidade" => $this->_request->getPost("irec_quantidade", NULL),
				"irec_recomendacao" => $this->_request->getPost("irec_recomendacao", NULL),
				"irec_produto" => $this->_request->getPost("irec_produto", NULL),
				"desc_produto" => $this->_request->getPost("desc_produto", NULL)
			);			
			try {
				
				$tbRec = new Application_Model_Receita();
				$tbIRec = new Application_Model_ReceitaItens();
				
				$dadosItens["rec_codigo"] = $tbRec->salvar($dados,$obs);	
				
				$tbIRec->salvar($dadosItens, $dados['rec_tipo']);
				
				$tipos = array("posto"=>"","controlados"=>"#tabs2-2","externo"=>"#tabs2-3");
				$tab = $tipos[ $dados['rec_tipo'] ];
				if($obs == "S"){
					$this->_redirect("/prontuario/receita-medica/index/obs/S/io_codigo/".$io_codigo."/ate_codigo/".$ate_codigo."/usu_codigo/".$usu_codigo."/".$tab);
				}else{
					$this->_redirect("/prontuario/receita-medica/".$tab);
				}
				
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object) $dados;
				$this->view->$dados['rec_tipo'] = (object) $dadosItens;
				$this->render("index");
			}
		} else {
			$this->_redirect("/prontuario/receita-medica");
		}
	}

	public function excluirAction(){
		$id = (int) $this->_getParam("id",0);
		$ate_codigo = $this->_getParam("ate_codigo",FALSE);
		$io_codigo = $this->_getParam("io_codigo",FALSE);
                
               
		if(!$id)
			return $this->_redirect ("/prontuario/receita-medica");
		
		$tbIRec = new Application_Model_ReceitaItens();
		$tbIRec->excluir($id);
		if($io_codigo){
                   return $this->_redirect ("/leito/atendimento/index/cod/$io_codigo/ate_codigo/$ate_codigo");
                }else{
                    return $this->_redirect ("/prontuario/receita-medica");
                }
	}

	public function imprimirAction(){
		Zend_Layout::getMvcInstance()->setLayout("print");
		$tbUsr = new Application_Model_Usuarios();
		
		$this->view->title = "Imprimir Receita Médica";
		
                $io_codigo = $this->_getParam("io_codigo",FALSE);
                $usu_codigo = $this->_getParam("usu_codigo",FALSE);
		$tipo = $this->_getParam("tipo","posto");
		
		$tbRec = new Application_Model_Receita();
		$this->view->dados = $tbRec->imprimir($tipo,$io_codigo,$usu_codigo);		
		$this->view->tipo = $tipo;
		$this->view->isMedico = $tbUsr->isMedico();
	}
}

