<?php

require_once COMUM_PATH."/reportApi/GeradorRelatorio.php";

class Relatorio_CertidaoLiberatoriaController extends Zend_Controller_Action {
    
    public function init(){

    	//"Solução técnica não-oficial" para remoção do arquivo relatorio.css, carregado automagicamente pelo Zend.
	    $headLinkContainer = $this->view->headLink()->getContainer();
	    foreach ($headLinkContainer as $key => $css){
	    	if (strpos($css->href,"relatorio")){
			    unset($headLinkContainer[$key]);
		    };
	    }
	    //Fim da solução
    }
    
    public function indexAction(){
	    $this->_helper->Layout->setLayout("simples");
	    $tbCertLib = new Application_Model_CertidaoLiberatoria();
	    $this->view->dados = $tbCertLib->getCertidoes();
    }


	public function pesquisaDadosAction(){
		$this->_helper->layout->disableLayout();
		$tbCert =  new Application_Model_CertidaoLiberatoria();
		$busca = $this->_request->getPost("busca");


		$this->view->dados = $tbCert->getDadosPesquisa($busca)->toArray();
		return $this->render("dados",NULL,TRUE);
	}

    
    public function formCertidaoLiberatoriaAction(){
	    $this->_helper->layout->disableLayout();
	    $tbAscl = new Application_Model_CertidaoLiberatoria();
	    $asclCodigo = $this->_request->getParam("ascl_codigo");
	    if ($asclCodigo){
		    $this->view->dados = $tbAscl->getDadosCertidao($asclCodigo);
	    }
	    if (!$asclCodigo){
		    $this->view->numero = $tbAscl->getNumeroCertidao();
	    }

	    $this->view->lei = $tbAscl->getLeiCertidao();
	    $this->view->decreto = $tbAscl->getDecretoCertidao();

    }

	public function formSalvarAction() {
		$this->_helper->layout->disableLayout();
		try {
			$asclCodigoPost = $this->_request->getPost("ascl_codigo");
			$dados = array_map("strtoupper", $_POST);

			$numeroCertidao = explode("/", $dados['numero']);

			$dadosCertidao = array(
				'ascl_codigo' => $dados['ascl_codigo'],
				'uni_codigo' => $dados['uni_codigo'],
				'ascl_lei' => $dados['ascl_lei'],
				'ascl_decreto' => $dados['ascl_decreto'],
				'ascl_data_validade' => $dados['ascl_data_validade'],
				'ascl_data_concessao' => $dados['ascl_data_concessao'],
				'ascl_numero' => $numeroCertidao[0],
				'ascl_exercicio' => $numeroCertidao[1],
				'usr_codigo' => $dados['usr_codigo'],
				'ascl_cargo' => $dados['crg_codigo'] ? $dados['crg_codigo'] : null
			);

			$this->view->codigo = $asclCodigoPost;

			// Valida Edição
			if ($asclCodigoPost=="") {
				unset($dadosCertidao["ascl_codigo"]);
			}
			try{
				$tbCert = new Application_Model_CertidaoLiberatoria();
				$this->view->dados = $tbCert->salvar($dadosCertidao);
			} catch (Exception $exc) {
				$this->view->dados = $exc->getMessage();
			}

		} catch (Exception $exc) {
			$this->view->dados = $exc->getMessage();
		}

		return $this->render("dados", NULL, TRUE);
	}

	public function relCertidaoLiberatoriaAction(){

        $ascl_codigo = $this->_getParam("ascl_codigo", NULL);
        $tp_rel = "SINTETICO";
        $gerador = new GeradorRelatorio();

        $this->view->dados = $gerador->gerar(
            "SOCIAL",
            "certidaoLiberatoria",
            array(
                "asclCodigo" => $ascl_codigo,
                "tp_rel" => $tp_rel
            )
        );
        $this->render("dados", NULL, TRUE);
    }
}

