<?php

class Suas_FamiliaController extends Zend_Controller_Action {

  public function init() {
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.maskMoney.js');
  }

  /* -----------------------------------------------------/
   * DADOS DA FAMÍLIA PRONTUÁRIO SUAS                     /
   * ---------------------------------------------------- */

  public function indexAction() {
    $this->view->title = "PRONTUÁRIO SUAS - DADOS DA FAMÍLIA";
    $this->_helper->layout->setLayout("simples");
    $tbUsr = new Application_Model_Usuarios();
    $usrLogin = $this->_request->getParam("id_login");
    $this->view->usr_codigo = $this->getDadosUsuarioLogado($usrLogin);
  }

  // Salva os dados do prontuário suas da familia
  public function carregaProntuarioAction() {
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $tbAspsUni = new Application_Model_AsProntuarioSuasUnidade();
    $dadosAsps = array(
      "asps_num_prontuario" => $this->_request->getPost("asps_num_prontuario")
    );
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {
      // Salvando prontuário SUAS
      $usuCodigo = $this->_request->getPost("usu_codigo");
      $aspsCodigo = $tbAsps->salvar($dadosAsps);
      // Salvando dados da unidade do prontuário por periodo
      $dadosProntUni = array(
        "asps_codigo" => $aspsCodigo,
        "uni_codigo" => $this->_request->getPost("uni_codigo"),
        "aspsuni_dtinicio" => "NOW()"
      );
      $tbAspsUni->salvar($dadosProntUni);
      // Salvando dados pessoa de referência SUAS
      $this->salvarRefProntuarioAction($aspsCodigo, $usuCodigo);
      Zend_Db_Table::getDefaultAdapter()->commit();
      // Retornando código SUAS jQuery
      $this->view->dados = $aspsCodigo;
      return $this->render("dados", NULL, TRUE);
    } catch (Exception $ex) {
      Zend_Db_Table::getDefaultAdapter()->rollBack();
      $this->view->dados = $ex->getMessage();
      return $this->render("dados", NULL, TRUE);
    }
  }

  public function salvarRefProntuarioAction($aspsCodigo = FALSE, $usuCodigo = FALSE) {
    $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
    $tbUsu = new Application_Model_Usuario();
    $dadosAspsu = array(
      "usu_codigo" => $usuCodigo,
      "asps_codigo" => $aspsCodigo,
      "aspsu_num_ordem" => "1",
      "aspsu_parentesco" => "1",
      "aspsu_ativo" => "t"
    );
    $dadosUsu = array(
      "usu_codigo" => $usuCodigo,
      "usu_asps_ativo" => "t",
      "usu_asps_ref" => "t"
    );
    try {
      $tbAspsu->salvar($dadosAspsu);
      $tbUsu->salvar($dadosUsu);
    } catch (Exception $ex) {
      $ex->getMessage();
    }
  }

  public function validaNumProntuarioAction() {
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $numProntuario = $this->_request->getPost("num_prontuario", FALSE);
    $this->view->dados = $tbAsps->validaNumProntuario($numProntuario);
    return $this->render("dados", NULL, TRUE);
  }

  public function setaNumProntuarioDispAction() {
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $numProntuario = $tbAsps->getUltNumeroProntuario()->asps_num_prontuario;
    $this->view->dados = $numProntuario + 1;
    return $this->render("dados", NULL, TRUE);
  }

  public function formDadosFamiliaPreenchidoAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $usuCodigo = $this->_request->getParam("usu_codigo");
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dados = $tbAsps->getDadosProntuarioRef($aspsCodigo, $usuCodigo);
  }

  public function formDadosFamiliaNovoAction() {
    $this->_helper->layout->disableLayout();
  }

  public function carregaMembrosFamiliaAction() {
    $aspsCodigo = $this->_request->getPost("asps_codigo");
    $tbUsu = new Application_Model_Usuario();
    $this->view->dados = $tbUsu->selectTagMembrosFamilia($aspsCodigo);
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM DADOS DA FAMÍLIA PRONTUÁRIO SUAS                 /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * REGISTRO ATENDIMENTO SIMPLIFICADO                    /
   * ---------------------------------------------------- */

  public function salvaRegistroAtendimentoSimplificadoAction() {
    $tbAspsrs = new Application_Model_AspsRegistroSimplificado();
    $dados = array(
      "asps_codigo" => $this->_request->getPost("asps_codigo"),
      "usr_codigo" => $this->_request->getPost("usr_codigo"),
      "usu_codigo" => ($this->_request->getPost("usu_codigo") != "" ?
        $this->_request->getPost("usu_codigo") :
        $this->_request->getPost("usu_codigo_ref")),
      "aspsrs_descricao" => $this->trataValor($this->_request->getPost("aspsrs_descricao")),
      "aspsrs_codigo_desc" => $this->_request->getPost("aspsrs_codigo_desc"),
      "aspsrs_data_atendimento" => "NOW()"
    );
    try {
      $tbAspsrs = new Application_Model_AspsRegistroSimplificado();
      $tbAspsrs->salvar($dados);
    } catch (Exception $ex) {
      $ex->getMessage();
    }
  }

  /* -----------------------------------------------------/
   * FIM REGISTRO ATENDIMENTO SIMPLIFICADO                /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * IDENTIFICAÇÃO DA PESSOA E REFERÊNCIA DA FAMÍLIA      /
   * ---------------------------------------------------- */

  public function dadosPessoaRefFamiliaAction() {
    $this->_helper->layout->disableLayout();
    $tbUsu = new Application_Model_Usuario();
    $tbConf = new Application_Model_Configuracao();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->dados = $tbUsu->getDadosEnderecoPessoaRef($aspsCodigo);
    $this->view->config = $tbConf->getConfig('MODULO_RUA');
  }

  public function salvarDadosPessoaRefFamiliaAction() {
    $this->_helper->layout->disableLayout();
    // Array de Dados Cidadão, o mesmo já vem carregado
    $pessoa = array(
      "usu_codigo" => ($this->_request->getPost("usu_codigo", "") ? strtoupper($this->_request->getPost("usu_codigo", "")) : NULL),
      "usu_nome" => ($this->_request->getPost("usu_nome", "") ? $this->_request->getPost("usu_nome", "") : NULL),
      "usu_as_apelido" => ($this->_request->getPost("usu_as_apelido", "") ? $this->_request->getPost("usu_as_apelido", "") : NULL),
      "usu_mae" => $this->trataValor($this->_request->getPost("usu_mae", "")),
      "usu_nis" => ($this->_request->getPost("usu_nis", "") ? $this->_request->getPost("usu_nis", "") : NULL),
      "usu_cpf" => ($this->_request->getPost("usu_cpf", "") ? $this->_request->getPost("usu_cpf", "") : NULL),
      "usu_rg" => ($this->_request->getPost("usu_rg", "") ? $this->_request->getPost("usu_rg", "") : NULL),
      "usu_rg_emissor" => ($this->_request->getPost("usu_rg_emissor", "") ? $this->_request->getPost("usu_rg_emissor", "") : NULL),
      "uf_sigla_rg" => ($this->_request->getPost("uf_sigla_rg", "") ? $this->_request->getPost("uf_sigla_rg", "") : NULL),
      "usu_rg_dt_emissao" => ($this->_request->getPost("usu_rg_dt_emissao", "") ? $this->_request->getPost("usu_rg_dt_emissao", "") : NULL),
      "usu_sexo" => ($this->_request->getPost("usu_sexo", "") ? $this->_request->getPost("usu_sexo", "") : NULL),
      "usu_datanasc" => ($this->_request->getPost("usu_datanasc", "") ? $this->_request->getPost("usu_datanasc", "") : NULL),
      "usu_asdeficiencia" => ($this->_request->getPost("usu_asdeficiencia", "") ? $this->_request->getPost("usu_asdeficiencia", "") : NULL),
      "usu_asdoc_cnprov" => ($this->_request->getPost("usu_asdoc_cnprov", "") ? $this->_request->getPost("usu_asdoc_cnprov", "") : NULL),
      "usu_asdoc_rgprov" => ($this->_request->getPost("usu_asdoc_rgprov", "") ? $this->_request->getPost("usu_asdoc_rgprov", "") : NULL),
      "usu_asdoc_ctpsprov" => ($this->_request->getPost("usu_asdoc_ctpsprov", "") ? $this->_request->getPost("usu_asdoc_ctpsprov", "") : NULL),
      "usu_asdoc_cpfprov" => ($this->_request->getPost("usu_asdoc_cpfprov", "") ? $this->_request->getPost("usu_asdoc_cpfprov", "") : NULL),
      "usu_asdoc_teprov" => ($this->_request->getPost("usu_asdoc_teprov", "") ? $this->_request->getPost("usu_asdoc_teprov", "") : NULL),
      "usu_fone" => ($this->_request->getPost("usu_fone", "") ? $this->_request->getPost("usu_fone", "") : NULL),
      "usu_celular" => ($this->_request->getPost("usu_celular", "") ? $this->_request->getPost("usu_celular", "") : NULL),
      "usu_recado" => ($this->_request->getPost("usu_recado", "") ? $this->_request->getPost("usu_recado", "") : NULL),
      "usu_dt_obito" => ($this->_request->getPost("usu_dt_obito", "") ? $this->_request->getPost("usu_dt_obito", "") : NULL),
      "usu_obito" => ($this->_request->getPost("usu_obito", "") ? $this->_request->getPost("usu_obito", "") : NULL)
    );

    if ($this->_request->getPost("dom_sn") == 1) {
      $dom_numero = "0";
    } else {
      $domNum = $this->_request->getPost("dom_numero");
      $dom_numero = ($domNum !== 'S/N' ? $domNum : "0");
    }
    // Array de dados de domicilio
    $dadosDomicilio = array(
      "dom_data_cadastro" => date("Y-m-d"),
      "dom_numero" => $dom_numero,
      "dom_complemento" => ($this->_request->getPost("dom_complemento") ? trim($this->_request->getPost("dom_complemento", "")) : NULL),
      "dom_ponto_referencia" => ($this->_request->getPost("dom_ponto_referencia") ? trim($this->_request->getPost("dom_ponto_referencia", "")) : NULL),
      "co_tipo_domicilio" => "6",
      "dom_telefone" => ($this->_request->getPost("dom_telefone") ? $this->_request->getPost("dom_telefone", "") : NULL),
      "dom_as_localizacao" => ($this->_request->getPost("dom_as_localizacao") ? $this->_request->getPost("dom_as_localizacao", "") : NULL),
      "dom_as_abrigo" => $this->trataBoolean($this->_request->getPost("dom_as_abrigo")),
      "usu_codigo_responsavel" => $pessoa["usu_codigo"],
      "rua_codigo" => ($this->_request->getPost("rua_codigo") ? $this->_request->getPost("rua_codigo", "") : NULL)
    );

    // Inicio da transação
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {
      $tbDom = new Application_Model_Domicilio();
      $tbDom->removeResponsavelDomicilio($pessoa["usu_codigo"]);

      if ($this->_request->getPost("dom_codigo")) {
        $dadosDomicilio["dom_codigo"] = $this->_request->getPost("dom_codigo");
      } else {
        if ($tbDom->getQtdCodDomicilioDuplicadoCompl($dadosDomicilio)->dom_codigo != "") {
          $dadosDomicilio["dom_codigo"] = $tbDom->getQtdCodDomicilioDuplicadoCompl($dadosDomicilio)->dom_codigo;
        }
      }

      $dadosDomicilio = array_map("strtoupper", $dadosDomicilio);
      $codDom = $tbDom->salvarDomicilio($dadosDomicilio);
      $pessoa["dom_codigo"] = $codDom;

      /* -------------------------------------------------------/
	   * INSERÇÃO CIDADÃO                                       /
	   * ------------------------------------------------------- */

      // Salvando dados usuario
      $tbUsu = new Application_Model_Usuario();
      $pessoa = array_map("strtoupper", $pessoa);
      $pessoa['usu_obito'] = ($this->_request->getPost("usu_obito", "") ? $this->_request->getPost("usu_obito", "") : NULL);
      if ($this->_request->getPost("usu_obito") == "t") {
        $pessoa['usu_bloqueado'] = "t";
      } else {
        $pessoa['usu_bloqueado'] = "f";
      }
      $usu_codigo = $tbUsu->salvarComCamposVazio($pessoa);
      Zend_Db_Table::getDefaultAdapter()->commit();
      $this->view->dados = $codDom;
    } catch (Exception $exc) {
      Zend_Db_Table::getDefaultAdapter()->rollBack();
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function validaDadosPessoaRefFamiliaAction() {
    $this->_helper->layout->disableLayout();
    $tbCid = new Application_Model_Usuario();
    $asps_codigo = $this->_request->getPost("asps_codigo");
    $this->view->dados = count($tbCid->validaDadosPessoaRef($asps_codigo));
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM IDENTIFICAÇÃO DA PESSOA E REFERÊNCIA DA FAMÍLIA  /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * FORMA DE INGRESSO NA UNIDADE E PRIMEIRO ATENDIMENTO                                  /
   * ---------------------------------------------------- */

  public function primeiroAtendimentoAction() {
    $this->_helper->layout->disableLayout();
    $tbAspt = new Application_Model_AspsPrimeiroAtendimento();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->dados = $tbAspt->getDadosPorProntuario($aspsCodigo);
  }

  public function primeiroAtendimentoSalvarAction() {
    $this->_helper->layout->disableLayout();
    $tbAspt = new Application_Model_AspsPrimeiroAtendimento();
    try {
      $dados = array(
        "aspt_forma_acesso" => $this->trataValor($this->_request->getPost("aspt_forma_acesso")),
        "aspt_encaminhamento" => $this->trataValor($this->_request->getPost("aspt_encaminhamento")),
        "aspt_razoes_necessidades" => $this->trataValor($this->_request->getPost("aspt_razoes_necessidades")),
        "aspt_bolsa_familia" => $this->trataBoolean($this->_request->getPost("aspt_bolsa_familia")),
        "aspt_bpc" => $this->trataBoolean($this->_request->getPost("aspt_bpc")),
        "aspt_paif" => $this->trataBoolean($this->_request->getPost("aspt_paif")),
        "aspt_scfv" => $this->trataBoolean($this->_request->getPost("aspt_scfv")),
        "aspt_paefi" => $this->trataBoolean($this->_request->getPost("aspt_paefi")),
        "aspt_outros" => $this->trataBoolean($this->_request->getPost("aspt_outros")),
        "aspt_prog_prioritarios" => $this->trataValor($this->_request->getPost("aspt_prog_prioritarios")),
        "asps_codigo" => $this->trataValor($this->_request->getPost("asps_codigo")),
      );
      // Valida Edição
      if ($this->_request->getPost("aspt_codigo")) {
        $dados["aspt_codigo"] = $this->_request->getPost("aspt_codigo");
      }
      $this->view->dados = $tbAspt->salvar($dados);
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function validaPrimeiroAtendimentoAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getPost("asps_codigo");
    $tbAspt = new Application_Model_AspsPrimeiroAtendimento();
    $this->view->dados = $tbAspt->verificaStatusAtendimento($aspsCodigo);
    return $this->render("dados", NULL, TRUE);
  }

  /* ----------------------------------------------------------/
   * FIM FORMA DE INGRESSO NA UNIDADE E PRIMEIRO ATENDIMENTO   /
   * --------------------------------------------------------- */


  /*-------------------------------------------------------------
   * ATENDIMENTOS / ENCAMINHAMENTOS / BENEFICIOS EVENTUAIS / GRUPOS
   *------------------------------------------------------------*/
  public function atendimentosAction() {
    $this->_helper->layout->disableLayout();
  }

  public function atendimentosBasicosAction() {
    $this->_helper->layout->disableLayout();
    $this->view->usr_atual = (new Application_Model_Usuarios())->getUsrAtual()->usr_codigo;
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbAtend = new Application_Model_AsAtendimentoBasicoCras();
    $this->view->dados = $tbAtend->getDadosPorProntuarioSuas($aspsCodigo);
    $this->view->asps_codigo = $aspsCodigo;

  }

  public function formAtendimentoBasicoAction() {
    $this->_helper->layout->disableLayout();
    $tbAteBasCras = new Application_Model_AsAtendimentoBasicoCras();
    $tbAteTipo = new Application_Model_AsAtendimentoTipo();
    $tbGruAce = new Application_Model_GrupoAcessoUsuarios();
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $asabCodigo = $this->_request->getParam("asab_codigo");
    $asps_codigo = $this->_request->getParam("asps_codigo");
    if ($asabCodigo) {
      $this->view->dados = $tbAteBasCras->getDadosPorId($asabCodigo);

      $tbMot = new Application_Model_MotivoAtendimento();
      $motivos = $tbMot->getMotivoPorAsab($asabCodigo);
      if (count($motivos) > 0) {
        $this->view->motivos = $motivos;
      }
    }

    $usr = (new Application_Model_Usuarios())->getUsrAtual();
    $this->view->uni_codigo = $usr->uni_codigo;
    $this->view->uni_desc = $usr->uni_desc;
    $this->view->usr_codigo = $usr->usr_codigo;
    $this->view->usr_nome = $usr->usr_nome;

    $this->view->membros = (new Application_Model_AsProntuarioSuas())->getDadosComposicaoFamiliarSuas($asps_codigo);

    $asatCodigo = $this->view->dados->asat_codigo;
    $this->view->acessoCursoSup = $tbGruAce->verificaAcessoCursoSuperior($usrCodigo);
    $this->view->selectTipoAte = $tbAteTipo->selectTag($asatCodigo);
  }

  public function visualizarAtendimentoBasicoAction() {
    $this->_helper->layout->disableLayout();
    $tbAteBasCras = new Application_Model_AsAtendimentoBasicoCras();
    $tbAteTipo = new Application_Model_AsAtendimentoTipo();
    $tbGruAce = new Application_Model_GrupoAcessoUsuarios();
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $asabCodigo = $this->_request->getParam("asab_codigo");
    $asps_codigo = $this->_request->getParam("asps_codigo");
    if ($asabCodigo) {
      $this->view->dados = $tbAteBasCras->getDadosPorId($asabCodigo);

      $tbMot = new Application_Model_MotivoAtendimento();
      $motivos = $tbMot->getMotivoPorAsab($asabCodigo);
      if (count($motivos) > 0) {
        $this->view->motivos = $motivos;
      }
    }

    $usr = (new Application_Model_Usuarios())->getUsrAtual();
    $this->view->uni_codigo = $usr->uni_codigo;
    $this->view->uni_desc = $usr->uni_desc;
    $this->view->usr_codigo = $usr->usr_codigo;
    $this->view->usr_nome = $usr->usr_nome;

    $this->view->membros = (new Application_Model_AsProntuarioSuas())->getDadosComposicaoFamiliarSuas($asps_codigo);

    $asatCodigo = $this->view->dados->asat_codigo;
    $this->view->acessoCursoSup = $tbGruAce->verificaAcessoCursoSuperior($usrCodigo);
    $this->view->selectTipoAte = $tbAteTipo->selectTag($asatCodigo);
  }

  public function encaminhamentosAction() {

    $this->_helper->layout->disableLayout();
    $this->view->usr_atual = (new Application_Model_Usuarios())->getUsrAtual()->usr_codigo;
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbEnc = new Application_Model_AsEncaminhamento();
    $this->view->dados = $tbEnc->getDadosPorProntuarioSuas($aspsCodigo);
    $this->view->asps_codigo = $aspsCodigo;
  }

  public function formEncaminhamentoAction() {
    $this->_helper->layout->disableLayout();
    $asencCodigo = $this->_request->getParam("asenc_codigo");
    $asps_codigo = $this->_request->getParam("asps_codigo");
    if ($asencCodigo) {
      $tbAsEnc = new Application_Model_AsEncaminhamento();
      $this->view->dados = $tbAsEnc->getDadosPorId($asencCodigo);
      $asecCodigo = $this->view->dados->asec_codigo;
      $aseCodigo = $this->view->dados->ase_codigo;
    }

    $usr = (new Application_Model_Usuarios())->getUsrAtual();
    $this->view->uni_codigo = $usr->uni_codigo;
    $this->view->uni_desc = $usr->uni_desc;
    $this->view->usr_codigo = $usr->usr_codigo;
    $this->view->usr_nome = $usr->usr_nome;

    $this->view->membros = (new Application_Model_AsProntuarioSuas())->getDadosComposicaoFamiliarSuas($asps_codigo);

    $tbAsEc = new Application_Model_AsEncaminhamentoCodigos();
    $this->view->selectEncCods = $tbAsEc->selectTag($asecCodigo);
    $tbEst = new Application_Model_AsEstabelecimentos();
    $this->view->selectEst = $tbEst->selectTag($aseCodigo);
    $this->view->usr_codigo = $this->_request->getParam("usr_codigo");
  }

  public function visualizarEncaminhamentoAction() {
    $this->_helper->layout->disableLayout();
    $asencCodigo = $this->_request->getParam("asenc_codigo");
    $asps_codigo = $this->_request->getParam("asps_codigo");
    if ($asencCodigo) {
      $tbAsEnc = new Application_Model_AsEncaminhamento();
      $this->view->dados = $tbAsEnc->getDadosPorId($asencCodigo);
      $asecCodigo = $this->view->dados->asec_codigo;
      $aseCodigo = $this->view->dados->ase_codigo;
    }

    $usr = (new Application_Model_Usuarios())->getUsrAtual();
    $this->view->uni_codigo = $usr->uni_codigo;
    $this->view->uni_desc = $usr->uni_desc;
    $this->view->usr_codigo = $usr->usr_codigo;
    $this->view->usr_nome = $usr->usr_nome;

    $this->view->membros = (new Application_Model_AsProntuarioSuas())->getDadosComposicaoFamiliarSuas($asps_codigo);

    $tbAsEc = new Application_Model_AsEncaminhamentoCodigos();
    $this->view->selectEncCods = $tbAsEc->selectTag($asecCodigo);
    $tbEst = new Application_Model_AsEstabelecimentos();
    $this->view->selectEst = $tbEst->selectTag($aseCodigo);
    $this->view->usr_codigo = $this->_request->getParam("usr_codigo");
  }

  public function beneficiosAction() {

    $this->_helper->layout->disableLayout();
    $this->view->usr_atual = (new Application_Model_Usuarios())->getUsrAtual()->usr_codigo;
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbBen = new Application_Model_AsBeneficiosDados();
    $this->view->dados = $tbBen->getDadosPorProntuarioSuas($aspsCodigo);
    $this->view->asps_codigo = $aspsCodigo;
  }

  public function formBeneficiosAction() {
    $this->_helper->layout->disableLayout();
    $asbdCodigo = $this->_request->getParam("asbd_codigo");
    $asps_codigo = $this->_request->getParam("asps_codigo");
    if ($asbdCodigo) {
      $tbBenDados = new Application_Model_AsBeneficiosDados();
      $this->view->dados = $tbBenDados->getDadosPorId($asbdCodigo);
      $tbBenItens = new Application_Model_AsBeneficiosDadosItens();
      $this->view->dadosBenItens = $tbBenItens->getDadosPorId($asbdCodigo);
    }
    $usr = (new Application_Model_Usuarios())->getUsrAtual();
    $this->view->uni_codigo = $usr->uni_codigo;
    $this->view->uni_desc = $usr->uni_desc;
    $this->view->usr_codigo = $usr->usr_codigo;
    $this->view->usr_nome = $usr->usr_nome;

    $this->view->membros = (new Application_Model_AsProntuarioSuas())->getDadosComposicaoFamiliarSuas($asps_codigo);

    $this->view->codigo = $asbdCodigo;
    $tbBenTipo = new Application_Model_AsBeneficiosTipo();
    $this->view->selectTipoBen = $tbBenTipo->selectTag($asbtCodigo, '');
    $tbEst = new Application_Model_AsEstabelecimentos();
    $this->view->selectEst = $tbEst->selectTag($aseCodigo, '');
    $this->view->usr_codigo = $this->_request->getParam("usr_codigo");
    $tbConf = new Application_Model_Configuracao();
    $this->view->mov_data_status = $tbConf->getConfig("BENEFICIO_RETROATIVO");
  }

  public function visualizarBeneficioAction(){
      $this->_helper->layout->disableLayout();
      $asbdCodigo = $this->_request->getParam("asbd_codigo");
      $asps_codigo = $this->_request->getParam("asps_codigo");
      if ($asbdCodigo) {
          $tbBenDados = new Application_Model_AsBeneficiosDados();
          $this->view->dados = $tbBenDados->getDadosPorId($asbdCodigo);
          $tbBenItens = new Application_Model_AsBeneficiosDadosItens();
          $this->view->dadosBenItens = $tbBenItens->getDadosPorId($asbdCodigo);
      }
      $usr = (new Application_Model_Usuarios())->getUsrAtual();
      $this->view->uni_codigo = $usr->uni_codigo;
      $this->view->uni_desc = $usr->uni_desc;
      $this->view->usr_codigo = $usr->usr_codigo;
      $this->view->usr_nome = $usr->usr_nome;

      $this->view->codigo = $asbdCodigo;
      $this->view->usr_codigo = $this->_request->getParam("usr_codigo");
      $tbConf = new Application_Model_Configuracao();
      $this->view->mov_data_status = $tbConf->getConfig("BENEFICIO_RETROATIVO");
  }

  public function atendimentosColetivosAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dados = $tbAsps->getGruposPorProntuarioSuas($aspsCodigo);
    $this->view->asps_codigo = $aspsCodigo;
  }

  /*-------------------------------------------------------------
   * FIM ATENDIMENTOS
   *------------------------------------------------------------*/


  /* -----------------------------------------------------/
   * COMPOSIÇÃO FAMILIAR                                  /
   * ---------------------------------------------------- */

  public function composicaoFamiliarAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dados = $tbAsps->getDadosComposicaoFamiliarSuas($aspsCodigo);
  }

  public function formComposicaoFamiliarAction() {
    $this->_helper->layout->disableLayout();
    $tbUsu = new Application_Model_Usuario();
    $usuCodigo = $this->_request->getParam("usu_codigo");
    if ($usuCodigo)
      $this->view->dados = $tbUsu->getDadosCidadao($usuCodigo);
  }

  public function formComposicaoFamiliarSalvarAction() {
    $this->_helper->layout->disableLayout();
    /* DADOS CIDADÃO */
    $tbUsu = new Application_Model_Usuario();
    $usuCodigo = $this->trataValor($this->_request->getPost("usu_codigo"));
    $dadosUsu = array(
      "usu_nome" => $this->trataValor($this->_request->getPost("usu_nome")),
      "usu_mae" => $this->trataValor($this->_request->getPost("usu_mae")),
      "usu_as_apelido" => $this->trataValor($this->_request->getPost("usu_as_apelido")),
      "usu_nis" => $this->trataValor($this->_request->getPost("usu_nis")),
      "usu_cpf" => $this->trataValor($this->_request->getPost("usu_cpf")),
      "usu_rg" => $this->trataValor($this->_request->getPost("usu_rg")),
      "usu_rg_emissor" => $this->trataValor($this->_request->getPost("usu_rg_emissor")),
      "usu_rg_emissor" => $this->trataValor($this->_request->getPost("estadoemissor")),
      "usu_obito" => $this->_request->getPost("usu_obito", NULL),
      "usu_dt_obito" => $this->trataValor($this->_request->getPost("usu_dt_obito")),
      "usu_rg_dt_emissao" => $this->trataValor($this->_request->getPost("usu_rg_dt_emissao")),
      "usu_sexo" => $this->trataValor($this->_request->getPost("usu_sexo")),
      "usu_datanasc" => $this->trataValor($this->_request->getPost("usu_datanasc")),
      "aspsu_parentesco" => $this->trataValor($this->_request->getPost("aspsu_parentesco")),
      "usu_asdeficiencia" => $this->trataBoolean($this->_request->getPost("usu_asdeficiencia")),
      "usu_asdoc_cnprov" => $this->trataValor($this->_request->getPost("usu_asdoc_cnprov")),
      "usu_asdoc_rgprov" => $this->trataValor($this->_request->getPost("usu_asdoc_rgprov")),
      "usu_asdoc_ctpsprov" => $this->trataValor($this->_request->getPost("usu_asdoc_ctpsprov")),
      "usu_asdoc_cpfprov" => $this->trataValor($this->_request->getPost("usu_asdoc_cpfprov")),
      "usu_asdoc_teprov" => $this->trataValor($this->_request->getPost("usu_asdoc_teprov")),
      "usu_asps_ativo" => "t"
    );
    if ($this->_request->getPost("usu_obito") == "t") {
      $dadosUsu['usu_bloqueado'] = "t";
    } else {
      $dadosUsu['usu_bloqueado'] = "f";
    }

    /* ATUALIZA DOMICILIO CIDADÃO */
    $usuCodRef = $this->_request->getPost("usu_codigo_ref");
    $codDom = $tbUsu->getDadosCidadao($usuCodRef)->dom_codigo;
    $dadosUsu["dom_codigo"] = $codDom;
    // Valida Edição
    if ($usuCodigo) {
      $dadosUsu["usu_codigo"] = $usuCodigo;
    } else {
      $dadosUsu['usr_cadastro_codigo'] = $_SESSION['usr_codigo'];
      $dadosUsu['uni_cadastro_codigo'] = $_SESSION['logon']['usr']->uni_codigo;
    }
    // Início da Transação
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {
      $codCid = $tbUsu->salvar($dadosUsu);
      /* DADOS VÍNCULO CIDADÃO SUAS(FAMILIA) */
      $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
      $aspsCodigo = $this->trataValor($this->_request->getPost("asps_codigo"));
      $aspsuCodigo = $this->trataValor($this->_request->getPost("aspsu_codigo"));
      $dadosVincCid = array(
        "asps_codigo" => $aspsCodigo,
        "usu_codigo" => $codCid,
        "aspsu_num_ordem" => (($tbAspsu->getOrdemComposicaoFamiliar($aspsCodigo)->aspsu_num_ordem) + 1),
        "aspsu_parentesco" => $this->trataValor($this->_request->getPost("aspsu_parentesco")),
        "aspsu_ativo" => "t"
      );
      // Valida Edição
      if ($aspsuCodigo) {
        $dadosVincCid["aspsu_codigo"] = $aspsuCodigo;
        // Removendo ordem para não editar
        unset($dadosVincCid["aspsu_num_ordem"]);
      }
      $tbAspsu->salvar($dadosVincCid);
      Zend_Db_Table::getDefaultAdapter()->commit();
      $this->view->dados = $codCid;
    } catch (Exception $ex) {
      Zend_Db_Table::getDefaultAdapter()->roolBack();
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function formComposicaoFamiliarInativaAction() {
    $this->_helper->layout->disableLayout();
    $this->view->aspsu_codigo = $this->_request->getParam("aspsu_codigo");
  }

  public function formComposicaoFamiliarInativaSalvarAction() {
    $this->_helper->layout->disableLayout();
    // Observação Composição Familiar
    $dadosAsocf = array(
      "asps_codigo" => $this->_request->getPost("asps_codigo"),
      "usr_codigo" => $this->_request->getPost("usr_codigo"),
      "aspso_obs" => $this->trataValor($this->_request->getPost("aspso_obs")),
      "aspso_data" => date("Y-m-d h:i:s")
    );
    // Dados desativação PRONTUARIO SUAS
    $aspsuCodigo = $this->_request->getPost("aspsu_codigo");
    $dadosAspsu = array(
      "aspsu_codigo" => $aspsuCodigo,
      "aspsu_ativo" => "f"
    );
    // Dados desativação Usuário
    $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
    $usuCodigo = $tbAspsu->getCodigo($aspsuCodigo)->usu_codigo;
    $dadosUsu = array(
      "usu_codigo" => $usuCodigo,
      "usu_asps_ativo" => "f",
      "usu_asps_ref" => "f"
    );
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {
      $tbAsObs = new Application_Model_AspsObsCf();
      $codAsObs = $tbAsObs->salvar($dadosAsocf);
      $tbAspsu->salvar($dadosAspsu);
      $tbUsu = new Application_Model_Usuario();
      $tbUsu->salvar($dadosUsu);
      Zend_Db_Table::getDefaultAdapter()->commit();
      $this->view->dados = $codAsObs;
      return $this->render("dados", NULL, TRUE);
    } catch (Exception $ex) {
      Zend_Db_Table::getDefaultAdapter()->roolBack();
      $this->view->dados = $ex->getMessage();
      return $this->render("dados", NULL, TRUE);
    }
  }

  public function composicaoFamiliarPerfilEtarioAction() {
    $this->_helper->layout->disableLayout();
    $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $dadosDatas = $tbAspsu->getDtNascimentoCidadaoSuas($aspsCodigo);
    $this->view->dados = $this->faixaDeIdades($dadosDatas);
  }

  public function composicaoFamiliarObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAsObs = new Application_Model_AspsObsCf();
    $this->view->dados = $tbAsObs->getObsSuas($aspsCodigo);
  }

  public function composicaoFamiliarObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAsObs = new Application_Model_AspsObsCf();
      $dados = array(
        "asps_codigo" =>
          $this->_request->getPost("asps_codigo"),
        "usr_codigo" =>
          $this->trataValor($this->_request->getPost("usr_codigo")),
        "aspso_obs" =>
          $this->trataValor($this->_request->getPost("aspso_obs")),
        "aspso_data" => date("Y-m-d h:i:s"),
      );
      // Valida Edição
      if ($this->_request->getPost("aspso_codigo")) {
        $dados["aspso_codigo"] = $this->_request->getPost("aspso_codigo");
      }
      $aspsoCod = $tbAsObs->salvar($dados);
      $this->view->dados = $aspsoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function composicaoFamiliarEspecSociaisAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAspses = new Application_Model_AspseEspecSociaisCf();
    $this->view->dados = $tbAspses->getDadosPeloCodigo($aspsCodigo);
  }

  public function composicaoFamiliarEspecSociaisSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspses = new Application_Model_AspseEspecSociaisCf();
      $dados = array(
        "asps_codigo" =>
          $this->_request->getPost("asps_codigo"),
        "aspses_fam_indigena_retnia" =>
          $this->trataValor($this->_request->getPost("aspses_fam_indigena_retnia")),
        "aspses_fam_indigena_nretnia" =>
          $this->trataValor($this->_request->getPost("aspses_fam_indigena_nretnia")),
        "aspses_fam_situacao_rua" => $this->trataBoolean(
          $this->_request->getPost("aspses_fam_situacao_rua")),
        "aspses_fam_quilombada" => $this->trataBoolean(
          $this->_request->getPost("aspses_fam_quilombada")),
        "aspses_fam_ribeirinha" => $this->trataBoolean(
          $this->_request->getPost("aspses_fam_ribeirinha")),
        "aspses_fam_cigana" => $this->trataBoolean(
          $this->_request->getPost("aspses_fam_cigana")),
        "aspses_fam_indigena_nresidente" => $this->trataBoolean(
          $this->_request->getPost("aspses_fam_indigena_nresidente")),
        "aspses_outros" => $this->trataBoolean(
          $this->_request->getPost("aspses_outros")),
        "aspses_data" => date("Y-m-d h:i:s"),
      );
      // Valida Edição
      if ($this->_request->getPost("aspses_codigo")) {
        $dados["aspses_codigo"] = $this->_request->getPost("aspses_codigo");
      }
      $aspsesCod = $tbAspses->salvar($dados);
      $this->view->dados = $aspsesCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM COMPOSIÇÃO FAMILIAR                              /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * INÍCIO CONDIÇÕES HABITACIONAIS                       /
   * ---------------------------------------------------- */

  public function condicoesHabitacionaisAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAspsch = new Application_Model_AspsCondicoesHabitacionais();
    $this->view->dados = $tbAspsch->getDadosPorProntuario($aspsCodigo);
  }

  public function condicoesHabitacionaisSalvarAction() {
    $tbAspsch = new Application_Model_AspsCondicoesHabitacionais();
    $dados = array(
      "asps_codigo" => $this->trataValor($this->_request->getPost("asps_codigo")),
      "aspsch_tipo_residencia" => $this->trataValor($this->_request->getPost("aspsch_tipo_residencia")),
      "aspsch_material" => $this->trataValor($this->_request->getPost("aspsch_material")),
      "aspsch_acesso_energia" => $this->trataValor($this->_request->getPost("aspsch_acesso_energia")),
      "aspsch_possui_agua" => $this->trataBoolean($this->_request->getPost("aspsch_possui_agua")),
      "aspsch_forma_abastecimento" => $this->trataValor($this->_request->getPost("aspsch_forma_abastecimento")),
      "aspsch_escoamento_sanit" => $this->trataValor($this->_request->getPost("aspsch_escoamento_sanit")),
      "aspsch_coleta_lixo" => $this->trataValor($this->_request->getPost("aspsch_coleta_lixo")),
      "aspsch_acessibilidade" => $this->trataValor($this->_request->getPost("aspsch_acessibilidade")),
      "aspsch_domicilio_area_risco" => $this->trataBoolean($this->_request->getPost("aspsch_domicilio_area_risco")),
      "aspsch_domicilio_area_geografica" => $this->trataBoolean($this->_request->getPost("aspsch_domicilio_area_geografica")),
      "aspsch_domicilio_area_conflito" => $this->trataBoolean($this->_request->getPost("aspsch_domicilio_area_conflito"))
    );
    // Valida Inteiros
    if ($this->_request->getPost("aspsch_num_comodos") != "")
      $dados["aspsch_num_comodos"] = $this->_request->getPost("aspsch_num_comodos");
    if ($this->_request->getPost("aspsch_num_comodos_utilizado") != "")
      $dados["aspsch_num_comodos_utilizado"] = $this->_request->getPost("aspsch_num_comodos_utilizado");
    if ($this->_request->getPost("aspsch_num_pessoas_comodos") != "")
      $dados["aspsch_num_pessoas_comodos"] = $this->_request->getPost("aspsch_num_pessoas_comodos");
    // Valida Edição
    if ($this->_request->getPost("aspsch_codigo") != "")
      $dados["aspsch_codigo"] = $this->_request->getPost("aspsch_codigo");
    try {
      $aspschCodigo = $tbAspsch->salvar($dados);
      $this->view->dados = $aspschCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesHabitacionaisObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAschObs = new Application_Model_AspsObsCh();
    $this->view->dados = $tbAschObs->getObsSuas($aspsCodigo);
  }

  public function condicoesHabitacionaisObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAschObs = new Application_Model_AspsObsCh();
      $dados = array(
        "asps_codigo" =>
          $this->_request->getPost("asps_codigo"),
        "usr_codigo" =>
          $this->trataValor($this->_request->getPost("usr_codigo")),
        "aspscho_obs" =>
          $this->trataValor($this->_request->getPost("aspscho_obs")),
        "aspscho_data" => date("Y-m-d h:i:s"),
      );
      // Valida Edição
      if ($this->_request->getPost("aspscho_codigo")) {
        $dados["aspscho_codigo"] = $this->_request->getPost("aspscho_codigo");
      }
      $aspschoCod = $tbAschObs->salvar($dados);
      $this->view->dados = $aspschoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM CONDIÇÕES HABITACIONAIS                          /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * INÍCIO CONDIÇÕES HABITACIONAIS                       /
   * ---------------------------------------------------- */

  public function condicoesEducacionaisAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dados = $tbAsps->getDadosComposicaoFamiliar($aspsCodigo);
  }

  public function condicoesEducacionaisVulnerabilidadesAction() {
    $this->_helper->layout->disableLayout();
    $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $dadosDatas = $tbAspsu->getDtNascCidNaoEstudaSuas($aspsCodigo);
    $this->view->dadosEstuda = $this->faixaDeIdadesEdu($dadosDatas);
    $dadosDatas = $tbAspsu->getDtNascCidAnalfabetoSuas($aspsCodigo);
    $this->view->dadosAnalfabetos = $this->faixaDeIdadesEdu($dadosDatas);
  }

  public function formCondicoesEducacionaisAction() {
    $this->_helper->layout->disableLayout();
    $tbUsu = new Application_Model_Usuario();
    $usuCodigo = $this->_request->getParam("usu_codigo");
    if ($usuCodigo)
      $this->view->dados = $tbUsu->getDadosCidadao($usuCodigo);
  }

  public function formCondicoesEducacionaisSalvarAction() {
    $tbUsu = new Application_Model_Usuario();
    $dados = array(
      "usu_codigo" => $this->trataValor($this->_request->getPost("usu_codigo")),
      "usu_nome" => $this->trataValor($this->_request->getPost("usu_nome")),
      "usu_datanasc" => $this->trataValor($this->_request->getPost("usu_datanasc")),
      "as_usu_alfabetizado" => $this->trataBoolean($this->_request->getPost("as_usu_alfabetizado")),
      "as_usu_estuda" => $this->trataBoolean($this->_request->getPost("as_usu_estuda")),
      "as_usu_escolaridade" => $this->trataValor($this->_request->getPost("as_usu_escolaridade")),
    );
    try {
      $usuCodigo = $tbUsu->salvar($dados);
      $this->view->dados = $usuCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesEducacionaisDescProgramaAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAspsdp = new Application_Model_AspsdpDescProgramaCe();
    $this->view->dados = $tbAspsdp->getDadosPeloCodigo($aspsCodigo);
  }

  public function formCondicoesEducacionaisDescProgramaAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dadosFamilia = $tbAsps->getDadosComposicaoFamiliar($aspsCodigo);
  }

  public function formCondicoesEducacionaisDescProgramaSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspsdp = new Application_Model_AspsdpDescProgramaCe();
      $dados = $_POST;
      // Removendo usr_codigo para não inserir, só usa no log
      unset($dados["usr_codigo"]);
      $aspsdpCodigo = $tbAspsdp->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "ANOTAÇÕES DE DESCUMPRIMENTOS NO PROGRAMA BOLSA FAMÍLIA";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspsdpCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesEducacionaisObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAspsceo = new Application_Model_AspsObsCe();
    $this->view->dados = $tbAspsceo->getObsSuas($aspsCodigo);
  }

  public function condicoesEducacionaisObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspsceo = new Application_Model_AspsObsCe();
      $dados = array_map("strtoupper", $_POST);
      $aspsceoCod = $tbAspsceo->salvar($dados);
      $this->view->dados = $aspsceoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM CONDIÇÕES HABITACIONAIS                          /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * CONDIÇÕES DE TRABALHO E RENDIMENTOS DA FAMÍLIA       /
   * ---------------------------------------------------- */

  public function condicoesTrabalhoAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dados = $tbAsps->getDadosComposicaoFamiliar($aspsCodigo);
  }

  public function formCondicoesTrabalhoAction() {
    $this->_helper->layout->disableLayout();
    $tbUsu = new Application_Model_Usuario();
    $usuCodigo = $this->_request->getParam("usu_codigo");
    if ($usuCodigo)
      $this->view->dados = $tbUsu->getDadosCidadao($usuCodigo);
  }

  public function formCondicoesTrabalhoSalvarAction() {
    $this->_helper->layout->disableLayout();
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {
      $tbUsu = new Application_Model_Usuario();
      $dados = array(
        "usu_codigo" => $this->_request->getPost("usu_codigo"),
        "usu_nome" => $this->trataValor($this->_request->getPost("usu_nome")),
        "usu_datanasc" => $this->trataValor($this->_request->getPost("usu_datanasc")),
        "usu_asdoc_ctpsprov" => $this->trataBoolean($this->_request->getPost("usu_asdoc_ctpsprov")),
        "as_cond_ocupacao" => $this->trataBoolean($this->_request->getPost("as_cond_ocupacao")),
        "as_possui_qualificacao" => $this->trataBoolean($this->_request->getPost("as_possui_qualificacao")),
        "as_possui_qualificacao_qual" => $this->trataValor($this->_request->getPost("as_possui_qualificacao_qual")),
        "as_renda_mensal" => $this->moedaBD($this->trataNumeric($this->_request->getPost("as_renda_mensal")))
      );

      $usuCodigo = $tbUsu->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "EDIÇÃO CONDIÇÕES DE TRABALHO";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      Zend_Db_Table::getDefaultAdapter()->commit();
      $this->view->dados = $usuCodigo;
    } catch (Exception $ex) {
      Zend_Db_Table::getDefaultAdapter()->roolBack();
      $this->view->dados = $ex->getTraceAsString();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesTrabalhoAnotProgramasFamAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAspsapf = new Application_Model_AspsAnotProgramasfamCt();
    $this->view->dados = $tbAspsapf->getDadosPorProntuario($aspsCodigo);
  }

  public function formCondicoesTrabalhoAnotProgramasFamAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $aspsapfCodigo = $this->_request->getParam("aspsapf_codigo");
    if ($aspsapfCodigo) {
      $tbAspsapf = new Application_Model_AspsAnotProgramasfamCt();
      $this->view->dados = $tbAspsapf->getDadosPorId($aspsapfCodigo);
    }
    $tbProgs = new Application_Model_AsProgramasSociais();
    $psCodigo = ($this->view->dados->ps_codigo != "" ? $this->view->dados->ps_codigo : 0);
    $this->view->selectProgramas = $tbProgs->selectTagProgramas($psCodigo);
  }

  public function formCondicoesTrabalhoAnotProgramasFamSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspsapf = new Application_Model_AspsAnotProgramasfamCt();
      $dados = array(
        "asps_codigo" => $this->trataValor($this->_request->getPost("asps_codigo")),
        "ps_codigo" => $this->trataValor($this->_request->getPost("ps_codigo")),
        "aspsapf_dtinicio" => $this->trataValor($this->_request->getPost("aspsapf_dtinicio")),
        "aspsapf_dtfinal" => $this->trataValor($this->_request->getPost("aspsapf_dtfinal")),
        "aspsapf_vlr_recebido" =>
          $this->moedaBD($this->trataNumeric($this->_request->getPost("aspsapf_vlr_recebido"))),
      );
      // Valida edição
      if ($this->_request->getPost("aspsapf_codigo")) {
        $dados["aspsapf_codigo"] = $this->_request->getPost("aspsapf_codigo");
      }
      $aspsapCodigo = $tbAspsapf->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "ANOTAÇÕES PROGRAMAS SOCIAIS FAMÍLIA";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspsapCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesTrabalhoInfRendaAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbUsu = new Application_Model_Usuario();
    $dadosRenda = $tbUsu->getDadosRendaFamilia($aspsCodigo);
    $tbAspsapf = new Application_Model_AspsAnotProgramasfamCt();
    $rendaProgs = $tbAspsapf->getDadosRendaProgs($aspsCodigo)->renda_progs;
    // Soma Beneficios + Renda
    $rendaBolsa = $rendaProgs + $dadosRenda->renda_familia;
    // Soma Beneficios + Renda Pércapita
    $rendaBolsaPerc = $rendaProgs + $dadosRenda->renda_percapita;
    $this->view->rendaBolsa = $rendaBolsa;
    $this->view->rendaBolsaPerc = $rendaBolsaPerc;
    $this->view->dadosRenda = $dadosRenda;
  }

  public function condicoesTrabalhoAnotProgramasAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dadosFamilia = $tbAsps->getDadosComposicaoFamiliar($aspsCodigo);
    $tbAspsap = new Application_Model_AspsAnotProgramasCt();
    $this->view->dados = $tbAspsap->getDadosPorProntuario($aspsCodigo);
  }

  public function formCondicoesTrabalhoAnotProgramasAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $aspsapCodigo = $this->_request->getParam("aspsap_codigo");
    if ($aspsapCodigo) {
      $tbAspsap = new Application_Model_AspsAnotProgramasCt();
      $this->view->dados = $tbAspsap->getDadosPorId($aspsapCodigo);
    }
    $tbUsu = new Application_Model_Usuario();
    $usuCodigo = ($this->view->dados->usu_codigo != "" ? $this->view->dados->usu_codigo : 0);
    $this->view->selectFamilia = $tbUsu->selectTagMembrosFamilia($aspsCodigo, $usuCodigo);
    $tbProgs = new Application_Model_AsProgramasSociais();
    $psCodigo = ($this->view->dados->ps_codigo != "" ? $this->view->dados->ps_codigo : 0);
    $this->view->selectProgramas = $tbProgs->selectTagProgramas($psCodigo);
  }

  public function formCondicoesTrabalhoAnotProgramasSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspsap = new Application_Model_AspsAnotProgramasCt();
      $dados = array(
        "asps_codigo" => $this->trataValor($this->_request->getPost("asps_codigo")),
        "usu_codigo" => $this->trataValor($this->_request->getPost("usu_codigo_ate")),
        "ps_codigo" => $this->trataValor($this->_request->getPost("ps_codigo")),
        "aspsap_dtinicio" => $this->trataValor($this->_request->getPost("aspsap_dtinicio")),
        "aspsap_dtfinal" => $this->trataValor($this->_request->getPost("aspsap_dtfinal")),
        "aspsap_vlr_recebido" =>
          $this->moedaBD($this->trataNumeric($this->_request->getPost("aspsap_vlr_recebido"))),
      );

      // Valida edição
      if ($this->_request->getPost("aspsap_codigo")) {
        $dados["aspsap_codigo"] = $this->_request->getPost("aspsap_codigo");
      }
      $aspsapCodigo = $tbAspsap->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "ANOTAÇÕES PROGRAMAS SOCIAIS";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspsapCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function atualizaCidadaoAposentadoAction($dados) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dados as $value) {
      try {
        $dadosAposentado = "";
        $dadosAposentado = array(
          "usu_codigo" => $value,
          "usu_as_aposentado" => "t"
        );
        $tbUsu->salvar($dadosAposentado);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
  }

  public function atualizaCidadaoBpcAction($dados) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dados as $value) {
      try {
        $dadosBpc = "";
        $dadosBpc = array(
          "usu_codigo" => $value,
          "usu_as_bpc" => "t"
        );
        $tbUsu->salvar($dadosBpc);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
  }

  public function condicoesTrabalhoObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAspscto = new Application_Model_AspsObsCt();
    $this->view->dados = $tbAspscto->getObsSuas($aspsCodigo);
  }

  public function condicoesTrabalhoObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspscto = new Application_Model_AspsObsCt();
      $dados = array_map("strtoupper", $_POST);
      $aspsctoCod = $tbAspscto->salvar($dados);
      $this->view->dados = $aspsctoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM CONDIÇÕES DE TRABALHO E RENDIMENTOS DA FAMÍLIA   /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * CONDIÇÕES DE SAÚDE DA FAMÍLIA                        /
   * ---------------------------------------------------- */

  public function condicoesSaudeAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dados = $tbAsps->getDadosComposicaoFamiliar($aspsCodigo);
  }

  public function formCondicoesSaudeAction() {
    $this->_helper->layout->disableLayout();
    $tbUsu = new Application_Model_Usuario();
    $usuCodigo = $this->_request->getParam("usu_codigo");
    if ($usuCodigo)
      $this->view->dados = $tbUsu->getDadosCidadao($usuCodigo);
  }

  public function formCondicoesSaudeSalvarAction() {
    $this->_helper->layout->disableLayout();
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {
      $tbUsu = new Application_Model_Usuario();
      $dados = array(
        "usu_codigo" => $this->_request->getPost("usu_codigo"),
        "usu_nome" => $this->trataValor($this->_request->getPost("usu_nome")),
        "usu_as_tipo_deficiencia" => $this->_request->getPost("usu_as_tipo_deficiencia"),
        "usu_as_cuidado_constante" => $this->trataBoolean($this->_request->getPost("usu_as_cuidado_constante")),
        "usu_as_resp_cuidado" => ($this->_request->getPost("usu_as_cuidado_constante") == 't' ?
          $this->trataValor($this->_request->getPost("usu_as_resp_cuidado")) : "Não informado")
      );
      $usuCodigo = $tbUsu->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "EDIÇÃO CONDIÇÕES DE SAÚDE";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      Zend_Db_Table::getDefaultAdapter()->commit();
      $this->view->dados = $usuCodigo;
    } catch (Exception $ex) {
      Zend_Db_Table::getDefaultAdapter()->roolBack();
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesSaudeAnotAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAspsas = new Application_Model_AspsAnotSaudeCs();
    $this->view->dados = $tbAspsas->getDadosPorProntuario($aspsCodigo);
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dadosFamilia = $tbAsps->getDadosComposicaoFamiliar($aspsCodigo);
  }

  public function condicoesSaudeAnotSalvarAction() {
    $this->_helper->layout->disableLayout();
    $tbAspsas = new Application_Model_AspsAnotSaudeCs();
    $aspsCodigo = $this->_request->getPost("asps_codigo");
    try {
      $dados = array(
        "asps_codigo" => $aspsCodigo,
        "aspsas_cuidado_constante" => $this->trataBoolean($this->_request->getPost("aspsas_cuidado_constante")),
        "aspsas_resp_cuidado_constante" => $this->trataValor($this->_request->getPost("aspsas_resp_cuidado_constante")),
        "aspsas_resp_cuidado_constante" => $this->trataBoolean($this->_request->getPost("aspsas_resp_cuidado_constante")),
        "aspsas_inseguranca_alimentar" => $this->trataBoolean($this->_request->getPost("aspsas_inseguranca_alimentar")),
        "aspsas_inseguranca_alimentar_data" => "NOW()",
        "aspsas_doenca_grave" => $this->trataBoolean($this->_request->getPost("aspsas_doenca_grave")),
        "aspsas_tipo_doenca_grave" => $this->trataValor($this->_request->getPost("aspsas_tipo_doenca_grave")),
        "aspsas_remedio_controlado" => $this->trataBoolean($this->_request->getPost("aspsas_remedio_controlado")),
        "aspsas_alcoolatra" => $this->_request->getPost("aspsas_alcoolatra"),
        "aspsas_alcoolatra_data" => "NOW()",
        "aspsas_drogado" => $this->_request->getPost("aspsas_drogado"),
        "aspsas_drogado_data" => "NOW()",
        "aspsas_tipo_droga" => $this->_request->getPost("aspsas_tipo_droga")
      );
      // Atualiza dados cidadão
      // Seta tudo como false as opção de saúde para atualizar e depois true
      $tbAsps = new Application_Model_AsProntuarioSuas();
      $dadosCidadao = $tbAsps->getCodigosComposicaoFamiliar($aspsCodigo);
      $this->atualizaFalseDadosSaudeCidadaoAction($dadosCidadao);
      // Atualiza TRUE
      $dadosCui = $this->_request->getPost("cuidados");
      if ($dadosCui != "")
        $this->atualizaCidadaoCuidadosAction($dadosCui, $dadosCidadao);
      $dadosDoenca = $this->_request->getPost("doenca");
      if ($dadosDoenca != "")
        $this->atualizaCidadaoDoencasAction($dadosDoenca);
      $dadosRem = $this->_request->getPost("remedio");
      if ($dadosRem != "")
        $this->atualizaCidadaoRemedioAction($dadosRem);
      $dadosAlc = $this->_request->getPost("alcoolatra");
      if ($dadosAlc != "")
        $this->atualizaCidadaoAlcoolatraAction($dadosAlc);
      $dadosDroga = $this->_request->getPost("drogado");
      if ($dadosDroga != "")
        $this->atualizaCidadaoDrogadoAction($dadosDroga);
      // Valida Edição
      if ($this->_request->getPost("aspsas_codigo")) {
        $dados["aspsas_codigo"] = $this->_request->getPost("aspsas_codigo");
      }
      $this->view->dados = $tbAspsas->salvar($dados);
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function atualizaFalseDadosSaudeCidadaoAction($dadosCidadao = FALSE) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dadosCidadao as $key => $value) {
      $dadosFalse = "";
      $dadosFalse = array(
        "usu_codigo" => $value->usu_codigo,
        "usu_as_cuidado_constante" => "f",
        "usu_as_doenca_grava" => "f",
        "usu_as_remedio_controlado" => "f",
        "usu_as_alcoolatra" => "f",
        "usu_as_drogado" => "f",
      );
      try {
        $tbUsu->salvar($dadosFalse);
      } catch (Exception $ex) {
        $ex->getMessage();
      }
    }
  }

  public function atualizaCidadaoCuidadosAction($dados = FALSE, $dadosCidadao = FALSE) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dados as $value) {
      try {
        $dadosCuidado = "";
        $dadosCuidado = array(
          "usu_codigo" => $value,
          "usu_as_cuidado_constante" => "t"
        );
        $tbUsu->salvar($dadosCuidado);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
  }

  public function atualizaCidadaoDoencasAction($dados) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dados as $value) {
      try {
        $dadosDoenca = "";
        $dadosDoenca = array(
          "usu_codigo" => $value,
          "usu_as_doenca_grava" => "t"
        );
        $tbUsu->salvar($dadosDoenca);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
  }

  public function atualizaCidadaoRemedioAction($dados) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dados as $value) {
      try {
        $dadosRemedio = "";
        $dadosRemedio = array(
          "usu_codigo" => $value,
          "usu_as_remedio_controlado" => "t"
        );
        $tbUsu->salvar($dadosRemedio);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
  }

  public function atualizaCidadaoAlcoolatraAction($dados) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dados as $value) {
      try {
        $dadosAlc = "";
        $dadosAlc = array(
          "usu_codigo" => $value,
          "usu_as_alcoolatra" => "t"
        );
        $tbUsu->salvar($dadosAlc);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
  }

  public function atualizaCidadaoDrogadoAction($dados) {
    $tbUsu = new Application_Model_Usuario();
    foreach ($dados as $value) {
      try {
        $dadosDroga = "";
        $dadosDroga = array(
          "usu_codigo" => $value,
          "usu_as_drogado" => "t"
        );
        $tbUsu->salvar($dadosDroga);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
  }

  public function condicoesSaudeDescProgramaAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAspsdpcs = new Application_Model_AspsdpcsDescProgramaCs();
    $this->view->dados = $tbAspsdpcs->getDadosPeloCodigo($aspsCodigo);
  }

  public function formCondicoesSaudeDescProgramaAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dadosFamilia = $tbAsps->getDadosComposicaoFamiliar($aspsCodigo);
  }

  public function formCondicoesSaudeDescProgramaSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspsdpcs = new Application_Model_AspsdpcsDescProgramaCs();
      $dados = $_POST;
      // Removendo usr_codigo para não inserir, só usa no log
      unset($dados["usr_codigo"]);
      $aspsdpcsCodigo = $tbAspsdpcs->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "ANOTAÇÕES SAÚDE DE DESCUMPRIMENTOS NO PROGRAMA BOLSA FAMÍLIA";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspsdpcsCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesSaudeRegGestanteAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAspsrg = new Application_Model_AspsRegGestanteCs();
    $this->view->dados = $tbAspsrg->getDadosPeloCodigo($aspsCodigo);
  }

  public function formCondicoesSaudeRegGestanteAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAsps = new Application_Model_AsProntuarioSuas();
    $this->view->dadosFamilia = $tbAsps->getDadosComposicaoFamiliarFeminina($aspsCodigo);
  }

  public function formCondicoesSaudeRegGestanteSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspsrg = new Application_Model_AspsRegGestanteCs();
      $dados = $_POST;
      // Removendo usr_codigo para não inserir, só usa no log
      unset($dados["usr_codigo"]);
      $aspsrgCodigo = $tbAspsrg->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "REGISTRO PRESENÇA DE GESTANTE NA FAMÍLIA";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspsrgCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function condicoesSaudeObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAspscso = new Application_Model_AspsObsCs();
    $this->view->dados = $tbAspscso->getObsSuas($aspsCodigo);
  }

  public function condicoesSaudeObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspscso = new Application_Model_AspsObsCs();
      $dados = array_map("strtoupper", $_POST);
      $aspscsoCod = $tbAspscso->salvar($dados);
      $this->view->dados = $aspscsoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * CONDIÇÕES DE SAÚDE DA FAMÍLIA                        /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * CONVIVÊNCIA FAMILIAR E COMUNITÁRIA                   /
   * ---------------------------------------------------- */

  public function convivenciaFamiliarAction() {
    $this->_helper->layout->disableLayout();
    $tbAspcf = new Application_Model_AspsConvivenciaFamiliar();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $this->view->dados = $tbAspcf->getDadosPorProntuario($aspsCodigo);
  }

  public function convivenciaFamiliarSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspscf = new Application_Model_AspsConvivenciaFamiliar();
      $dados = $_POST;
      // Valida Inteiros
      if ($this->_request->getPost("aspscf_anos_estado") == "")
        unset($dados["aspscf_anos_estado"]);
      if ($this->_request->getPost("aspscf_anos_municipio") == "")
        unset($dados["aspscf_anos_municipio"]);
      if ($this->_request->getPost("aspscf_anos_bairro") == "")
        unset($dados["aspscf_anos_bairro"]);
      // Removendo usr_codigo para não inserir, só usa no log
      unset($dados["usr_codigo"]);
      $aspscfCodigo = $tbAspscf->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "CONVIVÊNCIA FAMILIAR E COMUNITÁRIA";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspscfCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function convivenciaFamiliarObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAspscco = new Application_Model_AspsObsCc();
    $this->view->dados = $tbAspscco->getObsSuas($aspsCodigo);
  }

  public function convivenciaFamiliarObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAspscco = new Application_Model_AspsObsCc();
      $dados = array_map("strtoupper", $_POST);
      $aspsccoCod = $tbAspscco->salvar($dados);
      $this->view->dados = $aspsccoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM CONVIVÊNCIA FAMILIAR E COMUNITÁRIA               /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * SITUACÕES DE VIOLÊNCIA E VIOLAÇÕES DE DIREITOS       /
   * ---------------------------------------------------- */

  public function sitViolacoesAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbAsrv = new Application_Model_AsRegistrosViolacao();
    $this->view->dados = $tbAsrv->getDadosPeloSuas($aspsCodigo);
  }

  public function formSitViolacoesAction() {
    $this->_helper->layout->disableLayout();
    $asrvCodigo = $this->_request->getParam("asrv_codigo");
    if ($asrvCodigo) {
      $tbAsrv = new Application_Model_AsRegistrosViolacao();
      $this->view->dados = $tbAsrv->getDadosPeloCodigo($asrvCodigo);
      $assvCodigo = $this->view->dados->assv_codigo;
      $usuCodigo = $this->view->dados->usu_codigo;
    }
    $tbAssv = new Application_Model_AsSituacoesViolacao();
    $this->view->selectSit = $tbAssv->selectTag($assvCodigo);
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;

    $tbUsu = new Application_Model_Usuario();
    $this->view->selectCid = $tbUsu->selectTagMembrosFamilia($aspsCodigo, $usuCodigo);
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
  }

  public function formSitViolacoesSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $dados = $_POST;
      // Removendo usr_codigo para não inserir, só usa no log
      unset($dados["usr_codigo"]);
      $tbAsrv = new Application_Model_AsRegistrosViolacao();
      $aspscfCodigo = $tbAsrv->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "CADASTRO SITUAÇÕES DE VIOLÊNCIA E O VIOLAÇÕES DE DIREITO";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspscfCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function sitViolacoesObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbAsObs = new Application_Model_AspsObsSv();
    $this->view->dados = $tbAsObs->getObsSuas($aspsCodigo);
  }

  public function sitViolacoesObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAsObs = new Application_Model_AspsObsSv();
      $dados = array(
        "asps_codigo" => $this->_request->getPost("asps_codigo"),
        "usr_codigo" => $this->trataValor($this->_request->getPost("usr_codigo")),
        "aspsvo_obs" => $this->trataValor($this->_request->getPost("aspsvo_obs")),
        "aspsvo_data" => date("Y-m-d h:i:s"),
      );
      // Valida Edição
      if ($this->_request->getPost("aspsvo_codigo")) {
        $dados["aspsvo_codigo"] = $this->_request->getPost("aspsvo_codigo");
      }
      $aspsoCod = $tbAsObs->salvar($dados);
      $this->view->dados = $aspsoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* -----------------------------------------------------/
   * FIM SITUACÕES DE VIOLÊNCIA E VIOLAÇÕES DE DIREITOS   /
   * ---------------------------------------------------- */

  /* -----------------------------------------------------/
   * HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR   /
   * ---------------------------------------------------- */

  public function histAcolhimentoAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbAspsah = new Application_Model_AspsHistAcolhimento();
    $this->view->dados = $tbAspsah->getDadosPeloSuas($aspsCodigo);
  }

  public function formHistAcolhimentoAction() {
    $this->_helper->layout->disableLayout();
    $aspshaCodigo = $this->_request->getParam("aspsha_codigo");
    if ($aspshaCodigo) {
      $tbAspsha = new Application_Model_AspsHistAcolhimento();
      $this->view->dados = $tbAspsha->getDadosPeloCodigo($aspshaCodigo);
      $usuCodigo = $this->view->dados->usu_codigo;
    }
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbUsu = new Application_Model_Usuario();
    $this->view->selectCid = $tbUsu->selectTagMembrosFamilia($aspsCodigo, $usuCodigo);
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
  }

  public function formHistAcolhimentoSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $dados = array(
        "aspsha_codigo" => $this->_request->getPost("aspsha_codigo"),
        "asps_codigo" => $this->_request->getPost("asps_codigo"),
        "usu_codigo" => $this->_request->getPost("usu_codigo_ate"),
        "aspsha_dtinicio" => $this->_request->getPost("aspsha_dtinicio"),
        "aspsha_dtfinal" => $this->_request->getPost("aspsha_dtfinal"),
        "aspsha_motivo" => $this->_request->getPost("aspsha_motivo")
      );
      // Removendo usr_codigo para não inserir, só usa no log
      $tbAspsha = new Application_Model_AspsHistAcolhimento();
      $aspshaCodigo = $tbAspsha->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspshaCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function histAcolhimentoObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAsObs = new Application_Model_AspsObsHa();
    $this->view->dados = $tbAsObs->getObsSuas($aspsCodigo);
  }

  public function histAcolhimentoObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAsObs = new Application_Model_AspsObsHa();
      $dados = array(
        "asps_codigo" => $this->_request->getPost("asps_codigo"),
        "usr_codigo" => $this->trataValor($this->_request->getPost("usr_codigo")),
        "aspshao_obs" => $this->trataValor($this->_request->getPost("aspshao_obs")),
        "aspshao_data" => date("Y-m-d h:i:s"),
      );
      // Valida Edição
      if ($this->_request->getPost("aspshao_codigo")) {
        $dados["aspshao_codigo"] = $this->_request->getPost("aspshao_codigo");
      }
      $aspsoCod = $tbAsObs->salvar($dados);
      $this->view->dados = $aspsoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* ---------------------------------------------------------/
   * FIM HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR   /
   * --------------------------------------------------------*/

  /* -----------------------------------------------------/
   * HISTÓRICO DE CUMPRIMENTO DE MEDIDAS SOCIOEDUCATIVAS  /
   * ----------------------------------------------------*/

  public function medSocioeducativaAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $tbAspsms = new Application_Model_AspsMedidasSocioeducativas();
    $this->view->dados = $tbAspsms->getDadosPeloSuas($aspsCodigo);
  }

  public function formMedSocioeducativaAction() {
    $this->_helper->layout->disableLayout();
    $aspsmsCodigo = $this->_request->getParam("aspsms_codigo");
    if ($aspsmsCodigo) {
      $tbAspsms = new Application_Model_AspsMedidasSocioeducativas();
      $this->view->dados = $tbAspsms->getDadosPeloCodigo($aspsmsCodigo);
      $usuCodigo = $this->view->dados->usu_codigo;
      $astmsCodigo = $this->view->dados->astms_codigo;
    }
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $tbUsu = new Application_Model_Usuario();
    $this->view->selectCid = $tbUsu->selectTagMembrosFamilia($aspsCodigo, $usuCodigo);
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAstm = new Application_Model_AsTipoMedidaSocioeducativa();
    $this->view->selectTipo = $tbAstm->selectTag($astmsCodigo);
  }

  public function formMedSocioeducativaSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $dados = array(
        "aspsms_codigo" => $this->_request->getPost("aspsms_codigo"),
        "asps_codigo" => $this->_request->getPost("asps_codigo"),
        "usu_codigo" => $this->_request->getPost("usu_codigo_ate"),
        "astms_codigo" => $this->_request->getPost("astms_codigo"),
        "aspsms_num_processo" => $this->_request->getPost("aspsms_num_processo"),
        "aspsms_dtinicio" => $this->_request->getPost("aspsms_dtinicio"),
        "aspsms_dtfinal" => $this->_request->getPost("aspsms_dtfinal"),
        "aspsms_creas" => $this->_request->getPost("aspsms_creas")
      );
      // Removendo usr_codigo para não inserir, só usa no log
      $tbAspsms = new Application_Model_AspsMedidasSocioeducativas();
      $aspsmsCodigo = $tbAspsms->salvar($dados);
      // Salvar Log
      $aspsCodigo = $this->_request->getPost("asps_codigo");
      $usrCodigo = $this->_request->getPost("usr_codigo");
      $modulo = "HISTÓRICO DE MEDIDA SOCIOEDUCATIVA";
      $this->salvarLog($aspsCodigo, $usrCodigo, $modulo);
      $this->view->dados = $aspsmsCodigo;
    } catch (Exception $ex) {
      $this->view->dados = $ex->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function medSocioeducativaObsAction() {
    $this->_helper->layout->disableLayout();
    $aspsCodigo = $this->_request->getParam("asps_codigo");
    $this->view->asps_codigo = $aspsCodigo;
    $usrCodigo = $this->_request->getParam("usr_codigo");
    $this->view->usr_codigo = $usrCodigo;
    $tbAsObs = new Application_Model_AspsObsMs();
    $this->view->dados = $tbAsObs->getObsSuas($aspsCodigo);
  }

  public function medSocioeducativaObsSalvarAction() {
    $this->_helper->layout->disableLayout();
    try {
      $tbAsObs = new Application_Model_AspsObsMs();
      $dados = array(
        "asps_codigo" => $this->_request->getPost("asps_codigo"),
        "usr_codigo" => $this->trataValor($this->_request->getPost("usr_codigo")),
        "aspsmso_obs" => $this->trataValor($this->_request->getPost("aspsmso_obs")),
        "aspsmso_data" => date("Y-m-d h:i:s"),
      );
      // Valida Edição
      if ($this->_request->getPost("aspsmso_codigo")) {
        $dados["aspsmso_codigo"] = $this->_request->getPost("aspsmso_codigo");
      }
      $aspsoCod = $tbAsObs->salvar($dados);
      $this->view->dados = $aspsoCod;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }
    return $this->render("dados", NULL, TRUE);
  }

  /* ---------------------------------------------------------/
   * FIM HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR   /
   * --------------------------------------------------------*/

  /* -----------------------------------------------------/
   * FUNÇÕES GERAIS                                       /
   * ---------------------------------------------------- */

  public function trataValor($valor) {
    $valorFinal = ($valor != "" ? $valor : NULL);
    return mb_strtoupper($valorFinal, "UTF-8");
  }

  public function trataInt($valor) {
    $valorFinal = ($valor != "" ? $valor : 'NULL');
    return mb_strtoupper($valorFinal, "UTF-8");
  }

  public function trataBoolean($valor) {
    return $valorFinal = ($valor != "" ? $valor : 0);
  }

  public function trataNumeric($valor) {
    return $valorFinal = ($valor != "" ? $valor : '0.00');
  }

  public function getDadosUsuarioLogado($usrLogin) {
    $tbUsr = new Application_Model_Usuarios();
    return $tbUsr->getDadosPeloLogin($usrLogin)->usr_codigo;
  }

  public function faixaDeIdades($dadosDatas) {
    $cont0a6 = 0;
    $cont7a14 = 0;
    $cont15a17 = 0;
    $cont18a29 = 0;
    $cont30a59 = 0;
    $cont60a64 = 0;
    $cont65a69 = 0;
    $cont70 = 0;
    foreach ($dadosDatas as $val) {
      if ($this->idade($val->usu_datanasc) >= 0 &&
        $this->idade($val->usu_datanasc) <= 6) {
        $cont0a6++;
      }
      if ($this->idade($val->usu_datanasc) >= 7 &&
        $this->idade($val->usu_datanasc) <= 14) {
        $cont7a14++;
      }
      if ($this->idade($val->usu_datanasc) >= 15 &&
        $this->idade($val->usu_datanasc) <= 17) {
        $cont15a17++;
      }
      if ($this->idade($val->usu_datanasc) >= 18 &&
        $this->idade($val->usu_datanasc) <= 29) {
        $cont18a29++;
      }
      if ($this->idade($val->usu_datanasc) >= 30 &&
        $this->idade($val->usu_datanasc) <= 59) {
        $cont30a59++;
      }
      if ($this->idade($val->usu_datanasc) >= 60 &&
        $this->idade($val->usu_datanasc) <= 64) {
        $cont60a64++;
      }
      if ($this->idade($val->usu_datanasc) >= 65 &&
        $this->idade($val->usu_datanasc) <= 69) {
        $cont65a69++;
      }
      if ($this->idade($val->usu_datanasc) > 70) {
        $cont70++;
      }
    }
    $dadosFaixaEtaria = array(
      "cont0a6" => $cont0a6,
      "cont7a14" => $cont7a14,
      "cont15a17" => $cont15a17,
      "cont18a29" => $cont18a29,
      "cont30a59" => $cont30a59,
      "cont60a64" => $cont60a64,
      "cont65a69" => $cont65a69,
      "cont70" => $cont70,
      "qtdMembros" => count($dadosDatas)
    );
    return (object)$dadosFaixaEtaria;
  }

  public function faixaDeIdadesEdu($dadosDatas) {
    $cont0a5 = 0;
    $cont6a14 = 0;
    $cont15a17 = 0;
    $cont10a17 = 0;
    $cont18a59 = 0;
    $cont60 = 0;
    foreach ($dadosDatas as $val) {
      if ($this->idade($val->usu_datanasc) >= 0 &&
        $this->idade($val->usu_datanasc) <= 5) {
        $cont0a5++;
      }
      if ($this->idade($val->usu_datanasc) >= 6 &&
        $this->idade($val->usu_datanasc) <= 14) {
        $cont6a14++;
      }
      if ($this->idade($val->usu_datanasc) >= 15 &&
        $this->idade($val->usu_datanasc) <= 17) {
        $cont15a17++;
      }
      if ($this->idade($val->usu_datanasc) >= 10 &&
        $this->idade($val->usu_datanasc) <= 17) {
        $cont10a17++;
      }
      if ($this->idade($val->usu_datanasc) >= 18 &&
        $this->idade($val->usu_datanasc) <= 59) {
        $cont18a59++;
      }
      if ($this->idade($val->usu_datanasc) > 60) {
        $cont60++;
      }
    }
    $dadosFaixaEtaria = array(
      "cont0a5" => $cont0a5,
      "cont6a14" => $cont6a14,
      "cont15a17" => $cont15a17,
      "cont10a17" => $cont10a17,
      "cont18a59" => $cont18a59,
      "cont60" => $cont60,
      "qtdMembros" => count($dadosDatas)
    );
    return (object)$dadosFaixaEtaria;
  }

  function idade($dataNasc = FALSE, $especificacao = FALSE) {
    if (!$dataNasc)
      return "";

    list($a, $m, $d) = explode("-", $dataNasc);
    $mk = mktime(0, 0, 0, $m, $d, $a); // segundos
    if ($mk > time()) {

    }

    $anos = floor((time() - $mk) / 31536000);
    return $anos;
  }

  public function salvarLog($aspsCodigo, $usrCodigo, $modulo) {
    $dados = array(
      "asps_codigo" => $aspsCodigo,
      "usr_codigo" => $usrCodigo,
      "aspsl_modulo" => $modulo,
      "aspsl_data" => "NOW()"
    );
    try {
      $tbAspsl = new Application_Model_AspsLog();
      $tbAspsl->salvar($dados);
    } catch (Exception $ex) {
      $ex->getMessage();
    }
  }

  private function moedaBD($get_valor) {
    $source = array('.', ',');
    $replace = array('', '.');
    $valor = str_replace($source, $replace, $get_valor); //remove os pontos e substitui a virgula pelo ponto
    return $valor; //retorna o valor formatado para gravar no banco
  }

  /* -----------------------------------------------------/
   * FIM FUNÇÕES GERAIS                                   /
   * ---------------------------------------------------- */
}
