<?php

class Usuarios_UsuariosController extends Zend_Controller_Action
{
    public function init()
    {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/usuarios/form.js');
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.pstrength-min.1.2.js');
        $this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/usuarios/form.css', 'all');
        parent::init();

        $tbCon = new Application_Model_Conselho();
        $this->view->conselho = $tbCon->fetchAll();
    }

    public function indexAction()
    {
        $tbUsr = new Application_Model_Usuarios();
        $this->_helper->Layout->setLayout("simples");
        $usr_mestre = $tbUsr->getUsrAtual()->usr_mestre == 'S' ? true : false;
        $tbUsr = new Application_Model_Usuarios();
        $this->view->itens = $tbUsr->getUsuariosBuscaFormSocial(false, $usr_mestre);
        $this->view->title = "Módulo Usuários";

    }

    public function buscaGeralAction()
    {
        $tbUsus = new Application_Model_Usuarios();
        $term = $this->_getParam("term", FALSE);
        $all = $tbUsus->buscaGeral($term);

        $out = array();
        foreach ($all as $usr) {
            $data = $usr->toArray();
            $out [] = array(
                "id" => $usr->usr_codigo,
                "label" => $usr->usr_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("usr_codigo" => "0", "usr_nome" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados", NULL, TRUE);
    }

    public function getDadosNomeAction()
    {
        $this->_helper->layout->disableLayout();
        $nome = $this->_request->getPost("usr_nome");
        $tbUsus = new Application_Model_Usuarios();
        $this->view->dados = $tbUsus->getDadosPeloNome($nome)->usr_codigo;
        return $this->render("dados", NULL, TRUE);
    }


    public function novoAction()
    {
        $tbCon = new Application_Model_Conselho();
        $this->view->conselho = $tbCon->fetchAll();

        $tbCrg = new Application_Model_Cargos();
        $this->view->cargo = $tbCrg->fetchAll(null, 'crg_nome ASC');

        $this->_helper->layout->setLayout("simples");
        $this->render("form");
    }

    public function formAction()
    {

    }

    public function salvarAction()
    {
        $tbUsr = new Application_Model_Usuarios();
        $tbUnu = new Application_Model_UnidadeUsuarios();
        $this->_helper->layout->disableLayout();

        $dados_usr = array(
            "usr_nome"          => $this->trataValorMaiuscula($this->_getParam("usr_nome", FALSE)),
            "con_codigo"        => $this->_getParam("con_codigo", NULL),
            "crg_codigo"        => $this->_getParam("crg_codigo", NULL),
            "usr_num_conselho"  => $this->_getParam("usr_num_conselho", FALSE),
            "usr_login"         => $this->trataValorMinuscula($this->_getParam("usr_login", FALSE)),
            "usr_email"         => $this->trataValorMinuscula($this->_getParam("usr_email", FALSE)),
            "usr_modulos"       => $this->_getParam("usr_modulos", FALSE),
            "usr_ativo"         => $this->_getParam("usr_ativo", FALSE),
            "usr_troca_senha"   => $this->_getParam("usr_troca_senha", NULL)
        );

        if ($this->_request->getPost("usr_codigo", NULL)) {
            $dados_usr['usr_codigo'] = $this->_request->getPost("usr_codigo", NULL);
        }

	    if ($dados_usr['con_codigo'] == "") {
		    $dados_usr['con_codigo'] = NULL;
	    }

	    if ($dados_usr['crg_codigo'] == "") {
		    $dados_usr['crg_codigo'] = NULL;
	    }

        if ($this->_request->getPost("usr_senha") != NULL) {
            $dados_usr['usr_senha'] = md5($this->_getParam("usr_senha", FALSE));
        } else if (!$dados_usr['usr_codigo']) {
            $dados_usr['usr_senha'] = 123;
        }

        //echo "<pre>".print_r($dados_usr,1);die();

        $usr_codigo = $tbUsr->salvar($dados_usr);
        if ($this->_getParam("todas_unidades", FALSE) == "T") {
            $tbUni = new Application_Model_Unidade();
            $array_codigo = $tbUni->getCodUnidade()->toArray();
            $this->removeUnidadesDoUsuario($usr_codigo, $array_codigo);
        } else {
            $array_codigo = $this->_getParam("uni_codigo", FALSE);
        }
        if ($usr_codigo) {
            if (!empty($array_codigo)) {
                if (count($array_codigo) > 1) {
                    foreach ($array_codigo as $uni_codigo) {
                        $tbUnu->salvar(array("usr_codigo" => $usr_codigo,
                            "uni_codigo" => ($uni_codigo['uni_codigo'] ? $uni_codigo['uni_codigo'] : $uni_codigo)));
                    }
                } else {
                    $tbUnu->salvar(array("usr_codigo" => $usr_codigo,
                        "uni_codigo" => ($array_codigo[0] ? $array_codigo[0] : "NULL")));
                }
            }

	        $especialidades = $this->_request->getPost("esp_codigo_u", NULL);
	        if (!empty($especialidades)) {
		        $tbMesp = new Application_Model_MedicoEspecialidade();
		        foreach ($especialidades as $esp_codigo) {
			        $tbMesp->salvar(array("esp_codigo" => $esp_codigo,
				        "med_codigo" => $usr_codigo,
				        "mes_ativo" => "A",
				        "mes_data" => date('Y-m-d'),
				        "uni_codigo" => $this->_request->getPost("uni_codigo_$esp_codigo", NULL)));
		        }
	        }
	        $set_codigo = $this->_request->getPost("set_codigo", NULL);
	        if (!empty($set_codigo)) {
		        $tbUset = new Application_Model_UsuariosSetores();
		        foreach ($set_codigo as $set_codigo) {
			        $tbUset->salvar(array("set_codigo" => $set_codigo,
				        "usr_codigo" => $usr_codigo));
		        }
	        }

        }
        $this->_redirect("usuarios/usuarios/");
    }

    public function removeUnidadesDoUsuario($usr_codigo = FALSE)
    {
        $tbUnu = new Application_Model_UnidadeUsuarios();
        $tbUnu->excluirTodos($usr_codigo);
        return true;
    }

    public function pesquisaAction()
    {
        $this->view->title = "Módulo Usuários";
        $tbUsr = new Application_Model_Usuarios();
        $usr_mestre = ($tbUsr->getUsrAtual()->usr_mestre == "S" ? true : false);
        if ($this->_request->isPost()) {
            $tbUsr = new Application_Model_Usuarios();
            $this->view->busca = $this->_request->getPost("busca");
            $this->view->itens = $tbUsr->getUsuariosBuscaFormSocial($this->view->busca, $usr_mestre);
            $this->render("index");
        } else {
            $this->_redirect("/usuarios/usuarios/index");
        }
    }

    public function editarAction()
    {
        $this->_helper->layout->setLayout("simples");
        $usr_codigo = $this->_getParam("id");
        $tbUsr = new Application_Model_Usuarios();
        $tbUnu = new Application_Model_UnidadeUsuarios();
        $tbMes = new Application_Model_MedicoEspecialidade();
        $tbUset = new  Application_Model_UsuariosSetores();
	    $tbCrg = new Application_Model_Cargos();

        $this->view->dados = $tbUsr->getInfoUsr($usr_codigo);
        $this->view->unidades = $tbUnu->getUnidadeUsuarios($this->view->dados->usr_codigo)->toArray();
        $this->view->especialidades = $tbMes->getEspecialidadePorMedico($this->view->dados->usr_codigo)->toArray();
        $this->view->setores = $tbUset->getSetoresPorUsuarios($this->view->dados->usr_codigo);
	    $this->view->cargo = $tbCrg->fetchAll(null, 'crg_nome ASC');
        return $this->render("form");
    }

    public function inativarAction()
    {
        $id = (int)$this->_getParam("id", 0);
        $tbUsr = new Application_Model_Usuarios();
        $dados = array("usr_codigo" => $id, "usr_ativo" => "N");
        $tbUsr->salvar($dados);
        return $this->_redirect("/usuarios/usuarios");
    }

    public function excluirUnidadeAction()
    {
        $this->_helper->layout->disableLayout();
        $id = $this->_getParam("id", false);
        $tbUnu = new Application_Model_UnidadeUsuarios();
        $tbUnu->excluir($id);
        $this->render("dados");
    }

    public function excluirEspecialidadeAction()
    {
        $this->_helper->layout->disableLayout();
        $id = $this->_getParam("id", false);
        $tbMes = new Application_Model_MedicoEspecialidade();
        $tbMes->excluir($id);
        $this->render("dados");
    }

    public function excluirSetoresAction()
    {
        $this->_helper->layout->disableLayout();
        $id = $this->_getParam("id", false);
        $tbUset = new  Application_Model_UsuariosSetores();
        $tbUset->excluir($id);
        $this->render("dados");
    }

    public function jqgridAction()
    {

        $page = $this->_getParam("page", 1);
        $limit = $this->_getParam("rows");
        $sidx = $this->_getParam("sidx", "id");
        $sord = $this->_getParam("sord", "ASC");

        $tbUsr = new Application_Model_Usuarios();
        $tbUsr->setFields(array("usr_codigo", "usr_nome"));
        $this->view->dados = $tbUsr->getGridResource($page, $limit, $sidx, $sord);
        //echo "<pre>".print_r( $this->view->dados,1);die();

        return $this->render("dados", NULL, TRUE);
    }

    public function trataValorMaiuscula($valor)
    {
        $valorFinal = ($valor != "" ? $valor : NULL);
        return mb_strtoupper($valorFinal, "UTF-8");
    }

    public function trataValorMinuscula($valor)
    {
        $valorFinal = ($valor != "" ? $valor : NULL);
        return mb_strtolower($valorFinal, "UTF-8");
    }

    public function alteraSenhaAction()
    {
        $this->_helper->layout->setLayout("simples");
    }

    public function verificaSenhaAtualAction()
    {
        $dados = $this->_getAllParams();

        $tbUsr = new Application_Model_Usuarios();
        $this->view->dados = $tbUsr->verificaSenhaAtual($dados);
        return $this->render("dados", NULL, TRUE);
    }

    public function salvarAlteraSenhaAction()
    {
        $dados = array(
            'usr_codigo' => $this->_getParam('usr_codigo'),
            'usr_senha' => md5($this->_getParam('usr_senha'))
        );
        $tbUsr = new Application_Model_Usuarios();
        $this->view->dados = $tbUsr->salvar($dados);
        return $this->render("dados", NULL, TRUE);
    }

    public function grupoUsuariosAction()
    {
        $this->view->title = "GRUPO DE REUNIÕES";
        $this->_helper->layout->setLayout("simples");
        $tbGru = new Application_Model_AsGrupoUsuarios();
        $this->view->dados = $tbGru->getGrupos();

    }

    public function formGrupoUsuariosAction(){
        $asgpu_codigo = $this->_getParam("asgpu_codigo", FALSE);

        if($asgpu_codigo){
            $tbGruPart = new Application_Model_AsGrupoUsuariosParticipante();
            $tbGru = new Application_Model_AsGrupoUsuarios();
            $this->view->grupo = $tbGru->getGrupo($asgpu_codigo);
            $this->view->participantes = $tbGruPart->getParticipantes($asgpu_codigo);
        }
        $this->_helper->layout->disableLayout();
    }

    public function salvarFormGrupoUsuariosAction(){
        $tbGru = new Application_Model_AsGrupoUsuarios();
        $dados = array(
            "asgpu_codigo" => $this->_request->getPost("asgpu_codigo", NULL),
            "asgpu_desc" => $this->_request->getPost("asgpu_desc", NULL),
            "asgpu_status" => $this->_request->getPost("asgpu_status")
        );
        try{
            $retorno = $tbGru->salvar($dados);
            $this->view->dados = array("success" => TRUE, "asgpu_codigo" => $retorno);
        }catch (Exception $exp){
            $this->view->dados = array("success" => FALSE, "mensagem" => $exp->getMessage());
        }
        return $this->render("dados", NULL, TRUE);


    }

    public function validaNomeGrupoAction(){
        $term = $this->_getParam("term");
        $tbGru = new Application_Model_AsGrupoUsuarios();
        $aux = $tbGru->getGrupoPorNome($term)->toArray();
        if(count($aux)>0){
            $this->view->dados = array("success" => TRUE);
        }else{
            $this->view->dados = array("success" => FALSE);
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function salvaParticipantesGrupoAction(){
        $tbGruPart = new Application_Model_AsGrupoUsuariosParticipante();
        $asgpu_codigo = $this->_getParam('asgpu_codigo');
        $participantes = $this->_request->getPost("part");

        foreach ($participantes as $key => $part) {
            $participantes[$key]['asgpu_codigo'] = $asgpu_codigo;
            $tbGruPart->salvar($participantes[$key]);
        }
        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Grupo cadastrado com Sucesso!", "asgpu_codigo" => "$asgpu_codigo");
        return $this->render("dados", NULL, TRUE);

    }
    public function excluirParticipantesGrupoAction(){
        $tbGruPart = new Application_Model_AsGrupoUsuariosParticipante();
        $asgpp_codigo = $this->_getParam('asgpp_codigo');
       try{
           $tbGruPart->excluir($asgpp_codigo);
           $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Participante excluído com Sucesso!");
       }catch (Exception $exp){

           $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => $exp->getMessage());
       }

        return $this->render("dados", NULL, TRUE);

    }
    public function excluirGrupoAction(){
        $tbGruPart = new Application_Model_AsGrupoUsuarios();
        $asgpu_codigo = $this->_getParam('asgpu_codigo');
       try{
           $tbGruPart->excluir($asgpu_codigo);
           $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Grupo excluído com Sucesso!");
       }catch (Exception $exp){

           $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => $exp->getMessage());
       }

        return $this->render("dados", NULL, TRUE);

    }

    public function buscarGruposAction(){
        $term = $this->_getParam("term");
        $tbGru = new Application_Model_AsGrupoUsuarios();
        $this->view->dados = $tbGru->getGrupoPesquisa($term)->toArray();
        return $this->render("dados", NULL, TRUE);
    }

	public function pesquisaDadosAction()
	{
		$this->_helper->layout->disableLayout();
		$tbUsr = new Application_Model_Usuarios();
		$busca = $this->_request->getPost("busca");
		$status = $this->_request->getPost("status");
		$this->view->dados = $tbUsr->pesquisa($busca, $status)->toArray();

		return $this->render("dados", NULL, TRUE);
	}

	public function getParticipantesGrupoAction(){
        $asgpu_codigo = $this->_getParam("asgpu_codigo");
        $tbGruPart = new Application_Model_AsGrupoUsuariosParticipante();
        $this->view->dados = $tbGruPart->getParticipantes($asgpu_codigo)->toArray();
        return $this->render("dados", NULL, TRUE);

    }
}

