const URL = baseUrl + "/acesso/";


$(function () {

    $("#grupos-1").simplePagination({
        perPage: 7,
        previousButtonClass: "btn btn-danger",
        nextButtonClass: "btn btn-danger"
    });
    $("#grupos-2").simplePagination({
        perPage: 7,
        previousButtonClass: "btn btn-danger",
        nextButtonClass: "btn btn-danger"
    });
    $("#usuarios").simplePagination({
        perPage: 7,
        previousButtonClass: "btn btn-danger",
        nextButtonClass: "btn btn-danger"
    });

    $('#usuarios-grupo').hide();
    $('#permissoes-grupo').hide();
    $('#usuario-permissao').hide();
});

function validaAba(){
    $('#usuarios-grupo').hide();
    $('#permissoes-grupo').hide();
    $('#usuario-permissao').hide();
}
//------------------------------- FUNÇÕES DE GRUPO -----------------------------------------------
function grupoUsuario(id) {
    $.ajax({
        url: URL + 'grupo/carregar-usuarios/id/' + id,
        type: "POST",
        success: function (json) {
            $('#grupo-usuario').html("")
            if (json.length > 0) {
                $('#grupo-usuario').append(
                    "   <table>" +
                    "    <thead>" +
                    "        <tr>" +
                    "            <th class='ui-widget-header c' style='width: 80%'>Usuário</th>" +
                    "            <th class='ui-widget-header c' style='width: 10%'> Código</th>" +
                    "            <th class='ui-widget-header c'>Ação</th>" +
                    "        </tr>" +
                    "    </thead>" +
                    "    <tbody>")
                $.each(json, function (key, value) {
                    $('#grupo-usuario table').append(
                        "<tr id='grau_codigo_" + value.grau_codigo + "'> " +
                        "   <td>" + value.usr_nome + "</td>" +
                        "   <td style='text-align: center'><input type='hidden' id='usr_cod' name='usr_cod' value='" + value.usr_codigo + "'/>" + value.usr_codigo + "</td>" +
                        "   <td><a class='btn btn-warning' title='Excluir'" +
                        "       onclick='apagarUsuarioGrupo(" + value.grau_codigo + ", "+id+")'>" +
                        "       <i class='icon-remove icon-white'></i>" +
                        "       </a" +
                        "   </td>" +
                        "</tr>")
                })
                $('#grupo-usuario').append(
                    "   </tbody>" +
                    "   </table>")
            } else {
                $('#grupo-usuario').append(
                    "   <table>" +
                    "    <thead>" +
                    "        <tr>" +
                    "            <th class='ui-widget-header c' style='width: 80%'>Usuário</th>" +
                    "            <th class='ui-widget-header c' style='width: 10%'> Código</th>" +
                    "            <th class='ui-widget-header c'>Ação</th>" +
                    "        </tr>" +
                    "    </thead>" +
                    "    <tbody>" +
                    "       <tr> " +
                    "           <td colspan='3'> Nenhum usuário vinculado a este grupo!</td>" +
                    "       </tr>" +
                    "   </tbody>" +
                    "   </table>"
                )

            }
            $('#usuarios-grupo').show();
            $('#grac_codigo_usuario').val(id);
            $("#grupo-usuario").simplePagination({
                perPage: 7,
                previousButtonClass: "btn btn-danger",
                nextButtonClass: "btn btn-danger"
            });
        }


    });
}

function salvarGrupo() {
    var grac_codigo = $("#grac_codigo_edit").val();
    var grac_descricao = $("#grac_descricao").val();

    $.ajax({
        url: baseUrl + '/acesso/grupo/salvar/',
        type: 'POST',
        data: {
            grac_codigo: grac_codigo,
            grac_descricao: grac_descricao,
        },
        success: function (json) {
            if (json.success) {
                mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                    window.location.reload();
                });
                $("#form-grupo").remove();
            } else {
                mensagem("Erro", json.error, 300, 120, function () {
                });
            }
        }
    })
}

function janelaEditarGrupos(grac_codigo, grac_descricao) {
    if (typeof(grac_codigo) == "undefined") {
        grac_codigo = '';
        grac_descricao = '';
    }

    var form = '<form>' +
        '<input type="hidden" id="grac_codigo_edit" name="grac_codigo_edit" value="' + grac_codigo + '">' +
        '<label style="width: 75px">Descrição:</label>' +
        '<input id="grac_descricao" name="grac_descricao" value="' + grac_descricao + '" style="margin-left:3px;width: 300px; text-transform: uppercase;" class=\"ui-state-default\" />' +
        '<br/> </form>';

    $("body").append("<div id='form-grupo' title='Cadastro de Grupos' />");
    $("#form-grupo")
        .html(form)
        .dialog({
            modal: true,
            width: 450,
            height: 180,
            close: function () {
                $(this).remove();
            },
            buttons: {
                Salvar: salvarGrupo,
                Cancelar: function () {
                    $(this).dialog('close');
                }
            }
        });

    $("#usr_nome").buscar({
        url: baseUrl + "/default/usuarios/buscar",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function apagarGrupo(grac_codigo) {
    confirme("Atenção", "Deseja excluir este grupo?", 300, 150, function () {
        $.ajax({
            url: baseUrl + '/acesso/grupo/deletar/grac_codigo/' + grac_codigo,
            type: 'GET',
            success: function (txt) {
                if (txt.success) {
                    mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                        window.location.reload();
                    });
                } else {
                    mensagem('Erro', txt.mensagem, 300, 220, function () {
                    });
                }
            }
        });
    });

}

function pesquisaGrupo() {
    var term = $("#busca-grupo").val();
    setTimeout(function () {
        $.ajax({
            url: URL + "grupo/pesquisar",
            type: "POST",
            data: {
                busca: term,
            },
            success: function (json) {
                $("#grupos-1").html("");
                var tr = "<table class='table table-striped'>"
                    + "<thead>"
                    + "  <tr>"
                    + "     <th class='ui-widget-header'>Descrição</th>"
                    + "     <th class='ui-widget-header c' style='width: 15%'>Ações</th>"
                    + "  </tr>"
                    + "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element) {
                        tr += "<tr>"
                            + "<td class='ui-widget-content' onclick='grupoUsuario(" + element.grac_codigo + ")' title='Clique para visualizar os usuários'>" + element.grac_descricao + "</td>"
                            + "<td class='ui-widget-content coluna-center'>"
                            + "<a class='btn btn-info' title='Editar'"
                            + "  onclick=\"janelaEditarGrupos('" + element.grac_codigo + "','" + element.grac_descricao + "')\">"
                            + "  <i class='icon-edit icon-white'></i>"
                            + "</a> "
                            + "<a class='btn btn-warning' title='Excluir'"
                            + "  onclick='apagarGrupo(" + element.grac_codigo + ")'>"
                            + "  <i class='icon-remove icon-white'></i>"
                            + "</a>"
                            + "</td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>" +
                        " <td colspan='3'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#grupos-1").html(tr + "</table>");
                $("#grupos-1").simplePagination({
                    perPage: 7,
                    previousButtonClass: "btn btn-danger",
                    nextButtonClass: "btn btn-danger"
                });
            }
        });
    }, 1000);
    $('#grac_codigo_usuario').val('');
    $('#usuarios-grupo').hide();
}

//------------------------------ FIM FUNÇÕES GRUPO ------------------------------------------------

//------------------------------- FUNÇÕES DE GRUPO/USUARIOS ---------------------------------------

function apagarUsuarioGrupo(grau_codigo, grac_codigo) {
    confirme("Atenção", "Deseja excluir este usuário do grupo?", 300, 150, function () {
        $.ajax({
            url: baseUrl + '/acesso/grupo-acesso-usuarios/deletar/grau_codigo/' + grau_codigo,
            type: 'GET',
            success: function (txt) {
                if (txt.success) {
                    mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                      grupoUsuario(grac_codigo);
                    });
                } else {
                    mensagem('Erro', txt.mensagem, 300, 220, function () {
                    });
                }
            }
        });
    });

}

function janelaEditarUsuarioGrupo() {
    var form = '<form><input type="hidden" id="usr_codigo" value=""><label style="width: 75px">Usuário:</label><input type="text" id="usr_nome" value="" style="margin-left:3px;width: 240px" class="ui-state-default" /><br/></form>'

    $("body").append("<div id='usuario-grupo' title='Vinculo Usuário/Grupo' />");
    $("#usuario-grupo")
        .html(form)
        .dialog({
            modal: true,
            width: 500,
            height: 180,
            close: function () {
                $(this).remove();
            },
            buttons: {
                Salvar: salvarGrupoUsuario,
                Cancelar: function () {
                    $(this).dialog('close');
                }
            }
        });

    $("#usr_nome").buscar({
        url: baseUrl + "/usuarios/usuarios/busca-geral",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function salvarGrupoUsuario() {
    var usr_codigo = $('#usr_codigo').val();
    var usr_nome = $('#usr_nome').val();
    var grac_codigo = $('#grac_codigo_usuario').val();
    var valida = 0;

    if (usr_codigo != "" && usr_codigo != "undefined") {


        $('#grupo-usuario').find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (usr_codigo == $(this).val()) {
                    valida = 1;
                }
            });
        });
        if (valida == 0) {
            $.ajax({
                url: baseUrl + '/acesso/grupo-acesso-usuarios/salvar-grupo-usuarios',
                type: 'POST',
                data: {
                    usr_codigo: usr_codigo,
                    grac_codigo: grac_codigo
                },
                success: function (txt) {
                    if (txt.success) {
                      $("#usuario-grupo").dialog('close');
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                          grupoUsuario(grac_codigo);
                        });
                    } else {
                        mensagem('Erro', txt.mensagem, 300, 220, function () {
                        });
                    }
                }
            });
        } else {
            mensagem("Erro", "Usuário já vinculado ao grupo!", 300, 120, function () {
                $('#usr_codigo').val("");
                $('#usr_nome').val("");
            });
        }
    } else {
        return false;
    }

}

function pesquisaGrupoUsuario() {
    var term = $("#busca-usuario").val();
    var grupo = $('#grac_codigo_usuario').val();
    setTimeout(function () {
        $.ajax({
            url: URL + "grupo-acesso-usuarios/pesquisar",
            type: "POST",
            data: {
                busca: term,
                id: grupo,
            },
            success: function (json) {
                $("#grupo-usuario").html("");
                var tr = "<table class='table table-striped'>"
                    + "<thead>"
                    + "  <tr>"
                    + "     <th class='ui-widget-header c' style='width: 80%'>Usuário</th>"
                    + "     <th class='ui-widget-header c' style='width: 10%'> Código</th>"
                    + "     <th class='ui-widget-header c'>Ação</th>"
                    + "  </tr>"
                    + "</thead>";
                if (json.length > 0) {
                    $.each(json, function (key, value) {
                        tr +=
                            "<tr id='grau_codigo_" + value.grau_codigo + "'> " +
                            "   <td>" + value.usr_nome + "</td>" +
                            "   <td style='text-align: center'><input type='hidden' id='usr_cod' name='usr_cod' value='" + value.usr_codigo + "'/>" + value.usr_codigo + "</td>" +
                            "   <td><a class='btn btn-warning' title='Excluir'" +
                            "       onclick='apagarUsuarioGrupo(" + value.grau_codigo + ")'>" +
                            "       <i class='icon-remove icon-white'></i>" +
                            "       </a" +
                            "   </td>" +
                            "</tr>";
                    })
                } else {
                    tr += "<tr>" +
                        " <td colspan='3'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#grupo-usuario").append(tr + "</table>");
                $("#grupo-usuario").simplePagination({
                    perPage: 7,
                    previousButtonClass: "btn btn-danger",
                    nextButtonClass: "btn btn-danger"
                });
            }
        });
    }, 2000);

}

//------------------------------- FIM FUNÇÕES DE GRUPO/USUARIOS -----------------------------------

//------------------------------- FUNÇÕES DE GRUPO/PERMISSAO --------------------------------------

function pesquisaGrupoPermissao() {
    var term = $("#busca-grupo-2").val();
    setTimeout(function () {
        $.ajax({
            url: URL + "grupo/pesquisar",
            type: "POST",
            data: {
                busca: term,
            },
            success: function (json) {
                $("#grupos-2").html("");
                var tr = "<table class='table table-striped'>"
                    + "<thead>"
                    + "  <tr>"
                    + "     <th class='ui-widget-header'>Descrição</th>"
                    + "     <th class='ui-widget-header c' style='width: 15%'>Ações</th>"
                    + "  </tr>"
                    + "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element) {
                        tr += "<tr>"
                            + "<td class='ui-widget-content' onclick='grupoPermissao(" + element.grac_codigo + ")' title='Clique para visualizar os usuários'>" + element.grac_descricao + "</td>"
                            + "<td class='ui-widget-content coluna-center'>"
                            + "<a class='btn btn-info' title='Editar'"
                            + "  onclick=\"janelaEditarGrupos('" + element.grac_codigo + "','" + element.grac_descricao + "')\">"
                            + "  <i class='icon-edit icon-white'></i>"
                            + "</a> "
                            + "<a class='btn btn-warning' title='Excluir'"
                            + "  onclick='apagarGrupo(" + element.grac_codigo + ")'>"
                            + "  <i class='icon-remove icon-white'></i>"
                            + "</a>"
                            + "</td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>" +
                        " <td colspan='3'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#grupos-2").html(tr + "</table>");
                $("#grupos-2").simplePagination({
                    perPage: 7,
                    previousButtonClass: "btn btn-danger",
                    nextButtonClass: "btn btn-danger"
                });
            }
        });
    }, 1000);
    $('#grac_codigo_permissao').val('');

}

function grupoPermissao(id) {
    $.ajax({
        url: URL + 'grupo-acesso-permissoes/carregar-permissoes/id/' + id,
        type: "POST",
        success: function (json) {
            $('#grupo-permissao').html("")
            if (json.length > 0) {
                $('#grupo-permissao').append(
                    "   <table style='width: 100%'>" +
                    "    <thead>" +
                    "        <tr>" +
                    "            <th class='ui-widget-header c' style='width: 45%'>Permissão</th>" +
                    "            <th class='ui-widget-header c' style='width: 45%'> Caminho</th>" +
                    "            <th class='ui-widget-header c'>Ação</th>" +
                    "        </tr>" +
                    "    </thead>" +
                    "    <tbody>")
                $.each(json, function (key, value) {
                    $('#grupo-permissao table').append(
                        "<tr id='grap_codigo_" + value.grap_codigo + "'> " +
                        "   <td> <input type='hidden' id='ace_cod' name='ace_cod' value='" + value.ace_codigo + "'/> " + value.ace_descricao + "</td>" +
                        "   <td style='text-align: center'>" + value.ace_caminho + "</td>" +
                        "   <td><a class='btn btn-warning' title='Excluir'" +
                        "       onclick='apagarPermissaoGrupo(" + value.grap_codigo + ","+id+")'>" +
                        "       <i class='icon-remove icon-white'></i>" +
                        "       </a" +
                        "   </td>" +
                        "</tr>")
                })
                $('#grupo-permissao').append(
                    "   </tbody>" +
                    "   </table>")
            } else {
                $('#grupo-permissao').append(
                    "   <table style='width: 100%'>" +
                    "    <thead>" +
                    "        <tr>" +
                    "            <th class='ui-widget-header c' style='width: 45%'>Permissão</th>" +
                    "            <th class='ui-widget-header c' style='width: 45%'> Caminho</th>" +
                    "            <th class='ui-widget-header c'>Ação</th>" +
                    "        </tr>" +
                    "    </thead>" +
                    "    <tbody>" +
                    "       <tr> " +
                    "           <td colspan='3'> Nenhuma permissão vinculada a este grupo!</td>" +
                    "       </tr>" +
                    "   </tbody>" +
                    "   </table>"
                )

            }
            $('#permissoes-grupo').show();
            $('#grac_codigo_permissao').val(id);
            $("#grupo-permissao").simplePagination({
                perPage: 7,
                previousButtonClass: "btn btn-danger",
                nextButtonClass: "btn btn-danger"
            });
        }
    });
}

function apagarPermissaoGrupo(grap_codigo, grac_codigo) {
    confirme("Atenção", "Deseja excluir esta permissão do grupo?", 300, 120, function () {
        $.ajax({
            url: baseUrl + '/acesso/grupo-acesso-permissoes/deletar/',
            type: 'POST',
            data: {
                grap_codigo: grap_codigo
            },
            success: function (txt) {
                if (txt.success) {
                    mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                      grupoPermissao(grac_codigo);
                    });
                } else {
                    mensagem('Erro', txt.mensagem, 300, 220, function () {
                    });
                }
            }
        });
    });

}

function janelaEditarGrupoPermissoes() {

    var grac_codigo = $('#grac_codigo_permissao').val();

    var form = '<form><input type="hidden" id="grac_codigo_perm" value="' + grac_codigo + '"><input type="hidden" id="ace_codigo" value=""><div id="form-erro" class="h ui-state-error"/><label style="width: 75px">Permissão:</label><input id="ace_descricao" value="" style="margin-left:3px;width: 240px" class=\"ui-state-default\" /><br /></form>'

    $("body").append("<div id=\"acesso-dialog\" title=\"Vinculo com Permissões\" />");
    $("#acesso-dialog")
        .html(form)
        .dialog({
            modal: true,
            width: 370,
            height: 140,
            close: function () {
                $(this).remove();
            },
            buttons: {
                Salvar: salvarPermissaoGrupo,
                Cancelar: function () {
                    $(this).dialog('close');
                }
            }
        });

    $("#ace_descricao").buscar({
        url: baseUrl + "/acesso/acesso/buscar",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function salvarPermissaoGrupo() {
    var grac_codigo = $('#grac_codigo_perm').val();
    var ace_codigo = $('#ace_codigo').val();
    var valida = 0;

    if (ace_codigo != "" && ace_codigo != "undefined") {


        $('#grupo-permissao').find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (ace_codigo == $(this).val()) {
                    valida = 1;
                }
            });
        });
        if (valida == 0) {
            $.ajax({
                url: baseUrl + '/acesso/grupo-acesso-permissoes/salvar-grupo-permissoes',
                type: 'POST',
                data: {
                    ace_codigo: ace_codigo,
                    grac_codigo: grac_codigo
                },
                success: function (txt) {
                    if (txt.success) {
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                          $("#acesso-dialog").dialog('close');
                          grupoPermissao(grac_codigo);
                        });
                    } else {
                        mensagem('Erro', txt.mensagem, 300, 220, function () {
                        });
                    }
                }
            });
        } else {
            mensagem("Erro", "Permissão já vinculado ao grupo!", 300, 120, function () {
                $('#ace_codigo').val("");
                $('#ace_descricao').val("");
            });
        }
    } else {
        return false;
    }


}

function pesquisaPermissaoGrupo() {
    var term = $("#busca-permissao").val();
    var grac_codigo = $('#grac_codigo_permissao').val();

    setTimeout(function () {
        $.ajax({
            url: URL + 'grupo-acesso-permissoes/carregar-permissoes',
            type: "POST",
            data: {
                busca: term,
                id: grac_codigo,
            },
            success: function (json) {
                $('#grupo-permissao').html("")
                if (json.length > 0) {
                    $('#grupo-permissao').append(
                        "   <table>" +
                        "    <thead>" +
                        "        <tr>" +
                        "            <th class='ui-widget-header c' style='width: 80%'>Permissão</th>" +
                        "            <th class='ui-widget-header c' style='width: 10%'> Caminho</th>" +
                        "            <th class='ui-widget-header c'>Ação</th>" +
                        "        </tr>" +
                        "    </thead>" +
                        "    <tbody>")
                    $.each(json, function (key, value) {
                        $('#grupo-permissao table').append(
                            "<tr id='grap_codigo_" + value.grap_codigo + "'> " +
                            "   <td> <input type='hidden' id='ace_cod' name='ace_cod' value='" + value.ace_codigo + "'/> " + value.ace_descricao + "</td>" +
                            "   <td style='text-align: center'>" + value.ace_caminho + "</td>" +
                            "   <td><a class='btn btn-warning' title='Excluir'" +
                            "       onclick='apagarPermissaoGrupo(" + value.grap_codigo + ")'>" +
                            "       <i class='icon-remove icon-white'></i>" +
                            "       </a" +
                            "   </td>" +
                            "</tr>")
                    })
                    $('#grupo-permissao').append(
                        "   </tbody>" +
                        "   </table>")
                    $("#grupo-permissao").simplePagination({
                        perPage: 7,
                        previousButtonClass: "btn btn-danger",
                        nextButtonClass: "btn btn-danger"
                    });
                } else {
                    $('#grupo-permissao').append(
                        "   <table>" +
                        "    <thead>" +
                        "        <tr>" +
                        "            <th class='ui-widget-header c' style='width: 80%'>Permissão</th>" +
                        "            <th class='ui-widget-header c' style='width: 10%'> Caminho</th>" +
                        "            <th class='ui-widget-header c'>Ação</th>" +
                        "        </tr>" +
                        "    </thead>" +
                        "    <tbody>" +
                        "       <tr> " +
                        "           <td colspan='3'> Nenhuma permissão encontrada!</td>" +
                        "       </tr>" +
                        "   </tbody>" +
                        "   </table>"
                    )

                }
            }
        })
    }, 1000);

}

//------------------------------- FIM FUNÇÕES DE GRUPO/PERMISSAO -----------------------------------

//------------------------------- FUNÇÕES DE USUARIO/PERMISSAO -----------------------------------

function pesquisaUsuarioPermissao() {
    var term = $('#busca-usuarios').val();
    $.ajax({
        url: URL + 'acesso-usuarios/pesquisar',
        type: "POST",
        data: {
            busca: term
        },
        success: function (json) {
            $('#usuarios').html("");

            $('#usuarios').append(
                "   <table>" +
                "    <thead>" +
                "        <tr>" +
                "            <th class='ui-widget-header c' style='width: 80%'>USUÁRIO</th>" +
                "            <th class='ui-widget-header c' style='width: 10%'>CÓDIGO</th>" +
                "        </tr>" +
                "    </thead>" +
                "    <tbody>");
            $.each(json, function (key, value) {
                $('#usuarios table').append(
                    "<tr id='usr_codigo_" + value.usr_codigo + "'> " +
                    "   <td>" + value.usr_nome + "</td>" +
                    "   <td style='text-align: center'>" + value.usr_codigo + "</td>" +
                    "</tr>")
            });
            $('#usuarios').append(
                "   </tbody>" +
                "   </table>");

            $("#usuarios").simplePagination({
                perPage: 7,
                previousButtonClass: "btn btn-danger",
                nextButtonClass: "btn btn-danger"
            });
        }


    });
}

function usuarioPermissao(id) {
    $.ajax({
        url: URL + 'acesso-usuarios/carregar-permissoes/id/' + id,
        type: "POST",
        success: function (json) {
            $('#usuarios-permissoes').html("")
            if (json.length > 0) {
                $('#usuarios-permissoes').append(
                    "   <table style='width: 100%'>" +
                    "    <thead>" +
                    "        <tr>" +
                    "            <th class='ui-widget-header c' style='width: 45%'>Permissão</th>" +
                    "            <th class='ui-widget-header c' style='width: 45%'> Caminho</th>" +
                    "            <th class='ui-widget-header c'>Ação</th>" +
                    "        </tr>" +
                    "    </thead>" +
                    "    <tbody>")
                $.each(json, function (key, value) {
                    $('#usuarios-permissoes table').append(
                        "<tr id='acu_codigo_" + value.acu_codigo + "'> " +
                        "   <td class='ui-widget-content'> <input type='hidden' id='ace_cod' name='ace_cod' value='" + value.ace_codigo + "'/> " + value.ace_descricao + "</td>" +
                        "   <td style='text-align: center' class='ui-widget-content'>" + (value.ace_caminho != null ? value.ace_caminho : '') + "</td>" +
                        "   <td class='ui-widget-content'><a class='btn btn-warning' title='Excluir'" +
                        "       onclick='apagarPermissaoUsuario(" + value.acu_codigo + ","+id+")'>" +
                        "       <i class='icon-remove icon-white'></i>" +
                        "       </a" +
                        "   </td>" +
                        "</tr>")
                })
                $('#usuarios-permissoes').append(
                    "   </tbody>" +
                    "   </table>")
            } else {
                $('#usuarios-permissoes').append(
                    "   <table style='width: 100%'>" +
                    "    <thead>" +
                    "        <tr>" +
                    "            <th class='ui-widget-header c' style='width: 45%'>Permissão</th>" +
                    "            <th class='ui-widget-header c' style='width: 45%'> Caminho</th>" +
                    "            <th class='ui-widget-header c'>Ação</th>" +
                    "        </tr>" +
                    "    </thead>" +
                    "    <tbody>" +
                    "       <tr> " +
                    "           <td colspan='3'> Nenhuma permissão vinculada a este usuario!</td>" +
                    "       </tr>" +
                    "   </tbody>" +
                    "   </table>"
                )

            }
            $('#usuario-permissao').show();
            $('#usuario_codigo').val(id);
            $("#usuarios-permissoes").simplePagination({
                perPage: 7,
                previousButtonClass: "btn btn-danger",
                nextButtonClass: "btn btn-danger"
            });
        }
    });
}

function apagarPermissaoUsuario(id, usr_codigo) {
    confirme("Atenção", "Deseja retirar esta permissão do usuário?", 300, 120, function () {
        $.ajax({
            url: baseUrl + '/acesso/acesso-usuarios/deletar/',
            type: 'POST',
            data: {
                acu_codigo: id
            },
            success: function (txt) {
                if (txt.success) {
                    mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                      usuarioPermissao(usr_codigo);
                    });
                } else {
                    mensagem('Erro', txt.mensagem, 300, 220, function () {
                    });
                }
            }
        });
    });
}

function pesquisaPermissaoUsuario() {
    setTimeout(function () {
        var usr_codigo = $('#usuario_codigo').val();
        var term = $('#busca-permissao-usuario').val();
        $.ajax({
            url: URL + 'acesso-usuarios/carregar-permissoes/id/' + usr_codigo + '/term/' + term,
            type: "POST",
            success: function (json) {
                $('#usuarios-permissoes').html("")
                if (json.length > 0) {
                    $('#usuarios-permissoes').append(
                        "   <table style='width: 100%'>" +
                        "    <thead>" +
                        "        <tr>" +
                        "            <th class='ui-widget-header c' style='width: 45%'>Permissão</th>" +
                        "            <th class='ui-widget-header c' style='width: 45%'> Caminho</th>" +
                        "            <th class='ui-widget-header c'>Ação</th>" +
                        "        </tr>" +
                        "    </thead>" +
                        "    <tbody>")
                    $.each(json, function (key, value) {
                        $('#usuarios-permissoes table').append(
                            "<tr id='acu_codigo_" + value.acu_codigo + "'> " +
                            "   <td class='ui-widget-content'> <input type='hidden' id='ace_cod' name='ace_cod' value='" + value.ace_codigo + "'/> " + value.ace_descricao + "</td>" +
                            "   <td style='text-align: center' class='ui-widget-content'>" + (value.ace_caminho != null ? value.ace_caminho : '') + "</td>" +
                            "   <td class='ui-widget-content'><a class='btn btn-warning' title='Excluir'" +
                            "       onclick='apagarPermissaoUsuario(" + value.acu_codigo + ")'>" +
                            "       <i class='icon-remove icon-white'></i>" +
                            "       </a" +
                            "   </td>" +
                            "</tr>")
                    })
                    $('#usuarios-permissoes').append(
                        "   </tbody>" +
                        "   </table>")
                } else {
                    $('#usuarios-permissoes').append(
                        "   <table style='width: 100%'>" +
                        "    <thead>" +
                        "        <tr>" +
                        "            <th class='ui-widget-header c' style='width: 45%'>Permissão</th>" +
                        "            <th class='ui-widget-header c' style='width: 45%'> Caminho</th>" +
                        "            <th class='ui-widget-header c'>Ação</th>" +
                        "        </tr>" +
                        "    </thead>" +
                        "    <tbody>" +
                        "       <tr> " +
                        "           <td colspan='3'> Nenhuma permissão encontrada!</td>" +
                        "       </tr>" +
                        "   </tbody>" +
                        "   </table>"
                    )

                }
                $("#usuarios-permissoes").simplePagination({
                    perPage: 7,
                    previousButtonClass: "btn btn-danger",
                    nextButtonClass: "btn btn-danger"
                });
            }
        })
    }, 2000);
}

function janelaEditarUsuarioPermissoes(){

    var form = '<form><input type="hidden" id="ace_codigo" value=""><div id="form-erro" class="h ui-state-error"/><label style="width: 75px">Permissão:</label><input id="ace_descricao" value="" style="margin-left:3px;width: 240px" class=\"ui-state-default\" /><br /></form>'

    $("body").append("<div id='usuario_permissao' title='Vinculo com Permissões' />");
    $("#usuario_permissao")
        .html(form)
        .dialog({
            modal: true,
            width: 370,
            height: 140,
            close: function () {
                $(this).remove();
            },
            buttons: {
                Salvar: salvarPermissaoUsuario,
                Cancelar: function () {
                    $(this).dialog('close');
                }
            }
        });
    $("#ace_descricao").buscar({
        url: baseUrl + "/acesso/acesso/buscar",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });

}

function salvarPermissaoUsuario(){
    var usr_codigo = $('#usuario_codigo').val();
    var ace_codigo = $('#ace_codigo').val();
    var valida = 0;

    if (ace_codigo != "" && ace_codigo != "undefined") {


        $('#usuarios-permissoes').find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (ace_codigo == $(this).val()) {
                    valida = 1;
                }
            });
        });
        if (valida == 0) {
            $.ajax({
                url: baseUrl + '/acesso/acesso-usuarios/salvar-acesso-usuarios',
                type: 'POST',
                data: {
                    ace_codigo: ace_codigo,
                    usr_codigo: usr_codigo
                },
                success: function (txt) {
                    if (txt.success) {
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                          $("#usuario_permissao").dialog('close');
                          usuarioPermissao(usr_codigo);
                        });
                    } else {
                        mensagem('Erro', txt.mensagem, 300, 220, function () {
                        });
                    }
                }
            });
        } else {
            mensagem("Erro", "Permissão já vinculado ao usuário!", 300, 120, function () {
                $('#ace_codigo').val("");
                $('#ace_descricao').val("");
            });
        }
    } else {
        return false;
    }

}

//------------------------------- FIM FUNÇÕES DE USUARIO/PERMISSAO -----------------------------------
