const URL = baseUrl + "/atendimentocras/atendimento-basico";

function bloqueiaCidadao() {
  if ($('#usu_anonimo').is(':checked')) {
    $('#dcab_usu_nome').val('ANÔNIMO');
    $('#dcab_usu_codigo').val('9999999');
    $('#dcab_usu_nome').prop('disabled', true);
    $('#dcabalert_usu_nome').hide();
  } else {
    $('#dcab_usu_nome').val('');
    $('#dcab_usu_codigo').val('');
    $('#dcab_usu_nome').prop('disabled', false);
  }
}

function form(asab_codigo) {
  $("body").append("<div id='dab_form_abm' title='Atendimento básico.'></div>");
  var url = baseUrl+"/atendimentocras/atendimento-basico/form/usr_codigo/"+$("#dabc_usr_codigo").val()+"/asab_codigo/"+asab_codigo;
  abrirModal("dab_form_abm", url);
}

function formSalvar(e) {
  if (validaForm('dcab_form_cad_ab', e)) {
    e.preventDefault();
    var valoresForm = $("#dcab_form_cad_ab").serialize();

    mensagemSemOk("dcab_salvar_ab", "Confirmação", "Salvando dados ...", 250, 150);
    $.ajax({
      url: URL + '/form-salvar',
      type: "POST",
      data: valoresForm,
      success: function(txt) {
        if(txt > 0) {
          fecharMensagemSemOk("dcab_salvar_ab");
          mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
              $("#dab_form_abm").dialog("destroy").remove();
              atualizaPagina();
          });
        } else {
          $("#dcabalert_cad_ab").html(txt);
          $("#dcabalert_cad_ab").show(txt);
          fecharMensagemSemOk("dcab_salvar_ab");
        }
      }
    });
  } else {
    return false;
  }
}

function formCadastraMotivoGeralSalvar(e) {
  if (validaForm('dasam_form_cadastrog', e)) {
    e.preventDefault();
    var valoresForm = $("#dasam_form_cadastrog").serialize();
    mensagemSemOk("dcc_salvar_motivo", "Confirmação", "Salvando dados ...", 250, 150);
    $.ajax({
      url: baseUrl+'/atendimentocras/atendimento-basico/form-cadastro-motivo-geral-salvar',
      type: "POST",
      data: valoresForm,
      success: function (txt) {
        if (txt) {
          fecharMensagemSemOk("dcc_salvar_motivo");
          mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
            $("#dasam_formgm").dialog("destroy").remove();
            $('#dcab_asam_codigo').val(txt.asam_codigo);
            $('#dcab_asam_nome').val(txt.asam_nome);
          });
        } else {
          fecharMensagemSemOk("dcc_salvar_motivo");
        }
      }
    });
  } else {
    return false;
  }
}

function pesquisaDados() {
  setTimeout(function(){
    $.ajax({
      url: URL + "/pesquisa-dados",
      type: "POST",
      data: {
        busca: $("#dbe_busca_ben").val(),
      },
      success: function (json) {
        $("#resultado").html("");
        var tr =  "<table class='table table-striped'>"
                + "<thead>"
                + "  <tr>"
                + "     <th width='5%' class='coluna-center'>ID</th>"
                + "     <th width='15%'>Unidade</th>"
                + "     <th width='25%'>Cidadão</th>"
                + "     <th width='20%'>Tipo de Atendimento</th>"
                + "     <th width='15%'>Profissional</th>"
                + "     <th width='5%' class='coluna-center'>Data</th>"
                + "     <th width='8%' class='coluna-acoes'>Ações</th>"
                + "  </tr>"
                + "</thead>";
        if (json.length > 0){
          json.forEach(function(element) {
            tr += "<tr>"
                + "    <td class='coluna-center'>" + element.asab_codigo + "</td>"
                + "    <td>" + element.uni_desc  + "</td>"
                + "    <td>" + element.usu_nome  + "</td>"
                + "    <td>" + element.asat_nome + "</td>"
                + "    <td>" + element.usr_nome  + "</td>"
                + "    <td class='coluna-center'>"
                +          dataToBr(element.asab_data)
                + "    </td>"
                + "    <td class='coluna-acoes'>"
                + "        <a class='btn btn-info' title='Editar'"
                + "           onclick='form(" + element.asab_codigo + ")'>"
                + "            <i class='icon-edit icon-white'></i>"
                + "        </a>"
                + "    </td>"
                + "</tr>";
          });
        } else {
          tr += "<tr>"+
              " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>"+
              "</tr>";
        }
        $("#resultado").html(tr + "</table>");
        addPagination();
      }
    });
  },1000);
}
