/*---------------------------------------------------------------------/
 * FUNÇÕES GERAIS                                                      /
 *--------------------------------------------------------------------*/
const URL = baseUrl + "/atendimentocras/atendimento-coletivo";
$(document).ready(function () {
    setTimeout(function () {
        fechaMenus();
        limpaCampos();
        $('#dac_asag_titulo').focus();
    }, 350);
});

function fechaMenus() {
    $("#prof_resp").hide();
    $("#cid_part").hide();
    $("#reunioes").hide();
}

function abreMenus() {
    $("#prof_resp").show();
    $("#cid_part").show();
    $("#reunioes").show();
}

function fechaGruposAtuais(){
    $("#list_grupo").hide();
}

function abreFechaMenu(opcao) {
    if (opcao==1){ $("#dados_prof_resp").toggle("slow"); } else { $("#dados_prof_resp").slideUp(); }
    if (opcao==2){ $("#dados_cid_part").toggle("slow"); } else { $("#dados_cid_part").slideUp(); }
    if (opcao==3){ $("#dados_reunioes").toggle("slow"); } else { $("#dados_reunioes").slideUp(); }
}

function desabilitaBuscaGrupo() {
    $("#dac_asag_titulo").attr("disabled", true);
    $("#dac_btn_carregagrupo").attr("disabled", true);
    $("#dac_btn_novogrupo").attr("disabled", true);
    $("#dac_btn_novogrupo").prop('onclick',null);
    $('#dac_asag_codigo').attr("readonly", true);
}

// Limpando campos e ativando botões por causa do cache
function limpaCampos() {
    $('#dac_asag_titulo').removeAttr('disabled');
    $("#dac_asag_titulo").attr("enabled", true);
    $('#dac_btn_carregagrupo').removeAttr('disabled');
    $("#dac_btn_carregagrupo").attr("enabled", true);
    $('#dac_btn_novogrupo').removeAttr('disabled');
    $("#dac_btn_novogrupo").attr("enabled", true);
    $('#dac_asag_titulo').val("");
    $('#dac_asag_codigo').val("");
}

/*---------------------------------------------------------------------/
 * FIM FUNÇÕES GERAIS                                                  /
 *--------------------------------------------------------------------*/

/*--------------------------------------------------------------------/
 * DADOS GRUPO DE ATENDIMENTO COLETIVO                                 /
 *--------------------------------------------------------------------*/

function buscaDadosGrupo() {
    $("#dac_asag_codigo").val("");
    $('#dac_asag_titulo').autocomplete({
        source: baseUrl + '/atendimentocras/atendimento-coletivo/busca-dados-grupo/',
        minLength: 3,
        delay: 300,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#dac_asag_codigo").val(ui.item.id);
            $("#dac_asag_titulo").val(ui.item.data.asag_titulo);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li>")
                .append("<a><strong>" + item.label + (item.unidade ? " - " + item.unidade : "") + "</strong><br>\n\</a>").appendTo(ul);
    }
}

function formGrupo(asag_codigo) {
    $("body").append("<div id='dcg_form_grupom' title='Cadastro grupo de atendimento coletivo.'></div>");
    abrirModalAcao(
        'dcg_form_grupom',
        URL + "/form-grupo/asag_codigo/"+asag_codigo,
        formGrupoSalvar
    )
}

function formGrupoSalvar(e) {
    if (validaForm('dcg_form_cad_grupo', e)) {
        e.preventDefault();
        var valoresForm = $("#dcg_form_cad_grupo").serialize();

        mensagemSemOk("dcg_form_grupo_salvar","Salvando dados","Salvando dados...",200,150);
        $.ajax({
            url: URL + '/form-grupo-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {

                    if (txt > 0) {
                        $("#dac_asag_codigo").val(txt);
                        $("#dac_asag_titulo").val($("#dcg_asag_titulo").val());
                        $("#dcg_form_grupom").dialog("destroy").remove();
                        fecharMensagemSemOk("dcg_form_grupo_salvar");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });

                    } else {
                        $("#dcgalert_cad_grupo").html(txt);
                        $("#dcgalert_cad_grupo").show(txt);
                        fecharMensagemSemOk("dcg_form_grupo_salvar");
                    }
                    //$('html, body').animate({ scrollTop: $('#box_list_grupo'+asae_codigo).offset().top }, 'slow');

            }
        });
    } else {
        return false;
    }
}

function formGrupoExcluir(asag_codigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        mensagemSemOk("dcg_exc_grupo", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-grupo-excluir',
            type: "POST",
            data: {asag_codigo: asag_codigo},
            success: function (txt) {

                    if (txt > 0) {
                        $("#dacalert_dados_atend_col").hide();
                        fecharMensagemSemOk("dcg_exc_grupo");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });

                    } else {
                        $("#dacalert_dados_atend_col").html(txt);
                        $("#dacalert_dados_atend_col").show(txt);
                        fecharMensagemSemOk("dcg_exc_grupo");
                    }

            }
        });
    });
}

function carregaDadosGrupo(e) {
    var asag_codigo = $("#dac_asag_codigo").val();
    if (asag_codigo != "" && asag_codigo != 0) {
        e.preventDefault();
        mensagemSemOk("dac_carrega_grupo", "Confirmação", "Carregando Dados ...", 250, 150);
        setTimeout(function () {
            // Trava todos os campos de pesquisa e exibe os dados do grupo
            abreMenus();
            desabilitaBuscaGrupo();
            fechaGruposAtuais();
            fecharMensagemSemOk("dac_carrega_grupo");
        }, 150);
    } else {
        return false;
    }
}

/*--------------------------------------------------------------------/
 * FIM DADOS GRUPO DE ATENDIMENTO COLETIVO                             /
 *--------------------------------------------------------------------*/

/*---------------------------------------------------------------------/
 * PROFISSIONAIS RESPONSÁVEL                                           /
 *--------------------------------------------------------------------*/

function buscaProfissional(asae_codigo){
    $("#dps_busca_prof").autocomplete({
        source: baseUrl+'/usuarios/usuarios/busca-geral/',
        minLength: 3,
        delay: 300,
        search: function(event, ui){
            $(this).css("background","url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function(){
            $(this).css("background","none");
        },
        close: function(){
            $(this).css("background","none");
        },
        select: function (event, ui) {
            adicionaProfissionalReuniao(ui.item.id,asae_codigo);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function( ul, item ) {
        return $( "<li>" )
           .append("<a><strong>"+item.label+"</strong><br>\n\</a>").appendTo(ul);
    }
}

function adicionaProfissionalReuniao(usr_codigo,asae_codigo){
    $.ajax({
        url: URL + "/adiciona-profissional-reuniao",
        type: "POST",
        data: {
            usr_codigo: usr_codigo,
            asae_codigo: asae_codigo
        },
        success: function(txt){
            reunioesProfissionais(asae_codigo);
            $("#dados_profissionais_resp"+asae_codigo).toggle("slow");
        }
    });
}

function excluirProfissionalReuniao(asar_codigo,asae_codigo){
    $('html, body').animate({ scrollTop: $('#box_profissionais_resp'+asae_codigo).offset().top }, 'slow');
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function() {
        $.ajax({
            url: URL + '/excluir-profissional-reuniao',
            type: "POST",
            data: {
                asar_codigo:asar_codigo
            },
            success: function(txt) {
                reunioesProfissionais(asae_codigo);
                $("#dados_profissionais_resp"+asae_codigo).toggle("slow");
            }
        });
    });
}


/*---------------------------------------------------------------------/
 * FIM PROFISSIONAIS RESPONSÁVEL                                       /
 *--------------------------------------------------------------------*/

/*---------------------------------------------------------------------/
 * CIDADÃOS PARTICIPANTES                                              /
 *--------------------------------------------------------------------*/

function buscaVinculaCidadao(){
    $("#dcp_busca_cid").autocomplete({
        source: baseUrl+'/cidadao/cidadao/busca-geral/',
        minLength: 3,
        delay: 2000,
        search: function(event, ui){
            $(this).css("background","url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function(){
            $(this).css("background","none");
        },
        close: function(){
            $(this).css("background","none");
        },
        select: function (event, ui) {
            var usuCodigo = ui.item.id;
            var asagCodigo = $("#dac_asag_codigo").val();
            formCidadaoGrupo('',usuCodigo,asagCodigo);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function( ul, item ) {
        return $("<li " + usuarioBloqueado(item.data.usu_bloqueado) + ">")
            .append("<a><strong>" + item.label + "</strong><br>\n\
                        <strong>Nº Pront. Suas: </strong>" + validaCampoEmBranco(item.data.asps_num_prontuario) + "<br>\n\
                        <strong>Cpf:</strong>\n\ " + validaCampoEmBranco(item.data.usu_cpf) + "\n\
                        <strong>NIS:</strong>\n\ " + validaCampoEmBranco(item.data.usu_nis) + "<br>\n\
                        <strong>Mãe: </strong>" + validaCampoEmBranco(item.data.usu_mae) + " \n\
                        <strong>Data Nasc: </strong>" + dataToBrHiffen(item.data.usu_datanasc) + "<br>\n\
                     </a><br>"
                   ).appendTo(ul);
    }
}

function usuarioBloqueado(bloqueado) {
  return bloqueado ? "style='color: red'" : "";
}

function cidadaosPart(asag_codigo){
    abreFechaMenu(2);
    $('html, body').animate({ scrollTop: $('#box_cid_part').offset().top }, 'slow');
    $("#dados_cid_part").load(
        baseUrl+'/atendimentocras/atendimento-coletivo/cidadaos-part/asag_codigo/'+asag_codigo);
}

function formCidadaoGrupo(asapar_codigo,usu_codigo,asag_codigo){
    $("body").append("<div id='dcg_form_cidgrupom' title='Cadastro do cidadão no grupo de atendimento coletivo.'></div>");
    abrirModalAcao(
        'dcg_form_cidgrupom',
        URL + "/form-cidadao-grupo/asapar_codigo/"+asapar_codigo+"/usu_codigo/"+usu_codigo+"/asag_codigo/"+asag_codigo,
        formCidadaoGrupoSalvar
    )
}

function formCidadaoGrupoSalvar(e){
    if (validaForm('dcg_form_cad_cidgrupo', e)) {
        e.preventDefault();
        mensagemSemOk("dcg_form_cad_cidgrupo_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcg_form_cad_cidgrupo").serialize();
        $.ajax({
        url: URL + "/form-cidadao-grupo-salvar",
        type: "POST",
        data: valoresForm,
        success: function(txt){
            setTimeout(function(){
                if (txt > 0) {
                    $("#dcg_form_cidgrupom").dialog("destroy").remove();
                    fecharMensagemSemOk("dcg_form_cad_cidgrupo_salvar");
                    mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150);
                    cidadaosPart($("#dac_asag_codigo").val());
                    $("#dados_cid_part").toggle("slow");
                } else {
                    $("#dcgalert_cad_cidgrupo").html(txt);
                    $("#dcgalert_cad_cidgrupo").show(txt);
                }
            },300);
        }
    });
    } else {
        return false;
    }
}

function formCadastraCidadao(){
    $('html, body').animate({ scrollTop: $('#box_cid_part').offset().top }, 'slow');
    setTimeout(function () {
        $("body").append("<div id='dcid_formgm' title='Cadastro de Cidadão.'></div>");
        abrirModalAcao(
            'dcid_formgm',
            baseUrl+"/cidadao/cidadao/form-cadastro-geral",
            formCadastraCidadaoGeralSalvar
        )
    }, 600);

}

function formCadastraCidadaoGeralSalvar(e){
    if (validaForm('dcid_form_cadastrog', e)) {
        e.preventDefault();
        var valoresForm = $("#dcid_form_cadastrog").serialize();
        mensagemSemOk("dcc_salvar_cid", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl+'/cidadao/cidadao/form-cadastro-geral-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                    if (txt > 0) {
                        $("#dcid_formgm").dialog("destroy").remove();
                        fecharMensagemSemOk("dcc_salvar_cid");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            formCidadaoGrupo('',txt,$("#dac_asag_codigo").val());
                        });
                    } else {
                        fecharMensagemSemOk("dcc_salvar_cid");
                    }
            }
        });
    } else {
        return false;
    }
}

function formCadastraMotivoGeralSalvar(e){
    if (validaForm('dasam_form_cadastrog', e)) {
        e.preventDefault();
        var valoresForm = $("#dasam_form_cadastrog").serialize();
        mensagemSemOk("dcc_salvar_motivo", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl+'/atendimentocras/atendimento-basico/form-cadastro-motivo-geral-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        fecharMensagemSemOk("dcc_salvar_motivo");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                            $("#dasam_formgm").dialog("destroy").remove();
                            formCidadaoGrupo('',txt,$("#dac_asag_codigo").val());
                        });

                    } else {
                        fecharMensagemSemOk("dcc_salvar_motivo");
                    }
                }, 300);
            }
        });
    } else {
        return false;
    }
}

function imprimirParticipantes(asae_codigo) {
    popup(baseUrl.replace("zf","")+"PHPJasperXML/atendimento-coletivo/lista_presenca.php?asae_codigo="+asae_codigo, "login", 735, 412);
}

function atualizaParticipantes(asae_codigo){
    $('html, body').animate({ scrollTop: $('#box_participantes'+asae_codigo).offset().top }, 'slow');
    mensagemSemOk("atu_asae_codigo","Atualizando dados","Atualizando participantes",250,150);
    $.ajax({
        url: baseUrl+'/atendimentocras/atendimento-coletivo/atualiza-cidadaos-reuniao',
        type: "POST",
        data: {
            asae_codigo: asae_codigo,
            asag_codigo: $("#dac_asag_codigo").val()
        },
        success: function (txt) {
            setTimeout(function () {
                fecharMensagemSemOk("atu_asae_codigo");
                reunioesParticipantes(asae_codigo);
                $("#dados_participantes"+asae_codigo).toggle("slow");
            }, 150);
        }
    });
}

/*---------------------------------------------------------------------/
 * FIM CIDADÃOS PARTICIPANTES                                          /
 *--------------------------------------------------------------------*/

/*---------------------------------------------------------------------/
 * REUNIÕES                                                           /
 *--------------------------------------------------------------------*/

function reunioes(asag_codigo){
    abreFechaMenu(3);
    $('html, body').animate({ scrollTop: $('#box_reunioes').offset().top }, 'slow');
    $("#dados_reunioes").load(
        baseUrl+'/atendimentocras/atendimento-coletivo/reunioes/asag_codigo/'+asag_codigo);
}

function reuniaoDados(asae_codigo){
    $("#dados_inf_reunioes"+asae_codigo).toggle("slow");
    $('html, body').animate({ scrollTop: $("#box_reunioes"+asae_codigo).offset().top }, 'slow');
    $("#dados_inf_reunioes"+asae_codigo).load(
        baseUrl+'/atendimentocras/atendimento-coletivo/reunioes-dados/asae_codigo/'+asae_codigo);
}

function formReuniao(asag_codigo,asae_codigo){
    $("body").append("<div id='dcr_form_reuniaom' title='Cadastro reunião.'></div>");
    abrirModalAcao(
        'dcr_form_reuniaom',
        URL + "/form-reuniao/asag_codigo/"+asag_codigo+"/asae_codigo/"+asae_codigo,
        formReuniaoSalvar
    )
}

function verificaData (campo) {
    console.log("Valor: " + $("#" + campo.id).val());
    var id = $( "#" + campo.id );

    $( id ).tooltip({
        items: "[title]",
        position: {
            my: "right top",
            at: "right-5 top-20",
            collision: "none"
        }
    });

    $( id ).tooltip('close')
    $( id ).css('border', '1px solid #cccccc');


    dia = (campo.value.substring(0,2));
    mes = (campo.value.substring(3,5));
    ano = (campo.value.substring(6,10));

    hrs = (campo.value.substring(11,13));
    min = (campo.value.substring(14,16));

    dt = false;

    if(campo.value != ""){
        // verifica o dia valido para cada mes
        if ((dia < 01)||(dia < 01 || dia > 30) && (  mes == 04 || mes == 06 || mes == 09 || mes == 11 ) || dia > 31) {
            dt = true;
        }

        // verifica se o mes e valido
        if (mes < 01 || mes > 12 ) {
            dt = true;
        }

        // verifica se e ano bissexto
        if (mes == 2 && ( dia < 01 || dia > 29 || ( dia > 28 && (parseInt(ano / 4) != ano / 4)))) {
            dt = true;
        }

        // verifica data e hora
        if ((hrs < 00 ) || (hrs > 23) || ( min < 00) ||( min > 59)){
            dt = true;
        }
    } else {
        dt = true;
    }

    if (dt) {
        $( id ).css('border', '1px solid red');
        $( id ).attr("title", "Data/Hora Inválida");
        $( id ).tooltip("open");
        setTimeout(function (propertyName) {
            $( propertyName ).tooltip("close");
        }.bind(this, $( id )), 2000);
        $( id ).focus();
    }else{
        $( id ).tooltip('destroy');
        $( id ).attr("title", "");
        $( id ).css('border', '1px solid #cccccc');
    }
}

function formReuniaoSalvar(e){
    if (validaForm('dcr_form_cad_reuniao', e)) {
        e.preventDefault();
        var valoresForm = $("#dcr_form_cad_reuniao").serialize();
        mensagemSemOk("dcr_form_cad_reuniao_salvar","Salvando dados","Salvando dados...",200,150);
        $.ajax({
            url: baseUrl+'/atendimentocras/atendimento-coletivo/form-reuniao-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {

                    if (txt > 0) {
                        fecharMensagemSemOk("dcr_form_cad_reuniao_salvar");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            $("#dcr_form_reuniaom").dialog("destroy").remove();
                            reunioes($("#dac_asag_codigo").val());
                            $("#dados_reunioes").toggle("slow");

                        });
                    } else {
                        $("#dcralert_cad_reuniao").html(txt);
                        $("#dcralert_cad_reuniao").show(txt);
                    }
            }
        });
    } else {
        return false;
    }
}

function reunioesProfissionais(asae_codigo){
    $("#dados_profissionais_resp"+asae_codigo).toggle("slow");
    $('html, body').animate({ scrollTop: $('#box_profissionais_resp'+asae_codigo).offset().top }, 'slow');
    $("#dados_profissionais_resp"+asae_codigo).load(
        URL + '/reunioes-profissionais/asae_codigo/'+asae_codigo);
}

function reunioesParticipantes(asae_codigo){
    $("#dados_participantes"+asae_codigo).toggle("slow");
    $('html, body').animate({ scrollTop: $('#box_participantes'+asae_codigo).offset().top }, 'slow');
    $("#dados_participantes"+asae_codigo).load(
        URL + '/reunioes-participantes/asae_codigo/'+asae_codigo);
}

function reunioesComparecimentos(asaeh_codigo){
    $.ajax({
        url: URL + '/reunioes-comparecimentos',
        type: "POST",
        data: {
            asaeh_codigo:asaeh_codigo
        },
        success: function (txt) {
            if (txt=='t') {
                $("#status_pre"+asaeh_codigo + ' i')
                    .attr('class', 'fa fa-thumbs-o-up');
                $("#status_pre"+asaeh_codigo)
                    .attr("class", 'btn btn-success')
                    .attr("title","Presente");
            }else{
                $("#status_pre"+asaeh_codigo + ' i')
                    .attr('class', 'fa fa-thumbs-o-down');
                $("#status_pre"+asaeh_codigo)
                    .attr("class", 'btn btn-danger')
                    .attr("title","Ausente");
            }
        }
    });
}

/*---------------------------------------------------------------------/
 * FIM REUNIÕES                                                       /
 *--------------------------------------------------------------------*/

function somenteNumero(valor){
  var regra = /^[0-9]+$/;
  if (!valor.match(regra)) {
    $("#dcg_asag_quantidade_grupo").val("");
    return false;
  }
}

function verificaMinParticipantes(valor, minimo){
    if(valor != ''){
        if(parseInt(valor) < parseInt(minimo)) {
            mensagem("Atenção", "A <b>quantidade máxima</b> não pode ser <b>inferior</b> ao número de participantes já inscritos!");
            $("#dcg_asag_quantidade_grupo").val('');
        }
    }
}
