
var mindate;
var mindateDate = new Date();
const URL = baseUrl + '/atendimentocras/beneficios-cidadao';
$(function(){
    $('#dcbe_asbd_dtcadastro').change(function(){
            var parts = $('#dcbe_asbd_dtcadastro').val().split("/");
            var dataF = new Date(parseInt(parts[2], 10),
                      (parseInt(parts[1], 10)-1),
                      parseInt(parts[0], 10));

        console.log('mindateDate = '+mindateDate);
        console.log('dataF = '+dataF);
        if(mindateDate>dataF || dataF>new Date()){
            $('#dcbe_asbd_dtcadastro').val($.datepicker.formatDate("dd/mm/yy", new Date()));
        }
    });
    $('#dcbe_asbd_dtcadastro').mask("99/99/9999");
    $('#dcbe_asbd_dtcadastro').datepicker();
    $('#dcbe_asbd_dtcadastro').datepicker('option', 'minDate', mindate);
    $('#dcbe_asbd_dtcadastro').datepicker('option', 'maxDate', 0);
});

function form(asbd_codigo) {
    $("body").append("<div id='dbe_form_abm' title='Benefícios eventuais.'></div>");
    var url = URL + "/form/usr_codigo/" + $("#dbe_usr_codigo").val() + "/asbd_codigo/" + asbd_codigo;
    abrirModal('dbe_form_abm', url, '80%');
    if(asbd_codigo !== null && asbd_codigo !== ''){
        $("#btnSalvar").hide();
    }
}

function formSalvar(e) {
    if (validaForm('dcbe_form_cad_be', e)) {
        e.preventDefault();
        var valoresForm = $("#dcbe_form_cad_be").serialize();
        mensagemSemOk("dcbe_msg","Atenção","Carregando itens benefícios eventual",250,125);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                    if (txt > 0) {
                        fecharMensagemSemOk("dcbe_msg");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                            $("#dcbei_asbd_codigo").val(txt);
                            $("#dcbe_asbc_codigo").val(txt);
                            $("#dcbe_uni_desc").attr("disabled",true);
                            $("#dcbe_usu_nome").attr("disabled",true);
                            $("#dcbe_ase_codigo").attr("disabled",true);
                            $("#dcbe_asbd_obs").attr("disabled",true);
                            $("#dcbe_asbd_dtentrega").attr("disabled",true);
                            $("#dcbe_asbd_dtcadastro").attr("disabled",true);
                            $("#dcbe_novo").attr("disabled",true);
                            $("#dcbe_salvar").attr("disabled",true);
                            $("#dcbe_cancelar").attr("disabled",true);
                            $("#beneficios-msg").hide();
                            $("#beneficios").show();
                            $("#dcbe_ben_nome").focus();
                            $("#dcbealert_cad_be").hide();
                            $("#btnSalvar").hide();
                        });
                    } else {
                        $("#dcbealert_cad_be").html(txt);
                        $("#dcbealert_cad_be").show(txt);
                        fecharMensagemSemOk("dcbe_msg");
                    }
            }
        });
    } else {
        return false;
    }
}

function atualizarBeneficio(e){
    if (validaForm('dcbe_form_cad_be', e)) {
        e.preventDefault();
        var valoresForm = $("#dcbe_form_cad_be").serialize();
        valoresForm += "&asbd_dtcadastro="+$("#dcbe_asbd_dtcadastro").val();
        mensagemSemOk("dcbe_msg_atualiza","Atenção","Atualizando benefícios eventual",250,125);
        $.ajax({
            url: URL + '/form-salvar-finalizar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                fecharMensagemSemOk("dcbe_msg_atualiza");
                mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                    location.reload(true);
                });
            }
        });
    } else {
        return false;
    }
}

function formSalvarItens(e) {
    if (validaForm('dcbe_form_cad_bei', e)) {
        e.preventDefault();
        var valoresForm = $("#dcbe_form_cad_bei").serialize();

        mensagemSemOk("dcbe_msg_si","Atenção","Salvando itens benefícios eventual",250,125);
        $.ajax({
            url: baseUrl + '/atendimentocras/beneficios-cidadao/form-salvar-itens',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        atualizaListaBenItens(txt);
                        limpaFormBenItens();
                        $("#dcbealert_cad_bei").hide();
                        fecharMensagemSemOk("dcbe_msg_si");
                    } else {
                        $("#dcbealert_cad_bei").html(txt);
                        $("#dcbealert_cad_bei").show(txt);
                        fecharMensagemSemOk("dcbe_msg_si");
                    }
                }, 300);
            }
        });
    } else {
        return false;
    }
}

function atualizaListaBenItens(asbdiCodigo){
    setTimeout(function () {
        $("#btn-salvar-itens").show();
        $("#beneficios_inseridos").show();
        var codBeneficio = $("#dcbe_ben_codigo").val();
        var beneficio = $("#dcbe_ben_nome").val();
        var tipo = $("#dcab_asbt_codigo option:selected").text();
        var qtd = $("#dcbe_asbdi_qtd").val();
        var valor = $("#dcbe_asbdi_valor").val();
        var benConcedido = $("#dceb_asbdi_concedido").val();
        if (benConcedido=="t") { benConcedido = "Sim"; } else { benConcedido = "Não"; }
        $("#beneficios_inseridos").append("<tr id='beneficio_inserido"+asbdiCodigo+"'>"+
            "<td>"+beneficio+"</td>"+
            "<td>"+tipo+"</td>"+
            "<td class='coluna-center'>"+qtd+"</td>"+
            "<td class='coluna-currency'>"+valor+"</td>"+
            "<td class='coluna-center'>"+benConcedido+"</td>"+
            "<td class='coluna-acoes'>"+
                "<a class='btn btn-danger' onclick='excluirBeneficio(" + asbdiCodigo + ")' title='Excluir'>"+
                "   <i class='fa fa-close'></i>" +
                "</a>" +
            "</td>" +
        "</tr>");
    }, 300);
}

function limpaFormBenItens(){
    setTimeout(function () {
        $("#dcbe_ben_nome").val("");
        $("#dcbe_ben_codigo").val("");
        $("#dcbe_asbdi_qtd").val("");
        $("#dcbe_asbdi_valor").val("");
        $("#dcbe_ben_nome").focus();
    }, 300);
}

function finalizaBeneficios(){
    window.location.href = URL;
}

function excluirBeneficio(asbdi_codigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        mensagemSemOk("dce_exc_asbdi", "Confirmação", "Excluindo benefício ...", 250, 150);
        $.ajax({
            url: baseUrl + '/atendimentocras/beneficios-cidadao/excluir',
            type: "POST",
            data: {asbdi_codigo: asbdi_codigo},
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        fecharMensagemSemOk("dce_exc_asbdi");
                        mensagem("Confirmação", "Dados excluídos com sucesso.", 250, 120, function(){
                            $("#dcbealert_exc_bei").hide();
                            $("#beneficio_inserido"+asbdi_codigo).remove();
                        });
                    } else {
                        $("#dcbealert_exc_bei").html(txt);
                        $("#dcbealert_exc_bei").show(txt);
                        fecharMensagemSemOk("dce_exc_asbdi");
                    }
                }, 100);
            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function(){
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_ben").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr =  "<table class='table table-striped'>"
                    + "<thead>"
                    + "  <tr>"
                    + "    <th width='5%' class='coluna-center'>ID</th>"
                    + "    <th width='15%'>Unidade</th>"
                    + "    <th width='25%'>Cidadão</th>"
                    + "    <th width='20%'>Resp. Atendimento</th>"
                    + "    <th width='10%'>Estabel. de Retirada</th>"
                    + "    <th width='12%' class='coluna-center'>Ações</th>"
                    + "  </tr>"
                    + "</thead>";
                if (json.length > 0){
                    json.forEach(function(element) {
                        tr += "<tr>"
                            + "<td class='coluna-center'>" + element.asbd_codigo + "</td>"
                            + "<td>" + element.uni_desc + "</td>"
                            + "<td>" + element.usu_nome + "</td>"
                            + "<td>" + element.usr_nome + "</td>"
                            + "<td>" + element.ase_nome + "</td>"
                            + "<td class='coluna-center'>"
                            + "    <a class='btn btn-info' title='Editar'"
                            + "       onclick='form(" + element.asbd_codigo + ")'>"
                            + "        <i class='icon-edit icon-white'></i>"
                            + "    </a>"
                            + "    <a class='btn btn-warning' title='Imprimir'"
                            + "       onclick='imprimir(" + element.asbd_codigo + ", 1)'>"
                            + "        <i class='icon-print icon-white'></i>"
                            + "    </a>"
                            + "    <a class='btn btn-warning' title='Imprimir 2x'"
                            + "       onclick='imprimir(" + element.asbd_codigo + ", 2)'>"
                            + "        <i class='icon-print icon-white'></i> 2x"
                            + "    </a>"
                            + "</td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>"+
                        " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>"+
                        "</tr>";
                }
                $("#resultado").html(tr + "</table>");
                addPagination();
            }
        });
    },1000);
}

function imprimir(asbc_codigo,copia) {
    var url;
    if(copia==1){
        url = URL+"/imprimir/asbc_codigo/"+asbc_codigo;
    }else{
        url = URL+"/imprimir1/asbc_codigo/"+asbc_codigo;
    }
    popup(url,"Impressão de benefício eventual", screen.width, screen.height);
}

function buscaCidadaoBeneficios(){
    $("#dcbe_usu_codigo").val("");
    $("#dcbealert_usu_nome").hide();
    $("#dcbe_usu_nome").autocomplete({
        source: baseUrl+'/cidadao/cidadao/busca-geral/',
        minLength: 3,
        delay: 2000,
        search: function(event, ui){
            $(this).css("background","url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function(){1
            $(this).css("background","none");
        },
        close: function(){
            $(this).css("background","none");
        },
        select: function (event, ui) {
            $("#dcbe_usu_codigo").val(ui.item.id);
            $("#dcbe_usu_nome").val(ui.item.label);
            if (ui.item.id!="") { listaBeneficiosCid(ui.item.id); }
            if (ui.item.id=="") { $("#dcbe_usu_nome").val(""); }
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function( ul, item ) {
        return $("<li " + usuarioBloqueado(item.data.usu_bloqueado) + ">")
            .append("<a><strong>" + item.label + "</strong><br>\n\
                        <strong>Nº Pront. Suas: </strong>" + validaCampoEmBranco(item.data.asps_num_prontuario) + "<br>\n\
                        <strong>Cpf:</strong>\n\ " + validaCampoEmBranco(item.data.usu_cpf) + "\n\
                        <strong>NIS:</strong>\n\ " + validaCampoEmBranco(item.data.usu_nis) + "<br>\n\
                        <strong>Mãe: </strong>" + validaCampoEmBranco(item.data.usu_mae) + " \n\
                        <strong>Data Nasc: </strong>" + dataToBrHiffen(item.data.usu_datanasc) + "<br>\n\
                     </a><br>"
                   ).appendTo(ul);
    }
}

function usuarioBloqueado(bloqueado) {
  return bloqueado ? "style='color: red'" : "";
}

function listaBeneficiosCid(usu_codigo) {
    $("body").append("<div id='dbe_list_benm' title='Benefícios eventuais recebidos pela família.'></div>");
    $("#dbe_list_benm")
    .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
    title='Carregando dados ...' />")
    .dialog({
        modal: false,
        resizable: true,
        position: ['center', 'center-17'],
        width: 670,
        height: 300
    })
    .load(baseUrl + "/atendimentocras/beneficios-cidadao/beneficios-familia/usu_codigo/"+usu_codigo);
}

function formCadastraNovoItemBeneficio(idCodigo,idDesc,idAlert){
    $("body").append("<div id='dcid_formitem_ben' title='Cadastro de Itens Benefício'></div>");
    var urlItem = URL + "/form-cadastro-itens-beneficio";
    abrirModalParalelo(
        'dcid_formitem_ben',
        urlItem,
        formSalvarItens
    );
}
