const URL = baseUrl+"/atendimentocras/encaminhamento";
function form(asenc_codigo) {
    $("body").append("<div id='denc_form_encm' title='Cadastro de encaminhamento.'></div>");
    abrirModal(
        'denc_form_encm',
        URL + "/form/usr_codigo_logado/"+$("#denc_usr_codigo").val()+"/asenc_codigo/"+asenc_codigo
    );
}

function formSalvar(e) {
    if (validaForm('dcenc_form_cad_enc', e)) {
        e.preventDefault();
        var valoresForm = $("#dcenc_form_cad_enc").serialize();
        mensagemSemOk("dcenc_salvar_enc", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {

                    if (txt > 0) {
                        $("#denc_form_encm").dialog("destroy").remove();
                        fecharMensagemSemOk("dcenc_salvar_enc");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });
                    } else {
                        $("#dcencalert_cad_enc").html(txt);
                        $("#dcencalert_cad_enc").show(txt);
                        fecharMensagemSemOk("dcenc_salvar_enc");
                    }

            }
        });
    } else {
        return false;
    }
}

function formExcluir(ase_codigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        mensagemSemOk("dce_exc_ase", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/default/estabelecimentos/form-excluir',
            type: "POST",
            data: {ase_codigo: ase_codigo},
            success: function (txt) {

                    if (txt > 0) {
                        $("#dcealert_dados_est").hide();
                        fecharMensagemSemOk("dce_exc_ase");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150);
                        atualizaPagina();
                    } else {
                        $("#dcealert_dados_est").html(txt);
                        $("#dcealert_dados_est").show(txt);
                        fecharMensagemSemOk("dce_exc_ase");
                    }

            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function () {
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#denc_busca_enc").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>"
                       + "<thead>"
                       + "<th width='5%' class='coluna-center'>ID</th>"
                       + "<th width='15%'>Unidade</th>"
                       + "<th width='15%'>Local</th>"
                       + "<th width='20%'>Cidadão</th>"
                       + "<th width='20%'>Profissional Resp.</th>"
                       + "<th width='8%' class='coluna-center'>Cód. Encam.</th>"
                       + "<th width='9%' class='coluna-data'>Data</th>"
                       + "<th class='coluna-acoes'>Ações</th>"
                       + "</thead>";
                if (json.length > 0){
                    json.forEach(function(element, index, array) {
                        tr += "<tr>"
                            + " <td class='coluna-center'>" + element.asenc_codigo + "</td>"
                            + " <td>" + element.uni_desc + "</td>"
                            + " <td>" + element.ase_nome + "</td>"
                            + " <td>" + element.usu_nome + "</td>"
                            + " <td>" + element.usr_nome + "</td>"
                            + " <td class='coluna-center'>" + element.asec_num + "</td>"
                            + " <td class='coluna-center'>"
                            +       dataToBr(element.asenc_data)
                            + " </td>"
                            + " <td class='coluna-acoes'>"
                            + "     <a class='btn btn-info' title='Editar'"
                            + "        onclick='form(" + element.asenc_codigo + ")'>"
                            + "     <i class='icon-edit icon-white'></i>"
                            + "     </a>"
                            + "     <a class='btn btn-warning' title='Imprimir'"
                            + "        onclick='imprimir(" + element.asenc_codigo + ")'>"
                            + "          <i class='icon-print icon-white'></i>"
                            + "     </a>"
                            + " </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>"+
                          "   <td colspan='5'>Nenhum resultado encontrado até o momento!</td>"+
                          "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    }, 1000);
}

function imprimir(asenc_codigo) {
    var url = URL + "/imprimir/asenc_codigo/"+asenc_codigo;
    popup(url, "Impressão de encaminhamento", screen.width, screen.height);
}

