const URL = baseUrl + "/cidadao/cidadao";

function racCodigoChange() {
    if ($("#rac_codigo option:selected").val() == 5) {
        $("#etn_campos").show();
    } else {
        $("#etn_campos").hide();
    }
}

function tipoCertidaoChange() {
  if ($("#tipo_certidao_codigo option:selected").val() == 1) {
    $(".certidao_nascimento_campos").show();
    $(".certidao_casamento_campos").hide();
    $(".certidao_rani_campos").hide();

    return;
  } else if ($("#tipo_certidao_codigo option:selected").val() == 2){
    $(".certidao_casamento_campos").show();
    $(".certidao_nascimento_campos").hide();
    $(".certidao_rani_campos").hide();

    return;
  } else if ($("#tipo_certidao_codigo option:selected").val() == 3){
    $(".certidao_rani_campos").show();
    $(".certidao_nascimento_campos").hide();
    $(".certidao_casamento_campos").hide();

    return;
  }

  $(".certidao_nascimento_campos").hide();
  $(".certidao_casamento_campos").hide();
  $(".certidao_rani_campos").hide();
}

function cdNacionalidadeChange() {
    if ($("#cd_nacionalidade option:selected").val() == 'E') {
        $("#pais_campos").show();
        $("#entrada_campos").show();
    } else {
        $("#pais_campos").hide();
        $("#entrada_campos").hide();
    }

    if ($("#cd_nacionalidade option:selected").val() == 'N') {
        $("#portaria_campos").show();
        $("#nat_campos").show();
    } else {
        $("#portaria_campos").hide();
        $("#nat_campos").hide();

    }
}

function habilitaCidade() {
    var nacionalidade = $("#cd_nacionalidade option:selected").val();
    if (nacionalidade == "B") {
        $("#cidade_campos").show();
    } else {
        $("#cidade_campos").hide();
    }
}

function buscaCidades() {
    $("#cidade").buscar({
        url: baseUrl + '/cidade/buscar/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + " - " + item.data.uf_sigla + "</a>").appendTo(ul);
        },
        callback: function (ul, item) {
            return false;
        }
    });
}

function buscaCidadesCertidao(element) {
  $("#municipio_registro_" + element).buscar({
    url: baseUrl + '/cidade/buscar/',
    template: function (ul, item) {
      return $("<li/>").data("item.autocomplete", item).append(
        "<a>" + item.label + " - " + item.data.uf_sigla + "</a>").appendTo(ul);
    },
    callback: function (ul, item) {
      return false;
    }
  });
}

function buscaEstadosCertidao(element) {
  $("#estado_registro_" + element).buscar({
    url: baseUrl + '/estado/buscar/',
    template: function (ul, item) {
      return $("<li/>").data("item.autocomplete", item).append(
        "<a>" + item.label + " - " + item.data.uf_sigla + "</a>").appendTo(ul);
    },
    callback: function (ul, item) {
      return false;
    }
  });
}

function betweenDate(dataEntrada, dataInicial, dataFinal) {
    var parts = dataEntrada.split('/');
    dataEntrada = new Date(parts[2], parts[1] - 1, parts[0]);
    parts = dataInicial.split('/');
    var dataInicial = new Date(parts[2], parts[1] - 1, parts[0]);
    parts = dataFinal.split('/');
    var dataFinal = new Date(parts[2], parts[1] - 1, parts[0]);
    if (dataEntrada >= dataInicial && dataEntrada <= dataFinal) {
        return true;
    } else {
        return false;
    }
}

function validaDataForm() {
    if ($("#cd_nacionalidade option:selected").val() == 'N') {
        if (betweenDate($("#pep_data_naturalizacao").val(), $("#datanascimento").val(), $("#dataatual").val())) {
            return true;
        } else {
            mensagem("Atenção", "Data de naturalização deve estar entre data nascimento e atual!", 300, 150);
            $("#pep_data_naturalizacao").focus();
            return false;
        }
    }
    if ($("#cd_nacionalidade option:selected").val() == 'E') {
        if (betweenDate($("#pep_data_entrada_pais").val(), $("#datanascimento").val(), $("#dataatual").val())) {
            return true;
        } else {
            mensagem("Atenção", "Data de entrada no país deve estar entre data nascimento e atual!", 300, 150);
            $("#pep_data_entrada_pais").focus();
            return false;
        }
    }
    return true;
}

function cadastroCidadao(usu_codigo) {
    $("body").append("<div id='dc_form_cadastrom' title='Cadastro de cidadão' ></div>");
    abrirModal(
        'dc_form_cadastrom',
        URL + "/form-cadastro/usu_codigo/" + usu_codigo
    );
    setTimeout(function () {
        $("#etn_campos").hide();
        $("#pais_campos").hide();
        $("#portaria_campos").hide();
        $("#nat_campos").hide();
        $("#entrada_campos").hide();
        $("#cidade_campos").hide();
        cdNacionalidadeChange();
        racCodigoChange();
        habilitaCidade();
        tipoCertidaoChange();
        verificaObito();
    }, 2000);

}

function formSalvar(e) {
    var tipoCertidao = $("#tipo_certidao_codigo option:selected").val();
    if (tipoCertidao > 0) {
      var certidao = 'rani';
      if (tipoCertidao == 1) {
        certidao = 'nascimento';
      } else if (tipoCertidao == 2) {
        certidao = 'casamento';
      }
    }
    validaEspacoNome();
    validaNomeMae();
    validaNomePai();

    if ($("#rac_codigo option:selected").val() == 5) {
        if ($("#etn_codigo option:selected").val() === "") {
            result = false;
            mensagem("Atenção", "Obrigatório Etnia quando Indigena em raca/cor!", 300, 150);
            $("#etn_codigo").focus();
            return false;
        }
    }

    if ($("#cd_nacionalidade option:selected").val() === 'B') {
        if ($("#cidade").val() === "") {
            result = false;
            mensagem("Atenção", "Obrigatório Cidade de Nascimento quando nacionalidade Brasileiro!", 300, 150);
            $("#epa_codigo").focus();
            return false;
        }
    }

    if ($("#cd_nacionalidade option:selected").val() === 'E') {
        if ($("#epa_codigo option:selected").val() === "") {
            result = false;
            mensagem("Atenção", "Obrigatório País quando nacionalidade Estrangeiro!", 300, 150);
            $("#epa_codigo").focus();
            return false;
        }
        if ($("#usu_dt_entrada_pais").val() === "") {
            result = false;
            mensagem("Atenção", "Obrigatório Data de Entrada no Pais!", 300, 150);
            return false;
        }
    }

    if ($("#cd_nacionalidade option:selected").val() === 'N') {
        if ($("#nr_portaria_naturalizacao").val() === "") {
            result = false;
            mensagem("Atenção", "Obrigatório Portaria Naturalização!", 300, 150);
            $("#nr_portaria_naturalizacao").focus();
            return false;
        }
        if ($("#dt_naturalizacao").val() === "") {
            result = false;
            mensagem("Atenção", "Obrigatório Data Naturalização!", 300, 150);
            return false;
        }
    }

    if (!validaNIS()) {
        mensagem("Atenção", "Numero de NIS informado é inválido!", 300, 150);
        return false;
    }

    if (validaForm('dc_form_cadastro', e) && validaCamposCertidao(certidao, retornaCamposObrigatoriosCertidao(certidao))) {
        // Corta o Submit e deixa o jQuery trabalhar
        e.preventDefault();
        mensagemSemOk("dp_salvar_cidadao", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dc_form_cadastro").serialize();
        $.ajax({
            url: URL + '/form-cadastro-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                    if (txt > 0) {
                        $("#dcalert_dados_cid").hide();
                        $("#dc_form_cadastrom").dialog("destroy").remove();
                        fecharMensagemSemOk("dp_salvar_cidadao");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });
                    } else {
                        $("#dcalert_dados_cid").show();
                        $("#dcalert_dados_cid").html(txt);
                        $('html, body').animate({scrollTop: $('#dados_cidadao').offset().top}, 'slow');
                    }
            }
        });
    } else {
        return false;
    }
}

function validaCamposCertidao(tipoCertidao, arrCamposObrigatorios) {
  var semErro = true;
  $.each(arrCamposObrigatorios, function(campo, descricao){
    if ($("#" + campo + tipoCertidao).val() === "") {
      mensagem("Atenção",
        "Obrigatório informar " + descricao + " na certidão " + (tipoCertidao == 'rani' ? "da " + tipoCertidao.toUpperCase() : "de " + tipoCertidao) + "!",
        300,
        150);
      if (campo != 'data_registro_') {
        $("#" + campo + tipoCertidao).focus();
      }

      return semErro = false;
    }
  });

  return semErro;
}

function retornaCamposObrigatoriosCertidao(tipoCertidao) {
  /*
  FUNÇÃO CRIADA PARA VALIDAR FUTURAMENTE A OBRIGATORIEDADE
  DOS NOVOS CAMPOS QUE SERÃO EXCLUSIVOS DE CADA CERTIDÃO.
  HOJE SÃO VALORES IGUAIS, MAS CADA CERTIDÃO TERÁ SUA PARTICULARIDADE.
  */
  if (tipoCertidao == 'nascimento') {
    return {
      'nome_cartorio_' : 'o nome do cartório',
      'numero_livro_' : 'o número do livro',
      'numero_folha_' : 'o número da folha',
      'numero_termo_' : 'o número do termo',
      'data_registro_' : 'a data de registro',
      'estado_registro_' : 'o estado de registro',
      'municipio_registro_' : 'o município de registro',
      'codigo_cartorio_' : 'o código do cartório'
    };
  } else if (tipoCertidao == 'casamento') {
    return {
      'nome_cartorio_' : 'o nome do cartório',
      'numero_livro_' : 'o número do livro',
      'numero_folha_' : 'o número da folha',
      'numero_termo_' : 'o número do termo',
      'data_registro_' : 'a data de registro',
      'estado_registro_' : 'o estado de registro',
      'municipio_registro_' : 'o município de registro',
      'codigo_cartorio_' : 'o código do cartório'
    };
  }
  return {
    'nome_cartorio_' : 'o nome do cartório',
    'numero_livro_' : 'o número do livro',
    'numero_folha_' : 'o número da folha',
    'numero_termo_' : 'o número do termo',
    'data_registro_' : 'a data de registro',
    'estado_registro_' : 'o estado de registro',
    'municipio_registro_' : 'o município de registro',
    'codigo_cartorio_' : 'o código do cartório'
  };
}

function pesquisaDados() {
    setTimeout(function () {
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dc_busca_cid").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>"
                    + "<thead>"
                    + "    <tr>"
                    + "        <th width='5%' class='coluna-center'>ID</th>"
                    + "        <th width='30%'>Nome</th>"
                    + "        <th width='10%' class='coluna-data'>Dt. Nascimento</th>"
                    + "        <th width='25%'>Nome da Mãe</th>"
                    + "        <th class='coluna-center'>NIS</th>"
                    + "        <th class='coluna-center'>Óbito</th>"
                    + "        <th width='10%' class='coluna-center'>Telefone</th>"
                    + "        <th class='coluna-acoes'>Ações</th>"
                    + "    </tr>"
                    + "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element, index, array) {

                        if (element.usu_bloqueado == true) {

                            tr += "<tr style='color: red'>"
                            + "    <td class='coluna-center'>INATIVO</td>";
                        } else {
                            tr += "<tr>"
                                + "    <td class='coluna-center'>" + element.usu_codigo + "</td>";
                        }
                        tr  += "    <td>" + element.usu_nome + "</td>"
                            + "    <td class='coluna-data'>" + dataToBr(element.usu_datanasc) + "</td>"
                            + "    <td>" + element.usu_mae + "</td>"
                            + "    <td class='coluna-center'>" + (element.usu_nis ? element.usu_nis : '') + "</td>"
                            + "    <td class='coluna-center'>" + (element.usu_obito == 't' ? 'SIM' : 'NÃO') + "</td>"
                            + "    <td class='coluna-center'>" + (element.usu_fone ? element.usu_fone : '') + "</td>"
                            + "    <td class='coluna-acoes'>"
                            + "        <a class='btn btn-info' title='Editar'"
                            + "           onclick='cadastroCidadao(" + element.usu_codigo + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "        </a>"
                            + "        <a class='btn btn-danger' title='Apagar'"
                            + "           onclick='excluir(" + element.usu_codigo + ")'>"
                            + "            <i class='icon-trash icon-white'></i>"
                            + "        </a>"
                            + "    </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>" +
                        "<td colspan='6'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    }, 3000);
}

function excluir(usu_codigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        mensagemSemOk("dc_exc_cid", "Confirmação", "Excluindo dados ...", 250, 150);
        $.ajax({
            url: URL + '/excluir',
            type: "POST",
            data: {usu_codigo: usu_codigo},
            success: function (txt) {

                    if (txt > 0) {
                        $("#dcalert_dados_cid").hide();
                        fecharMensagemSemOk("dc_exc_cid");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });
                    } else {
                        $('html, body').animate({scrollTop: $('#dados_cid').offset().top}, 'slow');
                        $("#dcalert_dados_cid").html(txt);
                        $("#dcalert_dados_cid").show(txt);
                        fecharMensagemSemOk("dc_exc_cid");
                    }

            }
        });
    });
}

function validaEspacoNome() {
    var nome = $("#dc_usu_nome").val();
    if (nome.length>0 && nome.indexOf(" ") == -1) {
        mensagem("Atenção", "Obrigatório Nome e Sobrenome e um espaço entre Nome do paciente!", 300, 150, function () {
            $("#dc_usu_nome").focus();
            return false;
        });

    } else {
        validaEspacamento('dc_usu_nome');
    }
}

function validaNomeMae() {
    var nomeMae = $("#dc_usu_mae").val();
    if (nomeMae.length >0 && nomeMae.indexOf(" ") == -1) {
        mensagem("Atenção", "Obrigatório Nome e Sobrenome e um espaço entre Nome da mãe!", 300, 150, function () {
            $("#dc_usu_mae").focus();
            return false;
        });

    } else {
        validaEspacamento('dc_usu_mae');
    }
}

function validaNomePai() {
    var nomePai = $("#dc_usu_pai").val();
    if (nomePai.length > 0 && nomePai.indexOf(" ") == -1) {
        mensagem("Atenção", "Obrigatório Nome e Sobrenome e um espaço entre Nome do pai!", 300, 150, function () {
            $("#dc_usu_pai").focus();
            return false;
        });

    } else {
        validaEspacamento('dc_usu_pai');
    }
}

function validaEspacamento(idElemento) {
    var criaNomeElemento = '#' + idElemento;
    var nomeElemento = $(criaNomeElemento).val();
    var espaco = "  ";
    var verificaPalavraComposta = false;

    for (var i = 0; i < nomeElemento.length; i++) {
        if (nomeElemento.indexOf(espaco.toString()) !== -1) {
            var resposta = nomeElemento.replace(espaco.toString(), " ");
            $(criaNomeElemento).val(resposta);
            verificaPalavraComposta = true;
        }
        espaco += " ";
    }

    if (verificaPalavraComposta) {
        validaEspacamento(idElemento);
    }
}
function pesquisaCidadao() {
    setTimeout(function () {
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dc_busca_cid").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>"
                    + "<thead>"
                    + "    <tr>"
                    + "        <th width='5%' class='coluna-center'>ID</th>"
                    + "        <th width='30%'>Nome</th>"
                    + "        <th width='10%' class='coluna-data'>Dt. Nascimento</th>"
                    + "        <th width='25%'>Nome da Mãe</th>"
                    + "        <th class='coluna-center'>NIS</th>"
                    + "        <th class='coluna-center'>Óbito</th>"
                    + "        <th width='10%' class='coluna-center'>Telefone</th>"
                    + "        <th class='coluna-acoes'>Ações</th>"
                    + "    </tr>"
                    + "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element, index, array) {

                        if (element.usu_bloqueado == true) {

                            tr += "<tr style='color: red'>"
                                + "    <td class='coluna-center'>INATIVO</td>";
                        } else {
                            tr += "<tr>"
                                + "    <td class='coluna-center'>" + element.usu_codigo + "</td>";
                        }
                        tr  += "    <td>" + element.usu_nome + "</td>"
                            + "    <td class='coluna-data'>" + dataToBr(element.usu_datanasc) + "</td>"
                            + "    <td>" + element.usu_mae + "</td>"
                            + "    <td class='coluna-center'>" + (element.usu_nis ? element.usu_nis : '') + "</td>"
                            + "    <td class='coluna-center'>" + (element.usu_obito == 't' ? 'SIM' : 'NÃO') + "</td>"
                            + "    <td class='coluna-center'>" + (element.usu_fone ? element.usu_fone : '') + "</td>"
                            + "    <td class='coluna-acoes'>"
                            + "        <a class='btn btn-info' title='Editar'"
                            + "           onclick='cadastroCidadao(" + element.usu_codigo + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "        </a>"
                            + "        <a class='btn btn-danger' title='Apagar'"
                            + "           onclick='excluir(" + element.usu_codigo + ")'>"
                            + "            <i class='icon-trash icon-white'></i>"
                            + "        </a>"
                            + "    </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>" +
                        "<td colspan='6'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    }, 3000);
}