var URL = baseUrl + "/default/beneficios";
function form(ben_codigo){
    $("body").append("<div id='dcb_form_benm' title='Cadastro de Benefício.'></div>");
    abrirModal("dcb_form_benm", URL + "/form/cod_ben/"+ben_codigo);
}

function formSalvar(e){
    if (validaForm("dcb_form_cad_ben", e)) {
        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_ben").serialize();
        mensagemSemOk("dcb_salvar_ben", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function(txt) {

                    if(txt>0) {
                        $("#dcbalert_cad_ben").hide();
                        $("#dcb_form_benm").dialog("destroy").remove();
                        fecharMensagemSemOk("dcb_salvar_ben");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                            atualizaPagina();
                        });

                    } else {
                        $("#dcbalert_cad_ben").html(txt);
                        $("#dcbalert_cad_ben").show(txt);
                        fecharMensagemSemOk("dcb_salvar_ben");
                    }

            }
        });
    } else {
        return false;
    }
}

function formExcluir(ben_codigo){
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function() {
        mensagemSemOk("dcb_exc_ben", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-excluir',
            type: "POST",
            data: {cod_ben:ben_codigo},
            success: function(txt) {

                    if(txt>0) {
                        $("#dcbalert_dados_ben").hide();
                        fecharMensagemSemOk("dcb_exc_ben");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150, function(){
                            atualizaPagina();
                        });

                    } else {
                        $("#dcbalert_dados_ben").html(txt);
                        $("#dcbalert_dados_ben").show(txt);
                        fecharMensagemSemOk("dcb_exc_ben");
                    }

            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function(){
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_ben").val(),
                status: $("#dbe_status_ben").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>" +
                    "<thead>"+
                    "<tr>"+
                    "   <th class='coluna-center' style='width: 5%'>Id</th>" +
                    "   <th style='width: 67%'>Nome</th>" +
                    "   <th class='coluna-currency' style='width: 15%'>Valor(R$)</th>" +
                    "   <th class='coluna-center' style='width: 5%'>Status</th>" +
                    "   <th class='coluna-acoes' style='width: 8%;'>Ações</th>" +
                    "</tr>"+
                    "</thead>";
                if (json.length > 0){
                    json.forEach(function(element, index, array) {
                        tr += "<tr>"
                            + "     <td class='coluna-center'>" + element.cod_ben + "</td>"
                            + "     <td>" + element.beneficio + "</td>"
                            + "     <td class='coluna-currency'>"
                            +           (!element.valor ? '' :  formatMoney(element.valor))
                            + "     </td>"
                            + "     <td class='coluna-center'>"
                            +           (element.situacao === 'A' ? 'ATIVO' : 'INATIVO')
                            + "     </td>"
                            + "     <td class='coluna-center'>"
                            + "         <a class='btn btn-info' href='#' title='Editar'"
                            + "            onclick='form(" + element.cod_ben + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "         </a>"
                            + "         <a class='btn btn-danger' href='#' title='Excluir'"
                            + "            onclick='formExcluir(" + element.cod_ben + ")'>"
                            + "            <i class='icon-trash icon-white'></i>"
                            + "         </a>"
                            + "     </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>"+
                        " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>"+
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    },1000);
}