var URL = baseUrl + "/default/cargos";

function form(crg_codigo) {
    $("body").append("<div id='dcb_form_cargo' title='Cadastro de Cargo.'></div>");
    abrirModal("dcb_form_cargo", URL + "/form/crg_codigo/" + crg_codigo);
}

function formSalvar(e) {
    if (validaForm("dcb_form_cad_cargo", e)) {
        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_cargo").serialize();
        mensagemSemOk("dcb_salvar_cargo", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcbalert_cad_cargo").hide();
                        $("#dcb_form_cargo").dialog("destroy").remove();
                        fecharMensagemSemOk("dcb_salvar_cargo");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });

                    } else {
                        $("#dcbalert_cad_cargo").html(txt);
                        $("#dcbalert_cad_cargo").show(txt);
                        fecharMensagemSemOk("dcb_salvar_cargo");
                    }
                }, 100);
            }
        });
    } else {
        return false;
    }
}

function formExcluir(crg_codigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        mensagemSemOk("dcb_exc_cargo", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-excluir',
            type: "POST",
            data: {crg_codigo: crg_codigo},
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcbalert_dados_cargo").hide();
                        fecharMensagemSemOk("dcb_exc_cargo");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150);
                        atualizaPagina();
                    } else {
                        $("#dcbalert_dados_cargo").html(txt);
                        $("#dcbalert_dados_cargo").show(txt);
                        fecharMensagemSemOk("dcb_exc_cargo");
                    }
                }, 100);
            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function () {
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_cargo").val(),
                status: $("#dbe_status_cargo").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>" +
                    "<thead>" +
                    "<tr>" +
                    "   <th class='coluna-center' style='width: 5%'>Código</th>" +
                    "   <th style='width: 67%'>Nome</th>" +
                    "   <th class='coluna-center' style='width: 5%'>Status</th>" +
                    "   <th class='coluna-acoes' style='width: 8%'>Ações</th>" +
                    "</tr>" +
                    "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element, index, array) {
                        tr += "<tr>"
                            + "     <td class='coluna-center'>" + element.crg_codigo + "</td>"
                            + "     <td>" + element.crg_nome + "</td>"
                            + "     <td class='coluna-center'>"
                            + (element.crg_status ? 'ATIVO' : 'INATIVO')
                            + "     </td>"
                            + "     <td class='coluna-center'>"
                            + "         <a class='btn btn-info' href='#' title='Editar'"
                            + "            onclick='form(" + element.crg_codigo + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "         </a>"
                            + "     </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>" +
                        " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    }, 1000);
}