const URL = baseUrl + "/default/estabelecimentos";
function form(ase_codigo){
    $("body").append("<div id='dce_form_asem' title='Cadastro de Estabelecimento.'></div>");
    abrirModal("dce_form_asem", URL+"/form/ase_codigo/"+ase_codigo);
}

function formSalvar(e){
    if (validaForm("dce_form_cad_est", e)) {
        e.preventDefault();
        var valoresForm = $("#dce_form_cad_est").serialize();
        mensagemSemOk("dce_salvar_ase", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function(txt) {

                    if(txt>0) {
                        $("#dce_form_asem").dialog("destroy").remove();
                        fecharMensagemSemOk("dce_salvar_ase");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                            atualizaPagina();
                        });
                    } else {
                        $("#dcealert_cad_est").html(txt);
                        $("#dcealert_cad_est").show(txt);
                        fecharMensagemSemOk("dce_salvar_ase");
                    }

            }
        });
    } else {
        return false;
    }
}

function formExcluir(ase_codigo){
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function() {
        mensagemSemOk("dce_exc_ase", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-excluir',
            type: "POST",
            data: {ase_codigo:ase_codigo},
            success: function(txt) {

                    if(txt>0) {
                        $("#dcealert_dados_est").hide();
                        fecharMensagemSemOk("dce_exc_ase");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });

                    } else {
                        $("#dcealert_dados_est").html(txt);
                        $("#dcealert_dados_est").show(txt);
                        fecharMensagemSemOk("dce_exc_ase");
                    }

            }
        });
    });
    
}

function pesquisaDados() {
    setTimeout(function(){
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_est").val(),
                status: $("#dbe_status_est").val()
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>" +
                    "<thead>"+
                    "<tr>"+
                    "   <th style='width: 5%' class='coluna-center'>Id</th>" +
                    "   <th style='width: 32%'>Nome</th>" +
                    "   <th style='width: 7%' class='coluna-center'>Cep</th>" +
                    "   <th style='width: 35%'>Endereço</th>" +
                    "   <th style='width: 8%' class='coluna-center' >Número</th>" +
                    "   <th style='width: 5%' class='coluna-center'>Status</th>" +
                    "   <th style='width: 8%' class='coluna-acoes'>Ações</th>" +
                    "</tr>"+
                    "</thead>";
                if (json.length > 0){
                    json.forEach(function(element, index, array) {
                        tr += "<tr>"
                            + " <td class='coluna-center'>" + element.ase_codigo + "</td>"
                            + " <td>" + element.ase_nome + "</td>"
                            + " <td class='coluna-center'>" + element.ase_cep + "</td>"
                            + " <td>" + element.ase_logradouro + "</td>"
                            + " <td class='coluna-center'>" + element.ase_num + "</td>"
                            + " <td class='coluna-center'>"
                            +     (element.ase_situacao ? 'ATIVO' : 'INATIVO')
                            + " </td>"
                            + " <td class='coluna-center'>"
                            + "     <a class='btn btn-info' href='#' title='Editar'"
                            + "        onclick='form(" + element.ase_codigo+ ")'>"
                            + "         <i class='icon-edit icon-white'></i>"
                            + "     </a>"
                            + "     <a class='btn btn-danger' href='#' title='Excluir'"
                            + "        onclick='formExcluir(" + element.ase_codigo + ")'>"
                            + "         <i class='icon-trash icon-white'></i>"
                            + "     </a>"
                            + " </td>"
                            +"</tr>";
                    });
                } else {
                    tr += "<tr>"+
                        " <td colspan='8'>Nenhum resultado encontrado até o momento!</td>"+
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    },1000);
}