var URL = baseUrl + "/default/motivo";

function form(asam_codigo) {
    $("body").append("<div id='dcb_form_mot' title='Cadastro de Motivo.'></div>");
    abrirModal("dcb_form_mot", URL + "/form/asam_codigo/" + asam_codigo);
}

function formSalvar(e) {
    if (validaForm("dcb_form_cad_mot", e)) {
        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_mot").serialize();
        mensagemSemOk("dcb_salvar_mot", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcbalert_cad_mot").hide();
                        $("#dcb_form_mot").dialog("destroy").remove();
                        fecharMensagemSemOk("dcb_salvar_ben");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });

                    } else {
                        $("#dcbalert_cad_mot").html(txt);
                        $("#dcbalert_cad_mot").show(txt);
                        fecharMensagemSemOk("dcb_salvar_mot");
                    }
                }, 100);
            }
        });
    } else {
        return false;
    }
}

function formExcluir(asam_codigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        mensagemSemOk("dcb_exc_mot", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-excluir',
            type: "POST",
            data: {asam_codigo: asam_codigo},
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcbalert_dados_mot").hide();
                        fecharMensagemSemOk("dcb_exc_mot");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150);
                        atualizaPagina();
                    } else {
                        $("#dcbalert_dados_mot").html(txt);
                        $("#dcbalert_dados_mot").show(txt);
                        fecharMensagemSemOk("dcb_exc_mot");
                    }
                }, 100);
            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function () {
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_mot").val(),
                status: $("#dbe_status_mot").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>" +
                    "<thead>" +
                    "<tr>" +
                    "   <th class='coluna-center' style='width: 5%'>ID</th>" +
                    "   <th style='width: 67%'>Nome</th>" +
                    "   <th class='coluna-center' style='width: 5%'>Status</th>" +
                    "   <th class='coluna-acoes' style='width: 8%'>Ações</th>" +
                    "</tr>" +
                    "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element, index, array) {
                        tr += "<tr>"
                            + "     <td class='coluna-center'>" + element.asam_codigo + "</td>"
                            + "     <td>" + element.asam_nome + "</td>"
                            + "     <td class='coluna-center'>"
                            + (element.asam_status ? 'ATIVO' : 'INATIVO')
                            + "     </td>"
                            + "     <td class='coluna-center'>"
                            + "         <a class='btn btn-info' href='#' title='Editar'"
                            + "            onclick='form(" + element.asam_codigo + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "         </a>"
                            + "     </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>" +
                        " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    }, 1000);
}