var URL = baseUrl + "/default/reunioes";
function form(asreu_codigo){

   window.location.replace(URL + "/form-cadastro-reunioes/asreu_codigo/"+asreu_codigo);
}

function salvar(e){
    if (validaForm("form_reuniao", e)) {
        e.preventDefault();
        var valoresForm = $("#form_reuniao").serialize();
        mensagemSemOk("salvar_reu", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/salvar',
            type: "POST",
            data: valoresForm,
            success: function(txt) {

                if(txt.success) {
                    salvaParticipantes(txt.asreu_codigo);
                    fecharMensagemSemOk("salvar_reu");
                } else {
                    fecharMensagemSemOk("salvar_reu");
                }

            }
        });
    } else {
        return false;
    }
}

function salvaParticipantes(json) {
    var participantes = $('#form-participantes').serialize();
    console.log(participantes);
    if (participantes) {

        $.ajax({
            url: URL+"/salva-participantes-reuniao/asreu_codigo/" + json,
            type: "POST",
            data: participantes,
            success: function (txt) {
                if (txt.success == true) {

                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                            window.location.replace(URL + "/index");

                        });

                } else {
                    mensagem("Erro" + "," + txt.mensagem, 300, 150, function () {
                        return false;
                    });
                }

            }
        });
    } else {
        mensagem("Atenção", "Dados cadastrados com Sucesso!", 300, 150, function () {
            window.location.replace(URL + "/index");
        });
    }
}

function pesquisaDados() {
    setTimeout(function(){
        $.ajax({
            url: URL + "/pesquisa-dados/",
            type: "POST",
            data: {
                busca: $("#busca_reu").val()
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>" +
                    "<thead>"+
                    "<tr>"+
                    "   <th width='30%'>Título </th>" +
                    "   <th width='10%' class='coluna-data'>Data da Reunião</th>" +
                    "   <th width='10%' class='coluna-data'>Hora de Início</th>" +
                    "   <th width='10%' class='coluna-data'>Hora de Término</th>" +
                    "   <th width='25%'>Unidade de Realização</th>" +
                    "   <th>Ações</th>"+
                    "</tr>"+
                    "</thead>";
                if (json.length > 0){
                    json.forEach(function(element, index, array) {
                        tr += "<tr>"
                            + "     <td>" + element.asreu_titulo + "</td>"
                            + "     <td class='coluna-data'>" + dataToBrHiffen(element.asreu_data) + "</td>"
                            + "     <td class='coluna-data'>" + horaMinuto(element.asreu_hora_inicio) + "</td>"
                            + "     <td class='coluna-data'>" + horaMinuto(element.asreu_hora_fim) + "</td>"
                            + "     <td>" + element.uni_desc + "</td>"
                            + "     <td>"
                            + "         <a class='btn btn-info'  title='Editar'"
                            + "            onclick='form(" + element.asreu_codigo + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "         </a>"
                            + "         <a class='btn btn-danger'  title='Excluir'"
                            + "            onclick='excluirReuniao(" + element.asreu_codigo + ")'>"
                            + "            <i class='icon-trash icon-white'></i>"
                            + "         </a>"
                            + "         <a class='btn btn-warning' title='Imprimir Ata da Reunião'"
                            + "             onclick='imprimirAta(" + element.asreu_codigo +")'>"
                            + "             <i class='icon-print icon-white'></i>"
                            + "         </a>"
                            + "     </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>"+
                        " <td colspan='6'>Nenhum resultado encontrado até o momento!</td>"+
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    },1000);
}

function validaParticipante(term) {
    var cont = new Number($("#part_qtd_total").val()) + 1;
    var table = $('#participantes');
    var retorno = "";
    if (cont > 1) {
        table.find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (term == $(this).val()) {
                    retorno = 1;
                }
            });
        });
    }
    return retorno;
}

function adicionaParticipante() {
    var cont = parseInt($("#part_qtd_total").val()) + 1;
    var usr_nome = $("#usr_nome").val().trim();
    var usr_cargo = $("#usr_cargo").val().trim();
    var usr_codigo = $("#usr_codigo").val();

    if (usr_codigo == "" || usr_nome == "") {
        return;
    }
    if (validaParticipante(usr_codigo) == 0) {
        $("#part_qtde_0").remove();
        $("#part_qtd_total").val(cont);
        $("#participantes").append(
            '<tr id="part_qtd' + cont + '">' +
            "   <td>" + usr_nome +
            "       <input type='hidden' name='part[" + cont + "][usr_codigo]' value=\""+ usr_codigo +"\" />" +
            "       <input type='hidden' name='part[" + cont + "][asreupar_codigo]' value=''/>" +
            "   </td>" +
            "   <td>" + usr_cargo +
            "   </td>" +
            "   <td>" +
            "       <a class='btn btn-danger' title='Apagar' " +
            "        onclick='excluirConfirmacao("+ cont +")'>" +
            "       <i class='fa fa-trash'></i>"+
            "       </a>" +
            "   </td>" +
            "</tr>");
        $("#usr_nome").val("");
        $("#usr_codigo").val("");
    } else {
        mensagem("Erro", "Participante já vinculado a reunião", 250, 150, function () {
            $("#usr_nome").val("");
            $("#usr_codigo").val("");

        });
    }

}

function excluirConfirmacao(id, asreupar_codigo) {

    $('html, body').animate({scrollTop: $('#part_qtd' + id).offset().top}, 'slow');
    confirme("Confirme:", "Deseja realmente excluir este participante?", 300, 150, function () {
        $("#part_qtd" + id).remove();
        if (asreupar_codigo){
            $.ajax({
                url: URL + "/excluir-participante/asreupar_codigo/"+ asreupar_codigo,
                type: "GET",
                success: function (txt) {
                    if (txt.success == true) {
                        mensagem("Atenção", "Participante excluído com Sucesso!", 300, 150, function () {
                            return true;
                        });
                    } else {
                        mensagem(txt.titulo + "," + txt.mensagem, 300, 150, function () {
                            return false;
                        });
                    }

                }
            });
        }
        if($("#part_qtd_total").val() == 1){
            $("#participantes").append(
                "<tr id='part_qtde_0'>" +
                "<td colspan='7'>Nenhum participante vinculado até o momento.</td>" +
                "</tr>");
        }

    });
}

function excluirReuniao(asreu_codigo) {

    confirme("Confirme:", "Deseja realmente excluir esta reunião?", 300, 150, function () {
            $.ajax({
                url: URL + "/excluir/asreu_codigo/"+ asreu_codigo,
                type: "GET",
                success: function (txt) {
                    if (txt.success == true) {
                        mensagem("Atenção", "Reunião excluida com Sucesso!", 300, 150, function () {
                           atualizaPagina();
                        });
                    } else {
                        mensagem(txt.titulo + "," + txt.mensagem, 300, 150, function () {
                            return false;
                        });
                    }
                }
            });
    });

}

function imprimirAta(asreu_codigo){

    callGenerateReport(
        URL + "/imprimir-ata",
        {
            "asreu_codigo" : asreu_codigo,
            "tp_rel": "SINTETICO"
        }
    );
}

function visualizarGrupos() {
    $("body").append("<div id='modal_grupo_participante' title='Grupos de Usuários' ></div>");
    $("#modal_grupo_participante")
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
            title='Carregando dados ...' />")
        .dialog({
            modal: false,
            height: '90%',
            maxHeight: '200px',
            width: '50%',
            minWidth: '550px',
            position: 'right-20 top+29',
            closeOnEscape: false,
            className: 'modalteste',
            buttons: {
                Cancel: {
                    click: function () {
                        $(".ui-dialog").remove();
                    },
                    text: "Cancelar",
                    class: 'btn btn-warning btn-large'
                }
            },
            open: function () {
                $('.ui-dialog-buttonpane').find('button:contains("Cancel")')
                    .html("<i class='fa fa-close'></i> Cancelar");
            },
            close: function (ev, ui) {
                $(this).remove();
            }
        }).load(URL+"/grupo-usuarios");
}

function visualizarParticipantes(asgpu_codigo){
    $("<div id='modal_participantes' title='Usuários vinculados ao grupo' ></div>")
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
            title='Carregando dados ...' />")
        .dialog({
            modal: false,
            height: '90%',
            maxHeight: '200px',
            width: '50%',
            minWidth: '550px',
            position: 'left+20 top+29',
            autoOpen: true,
            closeOnEscape: false,
            resizable: false,
            open: function () {

                $('.ui-dialog-buttonpane').find('button:contains("Cancel")')
                    .html("<i class='fa fa-close'></i> Fechar");

            },
            close: function () {
                limpaObrigatorio();
                $(this).remove();
            }
        })
        .load(URL+"/grupo-participantes/asgpu_codigo/"+asgpu_codigo);
}

function inserirGrupoParticipantes(asgpu_codigo){
    $.ajax({
        url: baseUrl + "/usuarios/usuarios/get-participantes-grupo/asgpu_codigo/"+asgpu_codigo,
        type: "GET",
        success: function (txt) {

            for (var i = 0; i < txt.length; i++) {
                console.log(txt[i]['crg_nome']);

                adicionaParticipanteGrupo(txt[i]['usr_nome'], txt[i]['crg_nome'], txt[i]['usr_codigo']);
            }
            return true;
        }
    });
    $('#modal_grupos').remove();
}

function adicionaParticipanteGrupo(usrNome, usrCargo, usrCodigo){
    var cont = parseInt($("#part_qtd_total").val()) + 1;
    var usr_nome = usrNome;
    var usr_cargo = usrCargo;
    var usr_codigo = usrCodigo;

    if (usr_codigo == "" || usr_nome == "") {
        return;
    }
    if (validaParticipante(usr_codigo) == 0) {
        $("#part_qtde_0").remove();
        $("#part_qtd_total").val(cont);
        $("#participantes").append(
            '<tr id="part_qtd' + cont + '">' +
            "   <td>" + usr_nome +
            "       <input type='hidden' name='part[" + cont + "][usr_codigo]' value=\""+ usr_codigo +"\" />" +
            "       <input type='hidden' name='part[" + cont + "][asreupar_codigo]' value=''/>" +
            "   </td>" +
            "   <td>" + (usr_cargo != null ? usr_cargo: "") +
            "   </td>" +
            "   <td>" +
            "       <a class='btn btn-danger' title='Apagar' " +
            "        onclick='excluirConfirmacao("+ cont +")'>" +
            "       <i class='fa fa-trash'></i>"+
            "       </a>" +
            "   </td>" +
            "</tr>");
        $("#usr_nome").val("");
        $("#usr_codigo").val("");
    }
}

