const URL = baseUrl + "/default/unidade";
function form(uni_codigo){
    $("body").append("<div id='dcu_form_unim' title='Cadastro de Unidade'></div>");
    abrirModal("dcu_form_unim", URL + "/form/uni_codigo/"+uni_codigo);
}

function formSalvar(e){
    if (validaForm("du_form_unidade", e)) {
        e.preventDefault();
        var valoresForm = $("#du_form_unidade").serialize();
        mensagemSemOk("dcu_salvar_unim", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function(txt) {

                    if(txt>0) {
                        $("#dcu_form_unim").dialog("destroy").remove();
                        fecharMensagemSemOk("dcu_salvar_unim");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });

                    } else {
                        $("#dualert_form_unidade").html(txt);
                        $("#dualert_form_unidade").show(txt);
                        fecharMensagemSemOk("dcu_salvar_unim");
                    }

            }
        });
    } else {
        return false;
    }
}

function formExcluir(uni_codigo){
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function() {
        mensagemSemOk("dcu_exc_uni", "Confirmação", "Excluindo informação ...", 250, 150);
        $.ajax({
            url: URL + '/form-excluir',
            type: "POST",
            data: {uni_codigo:uni_codigo},
            success: function(txt) {

                    if(txt>0) {
                        $("#dcualert_dados_uni").hide();
                        fecharMensagemSemOk("dcu_exc_uni");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });

                    } else {
                        $("#dcualert_dados_uni").html(txt);
                        $("#dcualert_dados_uni").show(txt);
                        fecharMensagemSemOk("dcu_exc_uni");
                    }

            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function(){
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_ben").val()
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>"
                        + "<thead>"
                        + " <tr>"
                        + "    <th width='5%' class='coluna-center'>ID</th>"
                        + "    <th width='25%'>Nome</th>"
                        + "    <th width='25%'>Endereço</th>"
                        + "    <th width='18%'>Bairro</th>"
                        + "    <th width='10%' class='coluna-center'>Telefone</th>"
                        + "    <th width='7%' class='coluna-center'>Tipo</th>"
                        + "    <th width='8%' class='coluna-acoes'>Ações</th>"
                        + " </tr>"
                        + "</thead>";
                if (json.length > 0){
                    json.forEach(function(element, index, array) {
                        tr += "<tr>"
                            + "    <td class='coluna-acoes'>" + element.uni_codigo + "</td>"
                            + "    <td>" + element.uni_desc + "</td>"
                            + "    <td>"
                            +       (element.uni_endereco != '' ?
                                        element.uni_endereco + ', ' + (element.uni_numero != '' ? element.uni_numero : 'S/N'):'')
                            + "    </td>"
                            + "    <td>" + element.uni_asbairro + "</td>"
                            + "    <td class='coluna-center'>" + element.cnes_telefone + "</td>"
                            + "    <td class='coluna-center'>" + element.uni_astipo + "</td>"
                            + "    <td class='coluna-acoes'>"
                            + "        <a class='btn btn-info'"
                            + "           onclick='form(" + element.uni_codigo + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "        </a>"
                            + "        <a class='btn btn-danger'"
                            + "           onclick='formExcluir(" + element.uni_codigo + ")'>"
                            + "            <i class='icon-trash icon-white'></i>"
                            + "        </a>"
                            + "    </td>"
                            + "</tr>"
                    });
                } else {
                    tr += "<tr>"+
                        " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>"+
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    },1000);
}

function validaNomeUnidadeModal() {
    $.ajax({
        url: URL + "/valida-nome",
        type: "POST",
        data: { uni_desc: $("#du_uni_desc").val(), uni_codigo: $('#uni_codigo').val()},
        success:function(txt){
            if (txt>0){
                $("#du_uni_desc").val("");
                $("#dualert_uni_desc").css('display', '');
            } else {
                $("#dualert_uni_desc").css('display', 'none');
            }
        }
    });
}