$(function(){

	// mostra estoque ao abrir
	if($(".estoque").size())
		carregarEstoque();

	$("#carteirinha").disableSelection();

	// Ativa a busca do paciente
	try{
		$("#buscar").buscar({
			url: baseUrl+'/paciente/buscar',
			callback: carregarCarteirinha
		});
	} catch(e){}

	if($("#usu_codigo").size() && $("#usu_codigo").val() != "")
		carregarCarteirinha();

	// clique do botão de recarregar as vacinas aplicadas
	$("#rec-vacinas").click(function(e){
		e.preventDefault();

		if(!$(this).hasClass("ui-state-disabled")){
			carregarCarteirinha();
		}
	});

	// clique do botão de recarregar o estoque
	$("#rec-estoque").click(function(e){
		e.preventDefault();
		carregarEstoque();
	});

	// pega o clique no btn de imprimir atestado
	$("#print-atestado").click(imprimirAtestado);

	// pega o clique na vacina
	$(".vac").click(vacina);


	// trata o clique da vacina:
	function vacina(e){
		var vac = $(this);
		var partes = vac.attr("id").split("_");
		var dose = partes[1];
		var pro_codigo = partes[2];

		popupAcoesVacina(pro_codigo,dose);
		return true;

	}



	// tratar o click na celula da vacina
	function popupAcoesVacina(pro_codigo,dose){
		window.console && console.log("popAcoesVacina();");


		var usu_codigo = getUsu();
		if(!usu_codigo)
			return false;

		var ocupado = $("#vac_"+dose+"_"+pro_codigo).is(".vacA,.vacP,.vacZ");
		var buttons = [];

		var aplicar = {
			id: "btn_aplicar",
			text: "Aplicar",
			click: function(){
				// tem doses abertas?
				var doses = $("#vac_doses_"+pro_codigo+" input").val();
				if(doses == undefined){
					mensagem("Atenção", "Produto sem estoque!", 250, 120);

				} else if(doses == 0){
					mensagem("Atenção", "Não há frascos abertos", 250, 120)

				} else {
					// aplica a vacina
					acao(pro_codigo, dose, "A", getData());
				}
				$(this).dialog('close');
			}
		}

		var preencher = {
			id: "btn_preencher",
			text: "Preencher",
			click: function(){
				// preenche vacina
				acao(pro_codigo, dose, "P", getData());
				$(this).dialog('close');
			}
		}

		var aprazar = {
			id: "btn_aprazar",
			text: "Aprazar",
			click: function(){
				// aprazar
				acao(pro_codigo, dose, "Z", getData());
				$(this).dialog('close');
			}
		}

		var perguntar = function(){
			// cancelar
			confirme("Confirmação","Deseja realemente cancelar esta vacina?", 400,150, cancelar);
			$(this).dialog('close');
		}

		var perguntarCancelar = {
			id: "btn_cancelar",
			text: "Cancelar",
			click: function(){
				perguntar();
				$(this).dialog('close');
			}
		}

		var popup = {
			id: "btn_popup",
			text: "Cancelar",
			click: function(){
				popupReforcos(pro_codigo);
				$(this).dialog('close');
			}
		}

		var cancelar = function(){
			acao(pro_codigo, dose, "C");
			$(this).dialog('close');
		}

		if(ocupado){
			if(!$("#vac_"+dose+"_"+pro_codigo).is(".vacA")){ // se for preenchido ou aprazado
				buttons.push(aplicar);
				buttons.push(perguntarCancelar);

			}else {
				perguntar();
				return false;
			}
		} else {
			buttons.push(aplicar);
			buttons.push(preencher);
			buttons.push(aprazar);
		}

		$("body").append("<div id=\"vacina-dialog\" title=\"Selecione a data e/ou a ação\"><div class=\"c\"><div id=\"data\"></div></div></div>");
		$("#vacina-dialog").dialog({
			modal: true,
			width: 400,
			height: 310,
			close: function(){
				$(this).remove();
			},
			buttons: buttons
		});
		$("#data").datepicker({
			changeMonth: true,
			changeYear: true,
			onSelect: function(data){
				var dif = compararDatas(data);
				if(dif == 1){
					// desabilitar aplicar e preencher
					$("#btn_aplicar, #btn_preencher").attr("disabled","disabled").addClass("ui-state-disabled");
				} else {
					$("#btn_aplicar, #btn_preencher").removeAttr("disabled").removeClass("ui-state-disabled");
				}
			}
		})
	}

	// Busca as vacinas do pacinte
	function carregarCarteirinha(pro_codigo,dose){
		var usu_codigo = $("#usu_codigo").val();

		carregandoAba(1);
		$.ajax({
			url: baseUrl+'/vacina/dados/id/'+usu_codigo,
			dataType: 'json',
			success: preencheVacinas
		});

		liberaBotoes();
		return false;
	}

	function liberaBotoes(){
		$("#rec-vacinas, #print-carteirinha, #print-atestado").removeClass("ui-state-disabled");

		$("#print-carteirinha").attr("href",baseUrl+"/vacina/imprimir-carteirinha/usu/"+getUsu());
	}

	function preencheVacinas(json){
		limparVacinas();
		for(var i in json){
			var vac = json[i];

			// criar uma div dentro da celula, para guardar o tooltip
			var tooltip = "<div class=\"tooltip\">";
			tooltip += "<strong>Ação:</strong> "+nomeAcao(vac.vac_acao)+"<br />";
			tooltip += "<strong>Data:</strong> "+dataToBr(vac.vac_data)+"<br />";
			if(vac.vac_acao == "A"){
				tooltip += "<strong>Lote:</strong> "+vac.ite_lote+"<br />";
				tooltip += "<strong>Validade:</strong> "+dataToBr(vac.ite_validade)+"<br />";
			}
			tooltip += "<strong>Unidade:</strong> "+vac.uni_desc+"<br />";
			tooltip += "<strong>Usuário:</strong> "+vac.usr_nome+"<br />";
			tooltip += "</div>";

			var obj = $("#vac_"+vac.vac_dose+"_"+vac.pro_codigo);

			// verificar se já há algo na celula (reforço já preenchido)
			if((vac.vac_dose == 6 || vac.vac_dose == 7) && obj.is(".vacA, .vacP, .vacZ")){
				obj.removeClass("vacA vacP vacZ").addClass("vacR"); // deixar só a ultima ação
			}

			if(vac.vac_dose == 6 || vac.vac_dose == 7){
				// adiciona na coluna oculta
				var tr = "<td class=\"ui-widget ui-widget-content\">"+ ($("#vac_R_"+vac.pro_codigo+" table tbody tr").size()+1)+"º</td>"
				tr += "<td class=\"ui-widget ui-widget-content\">"+dataToBr(vac.vac_data)+"</td>";
				tr += "<td class=\"ui-widget ui-widget-content\">"+vac.uni_desc+"</td>";
				tr += "<td class=\"ui-widget ui-widget-content\">"+nomeAcao(vac.vac_acao)+"</td>";
				tr += "<td class=\"ui-widget ui-widget-content\">"+vac.usr_nome+"</td>";
				tr += "<td class=\"ui-widget ui-widget-content c\" id=\"del_"+vac.vac_usu_codigo+"\"><img src=\""+baseUrl+"/public/images/icons/excluir.png\" title=\"Cancelar esta vacina\" onclick=\"cancelarVacina("+vac.vac_usu_codigo+")\" /></td>";

				$("#vac_R_"+vac.pro_codigo+" table tbody")
				.append( "<tr>"+tr+"</tr>" );
			}

			obj
			.html(dataToBr(vac.vac_data)) // Adiciona a data
			.addClass("vac"+vac.vac_acao) // adiciona a cor
			.append(tooltip);

			// mostrar lote no carteirinha pra impressão
			if($("#impressao").val() == "1"){
                            if(vac.ite_lote=="--") {
                                if(vac.vac_acao=="P") {
				  obj.append("<br /><small>Preenchida</small>");
                                } else {
				  obj.append("<br /><small>Aprazada</small>");
                                }
                            } else {
				obj.append("<br /><small>Lote: "+vac.ite_lote+"</small>");
                            }
			}

		}

		// adiciona o tooltip
		$(".vacA, .vacP, .vacZ").each(function(){
			var obj = $(this);
			obj.easyTooltip({
				content: obj.find(".tooltip:last").html()
			});
		});
		carregandoAba(0);
	}

	function nomeAcao(acao){
		switch (acao) {
			case "A":
				return "Aplicada";
				break;
			case "P":
				return "Preenchida";
				break;
			case "Z":
				return "Aprazada";
				break;
			default:
				return "";
				break;
		}

	}

	// Busca o estoque: lotes, validades, frascos abertos e fechados
	function carregarEstoque(){
		carregandoAba(1);
		$.ajax({
			url: baseUrl+'/vacina/dados-estoque',
			dataType: 'json',
			success: preencheEstoque
		});
	}

	function preencheEstoque(json){
		limparEstoque();
		for(var i in json.aberto){
			var vac = json.aberto[i];

			$("#vac_lote_"+vac.pro_codigo).html(vac.ite_lote) // Adiciona o lote do produto aberto
			$("#vac_validade_"+vac.pro_codigo).html(verificarData(dataToBr(vac.ite_validade))) // Adiciona a validade do produto aberto
			$("#vac_doses_"+vac.pro_codigo).html(vac.cont_dose+"<input type=\"hidden\" value=\""+vac.cont_dose+"\" />") // Adiciona as doses (abertas)

			// Adiciona o botão de descartar frasco
			$("#vac_opcao_"+vac.pro_codigo).html("<img class=\"descartar\" data-pro_codigo=\""+vac.pro_codigo+"\" src=\""+baseUrl+"/public/images/descartar_vacina.png\" alt=\"Descartar frasco\" title=\"Descartar frasco\" />");
		}

		for(i in json.fechado){
			vac = json.fechado[i];
			$("#vac_qtde_"+vac.pro_codigo).html(vac.sal_qtde) // Adiciona a quantidade fechadas

			// Adiciona o botão de abrir o frasco, se não houver aberto
			var opcao = $("#vac_opcao_"+vac.pro_codigo)
			if(opcao.html() == ""){
				opcao.html("<img class=\"abrir\" data-pro_codigo=\""+vac.pro_codigo+"\" src=\""+baseUrl+"/public/images/abrir_vacina.png\" alt=\"Abrir frasco\" title=\"Abrir frasco\" />");

				// adiciona mensagem de frasco fechado
				$("#vac_doses_"+vac.pro_codigo).addClass('fechado').html("<em>frasco<br />fechado</em><input type=\"hidden\" value=\"0\" />") // Adiciona as doses (abertas)
				$("#vac_lote_"+vac.pro_codigo+", #vac_validade_"+vac.pro_codigo).addClass('fechado').html("<em>frasco<br />fechado</em>");
			}
		}
		carregandoAba(0);
		mensagemDeSemEstoque();
		bindAbrirDescartar();
	}

	// pega o clique nas imagens de abrir e descartar frascos
	function bindAbrirDescartar(){
		$(".abrir").click(function(){
			$(this).hide()
			.parent()
			.append("<img src=\""+baseUrl+"/public/images/loading.gif\" alt=\"Carregando...\" title=\"Carregando...\" />");

			var pro_codigo = $(this).data("pro_codigo");
			window.console && console.log("abrir: "+pro_codigo);
			abrirFrasco(pro_codigo);
		});

		$(".descartar").click(function(){
			var pro_codigo = $(this).data("pro_codigo");
			descartarFrasco(pro_codigo);
		});
	}

	// aidiciona mensagem de sem estoque aos campos vazios da tabela
	function mensagemDeSemEstoque(){
		$(".estoque").each(function(){
			if($(this).html() == "")
				$(this).addClass("sem-estoque").html("<em>sem<br />estoque</em>")
		})
	}

	// Apaga as vacinas A/P/Z, para limpar a carteirinha
	function limparVacinas(){
		$("#carteirinha .vacA, #carteirinha .vacP, #carteirinha .vacZ, #carteirinha .vacR") // vacR = dois ou mais reforços
		.removeClass("vacA vacP vacZ vacR") // tira todas classes
		.html("") // limpa o conteudo
		.unbind("hover"); // desabilita tooltip

		$("table.reforcos tbody").html(""); // limpa os reforços
	}

	// Apaga as informações de estoque
	function limparEstoque(){
		$(".estoque").html("").removeClass("sem-estoque").removeClass("fechado");
	}

	// verificar se a data é maior que atual
	function verificarData(data){
		var dif = compararDatas(data);

		if(dif == 0) // vence hoje
			return "<span class=\"aviso\">"+data+"</span>";

		if(dif == 2) // já venceu
			return "<span class=\"vencida\">"+data+"</span>";

		return data;
	}

	// abre o frasco
	function abrirFrasco(pro_codigo){
		abrirDescartarFrasco(pro_codigo, "abrir");
	}

	// descartar o frasco
	function descartarFrasco(pro_codigo){
		var form = "<input type=\"radio\" value=\"1\" name=\"motivo\" id=\"motivo1\" /> <label for=\"motivo1\">Quebra de frasco</label><br />";
		form += "<input type=\"radio\" value=\"2\" name=\"motivo\" id=\"motivo2\" /> <label for=\"motivo2\">Falta de energia</label><br />";
		form += "<input type=\"radio\" value=\"3\" name=\"motivo\" id=\"motivo3\" /> <label for=\"motivo3\">Falha no equipamento</label><br />";
		form += "<input type=\"radio\" value=\"4\" name=\"motivo\" id=\"motivo4\" /> <label for=\"motivo4\">Validade Vencida</label><br />";
		form += "<input type=\"radio\" value=\"5\" name=\"motivo\" id=\"motivo5\" /> <label for=\"motivo5\">Procedimento Inadequado</label><br />";
		form += "<input type=\"radio\" value=\"6\" name=\"motivo\" id=\"motivo6\" /> <label for=\"motivo6\">Falha no transporte</label><br />";
		form += "<input type=\"radio\" value=\"7\" name=\"motivo\" id=\"motivo7\" checked=\"checked\" /> <label for=\"motivo7\">Outros motivos</label><br />";

		$("body").append("<div id=\"motivo-dialog\" title=\"Informe o motivo do descarte\"></div>")
		$("#motivo-dialog")
		.html(form)
		.dialog({
			modal: true,
			width: 300,
			height: 250,
			close: function(){
				$(this).remove();
			},
			buttons: {
				Descartar: function(){
					$("#vac_opcao_"+pro_codigo+" img").hide()
						.parent()
						.append("<img src=\""+baseUrl+"/public/images/loading.gif\" alt=\"Carregando...\" title=\"Carregando...\" />");
					abrirDescartarFrasco(pro_codigo, "descartar", $("input[name=motivo]:checked").val());
					$(this).dialog('close');
				},
				Cancelar: function(){
					$(this).dialog('close');
				}
			}
		});
	}

	function abrirDescartarFrasco(pro_codigo,acao,motivo){
		var url = "/vacina/abrir-descartar-frasco/acao/"+acao+"/pro/"+pro_codigo;

		if(typeof(motivo) != "undefined")
			url += "/motivo/"+motivo;

		carregandoAba(1);
		$.ajax({
			url: baseUrl+url,
			dataType: "json",
			success: function(json){
				limparEstoque();
				preencheEstoque(json);
			}
		});

	}

	function acao(pro_codigo,dose,acao,data){
		var usu = getUsu();
		if(!usu)
			return false;

		$("#vac_"+dose+"_"+pro_codigo)
			.html("<img src=\""+baseUrl+"/public/images/loading.gif\" alt=\"Carregando...\" title=\"Carregando...\" />");

		if(acao == "A" || acao == "C")
			$("#vac_doses_"+pro_codigo)
				.html("<img src=\""+baseUrl+"/public/images/loading.gif\" alt=\"Carregando...\" title=\"Carregando...\" />");


		carregandoAba(1);

		$.ajax({
			url: baseUrl+"/vacina/salvar/",
			type: 'post',
			dataType:'json',
			data: {
				usu: usu,
				pro: pro_codigo,
				acao: acao,
				data: data,
				dose: dose
			},
			success: function(json){
				if(json.success == true){
					carregarCarteirinha();
					if(acao == "A" || acao == "C")
						carregarEstoque();
				} else {
					mensagem(json.mensagem.titulo,json.mensagem.mensagem,json.mensagem.x,json.mensagem.y);
				}
				carregandoAba(0);
			}
		});
	}

	function getUsu(){
		var usu_codigo = $("#usu_codigo").val();
		if(usu_codigo == ""){
			mensagem("Atenção","Selecione um paciente", 250, 120);
			$("#buscar").select();
			return false;
		}
		return usu_codigo;
	}

	function imprimirAtestado(){
		$("body").append("<div id=\"atestado-dialog\" title=\"Selecione a data do atestado\"><div id=\"data\" /></div>");
		$("#atestado-dialog").dialog({
			modal: true,
			width: 270,
			height: 310,
			close: function(){
				$(this).remove();
			},
			buttons: {
				Imprimir: function(){
					var url = baseUrl+"/vacina/imprimir-atestado/usu/"+getUsu()+"/ate/"+getData();
					popup(url, "atestado-vacina", 628, 535)
					$(this).dialog('close');
				},
				Cancelar: function(){
					$(this).dialog('close');
				}
			}
		});
		$("#data").datepicker({
			changeMonth: true,
			changeYear: true
		});
	}
});

function getData(){
	var data = $("#data").datepicker( "getDate" );
	var d = (data.getDate()<=9?"0"+data.getDate():data.getDate());
	var m = (data.getMonth()<=8?"0"+(data.getMonth()+1):(data.getMonth()+1));
	var Y = data.getFullYear();
	return Y+"-"+m+"-"+d;
}

function cancelarVacina(vac_usu_codigo){
	confirme("Confirmação","Deseja realemente cancelar esta vacina?", 400,150,function(){
		carregandoAba(1);

		$("#del_"+vac_usu_codigo+" img").hide()
			.parent()
			.append("<img src=\""+baseUrl+"/public/images/loading.gif\" alt=\"Carregando...\" title=\"Carregando...\" />");

		$.ajax({
			url: baseUrl+"/vacina/deletar",
			type: 'post',
			dataType: 'json',
			data:{
				vac: vac_usu_codigo
			},
			success: function(r){
				carregandoAba(0);
				if(!r.success)
					mensagem("Erro",r.mensagem, 200, 150);
				else
					$("#reforco-dialog").dialog('close');
			}

		});
	});
}
