const URL = baseUrl + '/domicilio/bairro';
var P_DISTRITO = '';

function form(bai_codigo){
    $("body").append("<div id='dcb_form_bai' title='Cadastro de Bairro.'></div>");
    abrirModal(
        'dcb_form_bai',
        URL + "/form/bai_codigo/"+bai_codigo
    );
}

function formSalvar(e){
    if (validaForm("dcb_form_cad_bai", e)) {
        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_bai").serialize();

        mensagemSemOk("dcb_salvar_bai", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function(txt) {

                    if(txt>0) {
                        $("#dcbalert_cad_bai").hide();
                        $("#dcb_form_bai").dialog("destroy").remove();
                        fecharMensagemSemOk("dcb_salvar_bai");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                            atualizaPagina();
                        });
                    } else {
                        $("#dcbalert_cad_bai").html(txt);
                        $("#dcbalert_cad_bai").show(txt);
                        fecharMensagemSemOk("dcb_salvar_bai");
                    }

            }
        });
    } else {
        return false;
    }
}

function formExcluir(bai_codigo){
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function() {
        mensagemSemOk("dcb_exc_bai", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-excluir',
            type: "POST",
            data: {bai_codigo:bai_codigo},
            success: function(txt) {
                setTimeout(function(){
                    if(txt>0) {
                        $("#dcbalert_dados_bai").hide();
                        fecharMensagemSemOk("dcb_exc_bai");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150);
                        atualizaPagina();
                    } else {
                        $("#dcbalert_dados_bai").html(txt);
                        $("#dcbalert_dados_bai").show(txt);
                        fecharMensagemSemOk("dcb_exc_bai");
                    }
                },100);
            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function(){
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_bai").val(),
            },
            success: function (json) {
                // $("#resultado").html("");
                var tr = "<table class='table table-striped'>"
                       + "<thead>"
                       + "<tr>"
                       + "    <th class='coluna-center' style='width: 5%'>Código</th>"
                       + "    <th style='width: 35%'>Bairro</th>"
                       + "    <th style='width: 27%'>Cidade</th>"
                       + "    <th style='width: 15%'>Distrito</th>"
                       + "    <th class='coluna-acoes'>Ações</th>"
                       + "</tr>"
                       + "</thead>";
                if (json.length > 0){
                    json.forEach(function(element, index, array) {
                        tr += "<tr>"
                            + "  <td class='coluna-center'>" + element.bai_codigo + "</td>"
                            + "  <td>" + element.bai_nome + "</td>"
                            + "  <td>" + (element.cid_distrito ? element.cid_distrito : element.cid_nome) + "</td>"
                            + "  <td>" + (element.dis_nome ? element.dis_nome : '') + "</td>"
                            + "  <td class='coluna-acoes'>"
                            + "      <a class='btn btn-info' href='#'"
                            + "         title='Editar'"
                            + "         onclick='form(" + element.bai_codigo + ")'>"
                            + "          <i class='icon-edit icon-white'></i>"
                            + "      </a>"
                            + "      <a class='btn btn-danger' href='#'"
                            + "         title='Excluir'"
                            + "         onclick='formExcluir(" + element.bai_codigo + ")'>"
                            + "          <i class='icon-trash icon-white'></i>"
                            + "      </a>"
                            + "  </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>"+
                          " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>"+
                          "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    },1000);
}