const URL = baseUrl + '/domicilio/logradouro';

function form(log_codigo){
    $("body").append("<div id='dcb_form_log' title='Cadastro de Logradouro'></div>");
    abrirModal("dcb_form_log", URL + "/form/log_codigo/"+log_codigo);
}

function formSalvar(e){
    if (validaForm("dcb_form_cad_log", e)) {

        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_log").serialize();

        mensagemSemOk("dcb_salvar_log", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function(txt) {

                    if(txt>0) {
                        $("#dcbalert_cad_log").hide();
                        $("#dcb_form_log").dialog("destroy").remove();
                        fecharMensagemSemOk("dcb_salvar_log");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function(){
                            atualizaPagina();
                        });

                    } else {
                        $("#dcbalert_cad_log").html(txt);
                        $("#dcbalert_cad_log").show(txt);
                        fecharMensagemSemOk("dcb_salvar_log");
                    }

            }
        });
    } else {
        return false;
    }
}

function formExcluir(log_codigo){
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function() {
        mensagemSemOk("dcb_exc_log", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: URL + '/form-excluir',
            type: "POST",
            data: {log_codigo:log_codigo},
            success: function(txt) {

                    if(txt>0) {
                        $("#dcbalert_dados_log").hide();
                        fecharMensagemSemOk("dcb_exc_log");
                        mensagem("Confirmação", "Item removido com sucesso.", 250, 150, function () {
                            atualizaPagina();
                        });
                    } else {
                        $("#dcbalert_dados_log").html(txt);
                        $("#dcbalert_dados_log").show(txt);
                        fecharMensagemSemOk("dcb_exc_log");
                    }

            }
        });
    });
}

function pesquisaDados() {
    setTimeout(function(){
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_log").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>" +
                    "<thead>"+
                    "<tr>"+
                    "   <th class='coluna-center' style='width: 5%;'>Código</th> " +
                    "   <th style='width: 9%;'>Tipo</th> " +
                    "   <th style='width: 30%' >Logradouro</th> " +
                    "   <th class='coluna-center' style='width: 8%' >CEP</th> " +
                    "   <th style='width: 15%' >Bairro</th> " +
                    "   <th style='width: 15%' >Cidade</th> " +
                    "   <th class='coluna-acoes'>Ações</th> " +
                    "</tr>"+
                    "</thead>";
                if (json.length > 0){
                    json.forEach(function(element, index, array) {
                        tr += "<tr>" +
                              "   <td class='coluna-center'>" + element.rua_codigo + "</td> " +
                              "   <td>" + element.ds_tipo_logradouro + "</td> " +
                              "   <td>" + element.rua_nome + "</td> " +
                            "   <td class='coluna-center'>" + element.rua_cep + "</td> " +
                              "   <td>" + element.bai_nome+ "</td> " +
                              "   <td>" + (element.localidade ? element.localidade : element.cid_nome) +"</td>" +
                              "   <td class='coluna-acoes'> " +
                              "       <a class='btn btn-info' href='#' " +
                              "           onclick='form(" + element.rua_codigo + ")' " +
                              "           title='Editar'> " +
                              "               <i class='icon-edit icon-white'></i> " +
                              "               </a> " +
                              "               <a class='btn btn-danger' href='#' " +
                              "           onclick='formExcluir(" + element.rua_codigo + ")' " +
                              "           title='Apagar'> " +
                              "               <i class='icon-trash icon-white'></i> " +
                              "           </a>" +
                              "   </td>" +
                              "</tr>";
                    });
                } else {
                    tr += "<tr>"+
                          " <td colspan='8'>Nenhum resultado encontrado até o momento!</td>"+
                          "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    },1000);
}