$(function () {

    if ($("#prof_resp_codigo").val() != "") {
        carregaCnes($("#prof_resp_codigo").val());
    }

    $.validator.addMethod("validaPosse", function (validaBairro, element) {
        if ($("#valid_66").val() == 1) { // se tiver marcado como rural ele entra no validador
            if ($(".66").is(':checked') == true) { //se tem pelo menos uma opcao marcada
                return true;
            }
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $("#form").validate({
        rules: {
            valid_57: {required: true},
            valid_58: {required: true},
            valid_66: {validaPosse: true},
            prof_resp: {required: true},
            cod_cnes_uni: {required: true},
            co_data_atendimento: {required: true},
            tipo_imovel: {required: true}
        },
        messages: {
            valid_57: {required: "Campo Obrigatório!"},
            valid_58: {required: "Campo Obrigatório!"},
            prof_resp: {required: "Campo Obrigatório!"},
            co_data_atendimento: {required: "Campo Obrigatório!"},
            cod_cnes_uni: {required: "Campo Obrigatório!"},
            tipo_imovel: {required: "Campo Obrigatório!"}
        }
    });

    $(".57").change(function () {
        $("#valid_57").val("1");
    });

    $(".58").change(function () {

        if ($(".58:checked").val() == 84) {
            $("#valid_66").val("1");
            $("#color_66").html("*");
        } else {
            $("#color_66").html("");
            $("#valid_66").val("0");
        }

        $("#valid_58").val("1");
    });

    if ($(".58:checked").val() == 83) {
        desabilitaAreaRural();
    } else {
        habilitaAreaRural();
    }

    if ($(".70:checked").val() == 0) {
        desabilitaAnimais();
    } else {
        habilitaAnimais();
    }

    /*$(".70").change(function(){
     if($(this).val() == 0)
     $(".filhos").prop( "disabled", true );
     
     if($(this).val() == 1)
     $(".filhos").prop( "disabled", false );
     });*/

    $(".70").change(function () {
        if ($(this).val() == 0) {
            desabilitaAnimais();
        } else {
            habilitaAnimais();
        }
    });

    $('#tipo_imovel').change(function () {
        validaOpcoes();
    });

});


function validaDataAtendimento() {
    var dataAtual = $('#co_data_atual').val();
    var dataAtualFormatada = dataAtual.split('/');
    var dataAtualFormatada = new Date(dataAtualFormatada[2], dataAtualFormatada[1] - 1, dataAtualFormatada[0]);
    
    var mesAtual = dataAtualFormatada.getMonth();
    var diaAtual = dataAtualFormatada.getDate();
    var anoAtual = dataAtualFormatada.getFullYear();
    
    var dataMinima = new Date(anoAtual, mesAtual - 12, diaAtual);
    
    var dataInformada = $("#co_data_atendimento").val();
    var dataInformadaFormatada = dataInformada.split('/');
    var dataInformadaFormatada = new Date(dataInformadaFormatada[2], dataInformadaFormatada[1] - 1, dataInformadaFormatada[0]);

    if (dataInformadaFormatada < dataMinima) {
        alert('A data do atendimento deve constar dentro do período de 1 ano!');
        $("#co_data_atendimento").val('');
    } 
}




function validaOpcoes() {
    var tipo_imovel = $('#tipo_imovel :checked').val();
    console.log('tipo_imovel = ' + tipo_imovel);
    if (tipo_imovel === '10') { //UNIDADE DE MEDIDA SOCIO EDUCATIVA
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").show(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").show(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").show(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").show(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").show(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").show(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").show(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").show(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '11') { //DELEGACIA
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").show(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").show(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").show(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").show(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").show(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").show(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").show(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").show(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '12') { //ESTABELECIMENTO RELIGIOSO
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '1') { //DOMICILIO
        $("#co_seq_pergunta_57").show(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").show(); //LOCALIZACAO
        $("#co_seq_pergunta_59").show(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").show(); //N DE MORADORES
        $("#co_seq_pergunta_61").show(); //N DE COMODOS
        $("#co_seq_pergunta_62").show(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").show(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").show(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").show(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").show(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").show(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").show(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").show(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").show(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '2') { //COMERCIO
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '3') { //TERRENO BALDIO
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '4') { //PONTO ESTRATEGICO
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '5') { //ESCOLA
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '6') { //CRECHE
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '7') { //ABRIGO
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").show(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").show(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").show(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").show(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").show(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").show(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").show(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").show(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '8') { //INSTITUICAO LONGA PERMANENCIA IDOSOS
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").show(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").show(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").show(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").show(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").show(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").show(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").show(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").show(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '9') { //UNIDADE PRISIONAL
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    } else if (tipo_imovel === '99') { //OUTROS
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
    }

    $("input:hidden").each(function () {
        if (this.type == 'text' || this.type == 'textarea') {
            this.value = '';
        } else if (this.type == 'radio' || this.type == 'checkbox') {
            this.checked = false;
        } else if (this.type == 'select-one' || this.type == 'select-multiple') {
            this.value = 'All';
        }
    });
	$("#cod_cnes_uni").change(function(){
		console.log("setou");
		carregaIne("", $("#prof_resp_codigo").val());
	});
	

}

function desabilitaAreaRural() {
    $(".66").prop("disabled", true);
    $(".66").prop("checked", false);
}

function habilitaAreaRural() {
    $(".66").prop("disabled", false);
}

function desabilitaAnimais() {
    $(".filhos").prop("disabled", true);
    $(".filhos").prop("checked", false);
    $(".filhos").val("");
}

function habilitaAnimais() {
    $(".filhos").prop("disabled", false);
}

function buscaProfResp() {
    $('#prof_resp').autocomplete({
        source: baseUrl + '/default/usuarios/buscar-profissionais-equipes',
        minLength: 3,
        delay: 300,
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#prof_resp").val(ui.item.label);
            $("#prof_resp_codigo").val(ui.item.id);
            carregaCnes(ui.item.id);
            //$("#cod_cnes_uni").val(validaCampoEmBranco(ui.item.data.cnes_numero));
            //$("#cod_equipe").val(validaCampoEmBranco(ui.item.data.nu_ine));
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
    }
}


function carregaCnes(usrCodigo) {
    setTimeout(function () {
        $("#cod_cnes_uni option").remove();
        $("#cod_cnes_uni").show();
        $.ajax({
            url: baseUrl + "/default/unidade/carrega-cnes",
            type: "POST",
            data: {
                usr_codigo: usrCodigo
            },
            success: function (txt) {
                var codCnesEdit = $("#cod_cnes_edit").val();
                $.each(txt, function (key, value) {
                    // Valida Edição ao carregar a página
                    var selectedCnes = '';
                    if (codCnesEdit == value['uni_codigo']) {
                        selectedCnes = "selected='selected'";
                    }

                    $("#cod_cnes_uni").append("<option " + selectedCnes + " value=\"" + value['uni_codigo'] + "\" onclick='carregaIne(" + value['uni_codigo'] + "," + usrCodigo + ")'>" + value['uni_desc'] + "\</option>");
                })
				carregaIne($("#cod_cnes_uni option:selected").val(), usrCodigo);
            }
        });
        
    }, 150);
}

function validaCampoEmBranco(texto) {
    if (texto == "" || texto == null || texto == "null" || texto == "undefined") {
        return "";
    } else {
        return texto;
    }
}

function carregaIne(uniCodigo, usrCodigo) {
	console.log($("#cod_cnes_uni option:selected").val());

    setTimeout(function () {
        $("#cod_equipe option").remove();
        $("#cod_equipe").show();

        $.ajax({
            url: baseUrl + "/default/usuarios/carrega-equipes",
            type: "POST",
            data: {
                uni_codigo: $("#cod_cnes_uni option:selected").val(),
                usr_codigo: usrCodigo
            },
            success: function (txt) {
                //alert(txt);
                var codIne = $("#cod_equipe_ine").val();
				
                $.each(txt, function (key, value) {
                    var selectedIne = '';
                    if (codIne == value['co_seq_equipe']) {
                        selectedIne = "selected='selected'";
						
						
                    }
                    $("#cod_equipe").append("<option " + selectedIne + " value=\"" + value['co_seq_equipe'] + "\">\n\
                                                " + value['nu_ine'] + "\
                                              </option>");
                });
            }
        });
    }, 150);
}
