var P_DISTRITO = '';

$(function () {
    megaBind();

    addPagination();

    $('.icon-chevron-up').live('click', function () {
        $(this).toggleClass("icon-chevron-down");
    });

    $('.data-mask').live('focus', function () {
        $(this).datepicker({
            changeMonth: false, changeYear: false

        })
        $(".data-mask").mask("99/99/9999");
    });
    $('.data-mask-futura').live('focus', function () {
        $(this).datepicker({
            changeMonth: false, changeYear: false,
            maxDate: new Date()
        })
        $(".data-mask-futura").mask("99/99/9999");
    });

    $('.hora').live('focus', function () {
        $(".hora").mask("99:99");

    });

    // Configuraçoes de plugins
    $.datepicker.regional['pt-BR'] = {
        closeText: 'Fechar',
        prevText: 'Anterior',
        nextText: 'Próximo',
        currentText: 'Hoje',
        monthNames: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
            'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
        monthNamesShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun',
            'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
        dayNames: ['Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado'],
        dayNamesShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
        dayNamesMin: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
        weekHeader: 'Sm',
        dateFormat: 'dd/mm/yy',
        firstDay: 0,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };
    $.datepicker.setDefaults($.datepicker.regional['pt-BR']);

    $('.data-hora-mask').live('focus', function () {
        $(".data-hora-mask").mask('99/99/9999 99:99');
    });

    $.validator.addMethod("dataBR", function (value, element) {
        return this.optional(element) || /^((([0][1-9]|[12][0-9])\/02\/(19|20)([13579][26]|[02468][048]))|(([0][1-9]|[1][0-9]|[2][0-8])\/02\/(19|20)([02468][12356]|[013579][13579]))|((([0][1-9]|[12][0-9]|30)\/(0[469]|11)|([0][1-9]|[12][0-9]|3[01])\/(0[13578]|1[02]))\/(19|20)[0-9][0-9]))$/.test(value);
    }, "Informe uma data válida (dd/mm/aaaa)");

    $.validator.addMethod("dataFutura", function (value, element) {
        var p = value.split("/");
        p = p[2] + p[1] + p[0];

        var hj = new Date();
        var h = [];
        h.push(hj.getDate() <= 9 ? "0" + hj.getDate() : hj.getDate());
        h.push(hj.getMonth() <= 9 ? "0" + (hj.getMonth() + 1) : hj.getMonth() + 1);
        h.push(hj.getFullYear());
        h = h[2] + "" + h[1] + "" + h[0];

        return this.optional(element) || p > h;
    }, "A data informada deve ser maior que a data atual.");

    $.validator.setDefaults({
        errorElement: "span",
        errorClass: "ui-state-error",
        errorPlacement: function (error, element) {
            error.insertAfter(element).addClass("ui-state-error");

            // se for hidden, adicionar classe de erro no input* anterior
            if (element.attr("type") == "hidden") {
                element.prev().addClass("ui-state-highlight");
            }
        },
        /*submitHandler: function() {
            alert("submitted!");
        },*/
        highlight: function (input) {
            $(input).addClass("ui-state-highlight");
        },
        unhighlight: function (input) {
            $(input).removeClass("ui-state-highlight");
            if ($(input).attr("type") == "hidden") {
                $(input).prev().removeClass("ui-state-highlight");
            }
        }
    });

    // jqGrid
    try {
        jQuery.extend(jQuery.jgrid.edit, {
            errorTextFormat: function (data) {
                var json = $.parseJSON(data.responseText);
                return json.error;
            }
        });
    } catch (e) {
    }

    // novo método
    $.fn.hasAttr = function (name) {
        return this.attr(name) !== undefined;
    };
});

function addPagination() {
    $("#resultado").simplePagination({
        perPage: 7,
        previousButtonClass: "btn btn-danger",
        nextButtonClass: "btn btn-danger"
    });
}

function megaBind(_pai) {

    $("#tabs, .abas", _pai).tabs();

    // foco automático
    $(".focus", _pai).focus();

    // Confirma excluir
    $("a.excluir", _pai).click(function (e) {
        var url = $(this).attr("href");

        e.preventDefault();
        e.stopPropagation();
        $("#sys").append("<div id=\"excluir-dialog\" title=\"Confirmação\">Deseja realmente excluir este item?</div>");
        $("#excluir-dialog").dialog({
            modal: true,
            width: 300,
            height: 140,
            position: ['center', 'center'],
            buttons: {
                Sim: function () {
                    window.location.href = url;
                },
                "Não": function () {
                    $("#excluir-dialog").dialog("destroy").remove();
                }
            }
        })
    });

    // confirmção personalizada
    $("a.confirm", _pai).click(function (e) {
        var url = this.href;
        var msg = $(this).attr("rel");
        e.preventDefault();
        e.stopPropagation();
        confirme("Confirmação", msg, 300, 140, function () {
            window.location.href = url;
        });
    });

    // icones nos botões (<a>)
    /**
     * As imagens devem estar no diretório /zf/public/images/icons
     */
    $.each(['salvar', 'salvar-icon', 'login', 'limpar', 'imprimir', 'historico', 'novo', 'voltar', 'finalizar', 'detalhes', 'atualizar', 'barcode', 'buscar', 'add', 'alta', 'paciente', 'procura', 'excluir3', 'tempo_pausa', 'tempo_periodo', 'transferir'], function (index, value) {
        $("a." + value, _pai).html(function () {
            return "<div><img src=\"" + baseUrl + "/public/images/icons/" + value + ".png\" /></div>" + $(this).html();
        });
    });

    // a.submit não tem imagem (usado em 'imprimir selecionados', 'buscar')
    $("a.salvar, a.submit", _pai).bind("click", function (e) {
        e.preventDefault();

        // adicionar opção de bloqueio da função
        // alguma função que queira bloquear o submit
        // deve declarar uma variável global _canSave = false
        if ($(this).hasClass("ui-state-disabled") || (typeof(_canSave) != "undefined" && !_canSave))
            return false;

        $(this).parents("form").trigger("submit");
    });

    // CTRL+S somente no submit do primeiro form
    // submits feitos com <a class="submit"> devem ter seu próprio atalho
    $("a.salvar:not([data-atalho]):first", _pai).attr("data-atalho", "CTRL+S");

    $("a.limpar", _pai).bind("click", function (e) {
        e.preventDefault();
        $(this).parents("form").trigger("reset");
    });
    $("a.limpar:first", _pai).attr("data-atalho", "CTRL+L");

    // a.popup abre em popup!
    /**
     * Converte <a> em popup
     * @exemple <a href="pagina.php" class="popup" rel="500x300">Abrir popup</a>
     */
    $("a.popup", _pai).click(function (e) {
        e.preventDefault();
        e.stopPropagation();

        if ($(this).hasClass("ui-state-disabled"))
            return false;

        var rel = $(this).attr("rel").split("x");
        var url = $(this).attr("href");
        popup(url, url, rel[0], rel[1]);

        return false;
    });

    // a.modal abre um dialog, com ajax
    $("a.modal", _pai).click(function (e) {
        var fazerMegaBind = ($(this).data("megabind"));

        var title = $(this).attr("title");
        if (!title)
            title = document.title;

        var rel = $(this).attr("rel").split("x");
        var pos = $(this).attr("pos");
        if ($(".posic")) {
            var x = jQuery(this).position().left + jQuery(this).outerWidth();
            var y = jQuery(this).position().top - jQuery(document).scrollTop();
        } else {
            var x = "middle";
            var y = 0;
        }
        var url = $(this).attr("href");
        e.preventDefault();
        e.stopPropagation();
        $("#sys").append("<div id=\"modal-dialog\" title=\"" + title + "\"></div>");
        $("#modal-dialog").css("display", "none");
        $("#modal-dialog")
            .load(url)
            .dialog({
                modal: true,
                width: rel[0],
                height: rel[1],
                position: [x, y],
                buttons: {
                    Fechar: function () {
                        // $("#modal-dialog").dialog({ autoOpen: false });
                        //jQuery('#modal-dialog').dialog('close');
                        jQuery(this).dialog('close');
                        //$("#modal-dialog").dialog("destroy").remove();
                        //  $("#modal-dialog").dialog("close");
                    }
                },
                success: function () {
                    if (fazerMegaBind) {
                        megaBind($("#modal-dialog"));
                    }
                }

            });
    });

    // data
    /**
     * @exemple <input name="usu_datanasc" class="data" />
     */
    $("input.data", _pai).datepicker();
    $("input.data-mes-ano", _pai).datepicker({
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'mm/yy',
        onClose: function (dateText, inst) {
            var month = $("#ui-datepicker-div .ui-datepicker-month :selected").val();
            var year = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
            $(this).datepicker('setDate', new Date(year, month, 1));
        }
    });


    // Elotech_View_Helper_Dialog
    if ($(".auto-dialog", _pai).size()) {
        var tmp_width = $(".auto-dialog").css("width").replace("px", "");
        var tmp_height = $(".auto-dialog").css("height").replace("px", "");
        $(".auto-dialog").dialog({
            modal: true,
            width: tmp_width,
            height: tmp_height,
            position: ['top', 'center'],
            buttons: {
                Ok: function () {
                    $(".auto-dialog").dialog("destroy");
                }
            }
        });
    }

    // efeito zebra em tabelas
    /**
     *
     */
    $("table.zebra")
        .find("tr:odd")
        .addClass("zebra1")
        .end()
        .find("tr:even")
        .addClass("zebra2");

    // efeitos visuais
    $("a.ui-button, form label", _pai).addClass("ui-corner-bl ui-corner-tr");
    $("form input,form textearea", _pai).addClass("ui-state-default");
    $("form input[readonly]", _pai).addClass("ui-priority-secondary");
    $("form .textarea-readonly", _pai).addClass("ui-widget-content");


    // Mascaras
    $(".mask", _pai).each(function () {
        $(this).mask($(this).attr("rel"));
    });

    $(".float", _pai).each(function () {
        var rel = $(this).attr("rel");
        if (rel) {
            limit = parseInt(rel.split(",").shift());
            centsLimit = parseInt(rel.split(",").pop());
        }
        $(this).priceFormat({
            prefix: '',
            centsSeparator: '.',
            thousandsSeparator: '',
            limit: limit + centsLimit,
            centsLimit: centsLimit
        });
    });

    $("#busca-comum", _pai).bind("submit", function (e) {
        var busca = $("input[name=busca]");
        if (busca.val() == "") {
            e.preventDefault();
            busca.focus();
        }
    });
    // ler atalhos de teclas
    $("[data-atalho]", _pai).each(function () {
        var obj = $(this);
        var atalho = obj.data("atalho");

        obj.append(" <span class=\"hotkey\">(" + atalho + ")</span>");

        $.Shortcuts.add({
            type: 'down',
            mask: atalho,
            enableInInput: true,
            handler: function (e) {
                e.preventDefault();

                if (obj.hasClass("ui-state-disabled"))
                    return false;

                // se o comando for obstrusivo (alert, confirme, prompt...) o firefox tbm executa o atalho
                setTimeout('$("[data-atalho=\'' + atalho + '\']").get(0).click()', 1);
                //if(obj.get(0).tagName == "A" && typeof(obj.attr("href")) != "undefined")
                //	window.location.href=obj.attr("href");

                return false; // impede o firefox de executar esse atalho
            }
        }).start();
    });

    $('textarea.tinymce', _pai).tinymce({
        // Location of TinyMCE script

        script_url: '/WebSocialSaude/zf/public/js/tiny_mce.js',

        // General options
        //theme : "../css/tinymce/advanced",
        theme: "advanced",
        skin: "o2k7",
        //plugins : "pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template",

        // Theme options
        theme_advanced_buttons1: "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,fontselect,fontsizeselect",
        theme_advanced_buttons2: "",
        theme_advanced_buttons3: "",
        theme_advanced_buttons4: "",
        theme_advanced_toolbar_location: "top",
        theme_advanced_toolbar_align: "left",
        theme_advanced_statusbar_location: "bottom",
        theme_advanced_resizing: true
    });
}

function popupLogin() {
    mensagem("Login", "Você precisa fazer login para continuar usando o sistema", 300, 150, function () {
        popup(baseUrl.replace("zf", "") + "auth.php?popup=1", "login", 735, 412);
    });
}

function popup(url, nomeJanela, w, h) {
    var l = (screen.width / 2) - (w / 2);
    var t = (screen.height / 2) - (h / 2);

    window.open(url, nomeJanela, 'toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=' + w + ',height=' + h + ',top=' + t + ',left=' + l);
}

function carregandoAba(tipo) {
    if (tipo == 1) {
        $("#tabs ul li:first").append("<img src=\"" + baseUrl + "/public/images/loading.gif\" " + ($("#tabs ul li:first img").size() ? "style=\"display:none\"" : "") + " />");
    } else {
        $("#tabs ul li:first img:last").remove();
    }
}


function datatimeToBr(dh) {
    var partes = dh.split(" ");
    partes[0] = dataToBr(partes[0]);
    return partes.join(" ");
}

/**
 * Entra: 2012-10-30 -> sai: 30/10/2012
 */
function dataToBr(yyyymmdd) {
    if (typeof(yyyymmdd) == "undefined")
        return "";

    try {
        var dt = yyyymmdd.split(" ");
        var p = dt[0].split("-");
        return p[2] + "/" + p[1] + "/" + p[0];
    } catch (e) {
        return "";
    }

    return "";

}

function dataToBrHiffen(yyyymmdd) {
    if (yyyymmdd != "" && yyyymmdd != "undefined") {
        try {
            var p = yyyymmdd.split("-");
            return p[2] + "/" + p[1] + "/" + p[0];
        } catch (e) {
            return "";
        }
    } else {
        return "-";
    }
}

/**
 * Entra 30/10/2012 sai 2012-10-30
 */
function brToSql(yyyymmdd) {
    if (typeof(yyyymmdd) == "undefined")
        return "";

    try {
        var p = yyyymmdd.split("/");
        return p[2] + "-" + p[1] + "-" + p[0];
    } catch (e) {
        return "";
    }

    return "";

}

function horaMinuto(hhmmss) {
    if (typeof(hhmmss) == "undefined")
        return "";

    try {
        var p = hhmmss.split(":");
        return p[0] + ":" + p[1];
    } catch (e) {
        return "";
    }

    return "";

}

/**
 * Compara duas datas
 * @param data1 data, no formato dd/mm/aaaa
 * @param data2 (opcional) data, no formato dd/mm/aaaa. Valor padrao: hoje
 *
 * @return int 1: a data 1 é maior; 2: a data 2 é maior; 0: as datas são iguais
 */
function compararDatas(data1, data2) {
    var d1 = data1.split("/");
    d1 = new Date(d1[2], d1[1] - 1, d1[0]);

    var d2;
    if (typeof(data2) == "undefined") {
        d2 = new Date();
    } else {
        d2 = data2.split("/");
        d2 = new Date(d2[2], d2[1] - 1, d2[0]);
    }

    if (d1 > d2) return 1;
    else if (d1 < d2) return 2;
    else return 0;
}

/**
 * Compara duas datas e horas
 * @param dh1 data, no formato Y-m-d H:i:s (sql)
 * @param dh2 (opcional) data, no formato Y-m-d H:i:s (sql). Valor padrao: agora
 *
 * @return int 1: a data 1 é maior; 2: a data 2 é maior; 0: as datas são iguais
 */
function compararDataHora(dh1, dh2) {
    var d1 = new Date(sqlToEn(dh1));
    var d2;
    if (typeof(dh2) != "undefined") {
        d2 = new Date(sqlToEn(dh2));
    } else {
        d2 = new Date();
    }

    if (d1 > d2) return 1;
    else if (d1 < d2) return 2;
    else return 0;
}

/**
 * 2012-03-21 08:00:00 => 03/21/2012 08:00:00
 */
function sqlToEn(dataSql) {
    var dh = dataSql.split(" ");
    var d = dh[0].split("-");
    return d[1] + "/" + d[2] + "/" + d[0] + " " + dh[1];
}

/**
 * retorno em segundos
 */
function diferencaEntreHoras(dh1, dh2) {
    var a = new Date(sqlToEn(dh1));
    var b;
    if (typeof(dh2) != "undefined") {
        b = new Date(sqlToEn(dh2));
    } else {
        b = new Date();
    }

    var n = a - b;
    if (n < 0) n *= -1;

    return n / 1000;
}

function segundosToHora(n) {
    var S = 1;
    var M = S * 60;
    var H = M * 60;
    var D = H * 24;

    var d = Math.floor(n / D);
    var h = Math.floor(n / H) % 24;
    var m = Math.floor(n / M) % 60;
    var s = Math.floor(n / S) % 60;

    if (h <= 9) h = "0" + h;
    if (m <= 9) m = "0" + m;
    if (s <= 9) s = "0" + s;

    var saida = "";
    if (d > 0)
        saida = d + " dia" + (d > 1 ? "s " : " ");

    saida += h + ":" + m + ":" + s;
    return saida;
}

function mensagem(titulo, mensagem, x, y, callback) {
    $("body").append("<div id=\"mensagem-dialog\" title=\"" + titulo + "\">" + mensagem + "</div>")
    $("#mensagem-dialog").dialog({
        modal: true,
        width: x,
        height: y,
        resizable: false,
        position: 'top+25',
        closeOnEscape: false,
        open: function (event, ui) {
            $('button.ui-dialog-titlebar-close').remove();
        },
        buttons: {
            "Ok": {
                click: function () {
                    if (typeof(callback) != "undefined")
                        callback();
                    $(this).remove();
                },
                text: 'OK',
                class: 'btn btn-success'
            }
        }
    });
}

function mensagemSemOk(id, titulo, mensagem, x, y) {
    $("body").append("<div id=\"" + id + "\" title=\"" + titulo + "\"><div class=\"c\">" + mensagem + "</div>" + imgCarregando() + "</div>");
    $("#" + id).dialog({
        modal: true,
        position: ['center', 'center'],
        resizable: false,
        closeOnEscape: false,
        open: function (event, ui) {
            $('button.ui-dialog-titlebar-close').remove();
        },
        beforeClose: function () {
            return false
        }
    });
}

function fecharMensagemSemOk(id) {
    $("#" + id).remove();
}

function confirme(titulo, mensagem, x, y, callback) {
    $("body").append("<div id=\"confirme-dialog\" title=\"" + titulo + "\">" + mensagem + "</div>")
    $("#confirme-dialog").dialog({
        modal: true,
        position: ['center', 'center-20'],
        width: x,
        height: y,
        closeOnEscape: false,
        open: function (event, ui) {
            $('button.ui-dialog-titlebar-close').remove();
        },
        buttons: {
            "Não": {
                click: function () {
                    $(this).dialog('close');
                },
                text: 'Não',
                class: 'btn btn-danger'
            },
            Sim: {
                click: function () {
                    callback();
                    $(this).dialog('close');
                },
                text: 'Sim',
                class: 'btn btn-success'
            }
        }
    });

}

function confirmeAlteracao(titulo, mensagem, callbackYes, callbackNo) {
    $("body").append("<div id='confirme-dialog' title='" + titulo + "'>" + mensagem + "</div>")
    $("#confirme-dialog").dialog({
        modal: true,
        position: 'top+40',
        closeOnEscape: false,
        open: function (event, ui) {
            $('button.ui-dialog-titlebar-close').remove();
        },
        buttons: {
            "Não": {
                click: function () {
                    callbackNo();
                    $(this).dialog('close');
                },
                text: 'Não',
                class: 'btn btn-danger'
            },
            Sim: {
                click: function () {
                    callbackYes();
                    $(this).dialog('close');
                },
                text: 'Sim',
                class: 'btn btn-success'
            }
        }
    });

}

function imgCarregando() {
    return "<div class=\"c\"><img class=\"loading\" src=\"" + baseUrl + "/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando...\" /></div>";
}

function imc(peso, altura) {
    if (peso && altura)
        return number_format(peso / (altura ^ 2), 1);

    return "--";
}

/* Cópia da função do php */
function number_format(number, decimals, dec_point, thousands_sep) {
    number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
    var n = !isFinite(+number) ? 0 : +number,
        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
        s = '',
        toFixedFix = function (n, prec) {
            var k = Math.pow(10, prec);
            return '' + Math.round(n * k) / k;
        };
    // Fix for IE parseFloat(0.55).toFixed(0) = 0;
    s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
    if (s[0].length > 3) {
        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
    }
    if ((s[1] || '').length < prec) {
        s[1] = s[1] || '';
        s[1] += new Array(prec - s[1].length + 1).join('0');
    }
    return s.join(dec);
}

function abreviaNome(nomecompleto, maxtamanho) {
    if (nomecompleto.length > maxtamanho) {
        var explode = nomecompleto.split(" ");
        var nomecartao = explode[0] + " ";
        var reducao;
        for (i = 1; i < (explode.length) - 1; i++) {
            var nomedomeio = explode[i];

            if ((nomedomeio == "DE") || (nomedomeio == "DA") || (nomedomeio == "E") || (nomedomeio == "DOS") || (nomedomeio == "DAS") || (nomedomeio == "DI")) {
                nomecartao += nomedomeio + " ";
            } else {
                reducao = nomedomeio.substr(0, 1);
                nomecartao += reducao + ". ";
            }
        }
        nomecartao += explode[i];
    } else {
        nomecartao = nomecompleto;
    }
    //alert(nomecartao);
    return nomecartao;
}

function validaCPFLimpo(strCPF) {
    var Soma;
    var Resto;
    Soma = 0;
    if (strCPF == "00000000000" || strCPF == "11111111111" || strCPF == "22222222222" || strCPF == "33333333333" || strCPF == "44444444444" || strCPF == "55555555555" || strCPF == "66666666666" || strCPF == "77777777777" || strCPF == "88888888888" || strCPF == "99999999999") return false;
    for (i = 1; i <= 9; i++) Soma = Soma + parseInt(strCPF.substring(i - 1, i)) * (11 - i);
    Resto = (Soma * 10) % 11;
    if ((Resto == 10) || (Resto == 11)) Resto = 0;
    if (Resto != parseInt(strCPF.substring(9, 10))) return false;
    Soma = 0;
    for (i = 1; i <= 10; i++) Soma = Soma + parseInt(strCPF.substring(i - 1, i)) * (12 - i);
    Resto = (Soma * 10) % 11;
    if ((Resto == 10) || (Resto == 11)) Resto = 0;
    if (Resto != parseInt(strCPF.substring(10, 11))) return false;
    return true;
};

function maskCpf(idCpf) {
    setTimeout(function () {
        $("#" + idCpf).mask("999.999.999-99");
    }, 1000);
}

function maskNIS(idNis) {
    $("#" + idNis).mask("999.99999.99-9");
}

function maskCep(idCep) {
    $("#" + idCep).mask("99999-999");
}

function maskCnpj(idCnpj) {
    $("#" + idCnpj).mask("99.999.999/9999-99");
}

function maskTelefone(idTelefone) {
    $("#" + idTelefone).mask("(99) 9999-9999?9");
    $("#" + idTelefone).blur(function (event) {
        if ($(this).val().length == 15) {
            $("#" + idTelefone).mask('(99) 99999-999?9');
        } else {
            $("#" + idTelefone).mask('(99) 9999-9999?9');
        }
    });
}

function formataTelefone() {
    $(".maskFone").mask("(99) 9999-9999?9");
    $(".maskFone").blur(function (event) {
        if ($(this).val().length == 15) {
            $('.maskFone').mask('(99) 99999-9999');
        } else {
            $('.maskFone').mask('(99) 9999-9999');
        }
    });
}

function maskMoney(id) {
    $("#" + id).maskMoney({
        symbol: 'R$ ', showSymbol: false, thousands: '.',
        decimal: ',', symbolStay: true
    });
}

function formatMoney(valor) {
    var formatter = new Intl.NumberFormat('pt-BR', {
        minimumFractionDigits: 2, /* this might not be necessary */
    });

    return formatter.format(valor);
}

function validaCpfCompleto(idCpf, idErro, idErroExiste, usuCodigo) {
    var cpf = "";
    var cpf_completo = $("#" + idCpf).val();
    cpf = cpf_completo.replace(".", "").replace(".", "").replace("-", "");
    if (cpf != "") {
        $.ajax({
            url: baseUrl + "/cidadao/cidadao/valida-cpf",
            type: "POST",
            data: {
                cpf: cpf_completo,
                usu_codigo: usuCodigo
            },
            success: function (txt) {
                if (txt == "cpf-ok") {
                    if (validaCPFLimpo(cpf)) {
                        $("#" + idErro).hide();
                        $("#" + idErroExiste).hide();
                        return true;
                    } else {
                        $("#" + idCpf).val("");
                        $("#" + idCpf).focus();
                        $("#" + idErroExiste).hide();
                        $("#" + idErro).show();
                    }
                } else {
                    $("#" + idCpf).val("");
                    $("#" + idCpf).focus();
                    $("#" + idErro).hide();
                    $("#" + idErroExiste).show();
                }
            }
        });
    }
}


function validaCpf() {
    var cpf = "";
    var cpf_completo = $("#cpf-val").val()
    cpf = cpf_completo.replace(".", "").replace(".", "").replace("-", "");
    if (cpf != "") {
        if (validaCPFLimpo(cpf)) {
            $("#alert-cpf").hide();
            $("#alert-cpf-existe").hide();
            return true;
        } else {
            $("#cpf-val").val("");
            $("#cpf-val").focus();
            $("#alert-cpf-existe").hide();
            $("#alert-cpf").show();
        }
    }
}

function campoVisivel(texto) {
    if (texto == "" || texto == null || texto == "null" || texto == "undefined") {
        return "display: none";
    } else {
        return "";
    }
}

function validaCampoEmBranco(texto) {
    if (texto == "" || texto == null || texto == "null" || texto == "undefined") {
        return "-";
    } else {
        return texto;
    }
}

function SomenteNumero(e) {
    var tecla = (window.event) ? event.keyCode : e.which;
    if ((tecla > 47 && tecla < 58)) return true;
    else {
        if (tecla == 8 || tecla == 0) return true;
        else return false;
    }
}

function validaNomeCidadao() {
    $.ajax({
        url: baseUrl + "/cidadao/cidadao/valida-nome",
        type: "POST",
        data: {usu_nome: $("#dc_usu_nome").val()},
        success: function (txt) {
            if (txt > 0) {
                //$("#dc_usu_nome").val("");
                //$("#dc_usu_nome").focus();
                $("#alert-nome").show();
            } else {
                $("#alert-nome").hide();
            }
        }
    });
}

function fecharModal(modal) {
    setTimeout(function () {
        $("#" + modal).dialog("destroy").remove();
    }, 250);
}

function validaCampoObrigatorio() {
    if (texto == "" || texto == null || texto == "null" || texto == "undefined") {
        return false;
    } else {
        return true;
    }
}

function trim(str) {
    return str.replace(/^\s+|\s+$/g, "");
}

function atualizaPagina() {
    location.reload();
}

function buscaCidadeGeral(idCodigo, idDesc, idAlert) {
    $("#" + idCodigo).val("");
    $("#" + idAlert).hide();
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/default/cidade/busca-dados/',
        minLength: 3,
        delay: 300,
        limit: 12,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        var template = "<a style='cursor: pointer;'>"
            + "	<strong>" + item.label + "</strong><br>"
            + "	<small style='font-size: 80%; " + campoVisivel(item.data.cid_codigo) + "'>"
            + "		<strong>Cód: </strong>" + validaCampoEmBranco(item.data.cid_codigo)
            + "		<strong>UF: </strong>" + validaCampoEmBranco(item.data.uf_sigla)
            + "	</small></br>"
            + "</a>";
        return $("<li>")
            .append(template)
            .appendTo(ul);
    }
}

function buscaUnidadeGeral(idCodigo, idDesc, idAlert) {
    $("#" + idCodigo).val("");
    $("#" + idAlert).hide();
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/default/unidade/busca-unidade/',
        minLength: 3,
        delay: 300,
        limit: 12,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li>")
            .append("<a><strong>" + item.label + "</strong><br>\n\
                        <strong>Nº da Unidade: </strong>"
                + validaCampoEmBranco(item.data.uni_asnumero) + " \n\
                        <strong>Tipo de Unidade: </strong>"
                + validaCampoEmBranco(item.data.uni_astipo) + "<br></a>")
            .appendTo(ul);
    }
}

function validaNomeUnidadeGeral(idCodigo, idDesc, idAlert) {
    var unidade = $("#" + idDesc).val();
    if (unidade != "") {
        $.ajax({
            url: baseUrl + "/default/unidade/valida-nome-geral",
            type: "POST",
            data: {uni_desc: $("#" + idDesc).val(), uni_codigo: $("#" + idCodigo).val()},
            success: function (txt) {
                if (txt > 0) {
                    $("#" + idCodigo).val(txt);
                    $("#" + idAlert).hide();
                } else {
                    $("#" + idDesc).val("");
                    $("#" + idCodigo).val("");
                    $("#" + idAlert).show();
                }
            }
        });
    }
}

function buscaCidadaoGeral(idCodigo, idDesc, idAlert) {
    $("#" + idCodigo).val("");
    $("#" + idAlert).hide();
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/cidadao/cidadao/busca-geral/',
        minLength: 3,
        delay: 2000,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li " + usuarioBloqueado(item.data.usu_bloqueado) + ">")
            .append("<a><strong>" + item.label + "</strong><br>\n\
                      <strong>Nº Pront. Suas: </strong>" + validaCampoEmBranco(item.data.asps_num_prontuario) + "<br>\n\
                      <strong>Cpf:</strong>\n\ " + validaCampoEmBranco(item.data.usu_cpf) + "\n\
                      <strong>NIS:</strong>\n\ " + validaCampoEmBranco(item.data.usu_nis) + "<br>\n\
                      <strong>Mãe: </strong>" + validaCampoEmBranco(item.data.usu_mae) + " \n\
                      <strong>Data Nasc: </strong>" + dataToBrHiffen(item.data.usu_datanasc) + "<br>\n\
                   </a><br>"
            ).appendTo(ul);
    }
}

function usuarioBloqueado(bloqueado) {
    return bloqueado ? "style='color: red'" : "";
}

function buscaMotivoAtendimento(idCodigo, idDesc, idAlert, tipo) {
    $("#" + idCodigo).val("");
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/atendimentocras/atendimento-motivo/busca/',
        minLength: 3,
        delay: 300,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);
            adicionaMotivos(idCodigo, idDesc);
            if (tipo == 0) {
                limparCampos(idDesc);
            }
            return false;
        }
    }, tipo);
}

function adicionaMotivos(idCodigo, idDesc) {
    var codigo = $("#" + idCodigo).val();
    var descricao = $("#" + idDesc).val();
    if ($("#motivoAtendBasico" + descricao).length == 0) {
        var template = "<div id='motivoAtendBasico" + codigo + "'>"
            + "    <div class='motivoAtendBasico'>"
            + "        <span class='titMotivoAtendBasico' title='" + descricao + "'>"
            + descricao.substr(0, 32) + " ..."
            + "        </span>"
            + "        <span class='excMotivoAtendBasico' style='float: right;'>"
            + "            <img src='" + baseUrl + "/public/images/icons/excluir.png' "
            + "                 onclick='excluiMotivo(" + codigo + ")' title='Excluir Motivo'"
            + "                 alt='Clique aqui para excluir o motivo' style='cursor: pointer' />"
            + "            <input type='hidden' name='motivos[]' value='" + codigo + "' />"
            + "        </span>"
            + "    </div>"
            + "</div>";
        $("#dadosMotivoAtendBasico").append(template);
    }
}

function excluiMotivo(idCodigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        $("#motivoAtendBasico" + idCodigo).remove();

        var cont = 0;
        $("#dadosMotivoAtendBasico").children("[class='motivoAtendBasico']").each(function () {
            cont++;
        });
        if (cont == 0) {
            $("#" + idCodigo).val("");
        } else {
            $("#" + idCodigo).val(cont);
        }
    });
}

function limparCampos(idDesc) {
    $("#" + idDesc).val("");
}

function validaNomeCidadaoGeral(idCodigo, idDesc, idAlert) {
    if ($("#" + idCodigo).val() == '') {
        $.ajax({
            url: baseUrl + "/cidadao/cidadao/get-dados-nome",
            type: "POST",
            data: {usu_nome: $("#" + idDesc).val()},
            success: function (txt) {
                if (txt > 0) {
                    $("#" + idCodigo).val(txt);
                    $("#" + idAlert).hide();
                } else {
                    $("#" + idCodigo).val("");
                    $("#" + idDesc).val("");
                    $("#" + idAlert).show();
                }
            }
        });
    }
}


// function validaNomeMotivoGeral(idCodigo, idDesc, idAlert) {
//     $.ajax({
//         url: baseUrl + "/atendimentocras/atendimento-basico/get-dados-nome",
//         type: "POST",
//         data: {asam_nome: $("#" + idDesc).val()},
//         success: function (txt) {
//
//             if (txt > 0) {
//                 $("#" + idCodigo).val(txt);
//                 $("#" + idAlert).hide();
//             } else {
//                 $("#" + idCodigo).val("");
//                 $("#" + idDesc).val("");
//                 $("#" + idAlert).show();
//             }
//         }
//     });
// }


function validaCidadaoJaExisteGeral(idCodigo, idDesc, idAlert) {
    if($("#" + idDesc).val().length >0){
        $.ajax({
            url: baseUrl + "/cidadao/cidadao/get-dados-nome",
            type: "POST",
            data: {usu_nome: $("#" + idDesc).val()},
            success: function (txt) {
                if (txt > 0 && txt != $("#" + idCodigo).val()) {
                    $("#" + idCodigo).val("");
                    $("#" + idDesc).val("");
                    $("#" + idAlert).show();
                } else {
                    $("#" + idAlert).hide();
                }
            }
        });
    }
}


function validaMotivoJaExisteGeral(idCodigo, idDesc, idAlert) {
    if ($("#" + idDesc).val() == "") {
        $("#" + idCodigo).val("");
    } else {
        $.ajax({
            url: baseUrl + "/atendimentocras/atendimentomotivo/get-dados-nome",
            type: "POST",
            data: {asam_nome: $("#" + idDesc).val()},
            success: function (txt) {
                if (txt > 0) {
                    $("#" + idCodigo).val("");
                    $("#" + idDesc).val("");
                    $("#" + idAlert).show();
                } else {
                    $("#" + idAlert).hide();
                }
            }
        });
    }
}


function buscaProfissionalGeral(idCodigo, idDesc, idAlert, idCargoNome, idCargo) {
    $("#" + idCodigo).val("");
    $("#" + idAlert).hide();
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/usuarios/usuarios/busca-geral/',
        minLength: 3,
        delay: 300,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);
            $("#" + idCargoNome).val(ui.item.data.crg_nome);
            $("#" + idCargo).val(ui.item.data.crg_codigo);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li>")
            .append("<a><strong>" + item.label + "</strong><br>\n\</a>").appendTo(ul);
    }
}

function validaNomeProfissionalGeral(idCodigo, idDesc, idAlert) {
    $.ajax({
        url: baseUrl + "/usuarios/usuarios/get-dados-nome",
        type: "POST",
        data: {usr_nome: $("#" + idDesc).val()},
        success: function (txt) {
            if (txt > 0) {
                $("#" + idCodigo).val(txt);
                $("#" + idAlert).hide();
            } else {
                $("#" + idCodigo).val("");
                $("#" + idDesc).val("");
                $("#" + idAlert).show();
            }
        }
    });
}

function buscaBeneficioGeral(idCodigo, idDesc, idAlert) {
    $("#" + idCodigo).val("");
    $("#" + idAlert).hide();
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/default/beneficios/busca-geral/',
        minLength: 3,
        delay: 300,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li>")
            .append("<a><strong>" + item.label + "</strong><br>\n\</a>").appendTo(ul);
    }
}

function validaNomeBeneficioGeral(idCodigo, idDesc, idAlert) {
    $.ajax({
        url: baseUrl + "/default/beneficios/get-dados-nome",
        type: "POST",
        data: {beneficio: $("#" + idDesc).val()},
        success: function (txt) {
            if (txt > 0) {
                $("#" + idCodigo).val(txt);
                $("#" + idAlert).hide();
            } else {
                $("#" + idCodigo).val("");
                $("#" + idDesc).val("");
                $("#" + idAlert).show();
            }
        }
    });
}

function formCadastraMotivoAtendimento(idCodigo, idDesc, idAlert) {
    $("body").append("<div id='dasam_formgm' title='Cadastro de Motivo do Atendimento.'></div>");
    var url = baseUrl + "/atendimentocras/atendimento-basico/form-cadastro-motivo/idCodigo/" + idCodigo + "/idDesc/" + idDesc;
    abrirModalParalelo(
        'dasam_formgm',
        url,
        formCadastraMotivoGeralSalvar
    );
}

/* Cadastro de cidadão geral*/
function formCadastraCidadaoGeral(cidCodigo, idCodigo, idDesc, idAlert) {
    $("body").append("<div id='dcid_formgm' title='Cadastro de Cidadão.'></div>");
    var url = baseUrl + "/cidadao/cidadao/form-cadastro-geral/cidCodigo/" + cidCodigo + "/idCodigo/" + idCodigo + "/idDesc/" + idDesc + "/idAlert/" + idAlert;
    abrirModalParalelo(
        'dcid_formgm',
        url,
        formCadastraCidadaoGeralSalvar
    );
    setTimeout(function () {
        $("#etn_campos").hide();
        $("#pais_campos").hide();
        $("#portaria_campos").hide();
        $("#nat_campos").hide();
        $("#entrada_campos").hide();
        $("#cidade_campos").hide();
        cdNacionalidadeChange();
        racCodigoChange();
        habilitaCidade();
    }, 1200);
}

function formCadastraCidadaoGeralSalvar(e) {

    var idCodigo = $("#dcid_idcodigo").val();
    var idDesc = $("#dcid_iddesc").val();
    var idAlert = $("#dcid_idalert").val();

    var cidadao = $("#dc_usu_nome").val();
    if (!validaNIS()) {
        $('#usu_nis').val("");
    }

    if (validaForm('dcid_form_cadastrog', e)) {
        e.preventDefault();
        var valoresForm = $("#dcid_form_cadastrog").serialize();
        mensagemSemOk("dcid_salvar_cg", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/cidadao/cidadao/form-cadastro-geral-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                if (txt > 0) {
                    fecharMensagemSemOk("dcid_salvar_cg");
                    mensagem("Confirmação", "Dados salvos com sucesso.", 250, 150, function () {
                        $("#dcid_formgm").dialog("close");
                        $("#" + idCodigo).val(txt);
                        $("#" + idDesc).val(cidadao);
                        $("#" + idAlert).hide();
                    });
                } else {
                    $("#dcid_alert_nome").html(txt);
                    $("#dcid_alert_nome").show(txt);
                    fecharMensagemSemOk("dcid_salvar_cg");
                }
            }
        });
    } else {
        return false;
    }
}

function racCodigoChange() {
    if ($("#rac_codigo option:selected").val() == 5) {
        $("#etn_campos").show();
    } else {
        $("#etn_campos").hide();
    }
}

function cdNacionalidadeChange() {
    if ($("#cd_nacionalidade option:selected").val() == 'E') {
        $("#pais_campos").show();
        $("#entrada_campos").show();
    } else {
        $("#pais_campos").hide();
        $("#entrada_campos").hide();
    }

    if ($("#cd_nacionalidade option:selected").val() == 'N') {
        $("#portaria_campos").show();
        $("#nat_campos").show();
    } else {
        $("#portaria_campos").hide();
        $("#nat_campos").hide();

    }
}

function habilitaCidade() {
    var nacionalidade = $("#cd_nacionalidade option:selected").val();
    if (nacionalidade == "B") {
        $("#cidade_campos").show();
    } else {
        $("#cidade_campos").hide();
    }
}

function buscaCidades() {
    $("#cidade").buscar({
        url: baseUrl + '/cidade/buscar/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + " - " + item.data.uf_sigla + "</a>").appendTo(ul);
        },
        callback: function (ul, item) {
            return false;
        }
    });
}

function betweenDate(dataEntrada, dataInicial, dataFinal) {
    var parts = dataEntrada.split('/');
    dataEntrada = new Date(parts[2], parts[1] - 1, parts[0]);
    parts = dataInicial.split('/');
    var dataInicial = new Date(parts[2], parts[1] - 1, parts[0]);
    parts = dataFinal.split('/');
    var dataFinal = new Date(parts[2], parts[1] - 1, parts[0]);
    if (dataEntrada >= dataInicial && dataEntrada <= dataFinal) {
        return true;
    } else {
        return false;
    }
}

function validaEspacoNome() {
    var nome = $("#dc_usu_nome").val();
    if (nome.indexOf(" ") == -1) {
        mensagem("Atenção", "Obrigatório Nome e Sobrenome e um espaço entre Nome do paciente!", 300, 150);
        $("#dc_usu_nome").focus();
    } else {
        validaEspacamento('dc_usu_nome');
    }
}

function validaNomeMae() {
    var nomeMae = $("#dc_usu_mae").val();
    if (nomeMae.indexOf(" ") == -1) {
        mensagem("Atenção", "Obrigatório Nome e Sobrenome e um espaço entre Nome da mãe!", 300, 150);
        $("#dc_usu_mae").focus();
    } else {
        validaEspacamento('dc_usu_mae');
    }
}

function validaNomePai() {
    var nomePai = $("#dc_usu_pai").val();
    if (nomePai.length > 0 && nomePai.indexOf(" ") == -1) {
        mensagem("Atenção", "Obrigatório Nome e Sobrenome e um espaço entre Nome do pai!", 300, 150);
        $("#dc_usu_pai").focus();
    } else {
        validaEspacamento('dc_usu_pai');
    }
}

function validaEspacamento(idElemento) {
    var criaNomeElemento = '#' + idElemento;
    var nomeElemento = $(criaNomeElemento).val();
    var espaco = "  ";
    var verificaPalavraComposta = false;

    for (var i = 0; i < nomeElemento.length; i++) {
        if (nomeElemento.indexOf(espaco.toString()) !== -1) {
            var resposta = nomeElemento.replace(espaco.toString(), " ");
            $(criaNomeElemento).val(resposta);
            verificaPalavraComposta = true;
        }
        espaco += " ";
    }

    if (verificaPalavraComposta) {
        validaEspacamento(idElemento);
    }
}

/***************************************************************/

function formCadastraLogradouro(idCodigo, idDesc, idAlert) {
    $("body").append("<div id='dcb_form_log' title='Cadastro de Logradouro'></div>");
    var url = baseUrl + "/domicilio/logradouro/form-cadastro-geral/idCodigo/" + idCodigo + "/idDesc/" + idDesc + "/idAlert/" + idAlert;
    abrirModalParalelo("dcb_form_log", url, formCadastraLogradouroGeralSalvar);
}

function formCadastraLogradouroGeralSalvar(e) {
    var idCodigo = $("#dlog_idcodigo").val();
    var idDesc = $("#dlog_iddesc").val();
    var idAlert = $("#dlog_idalert").val();

    if (validaForm("dcb_form_cad_log", e)) {
        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_log").serialize();
        mensagemSemOk("dcid_salvar_cg", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/domicilio/logradouro/form-cadastro-geral-salvar',
            type: "POST",
            data: valoresForm,
            success: function (response) {
                setTimeout(function () {
                    if (response != undefined) {
                        fecharMensagemSemOk("dcid_salvar_cg");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                            $("#dcb_form_log").dialog("destroy").remove();
                            $("#" + idCodigo).val(response.id);
                            $("#" + idDesc).val(response.label);
                            $("#" + idAlert).hide();
                        });
                    } else {
                        $("#dcb_form_cad_log").html(response);
                        $("#dcb_form_cad_log").show(response);
                        fecharMensagemSemOk("dcid_salvar_cg");
                    }
                }, 150);
            }
        });
    } else {
        return false;
    }
}


function buscaBairroGeral(idCodigo, idDesc) {
    $("#" + idCodigo).val("");
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/domicilio/logradouro/busca-bairro',
        minLength: 3,
        delay: 300,
        limit: 12,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);

            $("#localidade").val(ui.item.data['cid_nome'] + " - Distrito: " + ui.item.data['dis_nome']);
            $("#editar_rua").show();

            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        var template = "<a style='cursor: pointer;'>"
            + "	<strong>" + item.label + "</strong><br>"
            + "	<small style='font-size: 80%; " + campoVisivel(item.data.cid_nome) + "'>"
            + "		<strong>Cidade: </strong>" + validaCampoEmBranco(item.data.cid_nome)
            + "		<strong>Distrito: </strong>" + validaCampoEmBranco(item.data.dis_nome)
            + "	</small></br>"
            + "</a>";
        return $("<li>")
            .data("item.autocomplete", item)
            .append(template)
            .appendTo(ul);
    }
}

function buscaTipoLogradouroGeral(idCodigo, idDesc) {
    $("#" + idCodigo).val("");
    $("#" + idDesc).autocomplete({
        source: baseUrl + '/domicilio/logradouro/busca-tipo-logradouro',
        minLength: 3,
        delay: 300,
        limit: 12,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#" + idCodigo).val(ui.item.id);
            $("#" + idDesc).val(ui.item.label);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        var template = "<a style='cursor: pointer;'>"
            + "	<strong>" + item.label + "</strong>"
            + "</a>";
        return $("<li>")
            .append(template)
            .appendTo(ul);
    }
}

/************************************************************************/

function formCadastraBairroGeral(idCodigo, idDesc, idAlert) {
    $("body").append("<div id='dcb_form_bai' title='Cadastro de Bairro.'></div>");
    var url = baseUrl + "/domicilio/bairro/form-cadastro-geral/idCodigo/" + idCodigo + "/idDesc/" + idDesc + "/idAlert/" + idAlert;
    abrirModalParalelo("dcb_form_bai", url, formCadastraBairroGeralSalvar);
}

function formCadastraBairroGeralSalvar(e) {
    var idCodigo = $("#dbai_idcodigo").val();
    var idDesc = $("#dbai_iddesc").val();
    var idAlert = $("#dbai_idalert").val();

    var bairro = $("#dcid_bai_nome").val();

    if (validaForm("dcb_form_cad_bai", e)) {
        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_bai").serialize();
        mensagemSemOk("dcid_salvar_cg", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/domicilio/bairro/form-cadastro-geral-salvar',
            type: "POST",
            data: valoresForm,
            success: function (response) {
                setTimeout(function () {
                    if (response != undefined) {
                        fecharMensagemSemOk("dcid_salvar_cg");
                        mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                            $("#dcb_form_bai").dialog("destroy").remove();
                            $("#" + idCodigo).val(response.id);
                            $("#" + idDesc).val(response.label);
                            $("#" + idAlert).hide();

                            $("#localidade").val(response.data.localidade);

                            novoEditarBairro();

                        });


                    } else {
                        $("#dcb_form_cad_bai").html(response);
                        $("#dcb_form_cad_bai").show(response);
                        fecharMensagemSemOk("dcid_salvar_cg");
                    }
                }, 150);
            }
        });
    } else {
        return false;
    }
}

function possuiDistrito(val) {
    P_DISTRITO = val;

    $("#dis_codigo").val("");
    $("#cid_nome").val("");
    $("#cid_codigo").val("");

    if (val == "N") {
        $("#div_distrito").hide();
        $("#div_cidade").show();
        $("#cid_nome").prop('readonly', false);
        $("#dis_codigo").prop('required', false);
    } else {
        $("#cid_nome").prop('readonly', true);
        $("#div_distrito").show();
        $("#div_cidade").hide();
        $("#dis_codigo").prop('required', true);
    }
}

function possuiDistritoGeral(val) {
    P_DISTRITO = val;
    if (val == "N") {
        $("#div_distrito").hide();
        $("#div_cidade").show();
        $("#dcid_cid_nome").prop('readonly', false);
        $("#dcid_dis_codigo").prop('required', false);
    } else {
        $("#dcid_cid_nome").prop('readonly', true);
        $("#div_distrito").show();
        $("#div_cidade").hide();
        $("#dcid_dis_codigo").prop('required', true);
    }
}

function alteraCidade() {
    var dis_codigo = ($("#dcid_dis_codigo").val() ? $("#dcid_dis_codigo").val() : $("#dis_codigo").val());
    $.ajax({
        url: baseUrl + '/default/cidade/get-cidade-por-distrito',
        data: {dis_codigo: dis_codigo},
        success: function (txt) {
            if ($("#dcid_dis_codigo").val()) {
                $("#dcid_cid_codigo").val(txt["cid_codigo"]).change();
                $("#dcid_cid_nome").val(txt["cid_nome"]).change();
                $("#dcid_cid_nome").prop('readonly', true);
            } else {
                $("#cid_codigo").val(txt["cid_codigo"]).change();
                $("#cid_nome").val(txt["cid_nome"]).change();
                $("#cid_nome").prop('readonly', true);
            }
        }
    });
}

function formCadastraAtendimentoMotivo(idCodigo, idDesc, idAlert) {
    $("body").append("<div id='dasam_formgm' title='Cadastro de Motivos.'></div>");
    $("#dasam_formgm")
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
    title='Carregando dados ...' />")
        .dialog({
            modal: true,
            resizable: true,
            closeOnEscape: false,
            position: ['top', 'center'],
            width: 500,
            height: 380
        })
        .load(baseUrl + "/atendimentocras/atendimentomotivo/form-cadastro-motivo");
}

function maiuscula(z) {
    v = z.value.toUpperCase();
    z.value = v;
}

function validaForm(formId, event) {
    event.preventDefault();
    var fail = false;
    $('#' + formId).find('select, textarea, input').each(function () {
        $(this).tooltip({
            items: "[title]",
            position: {
                my: "right top",
                at: "right-5 top-20",
                collision: "none"
            }
        });
        if ($(this).prop('required')) {
            if (!$(this).val()) {
                fail = true;
                name = jQuery("label[for=" + $(this).attr('id') + "]").text();

                $(this).css('border', '1px solid red');
                $(this).attr("title", "Campo Obrigatório");
                $(this).tooltip("open");
                setTimeout(function (propertyName) {
                    $(propertyName).tooltip("close");
                }.bind(this, $(this)), 2000);

            } else {
                $(this).tooltip("close");
                $(this).css('border', '1px solid #cccccc');
            }
        }
    });

    if (fail) {
        return false;
    }
    return true;
}

function limpaObrigatorio() {
    $(this).find('select, textarea, input').each(function () {
        $(this).tooltip("close");
    });
}

function novoEditarBairro() {
    if ($('#bai_nome').val() === '') {
        $('#bai_codigo').val('');
        $('#localidade').val('');
    }
}

function abrirModal(idComp, url, width) {
    var w = (width ? width : '50%');
    $("#" + idComp)
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
            title='Carregando dados ...' />")
        .dialog({
            modal: true,
            height: '90%',
            maxHeight: '200px',
            width: w,
            minWidth: '550px',
            position: 'top+29',
            closeOnEscape: false,
            buttons: {
                Cancel: {
                    click: function () {
                        $(this).remove();
                    },
                    text: "Cancelar",
                    class: 'btn btn-warning btn-large'
                },
                'Salvar': {
                    click: formSalvar,
                    text: "Salvar",
                    id: 'btnSalvar',
                    class: 'btn btn-success btn-large'
                }
            },
            open: function () {
                $('.ui-dialog-buttonpane').find('button:contains("Cancel")')
                    .html("<i class='fa fa-close'></i> Cancelar");
                $('.ui-dialog-buttonpane').find('button:contains("Salvar")')
                    .html("<i class='fa fa-save'></i> Salvar");
            },
            close: function () {
                limpaObrigatorio();
                $(this).remove();
            }
        })
        .load(url);
}

function abrirModalAcao(idComp, url, action) {
    $("#" + idComp)
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
            title='Carregando dados ...' />")
        .dialog({
            modal: true,
            height: '90%',
            maxHeight: '200px',
            width: '50%',
            minWidth: '550px',
            position: 'top+29',
            closeOnEscape: false,
            buttons: {
                Cancel: {
                    click: function () {
                        $(this).remove();
                    },
                    text: "Cancelar",
                    class: 'btn btn-warning btn-large'
                },
                'Salvar': {
                    click: action,
                    text: "Salvar",
                    id: 'btnSalvar',
                    class: 'btn btn-success btn-large'
                }
            },
            open: function () {
                $('.ui-dialog-buttonpane').find('button:contains("Cancel")')
                    .html("<i class='fa fa-close'></i> Cancelar");
                $('.ui-dialog-buttonpane').find('button:contains("Salvar")')
                    .html("<i class='fa fa-save'></i> Salvar");
            },
            close: function () {
                limpaObrigatorio();
                $(this).remove();
            }
        })
        .load(url);
}

function abrirModalParalelo(idComp, url, funcaoSalvar) {
    $("#" + idComp)
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
            title='Carregando dados ...' />")
        .dialog({
            modal: true,
            height: '90%',
            maxHeight: '200px',
            width: '50%',
            minWidth: '550px',
            position: 'right-20 top+29',
            autoOpen: true,
            closeOnEscape: false,
            buttons: {
                Cancel: {
                    click: function () {
                        $(this).remove();
                    },
                    text: "Cancelar",
                    class: 'btn btn-warning btn-large'
                },
                'Salvar': {
                    click: funcaoSalvar,
                    text: "Salvar",
                    id: 'btnSalvar',
                    class: 'btn btn-success btn-large'
                }
            },
            open: function () {
                $('.ui-dialog-buttonpane').find('button:contains("Cancel")')
                    .html("<i class='fa fa-close'></i> Cancelar");
                $('.ui-dialog-buttonpane').find('button:contains("Salvar")')
                    .html("<i class='fa fa-save'></i> Salvar");
            },
            close: function () {
                limpaObrigatorio();
                $(this).remove();
            }
        })
        .load(url);
}

function informaSn(e, idNum) {
    var tipo = ($(e).attr("checked") == "checked" ? 'text' : 'number');
    var texto = ($(e).attr("checked") == "checked" ? 'S/N' : '');

    $("#" + idNum).prop("type", tipo);
    $("#" + idNum).prop("readonly", $(e).attr("checked") == "checked");
    $("#" + idNum).val(texto);

}

function aplicaMascaraCPF(cpf) {
    if (cpf !== null && cpf !== "" && cpf !== undefined) {
        cpf = cpf.replace(/\D/g, "")
        cpf = cpf.replace(/(\d{3})(\d)/, "$1.$2")
        cpf = cpf.replace(/(\d{3})(\d)/, "$1.$2")
        cpf = cpf.replace(/(\d{3})(\d{1,2})$/, "$1-$2")
    }
    return cpf;
}

function formataUrl(url) {
    return url.replace(/ /g, '+');
}

function formataDataBD(date) {
    if (date != "") {
        var split = date.split("/");
        return split[2] + "-" + split[1] + "-" + split[0]
    }
    return "";
}

function callGenerateReport(url, formulario) {
    mensagemSemOk("gerando-relatorio", "Aguarde...", "Gerando o relatório...", 280, 80);
    var baseComum = baseUrl + "/../../WebSocialComum/reportApi/report/removeArquivo.php";
    $.ajax({
        url: url,
        data: formulario,
        async: false,
        success: function (txt) {
            fecharMensagemSemOk("gerando-relatorio");
            if (!txt.status) {
                mensagem("Erro", txt.mensagem, 300, 150);
            } else {
                var open = window.open(txt.mensagem, "self");
                if (open) {
                    setTimeout(function () {
                        $.ajax({
                            url: baseComum + "?arquivo=" + txt.filename,
                            success: function (data) {
                                console.log(data);
                            }
                        });
                    }, 1500);
                }
            }
        }
    });
}

function validaNIS() {

    var nis = $('#usu_nis').val();

    if (nis != "") {

        var p1 = nis[0];
        var p2 = nis[1];
        var p3 = nis[2];
        var p4 = nis[3];
        var p5 = nis[4];
        var p6 = nis[5];
        var p7 = nis[6];
        var p8 = nis[7];
        var p9 = nis[8];
        var p10 = nis[9];
        var p11 = nis[10];

        var cd = p1 * 3 + p2 * 2 + p3 * 9 + p4 * 8 + p5 * 7 + p6 * 6 + p7 * 5 + p8 * 4 + p9 * 3 + p10 * 2;
        var dv = 11 - (cd % 11);
        if (dv > 9) {
            dv = 0;
        }
        if (dv == p11) {
            $('#alert-nis').hide();
            return true;
        } else {
            $('#alert-nis').show();
            return false;
        }
    }
    return true;
}

function verificaObito() {
    var obito = $('#usu_obito:checked').val();
    if (obito == "t") {
        $('#data_obito').show();
    } else {
        $('#data_obito').hide();
        $('#usu_dt_obito').val("");

    }
}

function voltar(url) {
    window.location.replace(baseUrl + url);
}


function buscaCargo() {
    var usr_codigo = $("#usr_codigo").val();
    $.ajax({
        url: baseUrl + '/default/cargos/get-cargo-por-profissional',
        data: {usr_codigo: usr_codigo},
        success: function (txt) {
            $("#crg_codigo").val(txt["crg_codigo"]);
            $("#crg_nome").val(txt["crg_nome"]);
        }
    });
}