const TIME_MODAL = 800;

$(document).ready(function () {
    setTimeout(function () {
        fechaMenus();
        limpaCampos();
        $('#dp_usu_nome').focus();
        //setaNumProntuarioDisponivel();
        $("#box_situacao").hide();
    }, 150);
});

/*-------------------------------------------------------
 * DADOS PRONTUÁRIO
 *-------------------------------------------------------*/

function validaRuaExiste() {
    $.ajax({
        url: baseUrl + "/default/rua/valida-rua-existe",
        type: "POST",
        data: {
            asps_codigo: $('#dp_asps_codigo').val(),
            asps_situacao: $("#situacao option:selected").val(),
            asps_num_habitacional: $("#dp_asps_num_prontuario").val()
        },
        success: function (txt) {
            //TODO SITUACAO selecionar
            $("#situacao").val(txt).find("option[value=" + txt + "]").attr('selected', true);
            $("#box_situacao").show();
        }
    });
};

function haDeficiencia() {
    if ($("#dceas_assofa_ha_membro_deficiencia:checked").val() == 'S') {
        $(".dceas_assofa_deficiencia").removeAttr("disabled");
    } else {
        $(".dceas_assofa_deficiencia").attr("disabled", true);
    }
}

function haAdaptacaoImovel() {
    if ($("#dceas_assofa_imovel_necessita_adaptacao:checked").val() == 'S') {
        $(".dceas_assofa_tipo_adaptacao").removeAttr("disabled");
    } else {
        $(".dceas_assofa_tipo_adaptacao").attr("disabled", true);
    }
}

// Limpando campos e ativando botões por causa do cache
function limpaCampos() {
    $("#dp_usu_codigo_ate").attr("enabled", true);
    $('#dp_usu_nome').attr("enabled", true);
    $('#dp_uni_desc').attr("enabled", true);
    $('#dp_asps_num_prontuario').attr("enabled", true);
    $("#dp_btn_carPront").attr("enabled", true);
    $("#dp_btn_cidn").attr("enabled", true);
    $("#dp_btn_unin").attr("enabled", true);
    $('#dp_usu_nome').val("");
    $('#dp_uni_desc').val("");
    $('#dp_asps_num_prontuario').val("");
    $("#dp_form input[type='text']").each(function () {
        $(this).val("");
    });

}

// function validaNomeProntuario(){
//     $.ajax({
//         url: baseUrl+"/habitacional/familia/valida-nome-prontuario",
//         type: "POST",
//         data: {
//             usu_codigo: $("#dp_usu_codigo").val(),
//             usu_nome: $("#dp_usu_nome").val(),
//         },
//         success:function(txt){
//             // Se nome e usuário conferem, entra aqui
//             if (txt>0){
//                 // Se número prontuario suas diferente de vazio, carrega tudo
//             // Remove todos os dados
//             } else {
//                 $("#dpalert_num_pront").hide();
//             }
//         }
//     });
// }

function validaNumProntuario(asps_num_prontuario) {
    $.ajax({
        url: baseUrl + "/habitacional/familia/valida-num-prontuario",
        type: "POST",
        data: {num_prontuario: $("#dp_asps_num_prontuario").val()},
        success: function (txt) {
            if (txt > 0) {
                $("#dp_asps_num_prontuario").val("");
                $("#dpalert_num_pront").show();
            } else {
                $("#dpalert_num_pront").hide();
            }
        }
    });
}

function editarUnidade() {
    $("#dp_uni_desc").attr("readonly", false);
    $("#dp_uni_desc").attr("required", true);
    $("label[for='dp_uni_desc']").addClass("obrigatorio");
    $("#dp_uni_codigo").val('');
    $("#dp_uni_desc").val('');
    $("#dp_btn_carPront")
        .html("<i class='fa fa-save'></i> Salvar Prontuário");
    buscaUnidade();
}

function formDadosFamiliaNovo() {
    setTimeout(function () {
        $("#dp_asps_codigo").val("");
        $("#dp_busca_dados_familia").remove();
        $("#dp_form_dados_familia").load(baseUrl + '/habitacional/familia/form-dados-familia-novo/');
        setaNumProntuarioDisponivel();
    }, 300);
}

function editaUnidade() {
    var aspsuni_codigo = $("#aspsuni_codigo").val();
    var uni_codigo_antes = $("#dp_uni_codigo_compare").val();
    var uni_codigo_atual = $("#dp_uni_codigo").val();
    var asps_codigo = $("#dp_asps_codigo").val();

    $.ajax({
        url: baseUrl + '/habitacional/familia/edita-unidade',
        type: "POST",
        data: {
            aspsuni_codigo: aspsuni_codigo,
            uni_codigo_antes: uni_codigo_antes,
            uni_codigo_atual: uni_codigo_atual,
            asps_codigo: asps_codigo
        },
        success: function (txt) {
        if(txt.success){
            return true;
        }
        return false;
        }
    });
}


function gerarComprovante(e) {
    var codigoAsps = $("#dp_asps_codigo").val();
    var codigoUsu = $("#dp_usu_codigo").val();
    e.preventDefault();
    popup(
        baseUrl.replace("zf", "") + "PHPJasperXML/comprovante-habitacional/ComprovanteHabitacional.php?codigo=" + codigoAsps + "&usucodigo=" + codigoUsu,
        "login", screen.width, screen.height
    );
}


function carregaProntuario(e) {
    if (validaForm('dp_form', e)) {
        e.preventDefault();

        $("#dp_btn_carComprovante").show();
        console.log($("#dp_uni_codigo_compare").val());

        if ($("#dp_uni_codigo_compare").val() != $("#dp_uni_codigo").val() && $("#dp_uni_codigo").val() != "" && $("#dp_uni_codigo_compare").val() !="") {
            editaUnidade();
            
        }
        var asps_codigo = $("#dp_asps_codigo").val();
        var desAte = "CADASTRAMENTO/ATUALIZAÇÃO CADASTRAL";
        if (asps_codigo != "") {
            mensagemSemOk("dp_carrega_pront", "Confirmação", "Carregando Prontuário ...", 250, 150);
            setTimeout(function () {
                /* CARREGA DADOS DO PRONTUÁRIO */
                desabilitaBuscaProntuario();
                validaMenus(asps_codigo);
                /* SALVA REGISTRO DE ATENDIMENTO SIMPLIFICADO */
                salvaRegistroAtendimentoSimplificado(desAte, asps_codigo, '4');
                fecharMensagemSemOk("dp_carrega_pront");
            }, 300);
        } else {
            /* SALVA NOVO PRONTUÁRIO */
            mensagemSemOk("dp_carrega_pront", "Confirmação",
                "Iniciando Prontuário ...", 250, 150);
            /* VALIDA SE NÚMERO PRONTUÁRIO JÁ EXISTE */
            $.ajax({
                url: baseUrl + "/habitacional/familia/valida-num-prontuario",
                type: "POST",
                data: {num_prontuario: $("#dp_asps_num_prontuario").val()},
                success: function (txt) {
                    if (txt > 0) {
                        var erro = "Erro! Número de prontuário já existe!";
                        $("#dpalert_form").html(erro);
                        $("#dpalert_form").show();
                    } else {
                        var valoresForm = $("#dp_form").serialize();
                        $.ajax({
                            url: baseUrl + '/habitacional/familia/carrega-prontuario',
                            type: "POST",
                            data: valoresForm,
                            success: function (txt) {
                                setTimeout(function () {
                                    if (txt > 0) {
                                        $("#dp_asps_codigo").val(txt);
                                        desabilitaBuscaProntuario();
                                        validaMenus(txt);
                                        /* SALVA REGISTRO DE ATENDIMENTO SIMPLIFICADO */
                                        salvaRegistroAtendimentoSimplificado(desAte, txt, '4');
                                        fecharMensagemSemOk("dp_carrega_pront");
                                    } else {
                                        $("#dpalert_form").html(txt);
                                        $("#dpalert_form").show();
                                    }
                                }, 300);
                            }
                        });
                    }
                }
            });
        }

    } else {
        e.preventDefault();
        return false;
    }
}

function atualizaSituacao() {
    $.ajax({
        url: baseUrl + "/habitacional/familia/grava-situacao",
        type: "POST",
        data: {
            asps_codigo: $('#dp_asps_codigo').val(),

            asps_situacao: $("#situacao option:selected").val(),
            asps_num_habitacional: $("#dp_asps_num_prontuario").val()
        },
        success: function (txt) {
            //TODO SITUACAO selecionar
            $("#situacao").val(txt).find("option[value=" + txt + "]").attr('selected', true);
            $("#box_situacao").show();
        }
    });
}

function salvaRegistroAtendimentoSimplificado(desAte, asps_codigo, codigo) {
    //desativaMembrosCidadao();
    $.ajax({
        url: baseUrl + "/habitacional/familia/salva-registro-atendimento-simplificado",
        type: "POST",
        data: {
            asps_codigo: asps_codigo,
            usr_codigo: $("#dp_usr_codigo").val(),
            usu_codigo_ref: $("#dp_usu_codigo").val(),
            usu_codigo: $("#dp_usu_codigo_ate").val(),
            aspsrs_descricao: desAte,
            aspsrs_codigo_desc: codigo,
        },
        success: function (txt) {
        }
    });
}

function desabilitaBuscaProntuario() {
    // Ocultando erro se ocorreu
    $("#dpalert_form").hide();
    $("#dpalert_usu_nome").hide();
    $("#dpalert_num_pront").hide();
    $("#dpalert_uni_desc").hide();
    // Desabilitando campos de busca do prontuário
    $('#dp_usu_nome').attr("disabled", true);
    $('#dp_uni_desc').attr("disabled", true);
    $('#dp_asps_num_prontuario').attr("disabled", true);
    $("#dp_btn_carPront").attr("disabled", true);
    $("#dp_usu_codigo_ate").attr("disabled", true);
    $("#dp_btn_carPront").removeAttr("onclick");
    $("#dp_btn_cidn").attr("disabled", true);
    $("#dp_btn_cidn").removeAttr("onclick");
    $("#dp_btn_unin").attr("disabled", true);
    $("#dp_btn_unin").removeAttr("onclick");
    $("#db_btn_edit_uni").attr("disabled", true);
    $("#db_btn_edit_uni").removeAttr("onclick");
}

function setaNumProntuarioDisponivel() {
    setTimeout(function () {
        $.ajax({
            url: baseUrl + "/habitacional/familia/seta-num-prontuario-disp",
            type: "POST",
            success: function (txt) {
                $("#dp_asps_num_prontuario").val(txt);
            }
        });
    }, 400);
}

/*-------------------------------------------------------
 * MENUS
 *-------------------------------------------------------*/

function abreFechaMenu(opcao) {
    //if (opcao==0){ $("#dados_prontuario").toggle("slow"); } else { $("#dados_prontuario").slideUp(); }
    if (opcao == 1) {
        $("#end_familia").toggle("slow");
    } else {
        $("#end_familia").slideUp();
    }
    if (opcao == 2) {
        $("#prim_atendimento").toggle("slow");
    } else {
        $("#prim_atendimento").slideUp();
    }
    if (opcao == 3) {
        $("#comp_familia").toggle("slow");
    } else {
        $("#comp_familia").slideUp();
    }
    if (opcao == 4) {
        $("#cond_habitacionais").toggle("slow");
    } else {
        $("#cond_habitacionais").slideUp();
    }
    if (opcao == 5) {
        $("#cond_educacionais").toggle("slow");
    } else {
        $("#cond_educacionais").slideUp();
    }
    if (opcao == 6) {
        $("#cond_trabalho").toggle("slow");
    } else {
        $("#cond_trabalho").slideUp();
    }
    if (opcao == 7) {
        $("#cond_saude").toggle("slow");
    } else {
        $("#cond_saude").slideUp();
    }
    if (opcao == 8) {
        $("#conv_familiar").toggle("slow");
    } else {
        $("#conv_familiar").slideUp();
    }
    if (opcao == 9) {
        $("#sit_violacoes").toggle("slow");
    } else {
        $("#sit_violacoes").slideUp();
    }
    if (opcao == 10) {
        $("#hist_acolhimento").toggle("slow");
    } else {
        $("#hist_acolhimento").slideUp();
    }
    if (opcao == 11) {
        $("#med_socioeducativa").toggle("slow");
    } else {
        $("#med_socioeducativa").slideUp();
    }
    if (opcao == 12) {
        $("#end_condicao_moradia_atual").toggle("slow");
    } else {
        $("#end_condicao_moradia_atual").slideUp();
    }
    if (opcao == 13) {
        $("#end_procedencia").toggle("slow");
    } else {
        $("#end_procedencia").slideUp();
    }
    if (opcao == 14) {
        $("#end_aspectos_sociais_familia").toggle("slow");
    } else {
        $("#end_aspectos_sociais_familia").slideUp();
    }
    if (opcao == 15) {
        $("#end_composicao_familia").toggle("slow");
    } else {
        $("#end_composicao_familia").slideUp();
    }

}

function fechaMenus() {
    $("#box_end_familia").hide();
    $("#end_familia").hide();
    $("#box_comp_familia").hide();
    $("#comp_familia").hide();
    $("#box_prim_atendimento").hide();
    $("#prim_atendimento").hide();
    $("#dp_usu_nome").focus();
    $("#box_cond_habitacionais").hide();
    $("#cond_habitacionais").hide();
    $("#box_cond_educacionais").hide();
    $("#cond_educacionais").hide();
    $("#box_cond_trabalho").hide();
    $("#cond_trabalho").hide();
    $("#box_cond_saude").hide();
    $("#cond_saude").hide();
    $("#box_conv_familiar").hide();
    $("#conv_familiar").hide();
    $("#box_sit_violacoes").hide();
    $("#sit_violacoes").hide();
    $("#box_hist_acolhimento").hide();
    $("#hist_acolhimento").hide();
    $("#box_med_socioeducativa").hide();
    $("#med_socioeducativa").hide();
    $("#box_end_condicao_moradia_atual").hide();
    $("#box_end_procedencia").hide();
    $("#box_end_aspectos_sociais_familia").hide();
    $("#box_end_composicao_familia").hide();
    $("#end_condicao_moradia_atual").hide();
    $("#end_procedencia").hide();
    $("#end_aspectos_sociais_familia").hide();
    $("#end_composicao_familia").hide();

}

function fechaMenu(menu) {
    $("#" + menu).toggle("slow");
}

function sobeMenu(menu) {
    $("#" + menu).get(0).scrollIntoView();
}

function abreMenus() {
    $("#box_end_familia").show();
    $("#box_prim_atendimento").show();
    $("#box_comp_familia").show();
    $("#box_cond_habitacionais").show();
    $("#box_cond_educacionais").show();
    $("#box_cond_trabalho").show();
    $("#box_cond_saude").show();
    $("#box_conv_familiar").show();
    $("#box_sit_violacoes").show();
    $("#box_hist_acolhimento").show();
    $("#box_med_socioeducativa").show();
    $("#box_end_condicao_moradia_atual").show();
    $("#box_end_procedencia").show();
    $("#box_end_aspectos_sociais_familia").show();
    $("#box_end_composicao_familia").show();
}

function validaMenus(asps_codigo) {
    // Valida se os dados da pessoa de referência já foi preenchido
    $.ajax({
        url: baseUrl + '/habitacional/familia/valida-dados-pessoa-ref-familia',
        type: "POST",
        data: {asps_codigo: asps_codigo},
        success: function (txt) {
            if (txt > 0) {
                // Dados de referência preenchido, verifica primeiro atendimento
                $.ajax({
                    url: baseUrl + '/habitacional/familia/valida-primeiro-atendimento',
                    type: "POST",
                    data: {asps_codigo: asps_codigo},
                    success: function (txt2) {
                        if (txt2 > 0) {
                            abreMenus();
                        } else {
                            $("#box_end_familia").show();
                            primeiroAtendimento(asps_codigo);
                        }
                    }
                });
            } else {
                dadosPessoaRefFamilia(asps_codigo);
            }
        }
    });
}

/*-------------------------------------------------------
 * FIM MENUS
 *-------------------------------------------------------*/

/*-------------------------------------------------------
 * CIDADÃO
 *-------------------------------------------------------*/

function buscaCidadao() {
    //desativaMembrosCidadao();
    $("#dpalert_usu_nome").hide();
    $('#dp_usu_nome').autocomplete({
        source: baseUrl + '/cidadao/cidadao/busca/',
        minLength: 3,
        delay: 300,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#dp_usu_codigo").val(ui.item.id);
            $("#dp_usu_nome").val(ui.item.label);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li " + usuarioBloqueado(item.data.usu_bloqueado) + ">")
            .append("<a><strong>" + item.label + "</strong><br>\n\
                        <strong>Nº Pront. Suas: </strong>" + validaCampoEmBranco(item.data.asps_num_prontuario) + "<br>\n\
                        <strong>Cpf:</strong>\n\ " + validaCampoEmBranco(item.data.usu_cpf) + "\n\
                        <strong>NIS:</strong>\n\ " + validaCampoEmBranco(item.data.usu_nis) + "<br>\n\
                        <strong>Mãe: </strong>" + validaCampoEmBranco(item.data.usu_mae) + " \n\
                        <strong>Data Nasc: </strong>" + dataToBrHiffen(item.data.usu_datanasc) + "<br>\n\
                     </a><br>"
                   ).appendTo(ul);
    }
}

function usuarioBloqueado(bloqueado) {
  return bloqueado ? "style='color: red'" : "";
}

function buscaDadosReferencia() {
    //var options = jQuery.extend(options, opcoes);
    $('#dp_usu_nome_busca').autocomplete({
        source: baseUrl + '/cidadao/cidadao/busca-dados-cidadao-ref/',
        //minLength: 3,
        delay: 300,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#dp_busca_dados_familia").remove();
            var asps_codigo = ui.item.data.asps_codigo;
            var usu_codigo = ui.item.id;
            $("#dp_asps_codigo").val(asps_codigo);
            $("#dp_usu_codigo").val(usu_codigo);
            $("#dp_uni_codigo").val(ui.item.data.uni_codigo);
            $("#dp_form_dados_familia").load(
                baseUrl + '/habitacional/familia/form-dados-familia-preenchido/asps_codigo/' + asps_codigo + '/usu_codigo/' + usu_codigo);
            carregaMembrosDaFamilia(ui.item.data.asps_codigo);
            setaNumProntuarioDisponivel();

            $("#dp_btn_carComprovante").hide();

            $.ajax({
                url: baseUrl + "/habitacional/familia/recupera-situacao",
                type: "POST",
                data: {
                    codigo: asps_codigo
                },
                success: function (txt) {
                    //TODO SITUACAO selecionar
                    $("#situacao").val(txt).find("option[value=" + txt + "]").attr('selected', true);
                    $("#box_situacao").show();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log("asps_codigo=" + asps_codigo);
                }
            });

            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li>")
            .append("<a><strong>" + item.label + "</strong><br>\n\
                        <strong>CPF: </strong>\n\
                        " + validaCampoEmBranco(aplicaMascaraCPF(item.data.usu_cpf)) + "<br>\n\
                        <strong>Mãe: </strong>" + validaCampoEmBranco(item.data.usu_mae) + " \n\
                        <strong>Data Nasc: </strong>"
                + dataToBrHiffen(item.data.usu_datanasc) + "<br>\n\
                        <strong>Nº Prontuario: </strong>\n\
                        " + validaCampoEmBranco(item.data.asps_num_prontuario) + "\n\
                        <strong>Parentesco: </strong>\n\
                        " + validaCampoEmBranco(item.data.aspsu_num_ordem) + "<br>\n\
                        <strong>Unidade: </strong>\n\
                        " + validaCampoEmBranco(item.data.uni_desc) + "<br>\n\
                        </a><br>").appendTo(ul);
    }
}


function cadastroCidadao() {
    $("body").append("<div id='dc_form_cadastrom' title='Cadastro de cidadão' ></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dc_form_cadastrom',
            baseUrl + "/cidadao/cidadao/form-cadastro",
            cadastroCidadaoSalvar
        );
    }, TIME_MODAL);
}

function cadastroCidadaoSalvar(e) {
    if (validaForm('dc_form_cadastro', e)) {
        // Corta o Submit e deixa o jQuery trabalhar
        e.preventDefault();
        mensagemSemOk("dp_salvar_cidadao", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dc_form_cadastro").serialize();
        $.ajax({
            url: baseUrl + '/cidadao/cidadao/form-cadastro-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    $("#dpalert_usu_nome").hide();
                    $("#dp_usu_nome").val($("#dc_usu_nome").val());
                    $("#dp_usu_codigo").val(txt);
                    $("#dc_form_cadastrom").dialog("destroy").remove();
                    //fecharModal('dc_form_cadastrom');
                    fecharMensagemSemOk("dp_salvar_cidadao");
                    mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function validaNomeReferencia() {
    $.ajax({
        url: baseUrl + "/cidadao/cidadao/get-dados-nome",
        type: "POST",
        data: {usu_nome: $("#dp_usu_nome").val()},
        success: function (txt) {
            if (txt > 0) {
                $("#dp_usu_codigo").val(txt);
                $("#dpalert_usu_nome").hide();
            } else {
                $("#dp_usu_codigo").val("");
                $("#dp_usu_nome").val("");
                $("#dpalert_usu_nome").show();
            }
        }
    });
}

function validaNomeReferenciaModal() {
    $.ajax({
        url: baseUrl + "/cidadao/cidadao/valida-nome",
        type: "POST",
        data: {usu_nome: $("#usu_nome").val()},
        success: function (txt) {
            if (txt == "nome-erro") {
                //$("#alert-nome").val("");
                //$("#alert-nome").focus();
                $("#alert-nome").show();
            } else {
                $("#alert-nome").hide();
            }
        }
    });
}

function carregaMembrosDaFamilia(asps_codigo) {
    mensagemSemOk("dp_car_membros", "Carregando", "Carregando dados ...", 250, 150);
    $.ajax({
        url: baseUrl + "/habitacional/familia/carrega-membros-familia",
        type: "POST",
        data: {asps_codigo: asps_codigo},
        success: function (txt) {
            $("#dp_familia").show();
            $("#dp_select_familia").append(txt);
            fecharMensagemSemOk("dp_car_membros");
        }
    });
}

/*-------------------------------------------------------
 * FIM MODÚLO CIDADAO
 *-------------------------------------------------------*/

/*-------------------------------------------------------
 * UNIDADE
 *-------------------------------------------------------*/

function buscaUnidade() {
    //Validação pra caso escolha uma unidade, mude e não sete uma nova
    $("#dp_uni_codigo").val("");
    $("#dpalert_uni_desc").hide();

    $('#dp_uni_desc').autocomplete({
        source: baseUrl + '/default/unidade/busca-unidade/',
        minLength: 3,
        delay: 300,
        limit: 12,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#dp_uni_codigo").val(ui.item.id);
            $("#dp_uni_desc").val(ui.item.label);
            //validaCadastroUnidade($("#dp_uni_codigo").val());

          //  alteraCadastroUnidade($("#dp_asps_codigo").val(), $("#dp_uni_codigo").val());

            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li>")
            .append("<a><strong>" + item.label + "</strong><br>\n\
                        <strong>Nº da Unidade: </strong>"
                + validaCampoEmBranco(item.data.uni_asnumero) + " \n\
                        <strong>Tipo de Unidade: </strong>"
                + validaCampoEmBranco(item.data.uni_astipo) + "<br></a>")
            .appendTo(ul);
    }
}

function validaCadastroUnidade(uniCodigo) {
    console.log('uniCodigo=' + uniCodigo);
    $.ajax({
        url: baseUrl + '/default/unidade/valida-cadastro',
        type: "POST",
        data: {uni_codigo: uniCodigo},
        success: function (txt) {
            // Se retorna maior que 0, cadastro imcompleto, atualizar
            if (txt > 0) {
                // Validando campos, para que forçe sempre a atualizar
                $("#dp_uni_codigo").val("");
                $("#dp_uni_desc").val("");
                // Edição dos dados
                $("body").append("<div id='du_form_resumido_mv' \n\
                    title='Erro!! Cadastro de Unidade imcompleto, atualize os dados.'></div>");
                $("#du_form_resumido_mv")
                    .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
                        title='Carregando dados ...' />")
                    .dialog({
                        modal: false,
                        width: 710,
                        height: 380
                    })
                    .load(baseUrl + "/default/unidade/form-cadastro-resumido/uni_codigo/" + uniCodigo);
            }
        }
    })
}

function alteraCadastroUnidade(dp_asps_codigo, dp_uni_codigo) {
    console.log(baseUrl + "/default/unidade/altera-unidade-suas");
    $.ajax({
        url: baseUrl + "/default/unidade/altera-unidade-suas",
        type: "POST",
        data: {
            uni_codigo: dp_uni_codigo,
            asps_codigo: dp_asps_codigo
        },
        success: function (txt) {
        }
    });
}

function validaNomeUnidade() {
    $.ajax({
        url: baseUrl + "/default/unidade/valida-nome",
        type: "POST",
        data: {uni_desc: $("#dp_uni_desc").val(), uni_codigo:$('#dp_uni_codigo').val()},
        success: function (txt) {
            if (txt == 0) {
                $("#dp_uni_desc").val("");
                $("#dp_uni_codigo").val("");
                $("#dpalert_uni_desc").show();
            } else {
                $("#dpalert_uni_desc").hide();
            }
        }
    });
}

function validaNomeUnidadeModal() {
    $.ajax({
        url: baseUrl + "/default/unidade/valida-nome",
        type: "POST",
        data: {uni_desc: $("#du_uni_desc").val()},
        success: function (txt) {
            if (txt > 0) {
                $("#du_uni_desc").val("");
                $("#dualert_uni_desc").show();
            } else {
                $("#dualert_uni_desc").hide();
            }
        }
    });
}

/*-------------------------------------------------------
 * FIM MODÚLO UNIDADE
 *-------------------------------------------------------*/

/*-------------------------------------------------------
 * FIM DADOS PRONTUÁRIO
 *-------------------------------------------------------*/

/*-------------------------------------------------------------
 * IDENTIFICAÇÃO PESSOA DE REFERÊNCIA E ENDEREÇO DA DAMÍLIA
 *------------------------------------------------------------*/

function semNumero() {
    if ($('#dom_sn').is(":checked")) {
        $("#def_num").val("S/N");
        $("#dom_sn").attr('checked', true); // Deprecated
        $("#dom_sn").prop('checked', true);
        abreModalDomicilios();
    } else {
        $("#def_num").attr("readonly", false);
        $("#def_num").val("");
    }
}

function dadosPessoaRefFamilia(asps_codigo) {
    $("#box_end_familia").show();
    abreFechaMenu(1);
    //$('#end_familia').get(0).scrollIntoView();
    $('html, body').animate({scrollTop: $('#box_end_familia').offset().top}, 'slow');
    $("#end_familia").load(
        baseUrl + '/habitacional/familia/dados-pessoa-ref-familia/asps_codigo/' + asps_codigo);
}

function procedencia(asps_codigo) {
    $("#box_end_procedencia").show();
    abreFechaMenu(13);
    //$('#end_familia').get(0).scrollIntoView();
    $('html, body').animate({scrollTop: $('#box_end_procedencia').offset().top}, 'slow');
    $("#end_procedencia").load(
        baseUrl + '/habitacional/familia/form-procedencia/asps_codigo/' + asps_codigo);
}

function formCondicaoMoradiaAtual(asps_codigo) {
    $("#box_end_condicao_moradia_atual").show();
    abreFechaMenu(12);
    //$('#end_familia').get(0).scrollIntoView();
    $('html, body').animate({scrollTop: $('#box_end_condicao_moradia_atual').offset().top}, 'slow');
    $("#end_condicao_moradia_atual").load(
        baseUrl + '/habitacional/familia/form-condicao-moradia-atual/asps_codigo/' + asps_codigo);
}

function formCondicaoMoradiaAtualSalvar(e) {
    var tamDeficiencia = $("#conmoratu_situacao_propriedade:checked").length;
    if (validaForm('dce_form_cad_moradia', e) && tamDeficiencia > 0) {
        e.preventDefault();
        mensagemSemOk("dcf_form_cad_moradia", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicao-moradia-atual-salvar',
            type: "POST",
            data: {
                "asps_codigo": $("#dp_asps_codigo").val(),
                "conmoratu_situacao_propriedade": $("#conmoratu_situacao_propriedade:checked").val(),
                "conmoratu_situacao_propriedade_valor": $("#conmoratu_situacao_propriedade_valor").val(),
                "conmoratu_situacao_propriedade_quem": $("#conmoratu_situacao_propriedade_quem").val(),
                "conmoratu_qtos_comodos_sala": $("#conmoratu_qtos_comodos_sala").val(),
                "conmoratu_qtos_comodos_cozinha": $("#conmoratu_qtos_comodos_cozinha").val(),
                "conmoratu_qtos_comodos_quartos": $("#conmoratu_qtos_comodos_quartos").val(),
                "conmoratu_qtos_comodos_banheiro": $("#conmoratu_qtos_comodos_banheiro").val(),
                "conmoratu_tempo_residencia_atual": $("#conmoratu_tempo_residencia_atual_ano").val() + "_" + $("#conmoratu_tempo_residencia_atual_mes").val()
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcfalert_cad_moradia").html(txt);
                        $("#dcfalert_cad_moradia").show(txt);
                        $('#dados_cad_aspectos_sociais_familia').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcf_salvar_moradia");
                    } else {
                        $("#dcf_form_cad_moradia").dialog("destroy").remove();
                        //fecharModal('dcf_form_cad_familiarm');
                        fecharMensagemSemOk("dcf_salvar_moradia");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        formCondicaoMoradiaAtual($("#dp_asps_codigo").val());
                    }
                }, 900);
            }
        });
    } else {
        return false;
    }
}

function aspectosSociaisFamilia(asps_codigo) {
    $("#box_end_aspectos_sociais_familia").show();
    abreFechaMenu(14);
    //$('#end_familia').get(0).scrollIntoView();
    $('html, body').animate({scrollTop: $('#box_end_aspectos_sociais_familia').offset().top}, 'slow');
    $("#end_aspectos_sociais_familia").load(
        baseUrl + '/habitacional/familia/form-aspectos-sociais-familia/asps_codigo/' + asps_codigo);
}

function dadosPessoaRefFamilia(asps_codigo) {
    $("#box_end_familia").show();
    abreFechaMenu(1);
    //$('#end_familia').get(0).scrollIntoView();
    $('html, body').animate({scrollTop: $('#box_end_familia').offset().top}, 'slow');
    $("#end_familia").load(
        baseUrl + '/habitacional/familia/dados-pessoa-ref-familia/asps_codigo/' + asps_codigo);
}

function salvarDadosPessoaRefFamilia(e) {
    var usu_codigo = $("#def_usu_codigo").val();
    var usu_nome = $("#def_usu_nome").val();
    var rua_codigo = $("#def_rua_codigo").val();
    var dom_num = ($("#def_num").val() == 'S/N' ? 0 : $("#def_num").val());
    var dom_compl = $("#dom_complemento").val();

    if (!validaNIS()) {
        e.preventDefault();
        mensagem("Atenção", "Numero de NIS informado é inválido!", 300, 150, function () {
            return false;
        });
        return false;
    }
    if (validaForm('dados_end_familia', e)) {
        e.preventDefault();
        var valoresForm = $("#dados_end_familia").serialize();

        $.ajax({
            url: baseUrl + '/domicilio/domicilio/verifica-domicilio-duplicado/rua_codigo/' + rua_codigo + "/dom_numero/" + dom_num + "/dom_compl/" + dom_compl,
            type: "GET",
            success: function (data) {
                if (data) {
                    if (data.usu_codigo_responsavel != null && data.usu_codigo_responsavel != usu_codigo) {
                        confirme(
                            "Atenção",
                            data.usu_nome + " é o atual responsável por este domicílio.\n Deseja alterar para " + usu_nome + "?",
                            400, 250,
                            function () {
                                salvaDados(valoresForm);
                            }
                        );
                    } else {
                        salvaDados(valoresForm);
                    }
                } else {
                    salvaDados(valoresForm);
                }
                ;
            }
        });
    } else {
        return false;
    }
}

function salvaDados(valoresForm) {
    mensagemSemOk("salvar_end_fam", "Confirmação", "Salvando dados ...", 250, 150);
    $.ajax({
        url: baseUrl + '/suas/familia/salvar-dados-pessoa-ref-familia',
        type: "POST",
        data: valoresForm,
        success: function (txt) {
            setTimeout(function () {
                if (txt > 0) {
                    $("#defalert_end_familia").hide();
                    $("#def_dom_codigo").val(txt);
                    fecharMensagemSemOk("salvar_end_fam");
                    mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                    validaMenus($("#dp_asps_codigo").val());
                    $("#dados_domicilio").find('select, textarea, input').each(function () {
                        $(this).attr("readonly", true);
                    });
                } else {
                    $("#defalert_end_familia").html(txt);
                    $("#defalert_end_familia").show();
                    $('#box_end_familia').get(0).scrollIntoView();
                    fecharMensagemSemOk("salvar_end_fam");
                }
                $("#btnEditar").attr("disabled", false);
            }, 500);
        }
    });
}

function formCadastraLogradouroFamilia(idCodigo, idDesc, idAlert) {
    $("body").append("<div id='dcb_form_log' title='Cadastro de Logradouro'></div>");
    var url = baseUrl + "/domicilio/logradouro/form-cadastro-geral/idCodigo/" + idCodigo + "/idDesc/" + idDesc + "/idAlert/" + idAlert;
    abrirModalParalelo("dcb_form_log", url, formCadastraLogradouroGeralFamiliaSalvar);
}

function formCadastraLogradouroGeralFamiliaSalvar(e) {
    var idCodigo = $("#dlog_idcodigo").val();
    var idDesc = $("#dlog_iddesc").val();
    var idAlert = $("#dlog_idalert").val();

    if (validaForm("dcb_form_cad_log", e)) {
        e.preventDefault();
        var valoresForm = $("#dcb_form_cad_log").serialize();
        mensagemSemOk("dcid_salvar_cg", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/domicilio/logradouro/form-cadastro-geral-salvar',
            type: "POST",
            data: valoresForm,
            success: function (response) {

                    if (response != undefined) {
                        fecharMensagemSemOk("dcid_salvar_cg");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 120, function () {
                            $("#dcb_form_log").dialog("destroy").remove();
                            $("#" + idCodigo).val(response.id);
                            $("#" + idDesc).val(response.label);
                            $("#" + idAlert).hide();

                            $("#def_rua_codigo").val(response.id);
                            $("#def_rua_nome").val(response.label);
                            $("#def_rua_cep").val(response.data.rua_cep);

                            $("#def_cid_codigo").val(response.data.cid_codigo);
                            $("#def_cid_nome").val(response.data.cid_nome);

                            $("#def_bai_codigo").val(response.data.bai_codigo);
                            $("#def_bairro_nome").val(response.data.bai_nome);

                            $("#def_uf_codigo").val(response.data.uf_codigo);
                            $("#def_uf_nome").val(response.data.uf_sigla);

                            editaDadosDomicilio(false, false);
                        });
                    } else {
                        $("#dcb_form_cad_log").html(response);
                        $("#dcb_form_cad_log").show(response);
                        fecharMensagemSemOk("dcid_salvar_cg");
                    }

            }
        });
    } else {
        return false;
    }
}

function buscaDadosEndereco() {
    $('#def_rua_nome').autocomplete({
        source: baseUrl + '/domicilio/logradouro/busca-dados-endereco/',
        minLength: 3,
        delay: 300,
        limit: 12,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#def_rua_codigo").val(ui.item.id);
            $("#def_rua_nome").val(ui.item.label);
            $("#def_rua_cep").val(ui.item.data.rua_cep);

            $("#def_cid_codigo").val(ui.item.data.cid_codigo);
            $("#def_cid_nome").val(ui.item.data.cid_nome);

            $("#def_bai_codigo").val(ui.item.data.bai_codigo);
            $("#def_bairro_nome").val(ui.item.data.bai_nome);

            $("#def_uf_codigo").val(ui.item.data.uf_codigo);
            $("#def_uf_nome").val(ui.item.data.uf_sigla);

            editaDadosDomicilio(false, false);
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li>")
            .append(
                "<a>"
                + "    <strong>" + item.label + " </strong> <br>"
                + "    <strong>Cep:      </strong> " + validaCampoEmBranco(item.data.rua_cep) + "<br>"
                + "    <strong>Bairro:   </strong> " + validaCampoEmBranco(item.data.bai_nome)
                + "    <strong>Distrito: </strong> " + validaCampoEmBranco(item.data.dis_nome) + "<br>"
                + "    <strong>Cidade:   </strong> " + validaCampoEmBranco(item.data.cid_nome)
                + "    <strong>Estado:   </strong> " + validaCampoEmBranco(item.data.uf_sigla) + "<br>"
                + "</a><br>"
            ).appendTo(ul);
    }
}

function abreModalDomicilios() {
    var ruaCod = $("#def_rua_codigo").val();
    var ruaNome = $("#def_rua_nome").val();
    var ruaCep = $("#def_rua_cep").val();
    var bairroNome = $("#def_bairro_nome").val();
    var domNumero = ($("#def_num").val() ? $("#def_num").val() : null);
    var domCompl = ($("#dom_complemento").val() ? $("#dom_complemento").val() : null);

    if (($("#def_num").attr('readonly') != 'readonly') || ($("#dom_complemento").attr('readonly') != 'readonly')) {
        if (domNumero != null || domCompl != null) {
            if (domNumero == 'S/N') {
                domNumero = '0';
            }
            var url = baseUrl + '/domicilio/domicilio/index'
                + '/rua_codigo/' + ruaCod
                + '/rua_cep/' + ruaCep
                + '/rua_bairro/' + bairroNome
                + '/dom_numero/' + domNumero
                + '/dom_compl/' + domCompl
                + '/rua_nome/' + ruaNome;
            $("body").append("<div id='dcb_form_dom' title='Domicílios Cadastrados'></div>");
            $("#dcb_form_dom")
                .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' \n\
        title='Carregando dados ...' />")
                .dialog({
                    modal: true,
                    height: '90%',
                    width: '80%',
                    minWidth: '550px',
                    position: 'right-50 top+2',
                    autoOpen: true,
                    closeOnEscape: false,
                    close: function () {
                        $(this).remove();
                    },
                    buttons: {
                        Close: {
                            click: function () {
                                editaDadosDomicilio(true, false);
                                $(this).remove();
                            },
                            text: 'Fechar',
                            class: 'btn btn-danger'
                        }
                    },
                    open: function () {
                        $('.ui-dialog-buttonpane').find('button:contains("Close")')
                            .html("<i class='fa fa-close'></i> Fechar");
                    },
                }).load(formataUrl(url));
        }
    }
}

function selecionaDomicilio(dom_codigo) {
    setTimeout(function () {
        $.ajax({
            url: baseUrl + '/domicilio/domicilio/pesquisa-domicilio-por-codigo/dom_codigo/' + dom_codigo,
            type: "GET",
            success: function (data) {
                $("#dcb_form_dom").dialog("destroy").remove();
                $("#def_dom_codigo").val(data.dom_codigo); //numero
                $("#def_num").val((data.dom_numero != 0 ? data.dom_numero : 'S/N')); //numero
                $("#dom_sn").attr("checked", (data.dom_numero == 0)); //sn
                $("#def_usu_codigo_responsavel").val(data.usu_codigo); //cod responsavel
                $("#def_usu_nome_responsavel").val(data.usu_nome); //nome responsavel
                $("#dom_complemento").val(data.dom_complemento); //complemento
                $("#dom_ponto_referencia").val(data.dom_ponto_referencia); //ponto referencia
                $("#dom_telefone").val(data.dom_telefone); //telefone domicilio
                $("#dom_as_localizacao").val(data.dom_as_localizacao); //localizacao
                $("#dom_as_abrigo").val(data.dom_as_abrigo == 1 ? 'T' : 'F'); //abrigo

                editaDadosDomicilio(false, false);

                $("#def_rua_nome").prop("readonly", true);
                $("#def_usu_nome_responsavel").prop("readonly", true);
                $("#def_num").attr("readonly", true);
                $("#dom_sn").attr("checked", true);
                $("#dom_sn").attr("readonly", true);
                $("#dom_complemento").prop("readonly", true);
                $("#dom_ponto_referencia").prop("readonly", true);
                $("#dom_telefone").prop("readonly", true);
                $("#dom_as_abrigo").prop("readonly", true);
                $("#novo_logradouro").prop("disabled", true);
            }
        });
    }, 500);
}

function alteraDadosDomicilio() {
    $("#btnEditar").prop("disabled", true);
    $("#novo_logradouro").prop("disabled", false);
    $("#dados_domicilio").find('select, textarea, input').each(function () {
        $(this).val("");
    });
    $("#def_rua_nome").prop("readonly", false);
    $("#dom_sn").prop("disabled", true);
    $("#dom_sn").attr("checked", false);
    $("#def_rua_nome").focus();
}

function editaDadosDomicilio(semNumero, editar) {
    $("#dados_domicilio").find('select, textarea, input').each(function () {
        if (this.id !== 'def_rua_nome' && this.id !== 'def_rua_cep' && this.id !== 'def_bairro_nome'
            && this.id !== 'def_cid_nome' && this.id !== 'def_uf_nome') {
            $(this).prop("readonly", false);
        }
    });

    $("#btnEditar").prop("disabled", true);
    $("#dom_sn").prop("disabled", false);
    $("#dom_sn").attr("checked", false);
    $("#def_num").attr("readonly", false);
    if ($("#def_num").val() == "S/N" && semNumero) {
        $("#def_num").attr("readonly", true);
        $("#dom_sn").attr("checked", true);
    }

    if (editar && $("#def_num").val() == "S/N") {
        $("#def_num").val("");
    }
}

/*-------------------------------------------------------------
 * FIM IDENTIFICAÇÃO PESSOA DE REFERÊNCIA E ENDEREÇO DA DAMÍLIA
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * PRIMEIRO ATENDIMENTO
 *------------------------------------------------------------*/

function primeiroAtendimento(asps_codigo) {
    $("#box_prim_atendimento").show();
    $('html, body').animate({scrollTop: $('#box_prim_atendimento').offset().top}, 'slow');
    abreFechaMenu(2);
    $("#prim_atendimento").load(
        baseUrl + '/habitacional/familia/primeiro-atendimento/asps_codigo/' + asps_codigo);
}

function primeiroAtendimentoSalvar(e) {
    if ($("#dpat_forma_acesso:checked").val() != "" && $("#dpat_aspt_razoes_necessidades").val() != "") {
        e.preventDefault();
        mensagemSemOk("dpat_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/primeiro-atendimento-salvar',
            type: "POST",
            data: {
                aspt_forma_acesso: $("#dpat_forma_acesso:checked").val(),
                aspt_encaminhamento: $("#dpat_aspt_encaminhamento").val(),
                aspt_razoes_necessidades: $("#dpat_aspt_razoes_necessidades").val(),
                aspt_bolsa_familia: $("#dpat_aspt_bolsa_familia:checked").val(),
                aspt_bpc: $("#dpat_aspt_bpc:checked").val(),
                aspt_paif: $("#dpat_aspt_paif:checked").val(),
                aspt_scfv: $("#dpat_aspt_scfv:checked").val(),
                aspt_paefi: $("#dpat_aspt_paefi:checked").val(),
                aspt_outros: $("#dpat_aspt_outros:checked").val(),
                aspt_prog_prioritarios: $("#dpat_aspt_prog_prioritarios").val(),
                asps_codigo: $("#dp_asps_codigo").val(),
                aspt_codigo: $("#dpat_aspt_codigo").val(),
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dpatalert_prim_atendimento").hide();
                        $("#dpat_aspt_codigo").val(txt);
                        fecharMensagemSemOk("dpat_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        abreMenus();
                        //composicaoFamiliar($("#dp_asps_codigo").val())
                    } else {
                        $("#dpatalert_prim_atendimento").html(txt);
                        $("#dpatalert_prim_atendimento").show(txt);
                        $('#dados_prim_atendimento').get(0).scrollIntoView();
                        fecharMensagemSemOk("dpat_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM PRIMEIRO ATENDIMENTO
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * COMPOSIÇÃO FAMILIAR
 *------------------------------------------------------------*/

function composicaoFamiliar(asps_codigo) {
    abreFechaMenu(3);
    $('html, body').animate({scrollTop: $('#box_comp_familia').offset().top}, 'slow');
    $("#comp_familia").load(
        baseUrl + '/habitacional/familia/composicao-familiar/asps_codigo/' + asps_codigo);
}

function formEditarReferencia() {
    var asps_codigo = $("#dp_asps_codigo").val();
    var usu_codigo = $("#dp_usu_codigo").val();
    //alert(asps_codigo);
    $('html, body').animate({scrollTop: $('#box_comp_familia').offset().top}, 'slow');
    $("body").append("<div id='edit_referencia' title='Editar pessoa de referencia.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'edit_referencia',
            baseUrl + "/habitacional/composicao-familiar/form-edit-referencia/asps_codigo/" + asps_codigo + "/usu_codigo/" + usu_codigo,
            formEditarReferenciaSalvar
        );
    }, TIME_MODAL);
}

function formEditarReferenciaSalvar(e) {
    if (validaForm('dcf_form_cad_familiar', e)) {
        e.preventDefault();
        mensagemSemOk("dcf_salvar_familiar", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/composicao-familiar/editar-pessoa-referencia',
            type: "POST",
            data: {
                usu_codigo: $("#cf_usu_codigo").val(),
                usu_codigo_ref: $("#cf_usu_codigo_membro").val(),
                asps_codigo: $("#cf_asps_codigo").val(),
                aspsu_parentesco: $("#cf_aspsu_parentesco").val()

            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#edit_referencia").dialog("destroy").remove();
                        //fecharModal('dcf_form_cad_familiarm');
                        fecharMensagemSemOk("dcf_salvar_familiar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        composicaoFamiliar($("#dp_asps_codigo").val());
                        $("#comp_familia").toggle("slow");
                    } else {
                        $("#dcfalert_cad_familiar").html("Erro Ao Salvar");
                        //$("#dcfalert_cad_familiar").show(txt);
                        $('#dados_cad_familiar').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcf_salvar_familiar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}


function formComposicaoFamiliar(usu_codigo) {
    $('html, body').animate({scrollTop: $('#box_comp_familia').offset().top}, 'slow');
    $("body").append("<div id='dcf_form_cad_familiarm' title='Cadastro de cidadão.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dcf_form_cad_familiarm',
            baseUrl + "/habitacional/familia/form-composicao-familiar/usu_codigo/" + usu_codigo,
            formComposicaoFamiliarSalvar
        );
    }, TIME_MODAL);
}

function formComposicaoFamiliarSalvar(e) {
    var cont = 0;
    var tamDeficiencia = $("#dcf_usu_asdeficiencia:checked").length;
    var tamSexo = $("#dcf_usu_sexo:checked").length;

    if (!validaNIS()) {
        e.preventDefault();
        mensagem("Atenção", "Numero de NIS informado é inválido!", 300, 150, function () {
            return false;
        });
        return false;
    }
    $(".obg").each(function () {
        if ($(this).val() == "") {
            cont++;
        }
        if (tamDeficiencia == 0) {
            cont++;
        }
        if (tamSexo == 0) {
            cont++;
        }
    });

    if (validaForm('dcf_form_cad_familiar', e) || cont == 0) {
        e.preventDefault();
        mensagemSemOk("dcf_salvar_familiar", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-composicao-familiar-salvar',
            type: "POST",
            data: {
                usu_codigo: $("#dcf_usu_codigo").val(),
                usu_codigo_ref: $("#dp_usu_codigo").val(),
                asps_codigo: $("#dp_asps_codigo").val(),
                aspsu_codigo: $("#dcf_aspsu_codigo").val(),
                usu_nome: $("#dcf_usu_nome").val(),
                usu_mae: $("#usu_mae").val(),
                usu_as_apelido: $("#usu_as_apelido").val(),
                usu_nis: $("#usu_nis").val(),
                usu_cpf: $("#dcf_usu_cpf").val(),
                usu_rg: $("#usu_rg").val(),
                usu_rg_emissor: $("#usu_rg_emissor").val(),
                uf_sigla_rg: $("#uf_sigla_rg").val(),
                usu_rg_dt_emissao: $("#usu_rg_dt_emissao").val(),
                usu_sexo: $("#dcf_usu_sexo:checked").val(),
                usu_datanasc: $("#dcf_usu_datanasc").val(),
                aspsu_parentesco: $("#dcf_aspsu_parentesco").val(),
                usu_asdeficiencia: $("#dcf_usu_asdeficiencia:checked").val(),
                usu_asdoc_cnprov: $("#dcf_usu_asdoc_cnprov:checked").val(),
                usu_asdoc_rgprov: $("#dcf_usu_asdoc_rgprov:checked").val(),
                usu_asdoc_ctpsprov: $("#dcf_usu_asdoc_ctpsprov:checked").val(),
                usu_asdoc_cpfprov: $("#dcf_usu_asdoc_cpfprov:checked").val(),
                usu_asdoc_teprov: $("#dcf_usu_asdoc_teprov:checked").val(),
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcf_form_cad_familiarm").dialog("destroy").remove();
                        //fecharModal('dcf_form_cad_familiarm');
                        fecharMensagemSemOk("dcf_salvar_familiar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        composicaoFamiliar($("#dp_asps_codigo").val());
                        $("#comp_familia").toggle("slow");
                    } else {
                        $("#dcfalert_cad_familiar").html(txt);
                        $("#dcfalert_cad_familiar").show(txt);
                        $('#dados_cad_familiar').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcf_salvar_familiar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function formAspectosSociaisFamiliaSalvar(e) {
    var cont = 0;
    var tamDeficiencia = $("#dcf_usu_asdeficiencia:checked").length;
    var tamSexo = $("#dcf_usu_sexo:checked").length;
    $(".obg").each(function () {
        if ($(this).val() == "") {
            cont++;
        }
        if (tamDeficiencia == 0) {
            cont++;
        }
        if (tamSexo == 0) {
            cont++;
        }
    });
    if (cont == 0) {
        e.preventDefault();
        mensagemSemOk("dcf_form_cad_aspectos_sociais_familia", "Confirmação", "Salvando dados ...", 250, 150);


        $.ajax({
            url: baseUrl + '/habitacional/familia/form-aspectos-sociais-familia-salvar',
            type: "POST",
            data: {
                usu_codigo: $("#dcf_usu_codigo").val(),
                usu_codigo_ref: $("#dp_usu_codigo").val(),
                asps_codigo: $("#dp_asps_codigo").val(),
                assofa_ha_membro_deficiencia: $("#dceas_assofa_ha_membro_deficiencia:checked").val(),
                assofa_deficiencia: $("#dceas_assofa_deficiencia_surdez:checked").val() + $("#dceas_assofa_deficiencia_fisica:checked").val() + $("#assofa_deficiencia_mental:checked").val() + $("#assofa_deficiencia_visual:checked").val() + $("#assofa_deficiencia_mudez:checked").val(),
                assofa_imovel_necessita_adaptacao: $("#dceas_assofa_imovel_necessita_adaptacao:checked").val(),
                assofa_tipo_adaptacao: $("#dceas_assofa_tipo_adaptacao").val(),
                assofa_cadastro_cadunico: $("#dce_assofa_cadastro_cadunico:checked").val(),
                assofa_participa_programa_social: $("#dce_assofa_participa_programa_social:checked").val()
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcfalert_cad_aspectos_sociais_familia").html(txt);
                        $("#dcfalert_cad_aspectos_sociais_familia").show(txt);
                        $('#dados_cad_aspectos_sociais_familia').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcf_salvar_aspectos_sociais_familia");
                    } else {
                        $("#dcf_form_cad_aspectos_sociais_familia").dialog("destroy").remove();
                        //fecharModal('dcf_form_cad_familiarm');
                        fecharMensagemSemOk("dcf_salvar_aspectos_sociais_familia");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        aspectosSociaisFamilia($("#dp_asps_codigo").val());
                        $("#comp_familia").toggle("slow");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}


function alteraCadastroUnidade(dp_asps_codigo, dp_uni_codigo) {
    console.log(baseUrl + "/default/unidade/altera-unidade-suas");
    $.ajax({
        url: baseUrl + "/default/unidade/altera-unidade-suas",
        type: "POST",
        data: {
            uni_codigo: dp_uni_codigo,
            asps_codigo: dp_asps_codigo
        },
        success: function (txt) {
        }
    });

    //TODO
}


function formProcedenciaSalvar(e) {
    var origem = $("#asproc_origem:checked").length;
    var declara = $("#asproc_o_inscrito_declara:checked").length;
    var count = (origem + declara);
    if (validaForm('dce_form_cad_procedencia', e) && count > 0) {
        e.preventDefault();
        mensagemSemOk("dcf_form_cad_procedencia", "Confirmação", "Salvando dados ...", 250, 150);
        console.log("usu_codigo:     " + $("#dcf_usu_codigo").val() +
            "   asps_codigo:    " + $("#dp_asps_codigo").val() +
            "   asproc_origem:  " + $("#asproc_origem:checked").val() +
            "   asproc_qual:    " + $("#asproc_qual").val() +
            "   asproc_tempo_residencia_municipio: " + $("#asproc_tempo_residencia_municipio_ano").val() + "_" + $("#asproc_tempo_residencia_municipio_mes").val() +
            "   asproc_o_inscrito_declara:" + $("#asproc_o_inscrito_declara:checked").val());
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-procedencia-salvar',
            type: "POST",
            data: {
                //usu_codigo:     $("#dcf_usu_codigo").val(),
                //usu_codigo_ref: $("#dp_usu_codigo").val(),
                asps_codigo: $("#dp_asps_codigo").val(),
                asproc_origem: $("#asproc_origem:checked").val(),
                asproc_qual: $("#asproc_qual").val(),
                asproc_tempo_residencia_municipio: $("#asproc_tempo_residencia_municipio_ano").val() + "_" + $("#asproc_tempo_residencia_municipio_mes").val(),
                asproc_o_inscrito_declara: $("#asproc_o_inscrito_declara:checked").val()
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcfalert_cad_procedencia").html(txt);
                        $("#dcfalert_cad_procedencia").show(txt);
                        $('#dados_cad_procedencia').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcf_salvar_procedencia");
                    } else {
                        $("#dcf_form_cad_procedencia").dialog("destroy").remove();
                        fecharMensagemSemOk("dcf_salvar_procedencia");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        procedencia($("#dp_asps_codigo").val());
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function composicaoFamiliarPerfilEtario(asps_codigo) {
    $("#perfil_familia").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_perfil_familia').offset().top}, 'slow');
    $("#perfil_familia").load(
        baseUrl + '/habitacional/familia/composicao-familiar-perfil-etario/asps_codigo/' + asps_codigo);
}

function composicaoFamiliarEspecSociais(asps_codigo) {
    $("#espec_sociais").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_espec_sociais').offset().top}, 'slow');
    $("#espec_sociais").load(
        baseUrl + '/habitacional/familia/composicao-familiar-espec-sociais/asps_codigo/' + asps_codigo);
}

function composicaoFamiliarEspecSociaisSalvar(e) {
    var cont = 0;
    for (i = 1; i < 7; i++) {
        if ($("#des_sit_fam0" + i).is(':checked')) {
            cont++;
        }
    }
    if (cont > 0) {
        e.preventDefault();
        mensagemSemOk("des_espec_sociais", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dados_espec_sociais").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/composicao-familiar-espec-sociais-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#desalert_espec_sociais").hide();
                        $("#des_aspse_codigo").val(txt);
                        fecharMensagemSemOk("des_espec_sociais");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        composicaoFamiliarEspecSociais($("#dp_asps_codigo").val());
                        $("#espec_sociais").toggle("slow");
                    } else {
                        $("#desalert_espec_sociais").show();
                        $("#desalert_espec_sociais").html(txt);
                        fecharMensagemSemOk("des_espec_sociais");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function composicaoFamiliarObs(asps_codigo) {
    $("#obs_comp_familia").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_comp_familia').offset().top}, 'slow');
    $("#obs_comp_familia").load(
        baseUrl + '/habitacional/familia/composicao-familiar-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function composicaoFamiliarObsSalvar(e) {
    if (validaForm('dcf_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dcf_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcf_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/composicao-familiar-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcfalert_dados_observacao").hide();
                        fecharMensagemSemOk("dcf_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        composicaoFamiliarObs($("#dp_asps_codigo").val());
                        $("#obs_comp_familia").toggle("slow");
                    } else {
                        $("#dcfalert_dados_observacao").show();
                        $("#dcfalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dcf_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function buscaFamiliar() {
    $('#dcpf_busca_familiar').autocomplete({
        source: baseUrl + '/cidadao/cidadao/busca-cidadao-sem-familia/',
        minLength: 3,
        delay: 300,
        search: function (event, ui) {
            $(this).css("background", "url('/WebSocialSocial/zf/public/images/loading.gif') no-repeat center right");
        },
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            formComposicaoFamiliar(ui.item.id);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        var bloqueado = item.data.usu_bloqueado ? "style='color: red'" : "";
        return $("<li>")
            .append("<a " + bloqueado + "><strong>" + item.label + "</strong><br>\n\
                        <strong>CPF: </strong>\n\
                        " + validaCampoEmBranco(item.data.usu_cpf) + "<br>\n\
                        <strong>Mãe: </strong>" + validaCampoEmBranco(item.data.usu_mae) + " \n\
                        <strong>Data Nasc: </strong>"
                + dataToBr(item.data.usu_datanasc) + "<br>\n\
                        </a><br>").appendTo(ul);
    }
}

function validaNomeComposicaoFamiliar() {
    $.ajax({
        url: baseUrl + "/cidadao/cidadao/valida-nome",
        type: "POST",
        data: {
            usu_nome: $("#dcf_usu_nome").val(),
            usu_codigo: $("#dcf_usu_codigo").val()
        },
        success: function (txt) {
            if (txt > 0) {
                //$("#dcf_usu_nome").val("");
                //$("#dcf_usu_nome").focus();
                $("#dcf_alert_nome").show();
            } else {
                $("#dcf_alert_nome").hide();
            }
        }
    });
}

/*-------------------------------------------------------------
 * FIM COMPOSIÇÃO FAMILIAR
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * INÍCIO CONDIÇÕES HABITACIONAIS
 *------------------------------------------------------------*/

function condicoesHabitacionais(asps_codigo) {
    abreFechaMenu(4);
    $('html, body').animate({scrollTop: $('#box_cond_habitacionais').offset().top}, 'slow');
    $("#cond_habitacionais").load(
        baseUrl + '/habitacional/familia/condicoes-habitacionais/asps_codigo/' + asps_codigo);
}

function condicoesHabitacionaisSalvar(e) {
    e.preventDefault();
    mensagemSemOk("dch_dados_cond_hab_salvar", "Confirmação", "Salvando dados ...", 250, 150);
    var valoresForm = $("#dados_cond_habitacionais").serialize();
    $.ajax({
        url: baseUrl + '/habitacional/familia/condicoes-habitacionais-salvar',
        type: "POST",
        data: valoresForm,
        success: function (txt) {
            setTimeout(function () {
                if (txt > 0) {
                    $("#dchalert_cond_habitacionais").hide();
                    $("#dch_aspsch_codigo").val(txt);
                    fecharMensagemSemOk("dch_dados_cond_hab_salvar");
                    mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                } else {
                    $("#dchalert_cond_habitacionais").show();
                    $("#dchalert_cond_habitacionais").html(txt);
                    fecharMensagemSemOk("dch_dados_cond_hab_salvar");
                }
            }, 500);
        }
    });
}

function condicoesHabitacionaisObs(asps_codigo) {
    $("#obs_cond_habitacionais").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_cond_habitacionais').offset().top}, 'slow');
    $("#obs_cond_habitacionais").load(
        baseUrl + '/habitacional/familia/condicoes-habitacionais-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function condicoesHabitacionaisObsSalvar(e) {
    if (validaForm('dch_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dch_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dch_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/condicoes-habitacionais-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dchalert_dados_observacao").hide();
                        fecharMensagemSemOk("dch_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesHabitacionaisObs($("#dp_asps_codigo").val());
                        $("#obs_cond_habitacionais").toggle("slow");
                    } else {
                        $("#dchalert_dados_observacao").show();
                        $("#dchalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dch_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM CONDIÇÕES HABITACIONAIS
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * CONDIÇÕES EDUCACIONAIS
 *------------------------------------------------------------*/

function condicoesEducacionais(asps_codigo) {
    abreFechaMenu(5);
    $('html, body').animate({scrollTop: $('#box_cond_educacionais').offset().top}, 'slow');
    $("#cond_educacionais").load(
        baseUrl + '/habitacional/familia/condicoes-educacionais/asps_codigo/' + asps_codigo);
}

function condicoesEducacionaisVulnerabilidades(asps_codigo) {
    $("#vulnerabilidade").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_vulnerabilidade').offset().top}, 'slow');
    $("#vulnerabilidade").load(
        baseUrl + '/habitacional/familia/condicoes-educacionais-vulnerabilidades/asps_codigo/' + asps_codigo);
}

function formCondicoesEducacionais(usu_codigo) {
    $('html, body').animate({scrollTop: $('#box_cond_educacionais').offset().top}, 'slow');
    $("body").append("<div id='dce_form_cad_edum' title='Cadastro de cidadão.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dce_form_cad_edum',
            baseUrl + "/habitacional/familia/form-condicoes-educacionais/usu_codigo/" + usu_codigo,
            formCondicoesEducacionaisSalvar
        )
    }, TIME_MODAL);
}

function formCondicoesEducacionaisSalvar(e) {
    var cont = 0;
    var alfabetizado = $("#dceas_usu_alfabetizado:checked").length;
    var estuda = $("#dce_as_as_usu_estuda:checked").length;
    $(".obg").each(function () {
        if ($(this).val() == "") {
            cont++;
        }
    });
    if (cont == 0 && alfabetizado > 0 && estuda > 0) {
        e.preventDefault();
        mensagemSemOk("dce_salvar_dados_educ", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicoes-educacionais-salvar',
            type: "POST",
            data: {
                usu_codigo: $("#dce_usu_codigo").val(),
                usu_nome: $("#dce_usu_nome").val(),
                usu_datanasc: $("#dce_usu_datanasc").val(),
                as_usu_alfabetizado: $("#dceas_usu_alfabetizado:checked").val(),
                as_usu_estuda: $("#dce_as_as_usu_estuda:checked").val(),
                as_usu_escolaridade: $("#dce_as_usu_escolaridade").val()
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcealert_cad_educ").hide();
                        $("#dce_form_cad_edum").dialog("destroy").remove();
                        //fecharModal('dce_form_cad_edum');
                        fecharMensagemSemOk("dce_salvar_dados_educ");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesEducacionais($("#dp_asps_codigo").val());
                        $("#cond_educacionais").toggle("slow");
                    } else {
                        $("#dcealert_cad_educ").html(txt);
                        $("#dcealert_cad_educ").show();
                        $('#dados_cad_educ').get(0).scrollIntoView();
                        fecharMensagemSemOk("dce_salvar_dados_educ");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function condicoesEducacionaisDescPrograma(asps_codigo) {
    $("#desc_programa").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_desc_programa').offset().top}, 'slow');
    $("#desc_programa").load(
        baseUrl + '/habitacional/familia/condicoes-educacionais-desc-programa/asps_codigo/' + asps_codigo);
}

function formCondicoesEducacionaisDescPrograma(asps_codigo) {
    $('html, body').animate({scrollTop: $('#box_desc_programa').offset().top}, 'slow');
    $("body").append("<div id='ddp_form_desc_programam' title='Cadastro descumprimento Bolsa Família.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'ddp_form_desc_programam',
            baseUrl + '/habitacional/familia/form-condicoes-educacionais-desc-programa/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val(),
            formCondicoesEducacionaisDescProgramaSalvar
        )
    }, TIME_MODAL);
}

function formCondicoesEducacionaisDescProgramaSalvar(e) {
    var benSuspenso = $('#dcdp_aspsdp_suspenso').length;
    if (validaForm('dcdp_form_cad_desc_prog', e) && benSuspenso > 0) {
        e.preventDefault();
        mensagemSemOk("dcdp_desc_prog", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcdp_form_cad_desc_prog").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicoes-educacionais-desc-programa-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcdpalert_cad_desc_prog").hide();
                        $("#ddp_form_desc_programam").dialog("destroy").remove();
                        //fecharModal('ddp_form_desc_programam');
                        fecharMensagemSemOk("dcdp_desc_prog");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesEducacionaisDescPrograma($("#dp_asps_codigo").val());
                        $("#desc_programa").toggle("slow");
                    } else {
                        $("#dcdpalert_cad_desc_prog").show();
                        $("#dcdpalert_cad_desc_prog").html(txt);
                        fecharMensagemSemOk("dcdp_desc_prog");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function condicoesEducacionaisObs(asps_codigo) {
    $("#obs_edu_familia").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_edu_familia').offset().top}, 'slow');
    $("#obs_edu_familia").load(
        baseUrl + '/habitacional/familia/condicoes-educacionais-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function condicoesEducacionaisObsSalvar(e) {
    if (validaForm('dce_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dce_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dce_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/condicoes-educacionais-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcealert_dados_observacao").hide();
                        fecharMensagemSemOk("dce_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesEducacionaisObs($("#dp_asps_codigo").val());
                        $("#obs_edu_familia").toggle("slow");
                    } else {
                        $("#dcealert_dados_observacao").show();
                        $("#dcealert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dce_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM CONDIÇÕES EDUCACIONAIS
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * CONDIÇÕES DE TRABALHO E RENDIMENTOS DA FAMÍLIA
 *------------------------------------------------------------*/

function condicoesTrabalho(asps_codigo) {
    $('html, body').animate({scrollTop: $('#box_cond_trabalho').offset().top}, 'slow');
    abreFechaMenu(6);
    $("#cond_trabalho").load(
        baseUrl + '/habitacional/familia/condicoes-trabalho/asps_codigo/' + asps_codigo);
}

function formCondicoesTrabalho(usu_codigo) {
    $('html,body').animate({scrollTop: $('#box_cond_trabalho').offset().top}, 'slow');
    $("body").append("<div id='dct_form_cond_trabalhom' title='Cadastro condições de trabalho e rendimentos.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dct_form_cond_trabalhom',
            baseUrl + '/habitacional/familia/form-condicoes-trabalho/usu_codigo/' + usu_codigo,
            formCondicoesTrabalhoSalvar
        )
    }, TIME_MODAL);
}

function formCondicoesTrabalhoSalvar(e) {
    if (validaForm('dce_form_cad_educ', e)) {
        e.preventDefault();
        mensagemSemOk("dct_salvar_cond_trab", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicoes-trabalho-salvar',
            type: "POST",
            data: {
                asps_codigo: $("#dp_asps_codigo").val(),
                usr_codigo: $("#dp_usr_codigo").val(),
                usu_codigo: $("#dct_usu_codigo").val(),
                usu_nome: $("#dct_usu_nome").val(),
                usu_datanasc: $("#dct_usu_datanasc").val(),
                usu_asdoc_ctpsprov: $("#dct_usu_asdoc_ctpsprov:checked").val(),
                as_cond_ocupacao: $("#dct_as_cond_ocupacao option:selected").val(),
                as_possui_qualificacao: $("#dct_as_possui_qualificacao:checked").val(),
                as_possui_qualificacao_qual: $("#dct_as_possui_qualificacao_qual").val(),
                as_renda_mensal: $("#dct_as_renda_mensal").val()
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dctalert_cond_trab").hide();
                        $("#dct_form_cond_trabalhom").dialog("destroy").remove();
                        //fecharModal('dct_form_cond_trabalhom');
                        fecharMensagemSemOk("dct_salvar_cond_trab");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesTrabalho($("#dp_asps_codigo").val());
                        $("#cond_trabalho").toggle("slow");
                    } else {
                        $("#dctalert_cond_trab").html(txt);
                        $("#dctalert_cond_trab").show();
                        $('#dados_cond_trab').get(0).scrollIntoView();
                        fecharMensagemSemOk("dct_salvar_cond_trab");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function condicoesTrabalhoAnotProgramasFam(asps_codigo) {
    $("#anot_programas_fam").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_anot_programas_fam').offset().top}, 'slow');
    $("#anot_programas_fam").load(
        baseUrl + '/habitacional/familia/condicoes-trabalho-anot-programas-fam/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function formCondicoesTrabalhoAnotProgramasFam(aspsapf_codigo) {
    $('html, body').animate({scrollTop: $('#box_anot_programas_fam').offset().top}, 'slow');
    $("body").append("<div id='dap_form_anot_programafamm' title='Cadastro programas sociais família.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dap_form_anot_programafamm',
            baseUrl + '/habitacional/familia/form-condicoes-trabalho-anot-programas-fam/aspsapf_codigo/' + aspsapf_codigo + '/asps_codigo/' + $("#dp_asps_codigo").val() + '/usr_codigo/' + $("#dp_usr_codigo").val(),
            formCondicoesTrabalhoAnotProgramasFamSalvar
        )
    }, TIME_MODAL);
}

function formCondicoesTrabalhoAnotProgramasFamSalvar(e) {
    if (validaForm('dcapf_form_cad_anot_prog_fam', e)) {
        e.preventDefault();
        mensagemSemOk("dcap_anot_prog_fam", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcapf_form_cad_anot_prog_fam").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicoes-trabalho-anot-programas-fam-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcapfalert_cad_anot_prog_fam").hide();
                        $("#dap_form_anot_programafamm").dialog("destroy").remove();
                        //fecharModal('dap_form_anot_programam');
                        fecharMensagemSemOk("dcap_anot_prog_fam");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesTrabalhoAnotProgramasFam($("#dp_asps_codigo").val());
                        $("#anot_programas_fam").toggle("slow");
                    } else {
                        $("#dcapfalert_cad_anot_prog_fam").show();
                        $("#dcapfalert_cad_anot_prog_fam").html(txt);
                        fecharMensagemSemOk("dcap_anot_prog_fam");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}


function condicoesTrabalhoInfRenda(asps_codigo) {
    $("#inf_renda").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_inf_renda').offset().top}, 'slow');
    $("#inf_renda").load(
        baseUrl + '/habitacional/familia/condicoes-trabalho-inf-renda/asps_codigo/' + asps_codigo);
}

function condicoesTrabalhoAnotProgramas(asps_codigo) {
    $("#anot_programas").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_anot_programas').offset().top}, 'slow');
    $("#anot_programas").load(
        baseUrl + '/habitacional/familia/condicoes-trabalho-anot-programas/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function formCondicoesTrabalhoAnotProgramas(aspsap_codigo) {
    $('html, body').animate({scrollTop: $('#box_anot_programas').offset().top}, 'slow');
    $("body").append("<div id='dap_form_anot_programam' title='Cadastro programas sociais cidadão.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dap_form_anot_programam',
            baseUrl + '/habitacional/familia/form-condicoes-trabalho-anot-programas/aspsap_codigo/' + aspsap_codigo + '/asps_codigo/' + $("#dp_asps_codigo").val() + '/usr_codigo/' + $("#dp_usr_codigo").val(),
            formCondicoesTrabalhoAnotProgramasSalvar
        )
    }, TIME_MODAL);
}

function formCondicoesTrabalhoAnotProgramasSalvar(e) {
    if (validaForm('dcap_form_cad_anot_prog', e)) {
        e.preventDefault();
        mensagemSemOk("dcap_anot_prog", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcap_form_cad_anot_prog").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicoes-trabalho-anot-programas-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcapalert_cad_anot_prog").hide();
                        $("#dap_form_anot_programam").dialog("destroy").remove();
                        //fecharModal('dap_form_anot_programam');
                        fecharMensagemSemOk("dcap_anot_prog");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesTrabalhoAnotProgramas($("#dp_asps_codigo").val());
                        $("#anot_programas").toggle("slow");
                    } else {
                        $("#dcapalert_cad_anot_prog").show();
                        $("#dcapalert_cad_anot_prog").html(txt);
                        fecharMensagemSemOk("dcap_anot_prog");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function condicoesTrabalhoObs(asps_codigo) {
    $("#obs_cond_trab").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_cond_trab').offset().top}, 'slow');
    $("#obs_cond_trab").load(
        baseUrl + '/habitacional/familia/condicoes-trabalho-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function condicoesTrabalhoObsSalvar(e) {
    if (validaForm('dct_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dct_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dct_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/condicoes-trabalho-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dctalert_dados_observacao").hide();
                        fecharMensagemSemOk("dct_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesTrabalhoObs($("#dp_asps_codigo").val());
                        $("#obs_cond_trab").toggle("slow");
                    } else {
                        $("#dctalert_dados_observacao").show();
                        $("#dctalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dct_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM CONDIÇÕES DE TRABALHO E RENDIMENTOS DA FAMÍLIA
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * CONDIÇÕES DE SAÚDE DA FAMÍLIA
 *------------------------------------------------------------*/

function condicoesSaude(asps_codigo) {
    $('html, body').animate({scrollTop: $('#box_cond_saude').offset().top}, 'slow');
    abreFechaMenu(7);
    $("#cond_saude").load(
        baseUrl + '/habitacional/familia/condicoes-saude/asps_codigo/' + asps_codigo);
}

function formCondicoesSaude(usu_codigo) {
    $('html,body').animate({scrollTop: $('#cond_saude').offset().top}, 'slow');
    $("body").append("<div id='dcs_form_cond_saudem' title='Cadastro condições de saúde.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dcs_form_cond_saudem',
            baseUrl + '/habitacional/familia/form-condicoes-saude/usu_codigo/' + usu_codigo,
            formCondicoesSaudeSalvar
        )
    }, TIME_MODAL);
}

function formCondicoesSaudeSalvar(e) {
    var cuidadoPes = $("#dcs_usu_as_cuidado_constante:checked").length;
    if (validaForm('dcs_form_cond_saude', e) && cuidadoPes > 0) {
        e.preventDefault();
        mensagemSemOk("dcs_salvar_cond_saude", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicoes-saude-salvar',
            type: "POST",
            data: {
                asps_codigo: $("#dp_asps_codigo").val(),
                usr_codigo: $("#dp_usr_codigo").val(),
                usu_codigo: $("#dcs_usu_codigo").val(),
                usu_nome: $("#dcs_usu_nome").val(),
                usu_as_tipo_deficiencia: $("#dcs_usu_as_tipo_deficiencia option:selected").val(),
                usu_as_cuidado_constante: $("#dcs_usu_as_cuidado_constante:checked").val(),
                usu_as_resp_cuidado: $("#dcs_usu_as_resp_cuidado").val(),
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcsalert_cond_saude").hide();
                        $("#dcs_form_cond_saudem").dialog("destroy").remove();
                        //fecharModal('dcs_form_cond_saudem');
                        fecharMensagemSemOk("dcs_salvar_cond_saude");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesSaude($("#dp_asps_codigo").val());
                        $("#cond_saude").toggle("slow");
                    } else {
                        $("#dcsalert_cond_saude").html(txt);
                        $("#dcsalert_cond_saude").show();
                        $('#dados_cond_saude').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcs_salvar_cond_saude");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function condicoesSaudeAnot(asps_codigo) {
    $("#anot_saude").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_anot_saude').offset().top}, 'slow');
    $("#anot_saude").load(baseUrl + '/habitacional/familia/condicoes-saude-anot/asps_codigo/' + asps_codigo);
}

function condicoesSaudeAnotSalvar(e) {
    e.preventDefault();
    mensagemSemOk("dpas_salvar", "Confirmação", "Salvando dados ...", 250, 150);
    var valoresForm = $("#dados_anot_saude").serialize();
    $.ajax({
        url: baseUrl + '/habitacional/familia/condicoes-saude-anot-salvar',
        type: "POST",
        data: valoresForm,
        success: function (txt) {
            if (txt > 0) {
                $("#dasalert_anot_saude").hide();
                $("#das_aspsas_codigo").val(txt);
                fecharMensagemSemOk("dpas_salvar");
                mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
            } else {
                $("#dasalert_anot_saude").html(txt);
                $("#dasalert_anot_saude").show(txt);
                $('#dados_anot_saude').get(0).scrollIntoView();
                fecharMensagemSemOk("dpas_salvar");
            }
        }
    });
}

/*function condicoesSaudeDescPrograma(asps_codigo){
    $("#desc_bolsas").toggle("slow");
    $('html, body').animate({ scrollTop: $('#box_desc_bolsas').offset().top }, 'slow');
    $("#desc_bolsas").load(
        baseUrl+'/habitacional/familia/condicoes-educacionais-desc-programa/asps_codigo/'+asps_codigo);
}

function formCondicoesSaudeDescPrograma(asps_codigo){
    $('html, body').animate({ scrollTop: $('#box_desc_bolsas').offset().top }, 'slow');
    $("body").append("<div id='ddps_form_desc_programam' title='Cadastro descumprimento Bolsa Família.'></div>");
    $("#ddps_form_desc_programam")
    .html("<img src="+baseUrl+"/public/images/load.gif alt='Carregando' \n\
            title='Carregando dados ...' />")
    .dialog({
        modal: false,
        width: 710,
        height: 416
    })
    .load(baseUrl+'/habitacional/familia/form-condicoes-saude-desc-programa/asps_codigo/'+asps_codigo+'/usr_codigo/'+$("#dp_usr_codigo").val());
}

function formCondicoesSaudeDescProgramaSalvar(e){
    var usuCodigo = $('#dcdps_usu_codigo').val();
    var dtOcorrencia = $('#dcdps_aspsdpcs_data_ocorrencia').val();
    var benSuspenso = $('#dcdps_aspsdpcs_suspenso:checked').length;
    var efeito = $('#dcdps_aspsdpcs_efeito').val();
    if (usuCodigo!="" && dtOcorrencia!="" && efeito!="" && benSuspenso>0) {
        e.preventDefault();
        mensagemSemOk("dcdps_desc_prog", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcdps_form_cad_desc_progs").serialize();
        $.ajax({
            url: baseUrl+'/habitacional/familia/form-condicoes-saude-desc-programa-salvar',
            type: "POST",
            data: valoresForm,
            success: function(txt) {
                setTimeout(function(){
                    if (txt>0) {
                        $("#dcdpsalert_cad_desc_prog").hide();
                        $("#ddps_form_desc_programam").dialog("destroy").remove();
                        fecharMensagemSemOk("dcdps_desc_prog");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesSaudeDescPrograma($("#dp_asps_codigo").val());
                        $("#desc_bolsas").toggle("slow");
                    } else {
                        $("#dcdpsalert_cad_desc_prog").show();
                        $("#dcdpsalert_cad_desc_prog").html(txt);
                        fecharMensagemSemOk("dcdps_desc_prog");
                    }
                },100);
            }
        });
    } else {
        return false;
    }
}*/

function condicoesSaudeRegGestante(asps_codigo) {
    $("#reg_gestante").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_reg_gestante').offset().top}, 'slow');
    $("#reg_gestante").load(
        baseUrl + '/habitacional/familia/condicoes-saude-reg-gestante/asps_codigo/' + asps_codigo);
}

function formCondicoesSaudeRegGestante(asps_codigo) {
    $('html, body').animate({scrollTop: $('#box_reg_gestante').offset().top}, 'slow');
    $("body").append("<div id='dprg_form_reg_gestantem' title='Cadastro presença de gestante(s) na família.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dprg_form_reg_gestantem',
            baseUrl + '/habitacional/familia/form-condicoes-saude-reg-gestante/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val(),
            formCondicoesSaudeRegGestanteSalvar
        )
    }, TIME_MODAL);
}

function formCondicoesSaudeRegGestanteSalvar(e) {
    var preNatal = $('#dcrg_aspsrg_prenatal:checked').length;
    if (validaForm('dcrg_form_cad_reg_gestante', e) && preNatal > 0) {
        e.preventDefault();
        mensagemSemOk("dcrg_reg_gestante_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcrg_form_cad_reg_gestante").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-condicoes-saude-reg-gestante-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcrgalert_cad_reg_gestante").hide();
                        $("#dprg_form_reg_gestantem").dialog("destroy").remove();
                        //fecharModal('dprg_form_reg_gestantem');
                        fecharMensagemSemOk("dcrg_reg_gestante_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesSaudeRegGestante($("#dp_asps_codigo").val());
                        $("#reg_gestante").toggle("slow");
                    } else {
                        $("#dcrgalert_cad_reg_gestante").show();
                        $("#dcrgalert_cad_reg_gestante").html(txt);
                        fecharMensagemSemOk("dcrg_reg_gestante_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function condicoesSaudeObs(asps_codigo) {
    $("#obs_cond_saude").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_cond_saude').offset().top}, 'slow');
    $("#obs_cond_saude").load(
        baseUrl + '/habitacional/familia/condicoes-saude-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function condicoesSaudeObsSalvar(e) {
    if (validaForm('dcs_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dcs_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcs_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/condicoes-saude-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcsalert_dados_observacao").hide();
                        fecharMensagemSemOk("dcs_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        condicoesSaudeObs($("#dp_asps_codigo").val());
                        $("#obs_cond_saude").toggle("slow");
                    } else {
                        $("#dcsalert_dados_observacao").show();
                        $("#dcsalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dcs_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM CONDIÇÕES DE SAÚDE DA FAMÍLIA
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * CONVIVÊNCIA FAMILIAR E COMUNITÁRIA
 *------------------------------------------------------------*/

function convivenciaFamiliar(asps_codigo) {
    $("#box_conv_familiar").show();
    abreFechaMenu(8);
    //$('#prim_atendimento').get(0).scrollIntoView();
    $('html, body').animate({scrollTop: $('#box_conv_familiar').offset().top}, 'slow');
    $("#conv_familiar").load(
        baseUrl + '/habitacional/familia/convivencia-familiar/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function convivenciaFamiliarSalvar(e) {
    e.preventDefault();
    mensagemSemOk("dcf_conv_familiar_salvar", "Confirmação", "Salvando dados ...", 250, 150);
    var valoresForm = $("#dados_conv_familiar").serialize();
    $.ajax({
        url: baseUrl + '/habitacional/familia/convivencia-familiar-salvar',
        type: "POST",
        data: valoresForm,
        success: function (txt) {
            setTimeout(function () {
                if (txt > 0) {
                    $("#dpcfalert_conv_familiar").hide();
                    $("#dpc_aspscf_codigo").val(txt);
                    fecharMensagemSemOk("dcf_conv_familiar_salvar");
                    mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                } else {
                    $("#dpcfalert_conv_familiar").show();
                    $("#dpcfalert_conv_familiar").html(txt);
                    fecharMensagemSemOk("dcf_conv_familiar_salvar");
                }
            }, 500);
        }
    });
}

function convivenciaFamiliarObs(asps_codigo) {
    $("#obs_conv_familiar").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_conv_familiar').offset().top}, 'slow');
    $("#obs_conv_familiar").load(
        baseUrl + '/habitacional/familia/convivencia-familiar-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function convivenciaFamiliarObsSalvar(e) {
    if (validaForm('dcc_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dcc_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dcc_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/convivencia-familiar-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dccalert_dados_observacao").hide();
                        fecharMensagemSemOk("dcc_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        convivenciaFamiliarObs($("#dp_asps_codigo").val());
                        $("#obs_conv_familiar").toggle("slow");
                    } else {
                        $("#dccalert_dados_observacao").show();
                        $("#dccalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dcc_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM CONVIVÊNCIA FAMILIAR E COMUNITÁRIA
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * SITUACÕES DE VIOLÊNCIA E VIOLAÇÕES DE DIREITOS
 *------------------------------------------------------------*/

function sitViolacoes(asps_codigo) {
    abreFechaMenu(9);
    $('html, body').animate({scrollTop: $('#sit_violacoes').offset().top}, 'slow');
    $("#sit_violacoes").load(
        baseUrl + '/habitacional/familia/sit-violacoes/asps_codigo/' + asps_codigo);
}

function formSitViolacoes(asrv_codigo) {
    $('html, body').animate({scrollTop: $('#box_sit_violacoes').offset().top}, 'slow');
    $("body").append("<div id='dsv_form_cad_svm' title='Cadastro de situações de violações.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dsv_form_cad_svm',
            baseUrl + "/habitacional/familia/form-sit-violacoes/asrv_codigo/" + asrv_codigo + "/asps_codigo/" + $("#dp_asps_codigo").val() + "/usr_codigo/" + $("#dp_usr_codigo").val(),
            formSitViolacoesSalvar
        )
    }, TIME_MODAL);
}

function formSitViolacoesSalvar(e) {
    if (validaForm('dcsv_form_cad_sit_violacoes', e)) {
        e.preventDefault();
        var valoresPost = $("#dcsv_form_cad_sit_violacoes").serialize();
        mensagemSemOk("dcsv_salvar_sv", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-sit-violacoes-salvar',
            type: "POST",
            data: valoresPost,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dsv_form_cad_svm").dialog("destroy").remove();
                        //fecharModal('dsv_form_cad_svm');
                        fecharMensagemSemOk("dcsv_salvar_sv");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        sitViolacoes($("#dp_asps_codigo").val());
                        $("#sit_violacoes").toggle("slow");
                    } else {
                        $("#dcsvalert_cad_sit_violacoes").html(txt);
                        $("#dcsvalert_cad_sit_violacoes").show(txt);
                        $('#dados_cad_sit_violacoes').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcsv_salvar_sv");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function sitViolacoesObs(asps_codigo) {
    $("#obs_sit_violacoes").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_sit_violacoes').offset().top}, 'slow');
    $("#obs_sit_violacoes").load(
        baseUrl + '/habitacional/familia/sit-violacoes-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function sitViolacoesObsSalvar(e) {
    if (validaForm('dsv_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dcsv_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dsv_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/sit-violacoes-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dsvalert_dados_observacao").hide();
                        fecharMensagemSemOk("dcsv_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        sitViolacoesObs($("#dp_asps_codigo").val());
                        $("#obs_sit_violacoes").toggle("slow");
                    } else {
                        $("#dsvalert_dados_observacao").show();
                        $("#dsvalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dcsv_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM SITUACÕES DE VIOLÊNCIA E VIOLAÇÕES DE DIREITOS
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR
 *------------------------------------------------------------*/

function histAcolhimento(asps_codigo) {
    abreFechaMenu(10);
    $('html, body').animate({scrollTop: $('#hist_acolhimento').offset().top}, 'slow');
    $("#hist_acolhimento").load(baseUrl + '/habitacional/familia/hist-acolhimento/asps_codigo/' + asps_codigo);
}

function formHistAcolhimento(aspsha_codigo) {
    $('html, body').animate({scrollTop: $('#box_hist_acolhimento').offset().top}, 'slow');
    $("body").append("<div id='dha_form_cad_ham' title='Cadastro de histórico de acolhimento.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dha_form_cad_ham',
            baseUrl + "/habitacional/familia/form-hist-acolhimento/aspsha_codigo/" + aspsha_codigo + "/asps_codigo/" + $("#dp_asps_codigo").val() + "/usr_codigo/" + $("#dp_usr_codigo").val(),
            formHistAcolhimentoSalvar
        )
    }, TIME_MODAL);
}

function formHistAcolhimentoSalvar(e) {
    if (validaForm('dcha_form_cad_hist_acolhimento', e)) {
        e.preventDefault();
        var valoresPost = $("#dcha_form_cad_hist_acolhimento").serialize();
        mensagemSemOk("dcha_salvar_ha", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-hist-acolhimento-salvar',
            type: "POST",
            data: valoresPost,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dha_form_cad_ham").dialog("destroy").remove();
                        //fecharModal('dha_form_cad_ham');
                        fecharMensagemSemOk("dcha_salvar_ha");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        histAcolhimento($("#dp_asps_codigo").val());
                        $("#hist_acolhimento").toggle("slow");
                    } else {
                        $("#dchaalert_cad_hist_acolhimento").html(txt);
                        $("#dchaalert_cad_hist_acolhimento").show(txt);
                        $('#dados_cad_hist_acolhimento').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcha_salvar_ha");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function histAcolhimentoObs(asps_codigo) {
    $("#obs_hist_acolhimento").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_hist_acolhimento').offset().top}, 'slow');
    $("#obs_hist_acolhimento").load(
        baseUrl + '/habitacional/familia/hist-acolhimento-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function histAcolhimentoObsSalvar(e) {
    if (validaForm('dha_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dcha_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dha_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/hist-acolhimento-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dhaalert_dados_observacao").hide();
                        fecharMensagemSemOk("dcha_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        histAcolhimentoObs($("#dp_asps_codigo").val());
                        $("#obs_hist_acolhimento").toggle("slow");
                    } else {
                        $("#dhaalert_dados_observacao").show();
                        $("#dhaalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dcha_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR
 *------------------------------------------------------------*/

/*-------------------------------------------------------------
 * HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR
 *------------------------------------------------------------*/

function medSocioeducativa(asps_codigo) {
    abreFechaMenu(11);
    $('html, body').animate({scrollTop: $('#med_socioeducativa').offset().top}, 'slow');
    $("#med_socioeducativa").load(baseUrl + '/habitacional/familia/med-socioeducativa/asps_codigo/' + asps_codigo);
}

function formMedSocioeducativa(aspsms_codigo) {
    $('html, body').animate({scrollTop: $('#box_med_socioeducativa').offset().top}, 'slow');
    $("body").append("<div id='dms_form_cad_ms' title='Cadastro de medida socioeducativa.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dms_form_cad_ms',
            baseUrl + "/habitacional/familia/form-med-socioeducativa/aspsms_codigo/" + aspsms_codigo + "/asps_codigo/" + $("#dp_asps_codigo").val() + "/usr_codigo/" + $("#dp_usr_codigo").val(),
            formMedSocioeducativaSalvar
        )
    }, TIME_MODAL);
}

function formMedSocioeducativaSalvar(e) {
    if (validaForm('dcms_form_cad_med_socioeducativa', e)) {
        e.preventDefault();
        var valoresPost = $("#dcms_form_cad_med_socioeducativa").serialize();
        mensagemSemOk("dcms_salvar_ms", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-med-socioeducativa-salvar',
            type: "POST",
            data: valoresPost,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dms_form_cad_ms").dialog("destroy").remove();
                        fecharMensagemSemOk("dcms_salvar_ms");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        medSocioeducativa($("#dp_asps_codigo").val());
                        $("#med_socioeducativa").toggle("slow");
                    } else {
                        $("#dcmsalert_cad_med_socioeducativa").html(txt);
                        $("#dcmsalert_cad_med_socioeducativa").show(txt);
                        $('#dcmsalert_cad_med_socioeducativa').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcms_salvar_ms");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

function medSocioeducativaObs(asps_codigo) {
    $("#obs_med_socioeducativa").toggle("slow");
    $('html, body').animate({scrollTop: $('#box_obs_med_socioeducativa').offset().top}, 'slow');
    $("#obs_med_socioeducativa").load(
        baseUrl + '/habitacional/familia/med-socioeducativa-obs/asps_codigo/' + asps_codigo + '/usr_codigo/' + $("#dp_usr_codigo").val());
}

function medSocioeducativaObsSalvar(e) {
    if (validaForm('dms_dados_observacao', e)) {
        e.preventDefault();
        mensagemSemOk("dcms_dados_observacao_salvar", "Confirmação", "Salvando dados ...", 250, 150);
        var valoresForm = $("#dms_dados_observacao").serialize();
        $.ajax({
            url: baseUrl + '/habitacional/familia/med-socioeducativa-obs-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dmsalert_dados_observacao").hide();
                        fecharMensagemSemOk("dcms_dados_observacao_salvar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        medSocioeducativaObs($("#dp_asps_codigo").val());
                        $("#obs_med_socioeducativa").toggle("slow");
                    } else {
                        $("#dmsalert_dados_observacao").show();
                        $("#dmsalert_dados_observacao").html(txt);
                        fecharMensagemSemOk("dcms_dados_observacao_salvar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}

/*-------------------------------------------------------------
 * FIM HISTÓRICO DE ACOLHIMENTO INSTITUCIONAL OU FAMILIAR
 *------------------------------------------------------------*/


function recarregarPagina() {
    $("#dp_asps_codigo").val("");
    location.reload();
}

function formComposicaoFamiliarInativa(aspsu_codigo) {
    $('html, body').animate({scrollTop: $('#comp_familia').offset().top}, 'slow');
    $("body").append("<div id='dcf_form_inat_familiarm' title='Exclusão cidadão da família.'></div>");
    setTimeout(function () {
        abrirModalAcao(
            'dcf_form_inat_familiarm',
            baseUrl + "/habitacional/familia/form-composicao-familiar-inativa/aspsu_codigo/" + aspsu_codigo,
            formComposicaoFamiliarInativaSalvar
        );
    }, TIME_MODAL);
}

function formComposicaoFamiliarInativaSalvar(e) {
    if (validaForm('dcf_form_inat_familiar', e)) {
        e.preventDefault();
        mensagemSemOk("dcf_inativa_familiar", "Confirmação", "Salvando dados ...", 250, 150);
        $.ajax({
            url: baseUrl + '/habitacional/familia/form-composicao-familiar-inativa-salvar',
            type: "POST",
            data: {
                aspsu_codigo: $("#dcfi_aspsu_codigo").val(),
                asps_codigo: $("#dp_asps_codigo").val(),
                usr_codigo: $("#dp_usr_codigo").val(),
                aspso_obs: $("#dcfi_aspso_obs").val()
            },
            success: function (txt) {
                setTimeout(function () {
                    if (txt > 0) {
                        $("#dcf_form_inat_familiarm").dialog("destroy").remove();
                        //fecharModal('dcf_form_inat_familiarm');
                        fecharMensagemSemOk("dcf_inativa_familiar");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        // Fecha composição familiar e recarrega a página
                        composicaoFamiliar($("#dp_asps_codigo").val());
                        // Depois de carregar a página abre novamente
                        $("#comp_familia").toggle("slow");
                    } else {
                        $("#dcfalert_inat_familiar").html(txt);
                        $("#dcfalert_inat_familiar").show(txt);
                        $('#dados_inat_familiar').get(0).scrollIntoView();
                        fecharMensagemSemOk("dcf_inativa_familiar");
                    }
                }, 500);
            }
        });
    } else {
        return false;
    }
}
