$(function(){
	
	// pega o click no +
	$(".add").click(function(){
		
		var tipo = $(this).data("tipo");
		
		switch (tipo) {
			case "alerta":
				alertaAdd($(this));
				break;
			case "pre-consulta":
				$("#form-pc").slideToggle();
				break;
			case "atendimento":
				$("#form-ate").slideToggle();
				break;
			case "procedimentos":
				mostrarFormProcedimento();
				break;
			default:
				alert(tipo+" é desconhecido");
				break;
		}		
	});
	/* Pré-Colsunta */
	formBind("#form-pc", "Salvando pré-consulta", pcAddFromJson, true);
	
	/* Atendimento */
	formBind("#form-ate", "Salvando atendimento", ateAddFromJson, false);
	
	/* Procedimentos */
	formBind("#form-proc", "Salvando procedimento", procAddFromJson, true);
	// o reset do procedimento precisa limpar o CID.
	$("#form-proc").bind("reset",function(){
		$("#form-proc #cid")
		.html("<option value=\"0\">-- Selecione um procedimento --</option>")
		.attr("disabled","disabled");
	})
	
	/* Cid do atendimento */
	$("#cd10_descricao").buscar({
		url: baseUrl + '/prontuario/cid/buscar/',
		template : function(ul, item) {
			return jQuery("<li></li>").data("item.autocomplete", item).append(
				"<a>" + item.label + "</a>").appendTo(ul);
		},
		callback: function(event, ui){
			return true;
		}
	});
	
	// preenche o select do CID (do procedimento), baseado no procedimento informado
	$("#proc_codigo").change(function(){
		url = baseUrl + "/prontuario/cid/procedimento/id/"+$(this).val();
		$("#cid")
		.attr("disabled","disabled")
		.html("<option value=\"0\">Carregando...</option>")
		.load(url, function(r){
			if(r == "")
				$(this).html("<option value=\"0\">Nenhum CID relacionado</option>");
			else
				$("#cid").removeAttr("disabled").focus();
		});
	});
	
});

function formBind(seletor,msg,callback, reset){
	$(seletor).hide()
	.bind("reset",function(){
		$(this).slideToggle()
	}).bind('submit', function(e) {
		e.preventDefault(); 
		mensagemSemOk("form-add", "Salvando...", msg, 330, 100);
		$(this).ajaxSubmit({
			success: function(json){
				fecharMensagemSemOk("form-add");
				if(json.error){
					mensagem("Erro!",json.mensagem,330,150);
					return;
				} 
				if(reset)
					$(seletor).trigger("reset");
				else
					$(seletor).slideToggle();
				
				callback(json);
			}
		});
	});
}


/* Alertas */
function alertaAdd(obj){
	obj
	.parents("h2")
	.after("<span><input id=\"addAlerta\" onblur=\"alertaBlur()\" onkeypress=\"alertaKeyPress(event)\" style=\"width: 300px\" /><br /></span>");
	$("input#addAlerta").select();	
}

function alertaKeyPress(e){
	if(e.keyCode == 13)
		return alertaBlur();
}

function alertaBlur(){
	var input = $("input#addAlerta");
	var alerta = input.val();
	
	if($.trim(alerta) == ""){
		input.parents("span").remove();
		return;
	}
	
	span = input.parents("span").html(imgCarregando()+"<br />");
	
	$.ajax({
		url: baseUrl+'/prontuario/alerta/salvar',
		type: 'post',
		dataType: 'json',
		data: {
			usu_codigo: getUsuCodigo(),
			ale_desc: alerta,
			json: true
		},
		success: function(json){
			var img = '<img src="'+baseUrl+'/public/images/icons/excluir.png" alt="Excluir" title="Excluir" onclick="alertaExcluir('+json.ale_codigo+')" /> ';
			span
			.html(img + json.ale_desc +"<br />" )
			.attr("id","ale_"+json.ale_codigo);
			
			escondeEm("alerta");
			destacar("#ale_"+json.ale_codigo);
		}
	});
}

function alertaExcluir(id){
	confirme("Confirme","Deseja realmente excluir este alerta?",300,120, function(){
		$("#ale_"+id+" br").before('<img src="'+baseUrl+'/public/images/loading.gif" class="loading" style="width:12px" />');
		
		$.ajax({
			url: baseUrl+'/prontuario/alerta/excluir',
			type: 'get',
			data:{
				id: id,
				json: true
			},
			success: function(){
				$("#ale_"+id).slideUp("fast", function(){
					$(this).remove();
					verificarEm("alerta","span","Nenhum alerta cadastrado");
				});
			}
		});
	});
}


/* Pré-Consultas */
function pcAddFromJson(json){
	var tr = "<tr><th>Data</th><th>Unidade De Saúde</th><th>Proficional</th><th>Especialidade</th><th>Temp.</th><th>Peso</th><th>Alt.</th><th>P/A</th><th>IMC</th></tr>";
	tr += "<tr><td>"+dataToBr(json.age_data)+"</td>";
	tr += "<td nowrap>"+json.uni_desc+"</td>";
	tr += "<td>"+json.usr_nome+"</td>";
	tr += "<td>"+json.esp_nome+"</td>";
	tr += "<td>"+json.pc_temperatura+"</td>";
	tr += "<td>"+json.pc_peso+"</td>";
	tr += "<td>"+json.pc_altura+"</td>";
	tr += "<td>"+json.pc_pressao_sistolica+"/"+json.pc_pressao_diastolica+"</td>";
	tr += "<td>"+imc(json.pc_peso, json.pc_altura)+"</td></tr>";
	
	if(json.pc_dados){
		tr += "<tr><td colspan=\"9\" class=\"escape\">";
		tr += "<strong>Observações:</strong>"+json.pc_dados;
		tr += "</td></tr>";
	}
	
	tr += "tr><td colspan=\"9\">&nbsp;</td></tr>";	
	$("#table-pc").prepend(tr);
}

/* Atendimentos */
function ateAddFromJson(json){
	var tr = "<tr><th>Data</th><th>Unidade De Saúde</th><th>Proficional</th><th>Especialidade</th></tr><tr>";
	tr += "<td>"+dataToBr(json.ate_data)+"</td>";
	tr += "<td>"+json.uni_desc+"</td>";
	tr += "<td>"+json.usr_nome+"</td>";
	tr += "<td>"+json.esp_nome+"</td></tr><tr>";
	tr += "<td colspan=\"8\"><strong>CID</strong> "+(json.cd10_codigo_cid ? json.cd10_codigo_cid + " - " + json.cd10_descricao:"<em>Não informado</em>")+"</td>";
	tr += "</tr><tr><td colspan=\"8\" class=\"escape\">";
	if(json.ate_reclamacao)
		tr += json.ate_reclamacao;
		
	if(json.ate_exame_fisico)
		tr += json.ate_exame_fisico;
		
	if(json.ate_diagnostico)
		tr += json.ate_diagnostico;
		
	if(json.ate_tratamento)
		tr += json.ate_tratamento;
		
	if(json.ate_curativo)
		tr += json.ate_curativo;
		
	tr += "</td></tr><tr><td colspan=\"8\">&nbsp;</td></tr>";
		
	// insert ou update?
	var insert = $("#ate_codigo").val()=="";
	if(!insert)
		$("#table-ate tr").slice(0, 5).remove();	
	else
		$("#ate_codigo").val(json.ate_codigo);
	
	// forms que precisam do ate_codigo: proc
	$("input[name=ate_codigo]").val(json.ate_codigo);
		
	$("#table-ate").prepend(tr);
}

/* Procedimentos */
function mostrarFormProcedimento(){
	var ate = $("#ate_codigo").val();
	if(ate == ""){
		mensagem("Erro!","Antes de realizar um procedimento é necessario fazer a consulta!", 330, 150);
		return;
	}
	
	$("#form-proc").slideToggle();
}

function procAddFromJson(json){
	var tr = "<tr id=\"pat_"+json.pat_codigo+"\">";
	tr += "<td><img class=\"a\" onclick=\"procExcluir("+json.pat_codigo+")\" src=\""+baseUrl+"/public/images/icons/excluir.png\" alt=\"Excluir\" title=\"Excluir\" /></td>";
	tr += "<td>"+dataToBr(json.ate_data)+"</td>";
	tr += "<td>"+json.proc_nome+"</td>";
	tr += "<td>"+(json.cd10_descricao?json.cd10_descricao:"--")+"</td>";
	tr += "<td>"+json.usr_nome+"</td>"
	tr += "<td>"+json.esp_nome+"</td></tr>";
	
	$("#table-proc tbody").prepend(tr);
	destacar("#pat_"+json.pat_codigo);
}

function procExcluir(id){
	confirme("Confirme","Deseja realmente excluir este procedimento?",300,120, function(){
		$("#pat_"+id+" td:first").html('<img src="'+baseUrl+'/public/images/loading.gif" class="loading" />');
		
		$.ajax({
			url: baseUrl+'/prontuario/procedimento/excluir',
			type: 'get',
			data:{
				id: id,
				json: true
			},
			success: function(){
				$("#pat_"+id).slideUp(function(){
					$(this).remove();
					verificarEm("procedimentos","span","Nenhum procedimento cadastrado");
				});
			}
		});
	});
	
}

/* helpers */
function verificarEm(classe, filho, texto){
	if(!$("div."+classe+" "+filho).size()){
		$("div."+classe+" .space").before("<em>"+texto+"</em>").find("em").hide().slideDown("normal");
	}
}

function escondeEm(classe){
	$("div."+classe+" em").hide();
}

function getUsuCodigo(){
	return $("#usu_codigo").val();
}

function destacar(seletor){
	$(seletor).effect("highlight", {}, 1000);
}