/* -----------------------------------/ 
 * FUNÇÕES GERAIS                     /  
 * ----------------------------------*/
// Função que carrega ao abrir a página
$(function(){
   
    
    $(".adulto, .crianca").each(function(){
        // Armazenando o valor de cada dente, de acordo com cada ID
        this.innerHTML = $(this).data("dente");
    }).click(function(){
        $('#odo_proc_dtprogramada').live('focus', function () { $(this).datepicker({ changeMonth: true, changeYear: true }) });
        // Pegando o ID do dente
        var denteNum = $(this).data("dente").toString();
        // Pega o Nome do dente, de acordo com a função getNome
        var dente = getNome(denteNum);
            // Exibindo nome do dente 
            $("body").append("<div id=\"dente-dialog\" title=\"Dente: "+dente+"\"></div>");
            $("#dente-dialog")
            .html("<img src=\""+baseUrl+"/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando Cadastro de Procedimento...\" />")
            .dialog({
                modal: true,
                width: 640,
                height: 380,
                buttons:{
                    Cancelar: function(){
                        $("#dente-dialog").dialog("destroy").remove();
                    },
                    Salvar: function(){
                        
                        if (validarTratamento() == true) {   
                            $.ajax({
                                url:baseUrl+"/prontuario/odontograma/salvar-procedimento",
                                type: "POST",
                                data: {
                                    odo_proc_dentenum: $("#odo_proc_dentenum").val(),
                                    odo_proc_denteface: retornaFaces(),
                                    proc_codigo: $("#proc_codigo").val(),
                                    odo_proc_denteanot: $("#odo_proc_denteanot").val(),
                                    odo_proc_status: retornaStatus(),
                                    odo_proc_dtprogramada: $("#odo_proc_dtprogramada").val()
                                },
                                success:function(txt){
                                    
                                    $("#dente-dialog").dialog("destroy").remove();
                                    mensagem("Confirmação de Cadastro","Procedimento cadastrado com sucesso!", 350, 120);
                                    if (txt != "procedimentoInserido") {
                                        incluiProcedimentoRealizado(txt);
                                    }
                                }
                            });
                        }
                    }
                }
            })
            .load(baseUrl+"/prontuario/odontograma/cadastra-procedimento/dente/"+denteNum,function(){
                // Depois vai ter que pintar os dentes  
                //incluiProcedimento();
                bindFaces();
            });
    }).hover(function(){
            $("#nome").html("<strong>Dente:</strong> "+getNome( $(this).data("dente").toString() ));

    }, function(){
            $("#nome").html("<strong>Selecione um dente</strong>");
    });
    // Carrega o histórico de procedimentos realizados pelo paciente
    carregaHistDeProcReal();
});
// Função que retorna faces selecionadas

function mostra_dt_programada(){
  $(".data-programada").show();
}

function esconde_dt_programada(){
  $(".data-programada").hide();
}

function retornaFaces(){
   var face = "";
   if( $("#face1").is(':checked') ){
    face += $("#face1").val();
   }
   if( $("#face2").is(':checked') ){
    face += $("#face2").val();
   }
   if( $("#face3").is(':checked') ){
    face += $("#face3").val();
   }
   if( $("#face4").is(':checked') ){
    face += $("#face4").val();
   }
   if( $("#face5").is(':checked') ){
    face += $("#face5").val();
   }
   return face;
}
// Função que retorna status selecionadas
function retornaStatus(){
   if($("#odo_proc_statusT").is(':checked')){
       return true;
   } else {
       return false;
   }
}
// Adiciona eventos depois de abrir o dialog(modal) do dente
function bindFaces(){
    $("area").click(function(){
        var area = $(this).data("area");
        var ckeckbox = $("#face"+area);
        ckeckbox.attr('checked',!ckeckbox.is(':checked'));
    }).hover(function(){		
            var area = $(this).data("area");
            $("#face"+area).next().css("font-weight","bold");
    }, function(){
            var area = $(this).data("area");
            $("#face"+area).next().css("font-weight","normal");
    });
}
// globais
var DENTES_ADULTO = new Array( '', 'Incisivo Central', 'Incisivo Lateral', 'Canino', '1º Premolar', '2º Premolar', '1º Molar', '2º Molar', '3º Molar');
var DENTES_CRIANCA = new Array( '', 'Incisivo Central', 'Incisivo Lateral', 'Canino', '1º Molar', '2º Molar' );
// Retorna o nome do dente de acordo com o tipo citado acima
function getNome(n){
    var q 	= n.substring(0,1);
    var d 	= n.substring(1);
    var qs,qp;	

    if( q <= 4 ){ // adulto
            qs  = ( q == 1 || q == 2 ? 'superior' : 'inferior' );
            qp	= ( q == 1 || q == 4 ? 'direito' : 'esquerdo' );
            return DENTES_ADULTO[d] + ' ' + qs + ' ' + qp;

    } else{ // crianca
            qs  = ( q == 5 || q == 6 ? 'superior' : 'inferior' );
            qp	= ( q == 5 || q == 8 ? 'direito' : 'esquerdo' );
            return DENTES_CRIANCA[d] + ' ' + qs + ' ' + qp;
    }
}
function imprimirProcedimentos(){
    $("body").append("<div id='imprimir-procedimentos' title='Impressão de procedimentos realizados e a realizar' ></div>");
    $("#imprimir-procedimentos")
    .html("<img src="+baseUrl+"/public/images/load.gif alt='Carregando' title='Carregando impressão ...' />")
    .dialog({
        modal:true,
        width: 640,
        height: 380,
        buttons: {
            Imprimir:function(){
                //$('.camada_para_impressao').printElement();
                $("#print").printElement();
            }
        }
    })
    .load(baseUrl+"/prontuario/odontograma/imprimir-procedimentos");
}
function imprimirOdontograma(){
    $("body").append("<div id='imprimir-odontograma' title='Impressão de odontograma e procedimentos realizados' ></div>");
    $("#imprimir-odontograma")
    .html("<img src="+baseUrl+"/public/images/load.gif alt='Carregando' title='Carregando impressão ...' />")
    .dialog({
        modal:true,
        width: 760,
        height: 550,
        buttons: {
            Imprimir:function(){
                //$('.camada_para_impressao').printElement();
                $("#print").printElement();
            }
        }
    })
    .load(baseUrl+"/prontuario/odontograma/imprimir-odontograma",function (){
        $(".adulto, .crianca").each(function(){
            // Armazenando o valor de cada dente, de acordo com cada ID
            this.innerHTML = $(this).data("dente");
        })
        carregaHistDeProcReal();
    });
}
// Função que valida os campos obrigatórios
function validarTratamento(){
    var v_checked = $('input:radio[name="odo_proc_status"]:checked').val();
    var msg_erro = "";
    if(v_checked == "F"){
        var data_atual = $("#dt_atual").val();
        var data_programada = $("#odo_proc_dtprogramada").val().split("/");
        var dt_programada = data_programada[2]+"-"+data_programada[1]+"-"+data_programada[0];
        
        if(!$("#odo_proc_dtprogramada").val()){
            msg_erro += " * Informe uma data para o procedimento!<br />";
        }
        
        if(data_atual > dt_programada){
            msg_erro +=  msg_erro += " * A data a ser realizada é maior que a atual!<br />";
        }
    }
    
    if(!$("#proc_codigo").val()){
        msg_erro += " * Selecione um procedimento!<br />";
    }
    
    //alert(retornaFaces());
    if(retornaFaces() == ""){
        msg_erro += " * Face do procedimento não selecionada!";
    }
    if (msg_erro != "") {
        $("#action-errors").remove();
        $("#formDente").prepend("<div class=\"ui-state-highlight erro\" id=\"action-errors\" style=\"width: 556px;\">"+msg_erro+"</div>");
        return false;
    } else {    
        return true;
    }
}
/* -----------------------------------/ 
 * FIM DAS FUNÇÕES GERAIS             /  
 * ----------------------------------*/
/* -----------------------------------/ 
 * FUNÇÕES TRATAMENTOS                /  
 * ----------------------------------*/
// Função responsavel por salvar o inicio do tratamento e a carregar o odontograma
function iniciarTratamento() {    
    mensagemSemOk("carregando-ate", "Aguarde", "Iniciando tratamento...", 280, 80);
    $.ajax({
            url: baseUrl+'/prontuario/odontograma/salvar-tratamento',
            type: "POST",
            success: function(txt){
                window.location = baseUrl + "/prontuario/odontograma/";
            },
            error: function(pq){alert(pq)}
    });
}
// Função responsavel por carregar o modal de lista de tratamentos realizados
function listaTratamentosRealizados(){
    $("body").append("<div id='tratamentos-realizados' title='Consulta de listagem de tratamentos realizados' ></div>");
    $("#tratamentos-realizados")
    .html("<img src="+baseUrl+"/public/images/load.gif alt='Carregando' title='Carregando listagem de tratamentos' />")
    .dialog({
        modal:true,
        width: 640,
        height: 380
    })
    .load(baseUrl+"/prontuario/odontograma/lista-tratamentos-realizados");
}
// Função que carrega o tratamento
function consultaTratamento(odo_trat_codigo){
    // Exibindo nome do dente 
    $("body").append("<div id=\"consulta-tratamento\" title=\"Consulta de tratamento\"></div>");
    $("#consulta-tratamento")
    .html("<img src=\""+baseUrl+"/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando consulta...\" />")
    .dialog({
        modal: true,
        width: 760,
        height: 500,
       buttons: {
            Imprimir:function(){
                //$('.camada_para_impressao').printElement();
                $("#print").printElement();
            }
        }
    })
    .load(baseUrl+"/prontuario/odontograma/consulta-tratamento/tratCodigo/"+odo_trat_codigo,function(){
        $(".consulta-adulto, .consulta-crianca").each(function(){
            // Armazenando o valor de cada dente, de acordo com cada ID
            this.innerHTML = $(this).data("consulta-dente");
        });
        carregaConsultaHistDeProcReal(odo_trat_codigo);
        carregaHistDeProcReal();
    });
}
// Função responsável por executar a finalização do tratamento
function finalizarTratamento(){
    $.ajax({
        url:baseUrl+"/prontuario/odontograma/finalizar-tratamento",
        type: "POST",
        success:function (txt){
            if (txt == "ok")  {
                mensagemSemOk("carregando-ate","Aguarde","Finalizando Tratamento",280,80);
                window.location = baseUrl+"/prontuario/odontograma/"
            } else {
               mensagem("Erro","Ainda existe procedimentos a serem realizado!", 350, 120);
            }
        }
    });
}
// Limpas dente do odontograma do tratamento carregado
function limparDentesConsulta(){
    $("div[data-consulta-dente] div").remove();
    _b = [];
}
// Pinta dentes do odontograma do tratamento carregado
function pintarDentesConsulta(json){
    //alert(json);
    for(var i in json){
        var denteNum = json[i].n;
        var faces = json[i].f;
        var proc  = json[i].s;
        for(var x in faces){
            addProcedimentoConsulta(denteNum, faces[x], proc);
        }
    }
}
// Adiciona procedimento do dente do odontograma do tratamento carregado
var _b = [];
function addProcedimentoConsulta(denteNum, face, procedimento){
    // Controle das faces de cima e de baixo
    if (denteNum > 28) {
        var faces = {
             "V" : 3,
             "M" : 2,
             "L" : 1,
             "D" : 4,
             "O" : 5,
             "N" : "full"
         }
     } else {
        var faces = {
             "V" : 1,
             "M" : 2,
             "L" : 3,
             "D" : 4,
             "O" : 5,
             "N" : "full"
         }
     }
     // Setando a div do dente para dente
     var dente = $("div[data-consulta-dente="+denteNum+"]");
     // Insere procedimentos laranja
     if (procedimento >= 28956 && procedimento <= 28974) {
         // Indica onde esta a imagem
         var img = baseUrl+"/public/images/dente/dentes_novos/adulto/vermelho/dente_adulto_verm_face"+faces[face]+".gif";
     }
     // Insere procedimentos marrom
     if (procedimento >= 28975 && procedimento <= 31222) {
         // Indica onde esta a imagem
         var img = baseUrl+"/public/images/dente/dentes_novos/adulto/laranja/dente_adulto_laranja_face"+faces[face]+".gif";
     }
     // Insere procedimentos azul
     if (procedimento >= 31223 && procedimento <= 31232) {
         // Indica onde esta a imagem
         var img = baseUrl+"/public/images/dente/dentes_novos/adulto/azul/dente_adulto_azul_face"+faces[face]+".gif";
     }
     // Inserindo onde esta a imagem
     dente.append("<div style='position:absolute; top:11px; right:0px; padding: 1px 4px;'><img src='"+img+"' border=0 />");
}
/* -------------------------------------/
 * FIM DAS FUNÇÕES DE TRATAMENTOS       /
 * ------------------------------------*/
/* ---------------------------------------------/
 * FUNÇÕES DE PROCEDIMENTOS A REALIZAR          /
 * --------------------------------------------*/
// Função responsável por chamar os procedimentos a realizar
function procedimentosaRealizar(){
    // Exibindo nome do dente 
    $("body").append("<div id=\"procedimentos-realizar\" title=\"Lista de procedimentos a realizar\"></div>");
    $("#procedimentos-realizar")
    .html("<img src=\""+baseUrl+"/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando Cadastro de Procedimento...\" />")
    .dialog({
            modal: true,
            width: 700,
            height: 400,
    })
    .load(baseUrl+"/prontuario/odontograma/lista-procedimentos/",function(){
        
    });
}
/* ---------------------------------------------/
 * FIM DAS FUNÇÕES DE PROCEDIMENTOS A REALIZAR  /
 * --------------------------------------------*/
/* -----------------------------------/ 
 * FUNÇÕES PROCEDIMENTOS REALIZADOS   /  
 * ----------------------------------*/
// Função que seta o procedimento como realizado exclui dos pensentes e insere nos realizados
function salvarProcedimentoRealizado(odo_proc_codigo){
    $("#proc-codigo"+odo_proc_codigo)
    .attr("src",baseUrl+"/public/images/loading.gif")
    .attr("title","Carregando");
    $.ajax({
        url: baseUrl+'/prontuario/odontograma/salvar-procedimento-realizado',
        type: "POST",
        data: {
            odo_proc_codigo: odo_proc_codigo
        },      
        success: function(txt){
            var odo_preal_codigo = txt;
            // Coloca nova img
            $("#proc-codigo"+odo_proc_codigo)
            .attr("src",baseUrl+"/public/images/icons/accept.png")
            .attr("title","Realizado");
            // E insere linha em procedimentos realizados, txt é o código a ser inserido
            incluiProcedimentoRealizado(odo_preal_codigo);
        }
    });
}
// Função que inclui linha nos procedimentos realizados
function incluiProcedimentoRealizado(odo_preal_codigo)
{
var listaProcedimentos = "";
$.ajax({url: baseUrl+"/prontuario/odontograma/get-procedimento-realizado",
    type: "POST",
    data:{
        odo_preal_codigo:odo_preal_codigo
    },
    success: function(txt){
        // Validaçoes
        if (txt.odo_preal_denteanot == "") {
            var denteanot = "--";
        } else {
            var denteanot = txt.odo_preal_denteanot;
        }
        // Criando lista de procedimentos
        listaProcedimentos +="<tr id='proc-num"+txt.odo_preal_codigo+"'>"+
                        "<td class='ui-state-default'>"+txt.proc_nome+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_preal_dentenum+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_preal_denteface+"</td>"+
                        "<td class='ui-state-default'>"+denteanot+"</td>"+
                        "<td class='ui-state-default'>"+
                                "<a href='#'>"+
                                        "<img title='Excluir' alt='Excluir' src='/WebSocialSaude/zf/public/images/icons/excluir.png' onclick=excluiProcedimentoRealizado("+txt.odo_preal_codigo+");></img>"+
                                "</a>"+
                        "</td>"+
                        "<td class='ui-state-default'>"+
                                "<a href='#'>"+
                                        "<img title='Editar' alt='Editar' src='/WebSocialSaude/zf/public/images/icons/editar.png' onclick='editaProcedimentoRealizado("+txt.odo_preal_codigo+");'></img>"+
                                "</a>"+
                        "</td>"+
                    "</tr>";
        $("#nenhum-result").remove();
        // Loading de carregando ...
        $("#result")
        .attr("src",baseUrl+"/public/images/load.gif")
        .attr("title","Carregando");
        // Inserindo procedimento realizado na lista
        $("#result").prepend(listaProcedimentos);
        // Pinta o dente do procedimento realizado
        carregaProcReal(odo_preal_codigo);
    }
});
}
// Função que exclui o procedimento realizado
function excluiProcedimentoRealizado(odo_preal_codigo){
    $.ajax({
        url:baseUrl+"/prontuario/odontograma/confere-procedimento-realizado-atendimento",
        type: "POST",
        data: {
            odo_preal_codigo: odo_preal_codigo
        },
        success:function(txt){
            if (txt == "true") {
                confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function(){
                    $("#proc-num"+odo_preal_codigo+"")
                    .attr("src",baseUrl+"/public/images/loading.gif")
                    .attr("title","Carregando");
                    $.ajax({
                        url:baseUrl+"/prontuario/odontograma/excluir-procedimento-realizado",
                        type: "POST",
                        data: {
                            odo_preal_codigo: odo_preal_codigo
                        },
                        success:function(txt){
                            $("#proc-num"+odo_preal_codigo).fadeOut('slow', function(){ $(this).remove(); });
                            //$("#proc-num"+odo_preal_codigo).remove(); 
                            // Carrega a lista de procedimento realizados
                            carregaHistDeProcReal();
                        }
                    });
                });
            } else {
                 mensagem("Erro:","Procedimento não está vinculado com o atendimento atual! Não pode ser apagado!", 320, 180);
            }
        }
    });
}
// Função que edita o procedimento realizado
function editaProcedimentoRealizado(odo_preal_codigo){
    $.ajax({
        url:baseUrl+"/prontuario/odontograma/confere-procedimento-realizado-atendimento",
        type: "POST",
        data: {
            odo_preal_codigo: odo_preal_codigo
        },
        success:function(txt){
            if (txt == "true") {
                // Exibindo nome do dente 
                $("body").append("<div id=\"dente-dialog\" title=\"Edição de procedimentos realizado\"></div>");
                $("#dente-dialog")
                .html("<img src=\""+baseUrl+"/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando Edição de Procedimento...\" />")
                .dialog({
                    modal: true,
                    width: 640,
                    height: 380,
                    data: {

                    },
                    buttons:{
                        Cancelar: function(){
                            $("#dente-dialog").dialog("destroy").remove();
                        },
                        Salvar: function(){
                            $.ajax({
                                url:baseUrl+"/prontuario/odontograma/salvar-posts-procedimento-realizado",
                                type: "POST",
                                data: {
                                    odo_preal_codigo: $("#odo_preal_codigo").val(),
                                    odo_pcon_codigo: $("#odo_pcon_codigo").val(),
                                    odo_preal_denteface: retornaFaces(),
                                    proc_codigo: $("#proc_codigo").val(),
                                    odo_preal_denteanot: $("#odo_preal_denteanot").val()
                                },
                                success:function(txt){
                                    $("#dente-dialog").dialog("destroy").remove();
                                    mensagem("Confirmação:","Procedimento editado com sucesso!", 350, 120);
                                    $("#proc-num"+odo_preal_codigo).remove();
                                    incluiProcedimentoRealizado(odo_preal_codigo);
                                }
                            });
                        }
                    }
                })
                .load(baseUrl+"/prontuario/odontograma/edita-procedimento-realizado/procRealCodigo/"+odo_preal_codigo+"",function(){
                    bindFaces();
                });
            } else {
                mensagem("Erro:","Procedimento não está vinculado com o atendimento atual! Não pode ser editado!", 320, 180);
            }
        }
    });
    // Carrega a lista de procedimento realizados
    carregaHistDeProcReal();
}
// Carrega o histórico de procedimentos realizados
function carregaHistDeProcReal(odo_trat_codigo){
    //carregandoAba(1);
    limparDentes();
    $.ajax({
        dataType: "json",
        url: baseUrl+"/prontuario/odontograma/lista-procedimentos-realizado",
        type: "POST",
        data: {
            odo_trat_codigo:odo_trat_codigo
        },
        //url: baseUrl+"/prontuario/odontograma/procedimentos",
        success: function(json){
            pintarDentes(json);
            carregandoAba(0);
        }
    });
}
// Carrega o histórico de procedimentos realizados
function carregaConsultaHistDeProcReal(odo_trat_codigo){
    //carregandoAba(1);
    limparDentesConsulta();
    $.ajax({
        dataType: "json",
        url: baseUrl+"/prontuario/odontograma/lista-procedimentos-realizado",
        type: "POST",
        data: {
            odo_trat_codigo:odo_trat_codigo
        },
        //url: baseUrl+"/prontuario/odontograma/procedimentos",
        success: function(json){
            pintarDentesConsulta(json);
            carregandoAba(0);
        }
    });
}
// Carrega somente o procedimento realizado especificado
function carregaProcReal(odo_preal_codigo){
    $.ajax ({
        url: baseUrl+"/prontuario/odontograma/lista-procedimentos-realizado",
        type: "POST",
        data:{
            odo_preal_codigo: odo_preal_codigo
        },
        success: function(json) {
            pintarDentes(json);
        }
    });
}
function limparDentes(){
	$("div[data-dente] div").remove();
	_b = [];
}
function pintarDentes(json){
    //alert(json);
    for(var i in json){
        var denteNum = json[i].n;
        var faces = json[i].f;
        var proc  = json[i].s;
        for(var x in faces){
            addProcedimento(denteNum, faces[x], proc);
        }
    }
}
var _b = [];
function addProcedimento(denteNum, face, procedimento){
    // Controle das faces de cima e de baixo
    if (denteNum > 28) {
        var faces = {
             "V" : 3,
             "M" : 2,
             "L" : 1,
             "D" : 4,
             "O" : 5,
             "N" : "full"
         }
     } else {
        var faces = {
             "V" : 1,
             "M" : 2,
             "L" : 3,
             "D" : 4,
             "O" : 5,
             "N" : "full"
         }
    }
    // Setando a div do dente para dente
    var dente = $("div[data-dente="+denteNum+"]");
    // Insere procedimentos laranja
    if (procedimento >= 28956 && procedimento <= 28974) {
        // Indica onde esta a imagem
        var img = baseUrl+"/public/images/dente/dentes_novos/adulto/vermelho/dente_adulto_verm_face"+faces[face]+".gif";
    }
    // Insere procedimentos marrom
    if (procedimento >= 28975 && procedimento <= 31222) {
        // Indica onde esta a imagem
        var img = baseUrl+"/public/images/dente/dentes_novos/adulto/laranja/dente_adulto_laranja_face"+faces[face]+".gif";
    }
    // Insere procedimentos azul
    if (procedimento >= 31223 && procedimento <= 31232) {
        // Indica onde esta a imagem
        var img = baseUrl+"/public/images/dente/dentes_novos/adulto/azul/dente_adulto_azul_face"+faces[face]+".gif";
    }
    // Inserindo onde esta a imagem
    dente.append("<div style='position:absolute; top:11px; right:0px; padding: 1px 4px;'><img src='"+img+"' border=0 />");
}
/* ---------------------------------------------/
 * FIM DAS FUNÇÕES DE PROCEDIMENTOS REALIZADOS  /
 * --------------------------------------------*/


/*
function calend(){
    $(".data").datepicker();
}

function novoTratamento(){
    $(".data").datepicker();
    $("body").append("<div id=\"dente-dialog\" title=\"Odontograma - Cadastro de Tratamento\"></div>");
    $("#dente-dialog")
    .html("<img src=\""+baseUrl+"/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando...\" />")
    .dialog({
            modal: true,
            width: 600,
            height: 280,
            buttons:{
                    Cancelar: function(){
                        $("#dente-dialog").dialog("destroy").remove();
                    },
                    Salvar: function(){
                        $.ajax({
                            url:baseUrl+"/prontuario/odontograma/salvar-tratamento",
                            type: "POST",
                            data: {
                                odo_trat_titulo: $("#odo_trat_titulo").val(),
                                odo_trat_dtinicial: $("#odo_trat_dtinicial").val(),
                                odo_trat_dtfinal: $("#odo_trat_dtfinal").val(),
                                odo_trat_dt_previsaofim: $("#odo_trat_dt_previsaofim").val(),
                                odo_trat_status: $("#odo_trat_status").val()
                            },
                            success:function(txt){
                                $("#dente-dialog").dialog("destroy").remove();
                                incluiTratamento();
                            }
                        })
                    }
            }
    })
    .load(baseUrl+"/prontuario/odontograma/novo-tratamento",function(){
    });
}

function incluiTratamento()
{
var listaTratamentos = "";
$.ajax({url: baseUrl+"/prontuario/odontograma/lista-tratamento",
    type: "POST",
    success: function(txt){
        listaTratamentos +="<tr id='proc-num"+txt.odo_trat_codigo+"'>"+
                        "<td class='ui-state-default'>"+txt.odo_trat_titulo+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_trat_dtinicial+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_trat_dtfinal+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_trat_dt_previsaofim+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_trat_status+"</td>"+
                        "</tr>";
        $("#result").prepend(listaTratamentos);
    }
});
}
function listaProcedimentos(){
$(function(){
	$(".adulto, .crianca").each(function(){
            // Armazenando o valor de cada dente, de acordo com cada ID
            this.innerHTML = $(this).data("dente");
        }).click(function(){		
            // Pegando o ID do dente
            var denteNum = $(this).data("dente").toString();
            // Pega o Nome do dente, de acordo com a função getNome
            var dente = getNome(denteNum);
            	// Exibindo nome do dente 
                $("body").append("<div id=\"dente-dialog\" title=\"Dente: "+dente+"\"></div>");
                $("input.data").datepicker();
		$("#dente-dialog")
		.html("<img src=\""+baseUrl+"/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando...\" />")
		.dialog({
			modal: true,
			width: 640,
			height: 380,
			buttons:{
				Cancelar: function(){
                                    $("#dente-dialog").dialog("destroy").remove();
				},
				Salvar: function(){
                                    $("#formDente").submit();
                                    incluiProcedimento();
                                }
			}
		})
		.load(baseUrl+"/prontuario/odontograma/info/dente/"+denteNum,function(){
                    //incluiProcedimento();
                    bindFaces();
		});
	}).hover(function(){
		$("#nome").html("<strong>Dente:</strong> "+getNome( $(this).data("dente").toString() ));
		
	}, function(){
		$("#nome").html("<strong>Selecione um dente</strong>");
	});
        // Carrega o histórico do paciente
        carregarHistorico();
        
        
});

}

insereProcedimentoRealizado
function incluiProcedimento()
{
var listaProcedimentos = "";
$.ajax({url: baseUrl+"/prontuario/odontograma/lista-ultimo-procedimento",
    type: "POST",
    success: function(txt){
        
        listaProcedimentos +="<tr id='proc-num"+txt.odo_proc_codigo+"'>"+
                        "<td class='ui-state-default'>"+txt.proc_nome+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_proc_dentenum+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_proc_denteface+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_proc_data_programado+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_proc_finalizado+"</td>"+
                        "<td class='ui-state-default'>"+txt.odo_proc_denteanot+"</td>"+
                        "<td class='ui-state-default'>"+
                                "<a href='#'>"+
                                        "<img title='Excluir' alt='Excluir' src='/WebSocialSaude/zf/public/images/icons/excluir.png' onclick=excluiProcedimento("+txt.od_hist_codigo+");></img>"+
                                "</a>"+
                        "</td>"+
                        "<td class='ui-state-default'>"+
                                "<a href='#'>"+
                                        "<img title='Editar' alt='Editar' src='/WebSocialSaude/zf/public/images/icons/editar.png' onclick='editarProcedimento("+txt.od_hist_codigo+");'></img>"+
                                "</a>"+
                        "</td>"+
                    "</tr>";
        $("#result").prepend(listaProcedimentos);
        carregarHistorico();
    }
});
}
*/

