const URL = baseUrl + "/relatorio/certidao-liberatoria";

function formSalvar(e) {
    if (validaForm('form_cert_lib', e)) {
        e.preventDefault();
        var valoresForm = $("#form_cert_lib").serialize();
        $.ajax({
            url: URL + '/form-salvar',
            type: "POST",
            data: valoresForm,
            success: function (txt) {

                if (txt > 0) {
                    mensagem("Confirmação", "Dados salvos com sucesso.", 250, 120, function () {
                        $("#dc_form_cadastro_certidao").remove();
                        atualizaPagina();
                    });
                } else {
                    $("#dcbalert_cad_cert").html(txt);
                    $("#dcbalert_cad_cert").show(txt);
                }

            }
        });
    } else {
        return false;
    }
}


// function validaDataForm() {
//     if ($("#cd_nacionalidade option:selected").val() == 'N') {
//         if (betweenDate($("#pep_data_naturalizacao").val(), $("#datanascimento").val(), $("#dataatual").val())) {
//             return true;
//         } else {
//             mensagem("Atenção", "Data de naturalização deve estar entre data nascimento e atual!", 300, 150);
//             $("#pep_data_naturalizacao").focus();
//             return false;
//         }
//     }
//     if ($("#cd_nacionalidade option:selected").val() == 'E') {
//         if (betweenDate($("#pep_data_entrada_pais").val(), $("#datanascimento").val(), $("#dataatual").val())) {
//             return true;
//         } else {
//             mensagem("Atenção", "Data de entrada no país deve estar entre data nascimento e atual!", 300, 150);
//             $("#pep_data_entrada_pais").focus();
//             return false;
//         }
//     }
//     return true;
// }

function cadastroCertidao(ascl_codigo) {
    $("body").append("<div id='dc_form_cadastro_certidao' title='Certidão Liberatória' ></div>");
    abrirModal(
        'dc_form_cadastro_certidao',
        URL + "/form-certidao-liberatoria/ascl_codigo/" + ascl_codigo
    );

}

function imprimirCertidao(ascl_codigo) {

    callGenerateReport(
        baseUrl + "/relatorio/certidao-liberatoria/rel-certidao-liberatoria",
        {
            "ascl_codigo": ascl_codigo
        }
    );
}

function pesquisaDados() {
    setTimeout(function () {
        $.ajax({
            url: URL + "/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#busca_cert").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>"
                    + "<thead>"
                    + "    <tr>"
                    + "        <th width='10%' class='coluna-center'>Número</th>"
                    + "        <th width='30%'>Unidade</th>"
                    + "        <th width='20%' class='coluna-data'>Data de Concessão</th>"
                    + "        <th width='20%' class='coluna-data'>Validade</th>"
                    + "        <th class='coluna-acoes'>Ações</th>"
                    + "    </tr>"
                    + "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element, index, array) {


                        tr += "<tr>"
                            + "    <td class='coluna-center'>" + element.ascl_numero + "/" + element.ascl_numero + "</td>"
                            + "    <td>" + element.uni_desc + "</td>"
                            + "    <td class='coluna-data'>" + dataToBr(element.ascl_data_concessao) + "</td>"
                            + "    <td class='coluna-data'>" + dataToBr(element.ascl_data_validade) + "</td>"
                            + "    <td class='coluna-acoes'>"
                            + "        <a class='btn btn-info' title='Editar'"
                            + "           onclick='cadastroCertidao(" + element.ascl_codigo + ")'>"
                            + "            <i class='icon-edit icon-white'></i>"
                            + "        </a>"
                            + "        <a class='btn btn-warning' title='Imprimir'"
                            + "           onclick='imprimirCertidao(" + element.ascl_codigo + ")'>"
                            + "            <i class='icon-print icon-white'></i>"
                            + "        </a>"
                            + "    </td>"
                            + "</tr>";

                    });
                } else {
                    tr += "<tr>" +
                        "<td colspan='6'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    }, 3000);
}
