$(function(){

    $.validator.addMethod("usr_tipo_medico", function(usr_tipo_medico, element) {
        
        if(usr_tipo_medico == "M" || usr_tipo_medico == "E" || usr_tipo_medico == "A" || usr_tipo_medico == "D" || usr_tipo_medico == "P"){
            if($(".esp_codigo").length == 0){
                return false;
            }else{
                return true;
            }
        }else{
            return true;
        }
        
     }, "Informe uma especialidade");
     
     if($("#con_codigo").val() != ''){
         $("#num_conselho").show();
     }

    $("#form").validate({
           rules: {
               usr_senha:{
                    minlength:3
                },
               usr_senha_confirm:{
                    equalTo : "#usr_senha"
               },
               usr_nome:{
                   required: true,
                   minlength: 4
               },
               usr_login:{
                   minlength: 4
               },
               login_invalido:{
                   required: true,
               }
               //usr_tipo_medico:{usr_tipo_medico:true}
           },
           messages: {
               usr_senha:{
                    required: "Preencha o campo senha",
                    minlength : "Coloque no minimo 3 caracteres"
               },
               usr_senha_confirm:{
                    equalTo : "Não é igual o campo senha"
               },
               usr_nome:{
                   minlength : "Coloque no minimo 3 caracteres",
                   required: "Preencha um Nome"
               },
               usr_login:{
                   minlength : "Coloque no minimo 4 caracteres"},
               login_invalido:{
                   required: "O login já existe",
               }

//               usr_tipo_medico: "Informe uma especialidade"
           }
    });

    $('.password_strength').pstrength();
    
    
    $("#uni_desc").buscar({
        url: baseUrl+"/unidade/buscar",
        template : function(ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: adicionaUnidade
    });
    
    //Alteração de senha
    $("#form-alterasenha").validate({
        rules: {
            nova_senha:{
                minlength: 8
            },
            confirma_senha:{
                equalTo : "#nova_senha"
            }
        },
        messages: {
            nova_senha:{
                required: "Preencha o campo senha",
                minlength : "Coloque no minimo 8 caracteres"
            },
            confirma_senha:{
                equalTo : "A senha não confere"
            }
        }
    });
    var tpl = "<span id='valida_atual' style='display: none; border: 1px solid #cd0a0a; " +
              "      background: #b81900 url(../../css/images/ui-bg_diagonals-thick_18_b81900_40x40.png) 50% 50% repeat; " +
              "      color: #ffffff;'>Senha Atual não confere</span> <input type='checkbox' id='vs_atual' onclick='visualizaSenha(this,\"senha_atual\")'><span>Visualizar</span>";
    $(tpl).insertAfter("#senha_atual");
    $("<input type='checkbox' id='vs_senha' onclick='visualizaSenha(this, \"nova_senha\")'> <span>Visualizar</span>").insertAfter("#nova_senha");
    $("<input type='checkbox' id='vs_confirma' onclick='visualizaSenha(this, \"confirma_senha\")'> <span>Visualizar</span>").insertAfter("#confirma_senha");

});


function chamaBuscaEsp(){
    $("#esp_nome").buscar({
        url: baseUrl+'/especialidade/buscar/',
        template : function(ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: adicionaLinhaEspecialidade
    });
}

function adicionaLinhaEspecialidade() {
    if ($(".tr_esp_" + $("#esp_codigo").val()).length == 0) {
        $(".tb_especialidades").show();
        $(".tb_especialidades").append("<tr class=\"tr_esp_" + $("#esp_codigo").val() + " l_esp\"><td >" + $("#esp_nome").val() + "<input type=\"hidden\" name=\"esp_codigo[]\" class=\"esp_codigo\" value=\"" + $("#esp_codigo").val() + "\">" +
            "<input type=\"hidden\" id=\"esp_nome_" + $("#esp_codigo").val() + "\" name=\"esp_nome[]\" class=\"esp_nome\" value=\"" + $("#esp_nome").val() + "\"></td><td ><img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"deleteRowEsp(" + $("#esp_codigo").val() + ")\"></td></tr>");
    }
    $("#esp_nome").val("");
    $("#esp_codigo").val("");
}


function mostraNumeroConselho(){
    if($("#con_codigo").val() != ""){
        $("#num_conselho").show();
    }else{
        $("#num_conselho").hide();
    }
}

function chamaBuscaSet(){
    $("#set_nome").buscar({
        url: baseUrl+'/setor/buscar/',
        template : function(ul, item) {
                return $("<li></li>").data("item.autocomplete", item).append(
                        "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: adicionaSetor
    });
}

function bloqueia(){

    if($("#todas_unidades").is(":checked")){
        $(".l_uni").remove();
        $(".tb_unidades").hide();
        $("#uni_desc").attr('readonly', true);
    }else{
        $("#uni_desc").attr('readonly', false);
    }

}

function adicionaUnidade(){
    if($(".tr_"+$("#uni_codigo").val()).length == 0){
        $(".tb_unidades").show();
        $(".tb_unidades").append("<tr class=\"tr_" + $("#uni_codigo").val() + " l_uni\">" +
            "<td >" +
            $("#uni_desc").val() + "<input type=\"hidden\" name=\"uni_codigo[]\" class=\"uni_codigo\" value=\"" + $("#uni_codigo").val() + "\">" +
            "</td>" +
            "<td >" +
            "<img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' id='espec_vinc_" + $("#uni_codigo").val() + "' onClick=\"deleteRow(" + $("#uni_codigo").val() + ")\">" +
            "</td>" +
            "<td >" +
            "<img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/dentista.png'  title='Especialidade' alt='especialidade' onClick=\"adicionaEspecialidade(" + $("#uni_codigo").val() + ")\">" +
            "</td>" +
            "</tr>");

    }
    $("#uni_desc").val("");
    $("#uni_codigo").val("");
}

function adicionaEspecialidade(uni_codigo) {
    $("#conf-cadastro").dialog({
        modal: true,
        width: 500,
        height: 400,
        close: function () {
            $(".tb_especialidades").html("");
            $(this).dialog('close');
        },
        buttons: {
            "Realizar Vinculo": function () {
                realizarVinculoEspecialidadeUnidade(uni_codigo);
            },
            "Fechar": function () {
                $(".tb_especialidades").html("");
                $(this).dialog('close');
            }
        }
    });
}

function realizarVinculoEspecialidadeUnidade(uni_codigo) {
    if ($(".l_esp_" + uni_codigo).length == 0)
        $("#espec_vinc_" + uni_codigo).hide();
    else
        $("#espec_vinc_" + uni_codigo).show();

    $(".esp_codigo").each(function () {
        if ($(".tr_esp_" + uni_codigo + "_" + $(this).val()).length == 0) {
            $(".tr_" + uni_codigo).after("<tr class=\"tr_esp_" + uni_codigo + "_" + $(this).val() + "  l_esp_" + uni_codigo + "\">" +
                "<td colspan=2 style=\"background-color: #49afcd;\">" +
                "&nbsp;&nbsp;&nbsp;&nbsp;" + $("#esp_nome_" + $(this).val()).val() + "<input type=\"hidden\" name=\"esp_codigo_u[]\" class=\"esp_codigo_u\" value=\"" + $(this).val() + "\">" +
                "<input type=\"hidden\" name=\"uni_codigo_" + $(this).val() + "\" class=\"esp_codigo_u\" value=\"" + uni_codigo + "\">" +
                "</td>" +
                "<td style=\"background-color: #49afcd;\">" +
                "<img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"deleteRowEspUni(" + $(this).val() + "," + uni_codigo + ")\">" +
                "</td>" +
                "</tr>");
        }
    });
}

function deleteRowEspUni(esp_codigo, uni_codigo) {
    $(".tr_esp_" + esp_codigo).remove();
    if (uni_codigo) {
        if ($(".l_esp_" + uni_codigo).length == 0)
            $("#espec_vinc_" + uni_codigo).hide();
        else
            $("#espec_vinc_" + uni_codigo).show();

        $(".tr_esp_" + uni_codigo + "_" + esp_codigo).remove();
    }

    if ($("table tr").length == 0) {
        $(".tb_especialidades").hide();
    }
}

function adicionaSetor(){
     if($(".tr_esp_"+$("#esp_codigo").val()).length == 0){
        $(".tb_setores").show();
        $(".tb_setores").append("<tr class=\"tr_set_"+$("#set_codigo").val()+" l_esp\"><td >"+$("#set_nome").val()+"<input type=\"hidden\" name=\"set_codigo[]\" value=\""+$("#set_codigo").val()+"\"></td><td ><img style=\"cursor:pointer;\" src='"+baseUrl+"/public/images/icons/excluir2.png' onClick=\"deleteRowSet("+$("#set_codigo").val()+")\"></td></tr>");
     }
     $("#set_nome").val("");
     $("#set_codigo").val("");
}

function deleteRow(uni_codigo){
    $(".tr_"+uni_codigo).remove();
    if($("table tr").length == 0){
        $(".tb_unidades").hide();
    }
}

function deleteRowEsp(esp_codigo){
    $(".tr_esp_"+esp_codigo).remove();
    if($("table tr").length == 0){
        $(".tb_especialidades").hide();
    }
}

function deleteRowSet(set_codigo){
    $(".tr_set_"+set_codigo).remove();
    if($("table tr").length == 0){
        $(".tb_setores").hide();
    }
}

function verificaExistente(){
    if($("#usr_login").val().length >= 3){
        $.ajax({
            url: baseUrl+"/default/usuarios/login/",
            type: "POST",
            data: {
                    term: $("#usr_login").val()
            },
            success: function(txt){
                if(txt == 1 && $("#usr_login").val() != $("#usr_login_controle").val()){
                    $("#login_existente").html("<font color=\"red\"><b>Login já existe</b></font>");
                    $("#login_invalido").val("");
                }else{
                    $("#login_existente").html("<font color=\"green\"><b>Login Válido</b></font>");
                    $("#login_invalido").val(1);
                }
            }
        });
    }else{
        $("#login_existente").html("<font color=\"blue\"><b>Coloque no minimo 3 Caracteres</b></font>");
    }
}

function deleteUnu(unu_codigo,uni_codigo){
    $.ajax({
        url: baseUrl + "/usuarios/usuarios/excluir-unidade",
        type: "POST",
        data:{
            id:unu_codigo
            },
        success: function(txt){
            deleteRow(uni_codigo);
        }
    });
}

function deleteMes(mes_codigo,esp_codigo, uni_codigo){
    $.ajax({
        url: baseUrl + "/usuarios/usuarios/excluir-especialidade",
        type: "POST",
        data:{
            id:mes_codigo
            },
        success: function(txt){
            deleteRowEspUni(esp_codigo, uni_codigo);
        }
    });
}

function deleteUset(uset_codigo,set_codigo){
    $.ajax({
        url: baseUrl + "/usuarios/usuarios/excluir-setores",
        type: "POST",
        data:{
            id:uset_codigo
            },
        success: function(txt){
            deleteRowSet(set_codigo);
        }
    });
}

/* Alteração de senha*/
function visualizaSenha(checkbox, input){
    $('#'+input).prop('type', (checkbox.checked ? 'text' : 'password'));
}

function verificaSenhaAtual(usr_codigo, usr_senha){
    var retorno = null;
    $.ajax({
        url: baseUrl + '/usuarios/usuarios/verifica-senha-atual?usr_codigo='+usr_codigo+'&usr_senha='+usr_senha,
        type: 'GET',
        async: false,
        success: function(txt){
            retorno = (txt > 0);
        }
    });
    return retorno;
}

function salvarAlteraSenha() {
    var usr_codigo = $('#usr_codigo').val();
    var usr_senha = $('#senha_atual').val();
    if(verificaSenhaAtual(usr_codigo, usr_senha)){
        $('#valida_atual').css('display', 'none');
        if($('#form-alterasenha').valid()){
            mensagemSemOk("dp_salvar_cidadao", "Confirmação", "Salvando dados ...", 250, 150);
            $.ajax({
                url: baseUrl + '/usuarios/usuarios/salvar-altera-senha?usr_codigo=' + usr_codigo + '&usr_senha=' + $("#nova_senha").val(),
                type: 'POST',
                success: function (txt) {
                    if(txt>0) {
                        fecharMensagemSemOk("dp_salvar_cidadao");
                        mensagem("Confirmação", "Dados salvo com sucesso.", 250, 150);
                        setTimeout(function(){
                            parent.location.href = baseUrl + "/../logoff.php?id_login=" + usr_codigo
                        }, 2500);
                    } else{
                        fecharMensagemSemOk("dp_salvar_cidadao");
                        mensagem("Erro", "Erro ao alterar a senha");
                    }
                }
            });
        }
    }else{
        $('#valida_atual').css('display', '');
    }
}
function salvar() {
    if($('#form').valid()) {
        mensagem("Atenção", "Dados Cadastrados com Sucesso.", 250, 150, function () {
        });
    }
}


function pesquisaDados() {
    setTimeout(function () {
        $.ajax({
            url: baseUrl + "/usuarios/usuarios/pesquisa-dados",
            type: "POST",
            data: {
                busca: $("#dbe_busca_usuarios").val(),
                status: $("#dbe_status_usuarios").val(),
            },
            success: function (json) {
                $("#resultado").html("");
                var tr = "<table class='table table-striped'>" +
                    "<thead>" +
                    "<tr>" +
                    "   <th class='coluna-center'>Código</th>" +
                    "   <th>Nome</th>" +
                    "   <th>Status</th>" +
                    "   <th class='coluna-acoes'>Ações</th>" +
                    "</tr>" +
                    "</thead>";
                if (json.length > 0) {
                    json.forEach(function (element, index, array) {
                        tr += "<tr>"
                            + "     <td class='coluna-center' width='80'>" + element.usr_codigo + "</td>"
                            + "     <td width='200'>" + element.usr_nome + "</td>"
                            + "     <td width='150'>"
                            + (element.usr_ativo == 'S' ? 'ATIVO' : 'INATIVO')
                            + "     </td>"
                            + "     <td class='coluna-center'>"
                            + "         <a class='btn btn-info' href= " + baseUrl + '/usuarios/usuarios/editar/id/' + element.usr_codigo + " title='Editar'>"
                            + "            <i class='fa fa-edit'></i>"
                            + "         </a>"
                            + "         <a class='confirm btn btn-danger' href= " + baseUrl + '/usuarios/usuarios/inativar/id/' + element.usr_codigo + " title='Inativar' id='excluir' rel='Deseja inativar este profissional?'>"
                            + "            <i class='fa fa-trash'></i>"
                            + "         </a>"
                            + "     </td>"
                            + "</tr>";
                    });
                } else {
                    tr += "<tr>" +
                        " <td colspan='5'>Nenhum resultado encontrado até o momento!</td>" +
                        "</tr>";
                }
                $("#resultado").html(tr + '</table>');
                addPagination();
            }
        });
    }, 1000);
}