function cadastraGrupo(asgpu_codigo){
    $("body").append("<div id='grp-form' title='Grupo de Usuários'></div>");
    var url = baseUrl+"/usuarios/usuarios/form-grupo-usuarios/asgpu_codigo/"+asgpu_codigo;
    abrirModal("grp-form", url);
}

function formSalvar(e) {
    if (validaForm('grp-form', e)) {
        e.preventDefault();
        salvaGrupo();
    } else {
        return false;
    }
}

function validaParticipante(term) {
    var cont = new Number($("#part_qtd_total").val()) + 1;
    var table = $('#participantes');
    var retorno = "";
    if (cont > 1) {
        table.find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (term == $(this).val()) {
                    retorno = 1;
                }
            });
        });
    }
    return retorno;
}
function salvaGrupo() {
    var form_grupo = $('#form-grupo').serialize();
    if(verificaNome()){
        $.ajax({
            url: baseUrl + "/usuarios/usuarios/salvar-form-grupo-usuarios",
            type: "POST",
            data: form_grupo,
            success: function (txt) {
                if (txt.success == true) {
                    salvaParticipantes(txt.asgpu_codigo);
                } else {
                    mensagem(txt.titulo, txt.mensagem, 300, 150, function () {
                        return false;
                    });
                }

            }

        });
    } else{
        mensagem("Erro","Nome de Grupo já cadastrado.",250,150, function () {
            return false;
        });
    }


}

function adicionaParticipante() {
    var cont = parseInt($("#part_qtd_total").val()) + 1;
    var usr_nome = $("#usr_nome").val().trim();
    var usr_codigo = $("#usr_codigo").val();

    if (usr_codigo == "" || usr_nome == "") {
        return;
    }
    if (validaParticipante(usr_codigo) == 0) {
        $("#part_qtde_0").remove();
        $("#part_qtd_total").val(cont);
        $("#participantes").append(
            '<tr id="part_qtd' + cont + '">' +
            "   <td>" + usr_codigo +
            "       <input type='hidden' name='part[" + cont + "][usr_codigo]' value=\""+ usr_codigo +"\" />" +
            "   </td>" +
            "   <td>" + usr_nome +
            "       <input type='hidden' name='part[" + cont + "][asgpp_codigo]' value=''/>" +
            "   </td>" +
            "   <td>" +
            "       <a href='#' class='excluir'>" +
            '           <img src="' + baseUrl + '/public/images/icons/excluir.png" alt="Excluir" title="Excluir" onclick="excluirConfirmacao(' + cont + ')" />' +
            "       </a>" +
            "   </td>" +
            "</tr>");
        $("#usr_nome").val("");
        $("#usr_codigo").val("");
    } else {
        mensagem("Erro", "Participante já vinculado ao grupo", 250, 150, function () {
            $("#usr_nome").val("");
            $("#usr_codigo").val("");

        });
    }

}

function salvaParticipantes(json) {
    var form_participantes = $('#form-participantes').serialize();
    if (form_participantes) {

        $.ajax({
            url: baseUrl + "/usuarios/usuarios/salva-participantes-grupo/asgpu_codigo/" + json,
            type: "POST",
            data: form_participantes,
            success: function (txt) {
                if (txt.success == true) {
                    mensagem("Atenção", "Dados cadastrados com Sucesso!", 300, 150, function () {

                        $(this).remove();
                        atualizaPagina();
                    });
                } else {
                    mensagem(txt.titulo + "," + txt.mensagem, 300, 150, function () {
                        return false;
                    });
                }

            }
        });
    } else {
        mensagem("Atenção", "Dados cadastrados com Sucesso!", 300, 150, function () {
            $(this).remove();
            atualizaPagina();
        });
    }
}

function excluirConfirmacao(id, asgpp_codigo) {

    $('html, body').animate({scrollTop: $('#part_qtd' + id).offset().top}, 'slow');
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        $("#part_qtd" + id).remove();
        if (asgpp_codigo){
            $.ajax({
                url: baseUrl + "/usuarios/usuarios/excluir-participantes-grupo/asgpp_codigo/"+ asgpp_codigo,
                type: "POST",
                data: asgpp_codigo,
                success: function (txt) {
                    if (txt.success == true) {
                        mensagem("Atenção", "Participante excluído com Sucesso!", 300, 150, function () {
                            return true;
                        });
                    } else {
                        mensagem(txt.titulo + "," + txt.mensagem, 300, 150, function () {
                            return false;
                        });
                    }

                }
            });
        }
        if($("#part_qtd_total").val() == 1){
            $("#participantes").append(
                "<tr id='part_qtde_0'>" +
                "<td colspan='7'>Nenhum participante vinculado até o momento.</td>" +
                "</tr>");
        }

    });
}

function excluirGrupo(asgpu_codigo) {

    confirme("Confirme:", "Deseja realmente excluir este grupo?", 300, 150, function () {

            $.ajax({
                url: baseUrl + "/usuarios/usuarios/excluir-grupo/asgpu_codigo/"+ asgpu_codigo,
                type: "GET",
                success: function (txt) {
                    if (txt.success == true) {
                        mensagem("Atenção", "Grupo excluído com Sucesso!", 300, 150, function () {
                            atualizaPagina();

                        });
                    } else {
                        mensagem(txt.titulo + "," + txt.mensagem, 300, 150, function () {
                            return false;
                        });
                    }

                }
            });

    });
}

function verificaNome(){
    var valida = true;
    var nome = $("#asgpu_desc").val();
    var nome_controle = $("#asgpu_desc_controle").val();
    if(nome == nome_controle){
        return valida;
    }else{
        $.ajax({
            url: baseUrl + "/usuarios/usuarios/valida-nome-grupo/term/"+ nome,
            type: "GET",
            async: false,
            success: function (txt) {
                if (txt.success) {
                        valida = false;
                   } else {
                        valida = true;
                }
            }
        });
        return valida;
    }
}
function buscarGrupo() {
        setTimeout(function () {
            $.ajax({
                url: baseUrl +"/usuarios/usuarios/buscar-grupos/term/"+ $("#busca_grupo").val(),
                type: "GET",
                success: function (json) {
                    $("#resultado").html("");
                    var tr = "<table class='table table-striped'>"
                        + "<thead>"
                        + "    <tr>"
                        + "        <th width='10%' class='coluna-center'>ID</th>"
                        + "        <th width='55%'>Descrição</th>"
                        + "        <th width='20%'>Status</th>"
                        + "        <th width='15%' class='coluna-acoes'>Ações</th>"
                        + "    </tr>"
                        + "</thead>";
                    if (json.length > 0) {
                        json.forEach(function (element, index, array) {
                           var status = "";
                            switch(element.asgpu_status){
                                case "A":
                                    status = "Ativo";
                                    break;
                                case "I":
                                    status = "Inativo";
                                    break;
                            }
                             tr += "<tr>"
                                + "    <td class='coluna-center'>" + element.asgpu_codigo + "</td>"
                                + "    <td>" + element.asgpu_desc + "</td>"
                                + "    <td>" + status + "</td>"
                                + "    <td class='coluna-acoes'>"
                                + "        <a class='btn btn-info' title='Editar'"
                                + "           onclick='cadastraGrupo(" + element.asgpu_codigo + ")'>"
                                + "            <i class='icon-edit icon-white'></i>"
                                + "        </a>"
                                + "        <a class='btn btn-danger' title='Apagar'"
                                + "           onclick='excluirGrupo(" + element.asgpu_codigo + ")'>"
                                + "            <i class='fa fa-trash'></i>"
                                + "        </a>"
                                + "    </td>"
                                + "</tr>";
                        });
                    } else {
                        tr += "<tr>" +
                            "<td colspan='6'>Nenhum resultado encontrado até o momento!</td>" +
                            "</tr>";
                    }
                    $("#resultado").html(tr + '</table>');
                    addPagination();
                }
            });
        }, 1500);

}

